/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueDouble;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.PrimitiveValueBlock;
import java.io.IOException;

public class DoubleValue
extends PrimitiveValueBlock {
    public DoubleValue() {
        super(DexValueType.DOUBLE);
    }

    public double get() {
        return Double.longBitsToDouble(this.getLongBits());
    }

    public void set(double value) {
        this.setLongBits(Double.doubleToLongBits(value));
    }

    private long getLongBits() {
        int shift = (7 - this.getValueSize()) * 8;
        return this.getUnsigned() << shift;
    }

    private void setLongBits(long bits) {
        int i;
        for (i = 0; i < 7 && (bits & 0xFFL) == 0L; ++i) {
            bits >>>= 8;
        }
        this.setValue(bits, 8 - i);
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.DOUBLE;
    }

    @Override
    public PrimitiveKey getKey() {
        return PrimitiveKey.of(this.get());
    }

    @Override
    public void setKey(Key key) {
        this.set(((PrimitiveKey.DoubleKey)key).value());
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_D;
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueDouble smaliValueDouble = (SmaliValueDouble)smaliValue;
        this.set(smaliValueDouble.getValue());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.get());
    }

    @Override
    public String toString() {
        return Double.toString(this.get());
    }
}

