/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph.cleaners;

import com.reandroid.apk.ApkModule;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.graph.ApkBuildOption;
import com.reandroid.graph.cleaners.UnusedClassComponentCleaner;
import com.reandroid.utils.collection.ArrayCollection;
import java.util.Iterator;
import java.util.List;

public class UnusedFieldsCleaner
extends UnusedClassComponentCleaner<DexField> {
    public UnusedFieldsCleaner(ApkBuildOption buildOption, ApkModule apkModule, DexClassRepository classRepository) {
        super(buildOption, apkModule, classRepository);
    }

    @Override
    protected boolean isEnabled() {
        return this.getBuildOption().isMinifyFields();
    }

    @Override
    protected List<DexField> listUnusedInClass(DexClass dexClass) {
        Iterator<DexField> iterator = dexClass.getDeclaredFields();
        ArrayCollection<DexField> list = null;
        while (iterator.hasNext()) {
            DexField dexField = iterator.next();
            if (!this.isUnusedField(dexField)) continue;
            if (list == null) {
                list = new ArrayCollection<DexField>();
            }
            list.add(dexField);
        }
        return list;
    }

    private boolean isUnusedField(DexField dexField) {
        return this.isUnusedPrivateField(dexField) || this.isUnusedInstanceField(dexField);
    }

    private boolean isUnusedPrivateField(DexField dexField) {
        if (!dexField.isPrivate()) {
            return false;
        }
        FieldKey fieldKey = dexField.getKey();
        String name = fieldKey.getName();
        Iterator<DexInstruction> iterator = dexField.getDexClass().getDexInstructions();
        while (iterator.hasNext()) {
            DexInstruction instruction = iterator.next();
            if (!fieldKey.equals(instruction.getKeyAsField()) && !name.equals(instruction.getString())) continue;
            return false;
        }
        return true;
    }

    private boolean isUnusedInstanceField(DexField dexField) {
        return false;
    }
}

