/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.identifiers;

import com.reandroid.identifiers.Identifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class IdentifierMap<CHILD extends Identifier>
extends Identifier
implements Comparator<CHILD> {
    private final Object mLock = new Object();
    private final Map<Integer, CHILD> idMap = new HashMap<Integer, CHILD>();
    private final Map<String, CHILD> nameMap = new HashMap<String, CHILD>();
    private boolean mCaseInsensitive = CASE_INSENSITIVE_FS;
    private int maxId;

    public IdentifierMap(int id, String name) {
        super(id, name);
    }

    public int getMaxId() {
        return this.maxId;
    }

    public List<CHILD> listDuplicates() {
        ArrayList<Identifier> results = new ArrayList<Identifier>();
        HashMap<String, Identifier> uniques = new HashMap<String, Identifier>();
        for (Identifier item : this.getItems()) {
            String name = item.getName();
            if (this.isCaseInsensitive()) {
                name = name.toLowerCase();
            }
            if (uniques.containsKey(name)) {
                results.add(item);
                results.add((Identifier)uniques.get(name));
                continue;
            }
            uniques.put(name, item);
        }
        results.sort(this);
        return results;
    }

    public boolean hasDuplicates() {
        HashSet<String> uniques = new HashSet<String>();
        for (Identifier item : this.getItems()) {
            String name = item.getName();
            if (uniques.contains(name)) {
                return true;
            }
            uniques.add(name);
        }
        return false;
    }

    public List<String> listNames() {
        ArrayList<String> results = new ArrayList<String>(this.size());
        for (Identifier item : this.list()) {
            results.add(item.getName());
        }
        return results;
    }

    public List<CHILD> list() {
        ArrayList<CHILD> childList = new ArrayList<CHILD>(this.getItems());
        childList.sort(this);
        return childList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CHILD> getItems() {
        Object object = this.mLock;
        synchronized (object) {
            return this.idMap.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.idMap.clear();
            this.nameMap.clear();
        }
    }

    public CHILD getByTag(Object tag) {
        for (Identifier item : this.getItems()) {
            if (!Objects.equals(tag, item.getTag())) continue;
            return (CHILD)item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mLock;
        synchronized (object) {
            return this.idMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHILD get(String childName) {
        Object object = this.mLock;
        synchronized (object) {
            return (CHILD)((Identifier)this.nameMap.get(childName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHILD get(int childId) {
        Object object = this.mLock;
        synchronized (object) {
            return (CHILD)((Identifier)this.idMap.get(childId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CHILD entry) {
        Object object = this.mLock;
        synchronized (object) {
            if (entry == null) {
                return;
            }
            this.idMap.remove(((Identifier)entry).getId());
            this.nameMap.remove(((Identifier)entry).getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHILD add(CHILD child) {
        Object object = this.mLock;
        synchronized (object) {
            if (child == null) {
                return null;
            }
            ((Identifier)child).setParent(this);
            Integer entryId = ((Identifier)child).getId();
            Identifier exist = (Identifier)this.idMap.get(entryId);
            if (exist != null) {
                if (exist.getName() == null) {
                    exist.setName(((Identifier)child).getName());
                    this.addNameMap(exist);
                }
                return (CHILD)exist;
            }
            this.idMap.put(entryId, child);
            if (entryId > this.maxId) {
                this.maxId = entryId;
            }
            this.addNameMap(child);
            return child;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadNameMap() {
        Object object = this.mLock;
        synchronized (object) {
            this.nameMap.clear();
            for (Identifier child : this.idMap.values()) {
                this.addNameMap(child);
            }
        }
    }

    private void addNameMap(CHILD child) {
        String childName = ((Identifier)child).getName();
        if (childName == null) {
            return;
        }
        Identifier exist = (Identifier)this.nameMap.get(childName);
        if (exist != null) {
            return;
        }
        this.nameMap.put(childName, child);
    }

    private boolean isCaseInsensitive() {
        return this.mCaseInsensitive;
    }

    void setCaseInsensitive(boolean caseInsensitive) {
        this.mCaseInsensitive = caseInsensitive;
    }

    @Override
    public int compare(CHILD child1, CHILD child2) {
        return ((Identifier)child1).compareTo((Identifier)child2);
    }

    @Override
    public String toString() {
        return super.toString() + " entries = " + this.size();
    }
}

