/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import com.reandroid.utils.Checksum;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Crc32
extends Checksum {
    private static final long[] CRC_TABLE;
    private long mCrc = 0xFFFFFFFFL;
    private long mLength;

    @Override
    public long getValue() {
        return this.mCrc ^ 0xFFFFFFFFL;
    }

    public long getLength() {
        return this.mLength;
    }

    @Override
    public void reset() {
        this.mCrc = 0xFFFFFFFFL;
        this.mLength = 0L;
    }

    @Override
    public void update(byte[] data, int offset, int length) {
        long c = this.mCrc;
        int end = offset + length;
        long[] table = CRC_TABLE;
        for (int i = offset; i < end; ++i) {
            int b = data[i] & 0xFF;
            c = table[(int)((c ^ (long)b) & 0xFFL)] ^ c >> 8;
        }
        this.mCrc = c;
        this.mLength += (long)length;
    }

    public static long of(byte[] bytes) {
        return Crc32.of(bytes, 0, bytes.length);
    }

    public static long of(byte[] bytes, int offset, int length) {
        Crc32 crc32 = new Crc32();
        crc32.update(bytes, offset, length);
        return crc32.getValue();
    }

    public static long of(File file) throws IOException {
        long fiftyMega;
        if (!file.isFile()) {
            throw new FileNotFoundException("No such file: " + file);
        }
        long length = file.length();
        if (length > (fiftyMega = 0x3200000L)) {
            length = -1L;
        }
        return Crc32.of((int)length, FileUtil.inputStream(file));
    }

    public static long of(InputStream stream) throws IOException {
        return Crc32.of(-1, stream);
    }

    public static long of(int bufferSize, InputStream stream) throws IOException {
        int length;
        if ((bufferSize & 0xFF000000) != 0) {
            bufferSize = 0x400000;
        }
        byte[] buffer = new byte[bufferSize];
        Crc32 crc32 = new Crc32();
        while ((length = stream.read(buffer, 0, bufferSize)) != -1) {
            crc32.update(buffer, 0, length);
        }
        stream.close();
        return crc32.getValue();
    }

    static {
        long[] table = new long[256];
        CRC_TABLE = table;
        for (int i = 0; i < 256; ++i) {
            long c = i;
            for (int j = 0; j < 8; ++j) {
                if ((c & 1L) == 1L) {
                    c = 0xEDB88320L ^ c >> 1;
                    continue;
                }
                c >>= 1;
            }
            table[i] = c;
        }
    }
}

