/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

public class HexUtil {
    public static String toSignedHex(long num) {
        boolean negative = num < 0L;
        String prefix = "0x";
        if (negative) {
            num = -num;
            prefix = "-0x";
        }
        return HexUtil.toHex(prefix, num, 1);
    }

    public static String toSignedHex(int num) {
        boolean negative = num < 0;
        String prefix = "0x";
        if (negative) {
            num = -num;
            prefix = "-0x";
        }
        return HexUtil.toHex(prefix, num, 1);
    }

    public static String toHex2(byte num) {
        return HexUtil.toHex((long)num & 0xFFL, 2);
    }

    public static String toHex2(String prefix, byte num) {
        return HexUtil.toHex(prefix, (long)num & 0xFFL, 2);
    }

    public static String toHex4(short num) {
        return HexUtil.toHex((long)num & 0xFFFFL, 4);
    }

    public static String toHex8(int num) {
        return HexUtil.toHex(num, 8);
    }

    public static String toHex8(long num) {
        return HexUtil.toHex(num, 8);
    }

    public static String toHex(int num, int minLength) {
        return HexUtil.toHex(0xFFFFFFFFL & (long)num, minLength);
    }

    public static String toHex(long num, int minLength) {
        String hex = Long.toHexString(num);
        StringBuilder builder = new StringBuilder();
        builder.append('0');
        builder.append('x');
        int rem = minLength - hex.length();
        for (int i = 0; i < rem; ++i) {
            builder.append('0');
        }
        builder.append(hex);
        return builder.toString();
    }

    public static String toHexNoPrefix8(int num) {
        return HexUtil.toHex(null, 0xFFFFFFFFL & (long)num, 8);
    }

    public static String toHexNoPrefix(int num, int minLength) {
        return HexUtil.toHex(null, 0xFFFFFFFFL & (long)num, minLength);
    }

    public static String toHex8(String prefix, int num) {
        return HexUtil.toHex(prefix, 0xFFFFFFFFL & (long)num, 8);
    }

    public static String toHex(String prefix, int num, int minLength) {
        return HexUtil.toHex(prefix, 0xFFFFFFFFL & (long)num, minLength);
    }

    public static String toHex(String prefix, long num, int minLength) {
        String hex = Long.toHexString(num);
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix);
        }
        int rem = minLength - hex.length();
        for (int i = 0; i < rem; ++i) {
            builder.append('0');
        }
        builder.append(hex);
        return builder.toString();
    }

    public static String toHexString(byte[] bytes) {
        int length = bytes.length;
        StringBuilder builder = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            byte b = bytes[i];
            builder.append(HexUtil.toHexChar(b >> 4 & 0xF));
            builder.append(HexUtil.toHexChar(b & 0xF));
        }
        return builder.toString();
    }

    public static byte[] fromHexSting(String hexString) {
        int length = hexString.length();
        if (length % 2 != 0) {
            throw new NumberFormatException("Odd hex string length: " + length);
        }
        byte[] results = new byte[length / 2];
        for (int i = 0; i < length; ++i) {
            int value = HexUtil.decodeHexChar(hexString.charAt(i)) << 4;
            results[i / 2] = (byte)((value |= HexUtil.decodeHexChar(hexString.charAt(++i))) & 0xFF);
        }
        return results;
    }

    public static int parseHex(String hexString) {
        return (int)HexUtil.parseHexLong(hexString);
    }

    public static byte parseHexByte(String hex) {
        int i;
        String hexString = hex;
        boolean negative = false;
        if (hexString.charAt(0) == '-') {
            hexString = hexString.substring(1);
            negative = true;
        }
        if (hexString.charAt(0) == '+') {
            hexString = hexString.substring(1);
        }
        if (hexString.charAt(i = hexString.length() - 1) == 't') {
            hexString = hexString.substring(0, i);
        }
        if (((i = Integer.parseInt(hexString = HexUtil.trim0x(hexString), 16)) & 0xFF) != i) {
            throw new NumberFormatException("Invalid byte hex '" + hex + "'");
        }
        if (negative) {
            i = -i;
        }
        return (byte)i;
    }

    public static short parseHexShort(String hex) {
        int i;
        char postfix;
        String hexString = hex;
        boolean negative = false;
        if (hexString.charAt(0) == '-') {
            hexString = hexString.substring(1);
            negative = true;
        }
        if (hexString.charAt(0) == '+') {
            hexString = hexString.substring(1);
        }
        if ((postfix = hexString.charAt(i = hexString.length() - 1)) == 'S' || postfix == 's') {
            hexString = hexString.substring(0, i);
        }
        if (((i = Integer.parseInt(hexString = HexUtil.trim0x(hexString), 16)) & 0xFFFF) != i) {
            throw new NumberFormatException("Invalid short hex '" + hex + "'");
        }
        if (negative) {
            i = -i;
        }
        return (short)i;
    }

    public static int parseHexInteger(String hex) {
        return (int)HexUtil.parseHexLong(hex);
    }

    public static long parseHexLong(String hex) {
        int i;
        String hexString = hex;
        boolean negative = false;
        if (hexString.charAt(0) == '-') {
            hexString = hexString.substring(1);
            negative = true;
        }
        if (hexString.charAt(0) == '+') {
            hexString = hexString.substring(1);
        }
        if (hexString.charAt(i = hexString.length() - 1) == 'L') {
            hexString = hexString.substring(0, i);
        }
        hexString = HexUtil.trim0x(hexString);
        long result = 0L;
        int length = hexString.length();
        for (i = 0; i < length; ++i) {
            result <<= 4;
            int v = HexUtil.decodeHexChar(hexString.charAt(i));
            if (v == -1) {
                throw new NumberFormatException("Invalid hex char for string '" + hexString + "'");
            }
            result |= (long)v;
        }
        if (negative) {
            result = -result;
        }
        return result;
    }

    public static int decodeHex(String hex, int def) {
        int i;
        String hexString = hex;
        boolean negative = false;
        if (hexString.charAt(0) == '-') {
            hexString = hexString.substring(1);
            negative = true;
        }
        if (hexString.charAt(0) == '+') {
            hexString = hexString.substring(1);
        }
        if (hexString.charAt(i = hexString.length() - 1) == 'L') {
            hexString = hexString.substring(0, i);
        }
        hexString = HexUtil.trim0x(hexString);
        int result = 0;
        int length = hexString.length();
        for (i = 0; i < length; ++i) {
            result <<= 4;
            int v = HexUtil.decodeHexChar(hexString.charAt(i));
            if (v == -1) {
                return def;
            }
            result |= v;
        }
        if (negative) {
            result = -result;
        }
        return result;
    }

    public static int decodeHexChar(byte b) {
        return HexUtil.decodeHexChar((char)(0xFF & b));
    }

    public static int decodeHexChar(char ch) {
        if (ch <= '9' && ch >= '0') {
            return ch - 48;
        }
        if (ch <= 'f' && ch >= 'a') {
            return 10 + (ch - 97);
        }
        if (ch <= 'F' && ch >= 'A') {
            return 10 + (ch - 65);
        }
        return -1;
    }

    public static boolean isHexChar(char ch) {
        if (ch <= '9' && ch >= '0') {
            return true;
        }
        if (ch <= 'f' && ch >= 'a') {
            return true;
        }
        return ch <= 'F' && ch >= 'A';
    }

    public static char toHexChar(int i) {
        if (i >= 0) {
            if (i < 10) {
                return (char)(i += 48);
            }
            if (i <= 16) {
                i -= 10;
                return (char)(i += 97);
            }
        }
        return '\u0000';
    }

    private static String trim0x(String hexString) {
        if (hexString == null || hexString.length() < 3) {
            return hexString;
        }
        if (hexString.charAt(0) == '0' && hexString.charAt(1) == 'x') {
            hexString = hexString.substring(2);
        }
        return hexString;
    }
}

