/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.io;

import java.io.File;

public class FilePermissions {
    private int value;

    public boolean apply(File file) {
        boolean applied;
        Permission owner = this.owner();
        Permission group = this.group();
        Permission others = this.others();
        boolean result = applied = file.setExecutable(owner.execute(), owner.execute() && !group.execute() && !others.execute());
        applied = file.setWritable(owner.write(), owner.write() && !group.write() && !others.write());
        result |= applied;
        applied = file.setReadable(owner.read(), owner.read() && !group.read() && !others.read());
        return result |= applied;
    }

    public int get() {
        return this.value;
    }

    public void set(int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw new NumberFormatException("Value out of range: " + value);
        }
        this.value = value;
    }

    public int high() {
        return this.get() / 512;
    }

    public void high(int high) {
        if (high < 0 || high > 511) {
            throw new NumberFormatException("High value out of range: " + high);
        }
        this.set(high * 512 + this.permissions());
    }

    public int permissions() {
        return this.owner().get() * 64 + this.group().get() * 8 + this.others().get();
    }

    public void permissions(int permissions) {
        if (permissions < 0 || permissions > 511) {
            throw new NumberFormatException("Permissions value out of range: " + permissions);
        }
        this.set(this.high() * 512 + permissions);
    }

    public Permission owner() {
        return new Permission(this, 2);
    }

    public Permission group() {
        return new Permission(this, 1);
    }

    public Permission others() {
        return new Permission(this, 0);
    }

    public String octal() {
        return '0' + Integer.toOctalString(this.get());
    }

    public String permissionsOctal() {
        return '0' + Integer.toOctalString(this.permissions());
    }

    public String permissionsString() {
        return '-' + this.owner().getString() + this.group().getString() + this.others().getString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilePermissions other = (FilePermissions)obj;
        return this.get() == other.get();
    }

    public int hashCode() {
        return this.get();
    }

    public String toString() {
        return this.octal() + ' ' + this.permissionsString();
    }

    public static FilePermissions of(int value) {
        FilePermissions filePermissions = new FilePermissions();
        filePermissions.set(value);
        return filePermissions;
    }

    public static class Permission {
        private final FilePermissions permissions;
        private final int index;

        Permission(FilePermissions permissions, int index) {
            this.permissions = permissions;
            this.index = index;
        }

        public boolean execute() {
            return (this.get() & 1) != 0;
        }

        public void execute(boolean b) {
            int subValue = this.get();
            subValue = b ? (subValue |= 1) : (subValue &= 0xE);
            this.set(subValue);
        }

        public boolean write() {
            return (this.get() & 2) != 0;
        }

        public void write(boolean b) {
            int subValue = this.get();
            subValue = b ? (subValue |= 2) : (subValue &= 0xD);
            this.set(subValue);
        }

        public boolean read() {
            return (this.get() & 4) != 0;
        }

        public void read(boolean b) {
            int subValue = this.get();
            subValue = b ? (subValue |= 4) : (subValue &= 0xB);
            this.set(subValue);
        }

        public int get() {
            return this.getFor(this.index);
        }

        public void set(int triad) {
            if (triad < 0 || triad > 7) {
                throw new NumberFormatException("Permission triad out of range: " + triad);
            }
            int factor = 1;
            int result = 0;
            int index = this.index;
            for (int i = 0; i < 6; ++i) {
                int triadValue = i == index ? triad : this.getFor(i);
                result += triadValue * factor;
                factor *= 8;
            }
            this.permissions.set(result);
        }

        private int getFor(int index) {
            int factor = 1;
            for (int i = 0; i < index; ++i) {
                factor *= 8;
            }
            return this.permissions.get() % (factor * 8) / factor;
        }

        public String getString() {
            int triad = this.get();
            byte[] bytes = new byte[]{(byte)((triad & 4) != 0 ? 114 : 45), (byte)((triad & 2) != 0 ? 119 : 45), (byte)((triad & 1) != 0 ? 120 : 45)};
            return new String(bytes);
        }

        public String getName() {
            int index = this.index;
            if (index == 0) {
                return "others";
            }
            if (index == 1) {
                return "group";
            }
            if (index == 2) {
                return "owner";
            }
            return "";
        }

        public String toString() {
            return this.getName() + ' ' + this.getString();
        }
    }
}

