/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.io;

import com.reandroid.arsc.ARSCLib;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.io.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileUtil {
    private static String def_prefix;
    private static final Map<String, File> TEMP_DIRS;
    private static final String[] FILE_SIZE_UNITS;

    public static List<File> listClassesDex(File dir) {
        ArrayCollection<File> results = new ArrayCollection<File>();
        if (dir == null || !dir.isDirectory()) {
            return results;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || FileUtil.getClassesDexNumber(file) == -1) continue;
                results.add(file);
            }
        }
        results.sort((file1, file2) -> CompareUtil.compare(FileUtil.getClassesDexNumber(file1), FileUtil.getClassesDexNumber(file2)));
        return results;
    }

    public static int getClassesDexNumber(File file) {
        if (file != null) {
            return FileUtil.getClassesDexNumber(file.getName());
        }
        return -1;
    }

    public static int getClassesDexNumber(String fileName) {
        if (fileName == null) {
            return -1;
        }
        if (fileName.equals("classes.dex")) {
            return 0;
        }
        String prefix = "classes";
        String ext = ".dex";
        if (!fileName.startsWith(prefix) || !fileName.endsWith(ext)) {
            return -1;
        }
        String numStr = fileName.substring(prefix.length(), fileName.length() - ext.length());
        try {
            int num = Integer.parseInt(numStr);
            if (num < 2) {
                return -1;
            }
            return num;
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    public static File toTmpName(File file) {
        File dir = file.getParentFile();
        String name = file.getName() + ".tmp";
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    @Deprecated
    public static void writeUtf8(File file, String content) throws IOException {
        IOUtil.writeUtf8(content, file);
    }

    public static String combineFilePath(String parent, String name) {
        return FileUtil.combinePath(File.separatorChar, parent, name);
    }

    public static String combineUnixPath(String parent, String name) {
        return FileUtil.combinePath('/', parent, name);
    }

    public static String combinePath(char separator, String parent, String name) {
        if (StringsUtil.isEmpty(parent)) {
            return name;
        }
        if (StringsUtil.isEmpty(name)) {
            return parent;
        }
        StringBuilder builder = new StringBuilder(parent.length() + name.length() + 1);
        builder.append(parent);
        if (parent.charAt(parent.length() - 1) != separator) {
            builder.append(separator);
        }
        builder.append(name);
        return builder.toString();
    }

    public static String shortPath(File file, int depth) {
        File dir;
        File tmp = file;
        while (depth > 0 && (dir = tmp.getParentFile()) != null) {
            tmp = dir;
            --depth;
        }
        if (file == tmp) {
            return file.getName();
        }
        int i = tmp.getAbsolutePath().length() + 1;
        return file.getAbsolutePath().substring(i);
    }

    public static String getParent(String path) {
        if (StringsUtil.isEmpty(path)) {
            return StringsUtil.EMPTY;
        }
        int i = path.lastIndexOf(47);
        if (i < 0) {
            i = path.lastIndexOf(92);
        }
        if (i <= 0) {
            return StringsUtil.EMPTY;
        }
        return path.substring(0, i + 1);
    }

    public static String getFileName(String path) {
        if (path == null) {
            return null;
        }
        int i = path.lastIndexOf(47);
        if (i < 0) {
            i = path.lastIndexOf(92);
        }
        if (i >= 0) {
            return path.substring(i + 1);
        }
        return path;
    }

    public static String getNameWoExtension(File file) {
        return FileUtil.getNameWoExtensionForSimpleName(file.getName());
    }

    public static String getNameWoExtension(String name) {
        return FileUtil.getNameWoExtensionForSimpleName(FileUtil.getFileName(name));
    }

    private static String getNameWoExtensionForSimpleName(String simpleName) {
        String ninePng = ".9.png";
        if (simpleName.endsWith(ninePng)) {
            return simpleName.substring(0, simpleName.length() - ninePng.length());
        }
        int i = simpleName.lastIndexOf(46);
        if (i < 0) {
            return simpleName;
        }
        return simpleName.substring(0, i);
    }

    public static String getExtension(File file) {
        return FileUtil.getExtensionForSimpleName(file.getName());
    }

    public static String getExtension(String name) {
        return FileUtil.getExtensionForSimpleName(FileUtil.getFileName(name));
    }

    private static String getExtensionForSimpleName(String simpleName) {
        String ninePng = ".9.png";
        if (simpleName.endsWith(ninePng)) {
            return ninePng;
        }
        int i = simpleName.lastIndexOf(46);
        if (i < 0) {
            return StringsUtil.EMPTY;
        }
        return simpleName.substring(i);
    }

    public static String toReadableFileSize(long size) {
        if (size < 0L) {
            return Long.toString(size);
        }
        String[] sizeUnits = FILE_SIZE_UNITS;
        String unit = "";
        long result = size;
        long dec = 0L;
        for (int i = 0; i < sizeUnits.length; ++i) {
            long div = i == 0 ? 1024L : 1000L;
            unit = sizeUnits[i];
            if ((size /= div) == 0L) break;
            dec = result - size * div;
            result = size;
        }
        if (dec == 0L) {
            return result + unit;
        }
        return result + "." + dec + unit;
    }

    public static FileChannel openReadChannel(File file) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("No such file: " + file);
        }
        return new FileInputStream(file).getChannel();
    }

    public static FileChannel openWriteChannel(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("File is directory: " + file);
        }
        FileUtil.ensureParentDirectory(file);
        if (!file.exists() || file.delete()) {
            file.createNewFile();
        }
        return new FileOutputStream(file).getChannel();
    }

    public static InputStream inputStream(File file) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("No such file: " + file);
        }
        return new FileInputStream(file);
    }

    public static OutputStream outputStream(File file) throws IOException {
        FileUtil.ensureParentDirectory(file);
        return new FileOutputStream(file);
    }

    public static void ensureParentDirectory(File file) {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void createNewFile(File file) throws IOException {
        FileUtil.ensureParentDirectory(file);
        if (file.isFile()) {
            file.delete();
        }
        file.createNewFile();
    }

    public static void deleteDirectory(File dir) {
        if (dir.isFile()) {
            dir.delete();
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            dir.delete();
            return;
        }
        for (File file : files) {
            FileUtil.deleteDirectory(file);
        }
        dir.delete();
    }

    public static void deleteEmptyDirectory(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            dir.delete();
            return;
        }
        for (File file : files) {
            if (!file.isDirectory()) {
                return;
            }
            FileUtil.deleteEmptyDirectory(file);
        }
        FileUtil.deleteIfEmptyDirectory(dir);
    }

    private static void deleteIfEmptyDirectory(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            dir.delete();
        }
    }

    public static File getTempDir() {
        return FileUtil.getTempDir(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempDir(String rootName) {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            File dir;
            if (rootName == null) {
                rootName = FileUtil.getDefRootName();
            }
            if ((dir = TEMP_DIRS.get(rootName)) == null) {
                dir = FileUtil.getWritableTempDir(rootName);
                if (dir != null) {
                    dir.deleteOnExit();
                    TEMP_DIRS.put(rootName, dir);
                }
            } else if (!dir.exists()) {
                dir.mkdir();
                dir.deleteOnExit();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dir;
        }
    }

    private static File getWritableTempDir(String rootName) {
        String path = System.getProperty("java.io.tmpdir", null);
        File dir = FileUtil.getWritableTempDir(path, rootName);
        if (dir == null) {
            path = System.getProperty("user.home", null);
            dir = FileUtil.getWritableTempDir(path, rootName);
        }
        if (dir == null) {
            File file = new File("tmp");
            dir = (file = new File(file.getAbsolutePath())).getParentFile();
            if (dir == null) {
                dir = file;
            }
            path = dir.getAbsolutePath();
            dir = FileUtil.getWritableTempDir(path, rootName);
        }
        return dir;
    }

    private static File getWritableTempDir(String path, String rootName) {
        if (path == null) {
            return null;
        }
        return FileUtil.getWritableTempDir(new File(path), rootName);
    }

    private static File getWritableTempDir(File baseDir, String rootName) {
        File dir = new File(baseDir, rootName);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        String testName = "test_" + System.currentTimeMillis() + "-";
        int max = 9999;
        for (int i = 0; i < max; ++i) {
            String name = testName + i;
            File file = new File(dir, name);
            if (file.exists()) continue;
            try {
                if (!file.createNewFile() || !file.delete()) {
                    return null;
                }
                return dir;
            }
            catch (IOException exception) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultTempPrefix(String prefix) {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            if (ObjectsUtil.equals(prefix, def_prefix)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (def_prefix != null) {
                TEMP_DIRS.remove(def_prefix);
            }
            def_prefix = prefix;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String getDefRootName() {
        if (def_prefix == null) {
            def_prefix = "tmp_" + ARSCLib.getName() + "-" + ARSCLib.getVersion();
        }
        return def_prefix;
    }

    static {
        TEMP_DIRS = new HashMap<String, File>();
        FILE_SIZE_UNITS = new String[]{" bytes", " Kb", " Mb", " Gb", " Tb", " Pb"};
    }
}

