/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Comment;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLComment
extends XMLNode
implements Comment {
    private String text;

    public XMLComment(String text) {
        this();
        this.setText(text);
    }

    public XMLComment() {
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.getText(false);
    }

    public String getText(boolean escapeXmlText) {
        String text = this.text;
        if (escapeXmlText) {
            return XMLUtil.escapeXmlChars(text);
        }
        return text;
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        serializer.comment(this.getText(false));
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        XMLUtil.expectEvent(parser, 9);
        this.setText(parser.getText());
        parser.nextToken();
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        appendable.append("<!--");
        appendable.append(this.getText(escapeXmlText));
        appendable.append("-->");
    }

    @Override
    public String toString() {
        return "<!--" + this.getText() + "-->";
    }
}

