/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLDocDeclaration;
import com.reandroid.xml.XMLDocType;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLFactory;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLNodeTree;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Document;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLDocument
extends XMLNodeTree
implements Document<XMLElement> {
    private final XMLDocDeclaration declaration = new XMLDocDeclaration();

    public XMLDocument(String elementName) {
        this();
        XMLElement docElem = new XMLElement(elementName);
        this.setDocumentElement(docElem);
    }

    public XMLDocument() {
    }

    @Override
    public XMLElement getDocumentElement() {
        return CollectionUtil.getFirst(this.iterator(XMLElement.class));
    }

    public void setDocumentElement(XMLElement element) {
        this.clear();
        this.add(element);
    }

    public XMLDocDeclaration getDeclaration() {
        return this.declaration;
    }

    public void setEncoding(String encoding) {
        this.getDeclaration().encoding(encoding);
    }

    public void setStandalone(Boolean standalone) {
        this.getDeclaration().standalone(standalone);
    }

    @Override
    public XMLElement newElement() {
        XMLElement element = new XMLElement();
        this.add(element);
        return element;
    }

    @Override
    public XMLText newText() {
        XMLText xmlText = new XMLText();
        this.add(xmlText);
        return xmlText;
    }

    @Override
    public XMLText newText(String text) {
        return super.newText(text);
    }

    @Override
    public XMLComment newComment() {
        XMLComment comment = new XMLComment();
        this.add(comment);
        return comment;
    }

    public XMLDocType getDocType() {
        return CollectionUtil.getFirst(this.iterator(XMLDocType.class));
    }

    public XMLDocType getOrCreateDocType() {
        XMLDocType docType = this.getDocType();
        if (docType == null) {
            docType = this.newDocType();
            this.move(docType, 0);
        }
        return docType;
    }

    @Override
    protected void onStartParse(XmlPullParser parser) throws XmlPullParserException, IOException {
        int event = parser.getEventType();
        if (event == 0) {
            this.clear();
            this.getDeclaration().parse(parser);
        } else if (!XMLUtil.hasFeatureRelaxed(parser)) {
            XMLUtil.expectEvent(parser, 0);
        }
    }

    @Override
    protected void onEndParse(XmlPullParser parser) throws XmlPullParserException, IOException {
    }

    @Override
    void startSerialize(XmlSerializer serializer) throws IOException {
        this.getDeclaration().serialize(serializer);
    }

    @Override
    void endSerialize(XmlSerializer serializer) {
        if (this.getDeclaration().isValid()) {
            try {
                serializer.endDocument();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        XMLDocDeclaration declaration = this.getDeclaration();
        if (declaration.isValid()) {
            appendable.append(declaration.toString());
        }
        Iterator<XMLNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().write(appendable, xml, escapeXmlText);
        }
    }

    public static XMLDocument load(String text) throws XmlPullParserException, IOException {
        XMLDocument document = new XMLDocument();
        document.parse(XMLFactory.newPullParser(text));
        return document;
    }

    public static XMLDocument load(InputStream inputStream) throws XmlPullParserException, IOException {
        XMLDocument document = new XMLDocument();
        document.parse(XMLFactory.newPullParser(inputStream));
        return document;
    }

    public static XMLDocument load(File file) throws XmlPullParserException, IOException {
        XMLDocument document = new XMLDocument();
        document.parse(XMLFactory.newPullParser(file));
        return document;
    }
}

