/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.IndexIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.RecursiveIterator;
import com.reandroid.utils.collection.ReversedIterator;
import com.reandroid.utils.collection.SizedSupplier;
import com.reandroid.xml.XMLCDSect;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLDocType;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNamespace;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLProcessingInstruction;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.base.NodeTree;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public abstract class XMLNodeTree
extends XMLNode
implements NodeTree<XMLNode>,
Iterable<XMLNode>,
SizedSupplier<XMLNode> {
    private ArrayCollection<XMLNode> mNodeList = EMPTY;
    private int lastTrimSize;
    private static final int TRIM_INTERVAL = 1000;
    private static final ArrayCollection<XMLNode> EMPTY = ArrayCollection.empty();

    public XMLNode getLast() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.mNodeList.get(size - 1);
    }

    public XMLElement getLastElement() {
        return CollectionUtil.getFirst(this.getElementsReversed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            this.mNodeList.clear();
            this.mNodeList.trimToSize();
            this.lastTrimSize = 0;
        }
    }

    @Override
    public Iterator<XMLNode> iterator(Predicate<? super XMLNode> filter) {
        return new IndexIterator<XMLNode>(this, filter);
    }

    @Override
    public Iterator<XMLNode> iterator() {
        return new IndexIterator<XMLNode>(this);
    }

    public Iterator<XMLNode> reversedIterator() {
        int size = this.size();
        int start = size - 1;
        return new ReversedIterator<XMLNode>(start, size){

            @Override
            public XMLNode get(int i) {
                return XMLNodeTree.this.get(i);
            }
        };
    }

    public Iterator<XMLNode> recursiveNodes() {
        return RecursiveIterator.of(this, XMLNode::iterator);
    }

    @Override
    public int size() {
        return this.mNodeList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLNode get(int index) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            return this.mNodeList.get(index);
        }
    }

    public void addAll(Iterable<? extends XMLNode> iterable) {
        Iterator<? extends XMLNode> itr = iterable.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(XMLNode xmlNode) {
        if (xmlNode == null || xmlNode == this) {
            return false;
        }
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            if (this.mNodeList == EMPTY) {
                this.mNodeList = new ArrayCollection();
            }
            if (this.mNodeList.containsExact(xmlNode)) {
                throw new IllegalArgumentException("Duplicate node: " + xmlNode);
            }
            boolean added = this.mNodeList.add(xmlNode);
            xmlNode.setParentNode(this);
            if (this.mNodeList.size() - this.lastTrimSize > 1000) {
                this.mNodeList.trimToSize();
                this.lastTrimSize = this.mNodeList.size();
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int i, XMLNode xmlNode) {
        if (xmlNode == null || xmlNode == this) {
            return;
        }
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            if (this.mNodeList == EMPTY) {
                this.mNodeList = new ArrayCollection();
            }
            if (this.mNodeList.containsExact(xmlNode)) {
                throw new IllegalArgumentException("Duplicate node: " + xmlNode);
            }
            this.mNodeList.add(i, xmlNode);
            xmlNode.setParentNode(this);
            if (this.mNodeList.size() - this.lastTrimSize > 1000) {
                this.mNodeList.trimToSize();
                this.lastTrimSize = this.mNodeList.size();
            }
        }
    }

    public int indexOf(XMLNode node) {
        return this.mNodeList.indexOf(node);
    }

    public int indexOfExact(XMLNode node) {
        return this.mNodeList.indexOfExact(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(XMLNode xmlNode) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            if (xmlNode != null && this.mNodeList.remove(xmlNode)) {
                xmlNode.setParentNode(null);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLNode remove(int i) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            XMLNode xmlNode = this.mNodeList.remove(i);
            if (xmlNode != null) {
                xmlNode.setParentNode(null);
            }
            return xmlNode;
        }
    }

    public void move(Object xmlNode, int to) {
        this.mNodeList.move(xmlNode, to);
    }

    @Override
    @Deprecated
    public boolean remove(Predicate<? super XMLNode> filter) {
        throw new RuntimeException("Depreciated method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super XMLNode> filter) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            return this.mNodeList.removeIf((Predicate<XMLNode>)filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sort(Comparator<? super XMLNode> comparator) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            return this.mNodeList.sortItems(comparator);
        }
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        this.startSerialize(serializer);
        this.serializeChildes(serializer);
        this.endSerialize(serializer);
    }

    abstract void startSerialize(XmlSerializer var1) throws IOException;

    private void serializeChildes(XmlSerializer serializer) throws IOException {
        Iterator<XMLNode> itr = this.iterator();
        while (itr.hasNext()) {
            itr.next().serialize(serializer);
        }
    }

    abstract void endSerialize(XmlSerializer var1) throws IOException;

    public abstract XMLElement newElement();

    public abstract XMLText newText();

    public XMLText newText(String text) {
        XMLText xmlText = this.newText();
        xmlText.setText(text);
        return xmlText;
    }

    public XMLComment newComment() {
        XMLComment comment = new XMLComment();
        this.add(comment);
        return comment;
    }

    public XMLNamespace newNamespace(String uri, String prefix) {
        return new XMLNamespace(uri, prefix);
    }

    public XMLElement newElement(String name) {
        XMLElement element = this.newElement();
        element.setName(name);
        return element;
    }

    public XMLDocType newDocType() {
        XMLDocType node = new XMLDocType();
        this.add(node);
        return node;
    }

    public XMLDocType newDocType(String type) {
        XMLDocType node = this.newDocType();
        node.setName(type);
        return node;
    }

    public XMLProcessingInstruction newProcessingInstruction() {
        XMLProcessingInstruction node = new XMLProcessingInstruction();
        this.add(node);
        return node;
    }

    public XMLCDSect newCDSect() {
        XMLCDSect node = new XMLCDSect();
        this.add(node);
        return node;
    }

    public XMLElement getOrCreateElement(String name) {
        XMLElement element = this.getElement(name);
        if (element == null) {
            element = this.newElement(name);
        }
        return element;
    }

    public XMLText getOrCreateFirstText(String text) {
        XMLNode node;
        XMLText xmlText = null;
        if (this.size() != 0 && (node = this.get(0)) instanceof XMLText) {
            xmlText = (XMLText)node;
            xmlText.setText(text);
        }
        if (xmlText == null) {
            xmlText = this.newText(text);
        }
        return xmlText;
    }

    public XMLText getOrCreateLastText() {
        XMLNode node = this.getLast();
        if (node instanceof XMLText) {
            return (XMLText)node;
        }
        return this.newText();
    }

    public XMLNode createForEvent(int event) {
        if (event == 2) {
            return this.newElement();
        }
        if (event == 10) {
            return this.newDocType();
        }
        if (XMLText.isTextEvent(event)) {
            return this.getOrCreateLastText();
        }
        if (event == 9) {
            return this.newComment();
        }
        if (event == 8) {
            return this.newProcessingInstruction();
        }
        if (event == 5) {
            return this.newCDSect();
        }
        return null;
    }

    public XMLElement getElement(String name) {
        return CollectionUtil.getFirst(this.getElements(name));
    }

    public Iterator<XMLElement> getElements(String name) {
        return InstanceIterator.of(this.iterator(), XMLElement.class, element -> element.equalsName(name));
    }

    public Iterator<? extends XMLElement> getElements() {
        return this.iterator(XMLElement.class);
    }

    public Iterator<? extends XMLElement> getElementsReversed() {
        return InstanceIterator.of(this.reversedIterator(), XMLElement.class);
    }

    public Iterator<? extends XMLText> getTexts() {
        return this.iterator(XMLText.class);
    }

    public boolean hasChildElements() {
        return !CollectionUtil.isEmpty(this.getElements());
    }

    public boolean hasTextNode() {
        return !CollectionUtil.isEmpty(this.getTexts());
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        this.onStartParse(parser);
        this.parseInner(parser);
        this.onEndParse(parser);
    }

    protected void onStartParse(XmlPullParser parser) throws XmlPullParserException, IOException {
    }

    public void parseInner(XmlPullParser parser) throws XmlPullParserException, IOException {
        int endEvent = this.getEndEvent();
        int event = parser.getEventType();
        while (event != endEvent && event != 1) {
            XMLNode node = this.createForEvent(event);
            if (node != null) {
                node.parse(parser);
            } else {
                this.onUnknownEvent(parser);
            }
            event = parser.getEventType();
        }
    }

    protected void onEndParse(XmlPullParser parser) throws XmlPullParserException, IOException {
    }

    protected void onUnknownEvent(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.nextToken();
    }

    private int getEndEvent() {
        if (this instanceof XMLElement) {
            return 3;
        }
        return 1;
    }
}

