/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.XmlIndentingSerializer;
import java.io.Closeable;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlParserToSerializer {
    private final XmlPullParser parser;
    private XmlSerializer serializer;
    private int depth = 0;
    private boolean enableIndent;
    boolean processNamespace;
    boolean reportNamespaceAttrs;

    public XmlParserToSerializer(XmlPullParser parser, XmlSerializer serializer) {
        this.parser = parser;
        this.serializer = XmlIndentingSerializer.create(serializer);
        this.enableIndent = true;
        XMLUtil.setFeatureSafe(parser, "http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XMLUtil.setFeatureSafe(parser, "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes", true);
    }

    public void setEnableIndent(boolean enableIndent) {
        if (enableIndent == this.enableIndent) {
            return;
        }
        this.enableIndent = enableIndent;
        if (enableIndent) {
            this.serializer = XmlIndentingSerializer.create(this.serializer);
        } else if (this.serializer instanceof XmlIndentingSerializer) {
            this.serializer = ((XmlIndentingSerializer)this.serializer).getBaseSerializer();
        }
    }

    public void write() throws IOException, XmlPullParserException {
        XmlPullParser parser = this.parser;
        this.processNamespace = XMLUtil.getFeatureSafe(parser, "http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
        this.reportNamespaceAttrs = XMLUtil.getFeatureSafe(parser, "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes", false);
        int event = parser.nextToken();
        while (this.nextEvent(event)) {
            event = parser.nextToken();
        }
        this.serializer.flush();
        this.close();
    }

    private void close() throws IOException {
        XmlPullParser parser = this.parser;
        if (parser instanceof Closeable) {
            ((Closeable)((Object)parser)).close();
        }
        XMLUtil.close(this.serializer);
    }

    private boolean nextEvent(int event) throws IOException, XmlPullParserException {
        boolean hasNext = event >= 0;
        switch (event) {
            case 0: {
                this.onStartDocument();
                ++this.depth;
                break;
            }
            case 2: {
                this.onStartTag();
                ++this.depth;
                break;
            }
            case 4: {
                this.onText();
                break;
            }
            case 6: {
                this.onEntityRef();
                break;
            }
            case 5: {
                this.onCdsect();
                break;
            }
            case 9: {
                this.onComment();
                break;
            }
            case 7: {
                this.onIgnorableWhitespace();
                break;
            }
            case 10: {
                this.onDocDecl();
                break;
            }
            case 8: {
                this.onProcessingInstruction();
                break;
            }
            case 3: {
                this.onEndTag();
                --this.depth;
                hasNext = this.depth != 0;
                break;
            }
            case 1: {
                this.onEndDocument();
                --this.depth;
                hasNext = this.depth != 0;
            }
        }
        return hasNext;
    }

    private void onStartDocument() throws IOException {
        this.serializer.startDocument(this.parser.getInputEncoding(), (Boolean)XMLUtil.getPropertySafe(this.parser, XMLUtil.PROPERTY_XMLDECL_STANDALONE));
    }

    private void onStartTag() throws IOException, XmlPullParserException {
        int i;
        boolean countNamespaceAsAttribute;
        XmlPullParser parser = this.parser;
        XmlSerializer serializer = this.serializer;
        boolean processNamespace = this.processNamespace;
        boolean bl = countNamespaceAsAttribute = processNamespace && this.reportNamespaceAttrs;
        if (!countNamespaceAsAttribute) {
            int nsCount = parser.getNamespaceCount(parser.getDepth());
            for (i = 0; i < nsCount; ++i) {
                String prefix = parser.getNamespacePrefix(i);
                String namespace = parser.getNamespaceUri(i);
                serializer.setPrefix(prefix, namespace);
            }
        }
        serializer.startTag(parser.getNamespace(), parser.getName());
        int attrCount = parser.getAttributeCount();
        for (i = 0; i < attrCount; ++i) {
            String namespace = processNamespace ? parser.getAttributeNamespace(i) : null;
            serializer.attribute(namespace, parser.getAttributeName(i), parser.getAttributeValue(i));
        }
    }

    private void onText() throws IOException {
        this.serializer.text(this.parser.getText());
    }

    private void onEntityRef() throws IOException {
        this.serializer.entityRef(this.parser.getName());
    }

    private void onCdsect() throws IOException {
        this.serializer.cdsect(this.parser.getText());
    }

    private void onComment() throws IOException {
        this.serializer.comment(this.parser.getText());
    }

    private void onEndTag() throws IOException {
        this.serializer.endTag(this.parser.getNamespace(), this.parser.getName());
    }

    private void onEndDocument() throws IOException {
        this.serializer.endDocument();
    }

    private void onDocDecl() throws IOException {
        this.serializer.docdecl(this.parser.getText());
    }

    private void onIgnorableWhitespace() throws IOException {
        this.serializer.ignorableWhitespace(this.parser.getText());
    }

    private void onProcessingInstruction() throws IOException {
        this.serializer.processingInstruction(this.parser.getText());
    }
}

