/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml.kxml2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import org.xmlpull.v1.XmlSerializer;

public class KXmlSerializer
implements XmlSerializer {
    private static final int BUFFER_LEN = 8192;
    private final char[] mText = new char[8192];
    private int mPos;
    private Writer writer;
    private boolean pending;
    private int auto;
    private int depth;
    private String[] elementStack = new String[12];
    private int[] nspCounts = new int[4];
    private String[] nspStack = new String[8];
    private boolean[] indent = new boolean[4];
    private boolean firstAttributeWritten;
    private int indentAttributeReference;
    private boolean unicode;
    private String encoding;
    private boolean enableIndentAttributes = true;

    public boolean isEnableIndentAttributes() {
        return this.enableIndentAttributes;
    }

    public void setEnableIndentAttributes(boolean enableIndentAttributes) {
        this.enableIndentAttributes = enableIndentAttributes;
    }

    private void append(char c) throws IOException {
        if (this.mPos >= 8192) {
            this.flushBuffer();
        }
        this.mText[this.mPos++] = c;
    }

    private void append(String str, int i, int length) throws IOException {
        while (length > 0) {
            int batch;
            if (this.mPos == 8192) {
                this.flushBuffer();
            }
            if ((batch = 8192 - this.mPos) > length) {
                batch = length;
            }
            str.getChars(i, i + batch, this.mText, this.mPos);
            i += batch;
            length -= batch;
            this.mPos += batch;
        }
    }

    private void appendSpace(int length) throws IOException {
        while (length > 0) {
            int batch;
            if (this.mPos == 8192) {
                this.flushBuffer();
            }
            if ((batch = 8192 - this.mPos) > length) {
                batch = length;
            }
            Arrays.fill(this.mText, this.mPos, this.mPos + batch, ' ');
            length -= batch;
            this.mPos += batch;
        }
    }

    private void append(String str) throws IOException {
        this.append(str, 0, str.length());
    }

    private void flushBuffer() throws IOException {
        if (this.mPos > 0) {
            this.writer.write(this.mText, 0, this.mPos);
            this.writer.flush();
            this.mPos = 0;
        }
    }

    private void check(boolean close, boolean voidTag) throws IOException {
        if (!this.pending) {
            return;
        }
        ++this.depth;
        this.pending = false;
        if (this.indent.length <= this.depth) {
            boolean[] hlp = new boolean[this.depth + 4];
            System.arraycopy(this.indent, 0, hlp, 0, this.depth);
            this.indent = hlp;
        }
        this.indent[this.depth] = this.indent[this.depth - 1];
        for (int i = this.nspCounts[this.depth - 1]; i < this.nspCounts[this.depth]; ++i) {
            if (!voidTag) {
                this.append(" xmlns");
            }
            if (!this.nspStack[i * 2].isEmpty()) {
                if (!voidTag) {
                    this.append(':');
                    this.append(this.nspStack[i * 2]);
                }
            } else if (this.getNamespace().isEmpty() && !this.nspStack[i * 2 + 1].isEmpty()) {
                throw new IllegalStateException("Cannot set default namespace for elements in no namespace");
            }
            if (voidTag) continue;
            this.append("=\"");
            this.writeEscaped(this.nspStack[i * 2 + 1], 34);
            this.append('\"');
        }
        if (this.nspCounts.length <= this.depth + 1) {
            int[] hlp = new int[this.depth + 8];
            System.arraycopy(this.nspCounts, 0, hlp, 0, this.depth + 1);
            this.nspCounts = hlp;
        }
        this.nspCounts[this.depth + 1] = this.nspCounts[this.depth];
        if (close && !voidTag) {
            this.append(" />");
        } else {
            this.append('>');
        }
    }

    private void writeEscaped(String s, int quot) throws IOException {
        int length = s.length();
        block6: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    if (quot == -1) {
                        this.append(c);
                        continue block6;
                    }
                    this.append("&#" + c + ';');
                    continue block6;
                }
                case '&': {
                    this.append("&amp;");
                    continue block6;
                }
                case '>': {
                    this.append("&gt;");
                    continue block6;
                }
                case '<': {
                    this.append("&lt;");
                    continue block6;
                }
                default: {
                    boolean allowedInXml;
                    if (c == quot) {
                        this.append(c == '\"' ? "&quot;" : "&apos;");
                        continue block6;
                    }
                    boolean bl = allowedInXml = c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
                    if (allowedInXml) {
                        if (this.unicode || c < '\u007f') {
                            this.append(c);
                            continue block6;
                        }
                        this.append("&#" + c + ";");
                        continue block6;
                    }
                    if (Character.isHighSurrogate(c) && i < length - 1) {
                        this.writeSurrogate(c, s.charAt(i + 1));
                        ++i;
                        continue block6;
                    }
                    this.append("&#" + c + ";");
                }
            }
        }
    }

    private static void reportInvalidCharacter(char ch) {
        throw new IllegalArgumentException("Illegal character (U+" + Integer.toHexString(ch) + ")");
    }

    @Override
    public void docdecl(String dd) throws IOException {
        this.append("<!DOCTYPE");
        this.append(dd);
        this.append('>');
    }

    @Override
    public void endDocument() throws IOException {
        while (this.depth > 0) {
            this.endTag(this.elementStack[this.depth * 3 - 3], this.elementStack[this.depth * 3 - 1]);
        }
        this.flush();
    }

    @Override
    public void entityRef(String name) throws IOException {
        this.check(false, false);
        this.append('&');
        this.append(name);
        this.append(';');
    }

    @Override
    public boolean getFeature(String name) {
        return "http://xmlpull.org/v1/doc/features.html#indent-output".equals(name) && this.indent[this.depth];
    }

    @Override
    public String getPrefix(String namespace, boolean create) {
        try {
            return this.getPrefix(namespace, false, create);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private String getPrefix(String namespace, boolean includeDefault, boolean create) throws IOException {
        String prefix;
        int[] nspCounts = this.nspCounts;
        int depth = this.depth;
        String[] nspStack = this.nspStack;
        for (int i = nspCounts[depth + 1] * 2 - 2; i >= 0; i -= 2) {
            if (!nspStack[i + 1].equals(namespace) || !includeDefault && nspStack[i].isEmpty()) continue;
            String cand = nspStack[i];
            for (int j = i + 2; j < nspCounts[depth + 1] * 2; ++j) {
                if (!nspStack[j].equals(cand)) continue;
                cand = null;
                break;
            }
            if (cand == null) continue;
            return cand;
        }
        if (!create) {
            return null;
        }
        if (namespace.isEmpty()) {
            prefix = "";
        } else {
            block2: do {
                prefix = "n" + this.auto++;
                for (int i = nspCounts[depth + 1] * 2 - 2; i >= 0; i -= 2) {
                    if (!prefix.equals(nspStack[i])) continue;
                    prefix = null;
                    continue block2;
                }
            } while (prefix == null);
        }
        boolean p = this.pending;
        this.pending = false;
        this.setPrefix(prefix, namespace);
        this.pending = p;
        return prefix;
    }

    @Override
    public Object getProperty(String name) {
        throw new RuntimeException("Unsupported property: " + name);
    }

    @Override
    public void ignorableWhitespace(String s) throws IOException {
        this.text(s);
    }

    @Override
    public void setFeature(String name, boolean value) {
        if (!"http://xmlpull.org/v1/doc/features.html#indent-output".equals(name)) {
            throw new RuntimeException("Unsupported Feature: " + name);
        }
        this.indent[this.depth] = value;
        this.firstAttributeWritten = false;
    }

    @Override
    public void setProperty(String name, Object value) {
        throw new RuntimeException("Unsupported Property:" + value);
    }

    @Override
    public void setPrefix(String prefix, String namespace) throws IOException {
        String defined;
        this.check(false, false);
        if (prefix == null) {
            prefix = "";
        }
        if (namespace == null) {
            namespace = "";
        }
        if (prefix.equals(defined = this.getPrefix(namespace, true, false))) {
            return;
        }
        int n = this.depth + 1;
        int n2 = this.nspCounts[n];
        this.nspCounts[n] = n2 + 1;
        int pos = n2 << 1;
        if (this.nspStack.length < pos + 1) {
            String[] hlp = new String[this.nspStack.length + 16];
            System.arraycopy(this.nspStack, 0, hlp, 0, pos);
            this.nspStack = hlp;
        }
        this.nspStack[pos++] = prefix;
        this.nspStack[pos] = namespace;
    }

    @Override
    public void setOutput(Writer writer) {
        this.writer = writer;
        this.nspCounts[0] = 2;
        this.nspCounts[1] = 2;
        this.nspStack[0] = "";
        this.nspStack[1] = "";
        this.nspStack[2] = "xml";
        this.nspStack[3] = "http://www.w3.org/XML/1998/namespace";
        this.pending = false;
        this.auto = 0;
        this.depth = 0;
        this.unicode = false;
    }

    @Override
    public void setOutput(OutputStream os, String encoding) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("os == null");
        }
        this.setOutput(encoding == null ? new OutputStreamWriter(os) : new OutputStreamWriter(os, encoding));
        this.encoding = encoding;
        if (encoding != null && encoding.toLowerCase(Locale.US).startsWith("utf")) {
            this.unicode = true;
        }
    }

    @Override
    public void startDocument(String encoding, Boolean standalone) throws IOException {
        this.append("<?xml version='1.0' ");
        if (encoding != null) {
            this.encoding = encoding;
            if (encoding.toLowerCase(Locale.US).startsWith("utf")) {
                this.unicode = true;
            }
        }
        if (this.encoding != null) {
            this.append("encoding='");
            this.append(this.encoding);
            this.append("' ");
        }
        if (standalone != null) {
            this.append("standalone='");
            this.append(standalone != false ? "yes" : "no");
            this.append("' ");
        }
        this.append("?>");
    }

    @Override
    public XmlSerializer startTag(String namespace, String name) throws IOException {
        String prefix;
        int esp;
        this.check(false, false);
        this.firstAttributeWritten = false;
        this.indentAttributeReference = 0;
        if (this.indent[this.depth]) {
            this.append('\r');
            this.append('\n');
            int spaceLength = 2 * this.depth;
            this.appendSpace(spaceLength);
            this.indentAttributeReference = spaceLength;
        }
        if (this.elementStack.length < (esp = this.depth * 3) + 3) {
            String[] hlp = new String[this.elementStack.length + 12];
            System.arraycopy(this.elementStack, 0, hlp, 0, esp);
            this.elementStack = hlp;
        }
        String string = prefix = namespace == null ? "" : this.getPrefix(namespace, true, true);
        if (namespace != null && namespace.isEmpty()) {
            for (int i = this.nspCounts[this.depth]; i < this.nspCounts[this.depth + 1]; ++i) {
                if (!this.nspStack[i * 2].isEmpty() || this.nspStack[i * 2 + 1].isEmpty()) continue;
                throw new IllegalStateException("Cannot set default namespace for elements in no namespace");
            }
        }
        this.elementStack[esp++] = namespace;
        this.elementStack[esp++] = prefix;
        this.elementStack[esp] = name;
        this.append('<');
        ++this.indentAttributeReference;
        if (!prefix.isEmpty()) {
            this.append(prefix);
            this.append(':');
            this.indentAttributeReference += prefix.length() + 1;
        }
        this.append(name);
        int len = name.length();
        if (len > 20) {
            len = 20;
        }
        this.indentAttributeReference += len;
        this.pending = true;
        return this;
    }

    @Override
    public XmlSerializer attribute(String namespace, String name, String value) throws IOException {
        if (!this.pending) {
            throw new IllegalStateException("illegal position for attribute");
        }
        if (namespace == null) {
            namespace = "";
        }
        String prefix = namespace.isEmpty() ? "" : this.getPrefix(namespace, false, true);
        this.attributeIndent();
        this.append(' ');
        if (!prefix.isEmpty()) {
            this.append(prefix);
            this.append(':');
        }
        this.append(name);
        this.append('=');
        char q = value.indexOf(34) == -1 ? (char)'\"' : '\'';
        this.append(q);
        this.writeEscaped(value, q);
        this.append(q);
        this.firstAttributeWritten = true;
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.check(false, false);
        this.flushBuffer();
    }

    @Override
    public XmlSerializer endTag(String namespace, String name) throws IOException {
        if (!this.pending) {
            --this.depth;
        }
        if (namespace == null && this.elementStack[this.depth * 3] != null || namespace != null && !namespace.equals(this.elementStack[this.depth * 3]) || !this.elementStack[this.depth * 3 + 2].equals(name)) {
            throw new IllegalArgumentException("</{" + namespace + "}" + name + "> does not match start");
        }
        if (this.pending) {
            this.check(true, false);
            --this.depth;
        } else {
            if (this.indent[this.depth + 1]) {
                this.append('\r');
                this.append('\n');
                this.appendSpace(2 * this.depth);
            }
            this.append("</");
            String prefix = this.elementStack[this.depth * 3 + 1];
            if (!prefix.isEmpty()) {
                this.append(prefix);
                this.append(':');
            }
            this.append(name);
            this.append('>');
        }
        this.nspCounts[this.depth + 1] = this.nspCounts[this.depth];
        return this;
    }

    public XmlSerializer endTag(boolean voidTag, String namespace, String name) throws IOException {
        if (!this.pending) {
            --this.depth;
        }
        if (namespace == null && this.elementStack[this.depth * 3] != null || namespace != null && !namespace.equals(this.elementStack[this.depth * 3]) || !this.elementStack[this.depth * 3 + 2].equals(name)) {
            throw new IllegalArgumentException("</{" + namespace + "}" + name + "> does not match start");
        }
        if (this.pending) {
            this.check(true, voidTag);
            --this.depth;
        } else {
            if (this.indent[this.depth + 1] && !voidTag) {
                this.append('\r');
                this.append('\n');
                this.appendSpace(2 * this.depth);
            }
            if (!voidTag) {
                this.append("</");
                String prefix = this.elementStack[this.depth * 3 + 1];
                if (!prefix.isEmpty()) {
                    this.append(prefix);
                    this.append(':');
                }
                this.append(name);
                this.append('>');
            }
        }
        this.nspCounts[this.depth + 1] = this.nspCounts[this.depth];
        return this;
    }

    @Override
    public String getNamespace() {
        return this.getDepth() == 0 ? null : this.elementStack[this.getDepth() * 3 - 3];
    }

    @Override
    public String getName() {
        return this.getDepth() == 0 ? null : this.elementStack[this.getDepth() * 3 - 1];
    }

    @Override
    public int getDepth() {
        return this.pending ? this.depth + 1 : this.depth;
    }

    @Override
    public XmlSerializer text(String text) throws IOException {
        this.check(false, false);
        this.indent[this.depth] = false;
        this.writeEscaped(text, -1);
        return this;
    }

    @Override
    public XmlSerializer text(char[] text, int start, int len) throws IOException {
        this.text(new String(text, start, len));
        return this;
    }

    @Override
    public void cdsect(String data) throws IOException {
        this.check(false, false);
        data = data.replace("]]>", "]]]]><![CDATA[>");
        this.append("<![CDATA[");
        for (int i = 0; i < data.length(); ++i) {
            boolean allowedInCdata;
            char ch = data.charAt(i);
            boolean bl = allowedInCdata = ch >= ' ' && ch <= '\ud7ff' || ch == '\t' || ch == '\n' || ch == '\r' || ch >= '\ue000' && ch <= '\ufffd';
            if (allowedInCdata) {
                this.append(ch);
                continue;
            }
            if (Character.isHighSurrogate(ch) && i < data.length() - 1) {
                this.append("]]>");
                this.writeSurrogate(ch, data.charAt(++i));
                this.append("<![CDATA[");
                continue;
            }
            KXmlSerializer.reportInvalidCharacter(ch);
        }
        this.append("]]>");
    }

    private void writeSurrogate(char high, char low) throws IOException {
        if (!Character.isLowSurrogate(low)) {
            throw new IllegalArgumentException("Bad surrogate pair (U+" + Integer.toHexString(high) + " U+" + Integer.toHexString(low) + ")");
        }
        int codePoint = Character.toCodePoint(high, low);
        this.append("&#" + codePoint + ";");
    }

    @Override
    public void comment(String comment) throws IOException {
        this.check(false, false);
        this.append("<!--");
        this.append(comment);
        this.append("-->");
    }

    @Override
    public void processingInstruction(String pi) throws IOException {
        this.check(false, false);
        this.append("<?");
        this.append(pi);
        this.append("?>");
    }

    private void attributeIndent() throws IOException {
        if (!(this.isEnableIndentAttributes() && this.firstAttributeWritten && this.indent[this.depth])) {
            return;
        }
        int length = this.indentAttributeReference;
        if (length <= 0) {
            return;
        }
        this.append('\r');
        this.append('\n');
        this.appendSpace(length);
    }
}

