/*
 * Decompiled with CFR 0.152.
 */
package redis;

import java.io.Serializable;
import org.apache.pekko.util.ByteString;
import redis.ByteStringDeserializer;
import redis.protocol.Bulk;
import redis.protocol.Integer;
import redis.protocol.MultiBulk;
import redis.protocol.RedisReply;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class MultiBulkConverter$ {
    public static final MultiBulkConverter$ MODULE$ = new MultiBulkConverter$();

    public Seq<String> toSeqString(MultiBulk reply) {
        return (Seq)reply.responses().map((Function1 & Serializable)r -> (Vector)r.map((Function1 & Serializable)x$1 -> x$1.toString())).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public <R> Seq<R> toSeqByteString(MultiBulk reply, ByteStringDeserializer<R> deserializer) {
        return (Seq)reply.responses().map((Function1 & Serializable)r -> (Vector)r.map((Function1 & Serializable)reply -> deserializer.deserialize(reply.toByteString()))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public <R> Seq<Option<R>> toSeqOptionByteString(MultiBulk reply, ByteStringDeserializer<R> deserializer) {
        return (Seq)reply.responses().map((Function1 & Serializable)r -> (Vector)r.map((Function1 & Serializable)x$2 -> x$2.asOptByteString().map((Function1 & Serializable)bs -> deserializer.deserialize((ByteString)bs)))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public <R> Seq<Tuple2<R, Object>> toSeqTuple2ByteStringDouble(MultiBulk reply, ByteStringDeserializer<R> deserializer) {
        return (Seq)reply.responses().map((Function1 & Serializable)r -> {
            Vector s = (Vector)r.map((Function1 & Serializable)x$3 -> x$3.toByteString());
            Builder builder = package$.MODULE$.Seq().newBuilder();
            s.grouped(2).foreach((Function1 & Serializable)x0$1 -> {
                SeqOps seqOps;
                Vector vector = x0$1;
                if (vector != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    ByteString a = (ByteString)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    ByteString b = (ByteString)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    return (Builder)builder.$plus$eq((Object)new Tuple2(deserializer.deserialize(a), (Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(b.utf8String())))));
                }
                throw new MatchError((Object)vector);
            });
            return (Seq)builder.result();
        }).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public Option<Tuple2<ByteString, ByteString>> toClusterSlots(MultiBulk reply) {
        return reply.responses().map((Function1 & Serializable)slot -> {
            Vector elementSeq = slot;
            ByteString begin = ((RedisReply)elementSeq.apply(0)).toByteString();
            ByteString end = ((RedisReply)elementSeq.apply(1)).toByteString();
            return new Tuple2((Object)begin, (Object)end);
        });
    }

    public Map<String, String> toMapString(MultiBulk reply) {
        return (Map)reply.responses().map((Function1 & Serializable)bs -> {
            Builder builder = Predef$.MODULE$.Map().newBuilder();
            MODULE$.seqtoMapString((Seq<RedisReply>)bs, (Builder<Tuple2<String, String>, Map<String, String>>)builder);
            return (Map)builder.result();
        }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    private void seqtoMapString(Seq<RedisReply> bsSeq, Builder<Tuple2<String, String>, Map<String, String>> acc) {
        while (bsSeq.nonEmpty()) {
            acc.$plus$eq((Object)new Tuple2(((RedisReply)bsSeq.head()).asOptByteString().map((Function1 & Serializable)x$4 -> x$4.utf8String()).getOrElse((Function0 & Serializable)() -> ""), ((RedisReply)((IterableOps)bsSeq.tail()).head()).asOptByteString().map((Function1 & Serializable)x$5 -> x$5.utf8String()).getOrElse((Function0 & Serializable)() -> "")));
            bsSeq = (Seq)((IterableOps)bsSeq.tail()).tail();
        }
    }

    public Seq<Map<String, String>> toSeqMapString(MultiBulk reply) {
        return (Seq)reply.responses().map((Function1 & Serializable)s -> (Vector)((StrictOptimizedIterableOps)s.map((Function1 & Serializable)x0$1 -> {
            RedisReply redisReply = x0$1;
            if (redisReply instanceof MultiBulk) {
                MultiBulk multiBulk = (MultiBulk)redisReply;
                return (Seq)multiBulk.responses().map((Function1 & Serializable)s -> {
                    Builder builder = package$.MODULE$.Seq().newBuilder();
                    s.grouped(2).foreach((Function1 & Serializable)x0$2 -> {
                        SeqOps seqOps;
                        Vector vector = x0$2;
                        if (vector != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                            RedisReply a = (RedisReply)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                            RedisReply b = (RedisReply)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                            return (Builder)builder.$plus$eq((Object)new Tuple2((Object)a.toString(), (Object)b.toString()));
                        }
                        throw new MatchError((Object)vector);
                    });
                    return (Seq)builder.result();
                }).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
            }
            return (Seq)Nil$.MODULE$;
        })).map((Function1 & Serializable)x$6 -> x$6.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public <R> Option<Tuple2<String, R>> toOptionStringByteString(MultiBulk reply, ByteStringDeserializer<R> deserializer) {
        return reply.responses().map((Function1 & Serializable)r -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)r.head().toString()), deserializer.deserialize(((RedisReply)r.tail().head()).toByteString())));
    }

    public Seq<Object> toSeqBoolean(MultiBulk reply) {
        return (Seq)reply.responses().map((Function1 & Serializable)r -> (Vector)r.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MultiBulkConverter$.$anonfun$toSeqBoolean$2(x$7)))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public Seq<String> toStringsSeq(RedisReply rd) {
        MultiBulk multiBulk;
        Option<Vector<RedisReply>> option;
        RedisReply redisReply = rd;
        if (redisReply instanceof MultiBulk && (option = (multiBulk = (MultiBulk)redisReply).responses()) instanceof Some) {
            Some some = (Some)option;
            Vector v = (Vector)some.value();
            return (Seq)v.flatMap((Function1 & Serializable)r -> MODULE$.toStringsSeq((RedisReply)r));
        }
        if (redisReply instanceof Bulk) {
            Bulk bulk = (Bulk)redisReply;
            Option<ByteString> b = bulk.response();
            return Option$.MODULE$.option2Iterable(b.map((Function1 & Serializable)x$8 -> x$8.decodeString("US-ASCII"))).toSeq();
        }
        if (redisReply instanceof Integer) {
            Integer integer = (Integer)redisReply;
            ByteString i = integer.i();
            return new .colon.colon((Object)i.decodeString("US-ASCII"), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$toSeqBoolean$2(RedisReply x$7) {
        String string = x$7.toString();
        String string2 = "1";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private MultiBulkConverter$() {
    }
}

