/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import io.github.redouane59.RelationType;
import io.github.redouane59.twitter.IAPIEventListener;
import io.github.redouane59.twitter.ITwitterClientArchive;
import io.github.redouane59.twitter.ITwitterClientV1;
import io.github.redouane59.twitter.ITwitterClientV2;
import io.github.redouane59.twitter.dto.collections.CollectionsResponse;
import io.github.redouane59.twitter.dto.collections.TimeLineOrder;
import io.github.redouane59.twitter.dto.dm.DirectMessage;
import io.github.redouane59.twitter.dto.dm.DmEvent;
import io.github.redouane59.twitter.dto.dm.DmListAnswer;
import io.github.redouane59.twitter.dto.endpoints.AdditionalParameters;
import io.github.redouane59.twitter.dto.getrelationship.IdList;
import io.github.redouane59.twitter.dto.getrelationship.RelationshipObjectResponse;
import io.github.redouane59.twitter.dto.others.BlockResponse;
import io.github.redouane59.twitter.dto.others.RateLimitStatus;
import io.github.redouane59.twitter.dto.others.RequestToken;
import io.github.redouane59.twitter.dto.stream.StreamRules;
import io.github.redouane59.twitter.dto.tweet.HiddenResponse;
import io.github.redouane59.twitter.dto.tweet.LikeResponse;
import io.github.redouane59.twitter.dto.tweet.MediaCategory;
import io.github.redouane59.twitter.dto.tweet.Tweet;
import io.github.redouane59.twitter.dto.tweet.TweetCountsList;
import io.github.redouane59.twitter.dto.tweet.TweetList;
import io.github.redouane59.twitter.dto.tweet.TweetSearchResponseV1;
import io.github.redouane59.twitter.dto.tweet.TweetV1;
import io.github.redouane59.twitter.dto.tweet.TweetV1Deserializer;
import io.github.redouane59.twitter.dto.tweet.TweetV2;
import io.github.redouane59.twitter.dto.tweet.UploadMediaResponse;
import io.github.redouane59.twitter.dto.user.FollowBody;
import io.github.redouane59.twitter.dto.user.FollowResponse;
import io.github.redouane59.twitter.dto.user.User;
import io.github.redouane59.twitter.dto.user.UserList;
import io.github.redouane59.twitter.dto.user.UserV2;
import io.github.redouane59.twitter.helpers.AbstractRequestHelper;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import io.github.redouane59.twitter.helpers.RequestHelper;
import io.github.redouane59.twitter.helpers.RequestHelperV2;
import io.github.redouane59.twitter.helpers.URLHelper;
import io.github.redouane59.twitter.signature.TwitterCredentials;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterClient
implements ITwitterClientV1,
ITwitterClientV2,
ITwitterClientArchive {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TwitterClient.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private URLHelper urlHelper = new URLHelper();
    private RequestHelper requestHelperV1;
    private RequestHelperV2 requestHelperV2;
    private TwitterCredentials twitterCredentials;
    public static final String TWEET_FIELDS = "tweet.fields";
    public static final String ALL_TWEET_FIELDS = "attachments,author_id,created_at,entities,geo,id,in_reply_to_user_id,lang,possibly_sensitive,public_metrics,referenced_tweets,source,text,withheld,context_annotations,conversation_id,reply_settings";
    public static final String EXPANSION = "expansions";
    public static final String ALL_EXPANSIONS = "author_id,entities.mentions.username,in_reply_to_user_id,referenced_tweets.id,referenced_tweets.id.author_id";
    public static final String USER_FIELDS = "user.fields";
    public static final String ALL_USER_FIELDS = "id,created_at,entities,username,name,location,url,verified,profile_image_url,public_metrics,pinned_tweet_id,description,protected";
    private static final String QUERY = "query";
    private static final String CURSOR = "cursor";
    private static final String NEXT = "next";
    private static final String PAGINATION_TOKEN = "pagination_token";
    private static final String PINNED_TWEET_ID = "pinned_tweet_id";
    private static final String[] DEFAULT_VALID_CREDENTIALS_FILE_NAMES = new String[]{"test-twitter-credentials.json", "twitter-credentials.json"};

    public TwitterClient() {
        this(TwitterClient.getAuthentication());
    }

    public TwitterClient(TwitterCredentials credentials) {
        this(credentials, new ServiceBuilder(credentials.getApiKey()).apiSecret(credentials.getApiSecretKey()));
    }

    public TwitterClient(TwitterCredentials credentials, HttpClient httpClient) {
        this(credentials, new ServiceBuilder(credentials.getApiKey()).apiSecret(credentials.getApiSecretKey()).httpClient(httpClient));
    }

    public TwitterClient(TwitterCredentials credentials, HttpClient httpClient, HttpClientConfig config) {
        this(credentials, new ServiceBuilder(credentials.getApiKey()).apiSecret(credentials.getApiSecretKey()).httpClient(httpClient).httpClientConfig(config));
    }

    public TwitterClient(TwitterCredentials credentials, ServiceBuilder serviceBuilder) {
        this(credentials, serviceBuilder.apiKey(credentials.getApiKey()).apiSecret(credentials.getApiSecretKey()).build((DefaultApi10a)TwitterApi.instance()));
    }

    public TwitterClient(TwitterCredentials credentials, OAuth10aService service) {
        this.twitterCredentials = credentials;
        this.requestHelperV1 = new RequestHelper(credentials, service);
        this.requestHelperV2 = new RequestHelperV2(credentials, service);
    }

    private List<String> getUserIdsByRelation(String url) {
        Optional<IdList> idListResponse;
        String cursor = "-1";
        ArrayList<String> result = new ArrayList<String>();
        do {
            String urlWithCursor = url + "&" + CURSOR + "=" + cursor;
            idListResponse = this.getRequestHelper().getRequest(urlWithCursor, IdList.class);
            if (!idListResponse.isPresent()) break;
            result.addAll(idListResponse.get().getIds());
        } while (!(cursor = idListResponse.get().getNextCursor()).equals("0"));
        return result;
    }

    private List<User> getUsersInfoByRelation(String url) {
        Optional<UserList> userListDTO;
        String token = null;
        ArrayList<User> result = new ArrayList<User>();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("max_results", String.valueOf(1000));
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        do {
            String urlWithCursor = url;
            if (token != null) {
                urlWithCursor = urlWithCursor + "?" + PAGINATION_TOKEN + "=" + token;
            }
            if (!(userListDTO = this.getRequestHelper().getRequestWithParameters(urlWithCursor, parameters, UserList.class)).isPresent()) break;
            result.addAll(userListDTO.get().getData());
        } while ((token = userListDTO.get().getMeta().getNextToken()) != null);
        return result;
    }

    public List<User> getUsersByRelation(String userId, RelationType relationType) {
        String url = null;
        if (relationType == RelationType.FOLLOWER) {
            url = this.urlHelper.getFollowersUrl(userId);
        } else if (relationType == RelationType.FOLLOWING) {
            url = this.urlHelper.getFollowingUrl(userId);
        }
        return this.getUsersInfoByRelation(url);
    }

    @Override
    public UserList getFollowers(String userId) {
        return this.getFollowers(userId, AdditionalParameters.builder().maxResults(1000).build());
    }

    @Override
    public UserList getFollowers(String userId, AdditionalParameters additionalParameters) {
        String url = this.urlHelper.getFollowersUrl(userId);
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserList getFollowing(String userId) {
        return this.getFollowing(userId, AdditionalParameters.builder().maxResults(1000).build());
    }

    @Override
    public UserList getFollowing(String userId, AdditionalParameters additionalParameters) {
        String url = this.urlHelper.getFollowingUrl(userId);
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public RelationType getRelationType(String userId1, String userId2) {
        String url = this.urlHelper.getFriendshipUrl(userId1, userId2);
        RelationshipObjectResponse relationshipDTO = this.getRequestHelper().getRequest(url, RelationshipObjectResponse.class).orElseThrow(NoSuchElementException::new);
        Boolean followedBy = relationshipDTO.getRelationship().getSource().isFollowedBy();
        Boolean following = relationshipDTO.getRelationship().getSource().isFollowing();
        if (followedBy.booleanValue() && following.booleanValue()) {
            return RelationType.FRIENDS;
        }
        if (!followedBy.booleanValue() && !following.booleanValue()) {
            return RelationType.NONE;
        }
        if (followedBy.booleanValue()) {
            return RelationType.FOLLOWER;
        }
        return RelationType.FOLLOWING;
    }

    @Override
    public List<String> getRetweetersId(String tweetId) {
        String url = this.urlHelper.getRetweetersUrl(tweetId);
        return this.getUserIdsByRelation(url);
    }

    @Override
    public List<String> getFollowersIds(String userId) {
        String url = this.urlHelper.getFollowersIdsUrl(userId);
        return this.getUserIdsByRelation(url);
    }

    @Override
    public FollowResponse follow(String targetUserId) {
        String url = this.urlHelper.getFollowUrl(this.getUserIdFromAccessToken());
        String body = OBJECT_MAPPER.writeValueAsString((Object)new FollowBody(targetUserId));
        return this.requestHelperV1.postRequestWithBodyJson(url, new HashMap<String, String>(), body, FollowResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public FollowResponse unfollow(String targetUserId) {
        String url = this.urlHelper.getUnfollowUrl(this.getUserIdFromAccessToken(), targetUserId);
        return this.getRequestHelper().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, FollowResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public BlockResponse blockUser(String targetUserId) {
        String url = this.urlHelper.getBlockUserUrl(this.getUserIdFromAccessToken());
        return this.getRequestHelper().makeRequest(Verb.POST, url, new HashMap<String, String>(), OBJECT_MAPPER.writeValueAsString((Object)new FollowBody(targetUserId)), true, BlockResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public BlockResponse unblockUser(String targetUserId) {
        String url = this.urlHelper.getUnblockUserUrl(this.getUserIdFromAccessToken(), targetUserId);
        return this.getRequestHelper().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, BlockResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserList getBlockedUsers() {
        String url = this.urlHelper.getBlockingUsersUrl(this.getUserIdFromAccessToken());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public User getUserFromUserId(String userId) {
        String url = this.getUrlHelper().getUserUrl(userId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, UserV2.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserV2 getUserFromUserName(String userName) {
        String url = this.getUrlHelper().getUserUrlFromName(userName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, UserV2.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public List<User> getUsersFromUserNames(List<String> userNames) {
        String url = this.getUrlHelper().getUsersByUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < userNames.size() && i < 100; ++i) {
            String name = userNames.get(i);
            names.append(name);
            names.append(",");
        }
        names.delete(names.length() - 1, names.length());
        parameters.put("usernames", names.toString());
        List<UserV2.UserData> result = this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new).getData();
        return result.stream().map(userData -> UserV2.builder().data((UserV2.UserData)userData).build()).collect(Collectors.toList());
    }

    @Override
    public List<User> getUsersFromUserIds(List<String> userIds) {
        String url = this.getUrlHelper().getUsersUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < userIds.size() && i < 100; ++i) {
            String name = userIds.get(i);
            names.append(name);
            names.append(",");
        }
        names.delete(names.length() - 1, names.length());
        parameters.put("ids", names.toString());
        List<UserV2.UserData> result = this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new).getData();
        return result.stream().map(userData -> UserV2.builder().data((UserV2.UserData)userData).build()).collect(Collectors.toList());
    }

    @Override
    public RateLimitStatus getRateLimitStatus() {
        String url = "https://api.twitter.com/1.1/application/rate_limit_status.json";
        return this.getRequestHelper().getRequest(url, RateLimitStatus.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public LikeResponse likeTweet(String tweetId) {
        String url = this.getUrlHelper().getLikeUrl(this.getUserIdFromAccessToken());
        return this.getRequestHelperV1().postRequestWithBodyJson(url, new HashMap<String, String>(), "{\"tweet_id\":\"" + tweetId + "\"}", LikeResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public LikeResponse unlikeTweet(String tweetId) {
        String url = this.getUrlHelper().getUnlikeUrl(this.getUserIdFromAccessToken(), tweetId);
        return this.getRequestHelper().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, LikeResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserList getLikingUsers(String tweetId) {
        String url = this.getUrlHelper().getLikingUsersUrl(tweetId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public TweetList getLikedTweets(String userId) {
        return this.getLikedTweets(userId, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public TweetList getLikedTweets(String userId, AdditionalParameters additionalParameters) {
        String url = this.getUrlHelper().getLikedTweetsUrl(userId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelper().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters);
    }

    @Override
    public TweetCountsList getTweetCounts(String query) {
        return this.getTweetCounts(query, AdditionalParameters.builder().build());
    }

    @Override
    public TweetCountsList getTweetCounts(String query, AdditionalParameters additionalParameters) {
        String url = this.getUrlHelper().getTweetsCountUrl();
        return this.getTweetCounts(url, query, additionalParameters);
    }

    @Override
    public TweetCountsList getAllTweetCounts(String query) {
        return this.getAllTweetCounts(query, AdditionalParameters.builder().build());
    }

    @Override
    public TweetCountsList getAllTweetCounts(String query, AdditionalParameters additionalParameters) {
        String url = this.getUrlHelper().getTweetsCountAllUrl();
        return this.getTweetCounts(url, query, additionalParameters);
    }

    private TweetCountsList getTweetCounts(String url, String query, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(QUERY, query);
        return this.getRequestHelperV2().getRequestWithParameters(url, parameters, TweetCountsList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public Tweet retweetTweet(String tweetId) {
        String url = this.getUrlHelper().getRetweetTweetUrl(tweetId);
        return this.requestHelperV1.postRequest(url, new HashMap<String, String>(), TweetV1.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public Tweet postTweet(String text) {
        return this.postTweet(text, null);
    }

    @Override
    public Tweet postTweet(String text, String inReplyToStatusId) {
        return this.postTweet(text, inReplyToStatusId, null);
    }

    @Override
    public Tweet postTweet(String text, String inReplyToStatusId, String mediaIds) {
        return this.postTweet(text, inReplyToStatusId, mediaIds, null);
    }

    @Override
    public Tweet postTweet(String text, String inReplyToStatusId, String mediaIds, String attachmentUrl) {
        String url = this.getUrlHelper().getPostTweetUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("status", text);
        if (inReplyToStatusId != null) {
            parameters.put("in_reply_to_status_id", inReplyToStatusId);
            parameters.put("auto_populate_reply_metadata", "true");
        }
        if (mediaIds != null) {
            parameters.put("media_ids", mediaIds);
        }
        if (attachmentUrl != null) {
            parameters.put("attachment_url", attachmentUrl);
        }
        return this.requestHelperV1.postRequest(url, parameters, TweetV1.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public Tweet deleteTweet(String tweetId) {
        String url = this.getUrlHelper().getDeleteTweetUrl(tweetId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        return this.requestHelperV1.postRequest(url, parameters, TweetV1.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public Tweet getTweet(String tweetId) {
        String url = this.getUrlHelper().getTweetUrl(tweetId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, TweetV2.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public TweetList getTweets(List<String> tweetIds) {
        String url = this.getUrlHelper().getTweetsUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < tweetIds.size() && i < 100; ++i) {
            String id = tweetIds.get(i);
            result.append(id);
            result.append(",");
        }
        result.delete(result.length() - 1, result.length());
        parameters.put("ids", result.toString());
        return this.getRequestHelper().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public boolean hideReply(String tweetId, boolean hide) {
        String url = this.getUrlHelper().getHideReplyUrl(tweetId);
        try {
            String body = OBJECT_MAPPER.writeValueAsString((Object)new HiddenResponse.HiddenData(hide));
            HiddenResponse response = this.requestHelperV1.putRequest(url, body, HiddenResponse.class).orElseThrow(NoSuchElementException::new);
            return response.getData().isHidden();
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException();
        }
    }

    @Override
    public List<Tweet> getFavorites(String userId, int count) {
        List<Object> result;
        ArrayList<Tweet> favoriteTweets = new ArrayList<Tweet>();
        String maxId = null;
        while (!(result = Arrays.asList((Object[])this.getRequestHelper().getRequest(this.getUrlHelper().getFavoriteTweetsUrl(userId, maxId), TweetV1[].class).orElseThrow(NoSuchElementException::new))).isEmpty()) {
            maxId = ((TweetV1)result.get(result.size() - 1)).getId();
            favoriteTweets.addAll(result.subList(0, result.size() - 1));
            if (favoriteTweets.size() < count && result.size() > 1) continue;
        }
        return favoriteTweets;
    }

    @Override
    public TweetList searchTweets(String query) {
        return this.searchTweets(query, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public TweetList searchTweets(String query, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(QUERY, query);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        String url = this.urlHelper.getSearchRecentTweetsUrl();
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelper().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters);
    }

    @Override
    public TweetList searchAllTweets(String query) {
        return this.searchAllTweets(query, AdditionalParameters.builder().maxResults(500).build());
    }

    @Override
    public TweetList searchAllTweets(String query, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(QUERY, query);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        String url = this.urlHelper.getSearchAllTweetsUrl();
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelperV2().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(500));
        }
        return this.getTweetsRecursively(url, parameters);
    }

    private TweetList getTweetsRecursively(String url, Map<String, String> parameters) {
        String next;
        TweetList result = TweetList.builder().data(new ArrayList<TweetV2.TweetData>()).meta(new TweetList.TweetMeta()).build();
        String newestId = null;
        do {
            Optional<TweetList> tweetList;
            if (!(tweetList = this.getRequestHelper().getRequestWithParameters(url, parameters, TweetList.class)).isPresent() || tweetList.get().getData() == null) {
                result.getMeta().setNextToken(null);
                break;
            }
            result.getData().addAll(tweetList.get().getData());
            if (newestId == null) {
                newestId = tweetList.get().getMeta().getNewestId();
            }
            TweetList.TweetMeta meta = TweetList.TweetMeta.builder().resultCount(result.getData().size()).oldestId(tweetList.get().getMeta().getOldestId()).newestId(newestId).nextToken(tweetList.get().getMeta().getNextToken()).build();
            result.setMeta(meta);
            next = tweetList.get().getMeta().getNextToken();
            if (url.contains("/search")) {
                parameters.put("next_token", next);
                continue;
            }
            parameters.put(PAGINATION_TOKEN, next);
        } while (next != null);
        return result;
    }

    @Override
    @Deprecated
    public List<Tweet> searchForTweetsWithin30days(String query, LocalDateTime fromDate, LocalDateTime toDate, String envName) {
        Optional<TweetSearchResponseV1> tweetSearchV1DTO;
        int count = 100;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(QUERY, query);
        parameters.put("maxResults", String.valueOf(count));
        parameters.put("fromDate", ConverterHelper.getStringFromDate(fromDate));
        parameters.put("toDate", ConverterHelper.getStringFromDate(toDate));
        ArrayList<Tweet> result = new ArrayList<Tweet>();
        while ((tweetSearchV1DTO = this.getRequestHelper().getRequestWithParameters(this.urlHelper.getSearchTweet30DaysUrl(envName), parameters, TweetSearchResponseV1.class)).isPresent() && tweetSearchV1DTO.get().getResults() != null) {
            result.addAll(tweetSearchV1DTO.get().getResults());
            String next = tweetSearchV1DTO.get().getNext();
            parameters.put(NEXT, next);
            if (next != null) continue;
        }
        return result;
    }

    @Override
    @Deprecated
    public List<Tweet> searchForTweetsArchive(String query, LocalDateTime fromDate, LocalDateTime toDate, String envName) {
        String next;
        int count = 100;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(QUERY, query);
        parameters.put("max_results", String.valueOf(count));
        parameters.put("fromDate", ConverterHelper.getStringFromDate(fromDate));
        parameters.put("toDate", ConverterHelper.getStringFromDate(toDate));
        ArrayList<Tweet> result = new ArrayList<Tweet>();
        do {
            Optional<TweetSearchResponseV1> tweetSearchV1DTO;
            if (!(tweetSearchV1DTO = this.getRequestHelper().getRequestWithParameters(this.urlHelper.getSearchTweetFullArchiveUrl(envName), parameters, TweetSearchResponseV1.class)).isPresent()) {
                LOGGER.error("empty response on searchForTweetsArchive");
                break;
            }
            result.addAll(tweetSearchV1DTO.get().getResults());
            next = tweetSearchV1DTO.get().getNext();
            parameters.put(NEXT, next);
        } while (next != null);
        return result;
    }

    @Override
    public Future<Response> startFilteredStream(Consumer<Tweet> consumer) {
        String url = this.urlHelper.getFilteredStreamUrl();
        return this.requestHelperV2.getAsyncRequest(url, consumer);
    }

    @Override
    public Future<Response> startFilteredStream(IAPIEventListener listener) {
        String url = this.urlHelper.getFilteredStreamUrl();
        return this.requestHelperV2.getAsyncRequest(url, listener);
    }

    @Override
    public boolean stopFilteredStream(Future<Response> response) {
        try {
            if (response.get() == null) {
                return false;
            }
            response.get().getStream().close();
            return true;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOGGER.error("Couldn't stopFilteredstream ", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public List<StreamRules.StreamRule> retrieveFilteredStreamRules() {
        String url = this.urlHelper.getFilteredStreamRulesUrl();
        StreamRules result = this.requestHelperV2.getRequest(url, StreamRules.class).orElseThrow(NoSuchElementException::new);
        return result.getData();
    }

    @Override
    public StreamRules.StreamRule addFilteredStreamRule(String value, String tag) {
        String url = this.urlHelper.getFilteredStreamRulesUrl();
        StreamRules.StreamRule rule = StreamRules.StreamRule.builder().value(value).tag(tag).build();
        try {
            String body = "{\"add\": [" + OBJECT_MAPPER.writeValueAsString((Object)rule) + "]}";
            StreamRules result = this.requestHelperV2.postRequest(url, body, StreamRules.class).orElseThrow(NoSuchElementException::new);
            if (result.getData() == null || result.getData().isEmpty()) {
                throw new IllegalArgumentException();
            }
            return result.getData().get(0);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException();
        }
    }

    @Override
    public StreamRules.StreamMeta deleteFilteredStreamRule(String ruleValue) {
        String url = this.urlHelper.getFilteredStreamRulesUrl();
        String body = "{\"delete\": {\"values\": [\"" + ruleValue + "\"]}}";
        StreamRules result = this.requestHelperV2.postRequest(url, body, StreamRules.class).orElseThrow(NoSuchElementException::new);
        return result.getMeta();
    }

    @Override
    public StreamRules.StreamMeta deleteFilteredStreamRuletag(String ruleTag) {
        String url = this.urlHelper.getFilteredStreamRulesUrl();
        String body = "{\"delete\": {\"ids\": [\"" + ruleTag + "\"]}}";
        StreamRules result = this.requestHelperV2.postRequest(url, body, StreamRules.class).orElseThrow(NoSuchElementException::new);
        return result.getMeta();
    }

    @Override
    public Future<Response> startSampledStream(Consumer<Tweet> consumer) {
        String url = this.urlHelper.getSampledStreamUrl();
        return this.requestHelperV2.getAsyncRequest(url, consumer);
    }

    @Override
    public Future<Response> startSampledStream(IAPIEventListener listener) {
        String url = this.urlHelper.getSampledStreamUrl();
        return this.requestHelperV2.getAsyncRequest(url, listener);
    }

    @Override
    public TweetList getUserTimeline(String userId) {
        return this.getUserTimeline(userId, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public TweetList getUserTimeline(String userId, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        String url = this.urlHelper.getUserTimelineUrl(userId);
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelperV2().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters);
    }

    @Override
    public TweetList getUserMentions(String userId) {
        return this.getUserMentions(userId, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public TweetList getUserMentions(String userId, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        String url = this.urlHelper.getUserMentionsUrl(userId);
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelperV2().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters);
    }

    @Override
    public List<TweetV1> readTwitterDataFile(File file) throws IOException {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(TweetV1.class, (JsonDeserializer)new TweetV1Deserializer());
        ObjectMapper customObjectMapper = new ObjectMapper();
        customObjectMapper.registerModule((Module)module);
        ArrayList<TweetV1> result = new ArrayList();
        if (!file.exists()) {
            LOGGER.error("file not found at : " + file.toURI().toString());
        } else {
            result = Arrays.asList((Object[])customObjectMapper.readValue(file, TweetV1[].class));
        }
        return result;
    }

    @Override
    public String getBearerToken() {
        return this.requestHelperV2.getBearerToken();
    }

    @Override
    public RequestToken getOauth1Token() {
        return this.getOauth1Token(null);
    }

    @Override
    public RequestToken getOauth1Token(String oauthCallback) {
        String url = "https://api.twitter.com/oauth/request_token";
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (oauthCallback != null) {
            parameters.put("oauth_callback", oauthCallback);
        }
        String stringResponse = this.requestHelperV1.postRequest(url, parameters, String.class).orElseThrow(NoSuchElementException::new);
        RequestToken requestToken = new RequestToken(stringResponse);
        LOGGER.info("Open the following URL to grant access to your account:");
        LOGGER.info("https://twitter.com/oauth/authenticate?oauth_token=" + requestToken.getOauthToken());
        return requestToken;
    }

    @Override
    public RequestToken getOAuth1AccessToken(RequestToken requestToken, String pinCode) {
        String url = "https://api.twitter.com/oauth/access_token";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oauth_verifier", pinCode);
        parameters.put("oauth_token", requestToken.getOauthToken());
        String stringResponse = this.requestHelperV1.postRequest(url, parameters, String.class).orElseThrow(NoSuchElementException::new);
        return new RequestToken(stringResponse);
    }

    @Override
    public UploadMediaResponse uploadMedia(String mediaName, byte[] data, MediaCategory mediaCategory) {
        String url = this.urlHelper.getUploadMediaUrl(mediaCategory);
        return this.requestHelperV1.uploadMedia(url, mediaName, data, UploadMediaResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UploadMediaResponse uploadMedia(File imageFile, MediaCategory mediaCategory) {
        String url = this.urlHelper.getUploadMediaUrl(mediaCategory);
        return this.requestHelperV1.uploadMedia(url, imageFile, UploadMediaResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public CollectionsResponse collectionsCreate(String name, String description, String collectionUrl, TimeLineOrder timeLineOrder) {
        String url = this.getUrlHelper().getCollectionsCreateUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", name);
        parameters.put("description", description);
        parameters.put("url", collectionUrl);
        if (timeLineOrder != null) {
            parameters.put("timeline_order", timeLineOrder.value());
        }
        return this.requestHelperV1.postRequest(url, parameters, CollectionsResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public CollectionsResponse collectionsCurate(String collectionId, List<String> tweetIds) {
        String url = this.getUrlHelper().getCollectionsCurateUrl();
        AtomicInteger index = new AtomicInteger(0);
        Stream<List> chunked = tweetIds.stream().collect(Collectors.groupingBy(x -> index.getAndIncrement() / 100)).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue);
        return chunked.map(chunk -> {
            String json = String.format("{\"id\": \"%s\",\"changes\": [", collectionId);
            json = json + chunk.stream().map(tweetId -> String.format("{ \"op\": \"add\", \"tweet_id\": \"%s\"}", tweetId)).collect(Collectors.joining(", "));
            json = json + "]}";
            return this.requestHelperV1.postRequestWithBodyJson(url, Collections.emptyMap(), json, CollectionsResponse.class).orElseThrow(NoSuchElementException::new);
        }).filter(CollectionsResponse::hasErrors).findFirst().orElse(new CollectionsResponse());
    }

    @Override
    public CollectionsResponse collectionsDestroy(String collectionId) {
        String url = this.getUrlHelper().getCollectionsDestroyUrl(collectionId);
        return this.requestHelperV1.postRequest(url, Collections.emptyMap(), CollectionsResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public List<DirectMessage> getDmList() {
        return this.getDmList(Integer.MAX_VALUE);
    }

    @Override
    public List<DirectMessage> getDmList(int count) {
        DmListAnswer dmListAnswer;
        ArrayList<DirectMessage> result = new ArrayList<DirectMessage>();
        int maxCount = 50;
        String url = this.getUrlHelper().getDMListUrl(maxCount);
        do {
            dmListAnswer = this.requestHelperV1.getRequest(url, DmListAnswer.class).orElseThrow(NoSuchElementException::new);
            result.addAll(dmListAnswer.getDirectMessages());
            url = this.getUrlHelper().getDMListUrl(maxCount) + "&" + CURSOR + "=" + dmListAnswer.getNextCursor();
        } while (dmListAnswer.getNextCursor() != null && result.size() < count);
        if (count == Integer.MAX_VALUE) {
            return result;
        }
        return result.subList(0, count);
    }

    @Override
    public DirectMessage getDm(String dmId) {
        String url = this.urlHelper.getDmUrl(dmId);
        DmEvent result = this.getRequestHelper().getRequest(url, DmEvent.class).orElseThrow(NoSuchElementException::new);
        return result.getEvent();
    }

    @Override
    public DmEvent postDm(String text, String userId) {
        String url = this.urlHelper.getPostDmUrl();
        try {
            String body = OBJECT_MAPPER.writeValueAsString((Object)DmEvent.builder().event(new DirectMessage(text, userId)).build());
            return this.getRequestHelperV1().postRequestWithBodyJson(url, null, body, DmEvent.class).orElseThrow(NoSuchElementException::new);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Object[])e.getStackTrace());
            return null;
        }
    }

    @Override
    public CollectionsResponse collectionsEntries(String collectionId, int count, String maxPosition, String minPosition) {
        String url = this.getUrlHelper().getCollectionsEntriesUrl(collectionId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (count > 0) {
            parameters.put("count", Integer.toString(count));
        }
        if (maxPosition != null) {
            parameters.put("max_position", maxPosition);
        }
        if (minPosition != null) {
            parameters.put("min_position", minPosition);
        }
        return this.getRequestHelper().getRequestWithParameters(url, parameters, CollectionsResponse.class).orElseThrow(NoSuchElementException::new);
    }

    public static TwitterCredentials getAuthentication() {
        String credentialPath = System.getProperty("twitter.credentials.file.path");
        if (credentialPath != null) {
            return TwitterClient.getAuthentication(new File(credentialPath));
        }
        return TwitterClient.getAuthentication(Paths.get("", new String[0]), new String[0]);
    }

    public static TwitterCredentials getAuthentication(Path pathToScan, String ... validNames) {
        if (pathToScan.toFile().isFile()) {
            return TwitterClient.getAuthentication(pathToScan.toFile());
        }
        String[] namesToCheck = validNames != null && validNames.length > 0 ? validNames : DEFAULT_VALID_CREDENTIALS_FILE_NAMES;
        for (Path currentPath = pathToScan; currentPath != null; currentPath = currentPath.getParent()) {
            for (String name : namesToCheck) {
                Path file = currentPath.resolve(name);
                if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                return TwitterClient.getAuthentication(file.toFile());
            }
        }
        return null;
    }

    public static TwitterCredentials getAuthentication(File twitterCredentialsFile) {
        try {
            TwitterCredentials twitterCredentials = (TwitterCredentials)OBJECT_MAPPER.readValue(twitterCredentialsFile, TwitterCredentials.class);
            if (twitterCredentials.getAccessToken() == null) {
                LOGGER.error("Access token is null in twitter-credentials.json");
            }
            if (twitterCredentials.getAccessTokenSecret() == null) {
                LOGGER.error("Secret token is null in twitter-credentials.json");
            }
            if (twitterCredentials.getApiKey() == null) {
                LOGGER.error("Consumer key is null in twitter-credentials.json");
            }
            if (twitterCredentials.getApiSecretKey() == null) {
                LOGGER.error("Consumer secret is null in twitter-credentials.json");
            }
            return twitterCredentials;
        }
        catch (Exception e) {
            LOGGER.error("twitter credentials json file error in path " + twitterCredentialsFile.getAbsolutePath() + ". Use program argument -Dtwitter.credentials.file.path=/my/path/to/json . ", (Throwable)e);
            return null;
        }
    }

    private AbstractRequestHelper getRequestHelper() {
        if (this.requestHelperV1.getTwitterCredentials().getAccessToken() != null && this.requestHelperV1.getTwitterCredentials().getAccessTokenSecret() != null) {
            return this.requestHelperV1;
        }
        return this.requestHelperV2;
    }

    public String getUserIdFromAccessToken() {
        String accessToken = this.twitterCredentials.getAccessToken();
        if (accessToken == null || accessToken.isEmpty() || !accessToken.contains("-")) {
            LOGGER.error("access token null, empty or incorrect");
            throw new IllegalArgumentException();
        }
        return accessToken.substring(0, accessToken.indexOf("-"));
    }

    @Generated
    public URLHelper getUrlHelper() {
        return this.urlHelper;
    }

    @Generated
    public RequestHelper getRequestHelperV1() {
        return this.requestHelperV1;
    }

    @Generated
    public RequestHelperV2 getRequestHelperV2() {
        return this.requestHelperV2;
    }

    @Generated
    public TwitterCredentials getTwitterCredentials() {
        return this.twitterCredentials;
    }

    @Generated
    public void setUrlHelper(URLHelper urlHelper) {
        this.urlHelper = urlHelper;
    }

    @Generated
    public void setRequestHelperV1(RequestHelper requestHelperV1) {
        this.requestHelperV1 = requestHelperV1;
    }

    @Generated
    public void setRequestHelperV2(RequestHelperV2 requestHelperV2) {
        this.requestHelperV2 = requestHelperV2;
    }

    @Generated
    public void setTwitterCredentials(TwitterCredentials twitterCredentials) {
        this.twitterCredentials = twitterCredentials;
    }
}

