/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.dm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;

public class DirectMessage {
    private String id;
    @JsonProperty(value="created_timestamp")
    private String createdTimeStamp;
    private String type = "message_create";
    @JsonProperty(value="message_create")
    private MessageCreate messageCreate;

    public DirectMessage(String text, String userId) {
        this.messageCreate = new MessageCreate();
        this.messageCreate.setMessageData(new MessageCreate.MessageData(text, null));
        this.messageCreate.setTarget(new Target(userId));
    }

    @JsonIgnore
    public String getText() {
        if (this.getMessageCreate() == null || this.getMessageCreate().getMessageData() == null) {
            return null;
        }
        return this.getMessageCreate().getMessageData().getText();
    }

    @Generated
    public static DirectMessageBuilder builder() {
        return new DirectMessageBuilder();
    }

    @Generated
    public DirectMessage() {
    }

    @Generated
    public DirectMessage(String id, String createdTimeStamp, String type, MessageCreate messageCreate) {
        this.id = id;
        this.createdTimeStamp = createdTimeStamp;
        this.type = type;
        this.messageCreate = messageCreate;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCreatedTimeStamp() {
        return this.createdTimeStamp;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public MessageCreate getMessageCreate() {
        return this.messageCreate;
    }

    @Generated
    public static class DirectMessageBuilder {
        @Generated
        private String id;
        @Generated
        private String createdTimeStamp;
        @Generated
        private String type;
        @Generated
        private MessageCreate messageCreate;

        @Generated
        DirectMessageBuilder() {
        }

        @Generated
        public DirectMessageBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="created_timestamp")
        @Generated
        public DirectMessageBuilder createdTimeStamp(String createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        @Generated
        public DirectMessageBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="message_create")
        @Generated
        public DirectMessageBuilder messageCreate(MessageCreate messageCreate) {
            this.messageCreate = messageCreate;
            return this;
        }

        @Generated
        public DirectMessage build() {
            return new DirectMessage(this.id, this.createdTimeStamp, this.type, this.messageCreate);
        }

        @Generated
        public String toString() {
            return "DirectMessage.DirectMessageBuilder(id=" + this.id + ", createdTimeStamp=" + this.createdTimeStamp + ", type=" + this.type + ", messageCreate=" + this.messageCreate + ")";
        }
    }

    public static class Target {
        @JsonProperty(value="recipient_id")
        private String recipientId;

        @Generated
        public Target() {
        }

        @Generated
        public Target(String recipientId) {
            this.recipientId = recipientId;
        }

        @Generated
        public String getRecipientId() {
            return this.recipientId;
        }
    }

    public static class MessageCreate {
        @JsonProperty(value="sender_id")
        private String senderId;
        @JsonProperty(value="source_app_id")
        private String sourceAppId;
        @JsonProperty(value="message_data")
        private MessageData messageData;
        private Target target;

        @JsonProperty(value="sender_id")
        @Generated
        public void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @JsonProperty(value="source_app_id")
        @Generated
        public void setSourceAppId(String sourceAppId) {
            this.sourceAppId = sourceAppId;
        }

        @JsonProperty(value="message_data")
        @Generated
        public void setMessageData(MessageData messageData) {
            this.messageData = messageData;
        }

        @Generated
        public void setTarget(Target target) {
            this.target = target;
        }

        @Generated
        public String getSenderId() {
            return this.senderId;
        }

        @Generated
        public String getSourceAppId() {
            return this.sourceAppId;
        }

        @Generated
        public MessageData getMessageData() {
            return this.messageData;
        }

        @Generated
        public Target getTarget() {
            return this.target;
        }

        public static class MessageData {
            private String text;
            private JsonNode entities;

            @Generated
            public MessageData() {
            }

            @Generated
            public MessageData(String text, JsonNode entities) {
                this.text = text;
                this.entities = entities;
            }

            @Generated
            public String getText() {
                return this.text;
            }

            @Generated
            public JsonNode getEntities() {
                return this.entities;
            }

            @Generated
            public void setText(String text) {
                this.text = text;
            }

            @Generated
            public void setEntities(JsonNode entities) {
                this.entities = entities;
            }
        }
    }
}

