/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.tweet;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;

public class TweetCountsList {
    private List<TweetCountData> data;
    private TweetCountMeta meta;

    @Generated
    public static TweetCountsListBuilder builder() {
        return new TweetCountsListBuilder();
    }

    @Generated
    public TweetCountsList(List<TweetCountData> data, TweetCountMeta meta) {
        this.data = data;
        this.meta = meta;
    }

    @Generated
    public TweetCountsList() {
    }

    @Generated
    public List<TweetCountData> getData() {
        return this.data;
    }

    @Generated
    public TweetCountMeta getMeta() {
        return this.meta;
    }

    @Generated
    public static class TweetCountsListBuilder {
        @Generated
        private List<TweetCountData> data;
        @Generated
        private TweetCountMeta meta;

        @Generated
        TweetCountsListBuilder() {
        }

        @Generated
        public TweetCountsListBuilder data(List<TweetCountData> data) {
            this.data = data;
            return this;
        }

        @Generated
        public TweetCountsListBuilder meta(TweetCountMeta meta) {
            this.meta = meta;
            return this;
        }

        @Generated
        public TweetCountsList build() {
            return new TweetCountsList(this.data, this.meta);
        }

        @Generated
        public String toString() {
            return "TweetCountsList.TweetCountsListBuilder(data=" + this.data + ", meta=" + this.meta + ")";
        }
    }

    public static class TweetCountMeta {
        @JsonProperty(value="total_tweet_count")
        private int totalTweetCount;
        @JsonProperty(value="next_token")
        private String nextToken;

        @Generated
        public static TweetCountMetaBuilder builder() {
            return new TweetCountMetaBuilder();
        }

        @Generated
        public TweetCountMeta(int totalTweetCount, String nextToken) {
            this.totalTweetCount = totalTweetCount;
            this.nextToken = nextToken;
        }

        @Generated
        public TweetCountMeta() {
        }

        @Generated
        public int getTotalTweetCount() {
            return this.totalTweetCount;
        }

        @Generated
        public String getNextToken() {
            return this.nextToken;
        }

        @Generated
        public static class TweetCountMetaBuilder {
            @Generated
            private int totalTweetCount;
            @Generated
            private String nextToken;

            @Generated
            TweetCountMetaBuilder() {
            }

            @JsonProperty(value="total_tweet_count")
            @Generated
            public TweetCountMetaBuilder totalTweetCount(int totalTweetCount) {
                this.totalTweetCount = totalTweetCount;
                return this;
            }

            @JsonProperty(value="next_token")
            @Generated
            public TweetCountMetaBuilder nextToken(String nextToken) {
                this.nextToken = nextToken;
                return this;
            }

            @Generated
            public TweetCountMeta build() {
                return new TweetCountMeta(this.totalTweetCount, this.nextToken);
            }

            @Generated
            public String toString() {
                return "TweetCountsList.TweetCountMeta.TweetCountMetaBuilder(totalTweetCount=" + this.totalTweetCount + ", nextToken=" + this.nextToken + ")";
            }
        }
    }

    public static class LocalDateDeserializer
    extends StdDeserializer<LocalDateTime> {
        private static final long serialVersionUID = 1L;

        protected LocalDateDeserializer() {
            super(LocalDateTime.class);
        }

        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return ConverterHelper.getDateFromTwitterStringV2((String)jp.readValueAs(String.class));
        }
    }

    public static class TweetCountData {
        @JsonProperty(value="tweet_count")
        private int tweetCount;
        @JsonDeserialize(using=LocalDateDeserializer.class)
        private LocalDateTime start;
        @JsonDeserialize(using=LocalDateDeserializer.class)
        private LocalDateTime end;

        @Generated
        public static TweetCountDataBuilder builder() {
            return new TweetCountDataBuilder();
        }

        @Generated
        public TweetCountData(int tweetCount, LocalDateTime start, LocalDateTime end) {
            this.tweetCount = tweetCount;
            this.start = start;
            this.end = end;
        }

        @Generated
        public TweetCountData() {
        }

        @Generated
        public int getTweetCount() {
            return this.tweetCount;
        }

        @Generated
        public LocalDateTime getStart() {
            return this.start;
        }

        @Generated
        public LocalDateTime getEnd() {
            return this.end;
        }

        @Generated
        public static class TweetCountDataBuilder {
            @Generated
            private int tweetCount;
            @Generated
            private LocalDateTime start;
            @Generated
            private LocalDateTime end;

            @Generated
            TweetCountDataBuilder() {
            }

            @JsonProperty(value="tweet_count")
            @Generated
            public TweetCountDataBuilder tweetCount(int tweetCount) {
                this.tweetCount = tweetCount;
                return this;
            }

            @JsonDeserialize(using=LocalDateDeserializer.class)
            @Generated
            public TweetCountDataBuilder start(LocalDateTime start) {
                this.start = start;
                return this;
            }

            @JsonDeserialize(using=LocalDateDeserializer.class)
            @Generated
            public TweetCountDataBuilder end(LocalDateTime end) {
                this.end = end;
                return this;
            }

            @Generated
            public TweetCountData build() {
                return new TweetCountData(this.tweetCount, this.start, this.end);
            }

            @Generated
            public String toString() {
                return "TweetCountsList.TweetCountData.TweetCountDataBuilder(tweetCount=" + this.tweetCount + ", start=" + this.start + ", end=" + this.end + ")";
            }
        }
    }
}

