/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.tweet;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.redouane59.twitter.dto.tweet.Attachments;
import io.github.redouane59.twitter.dto.tweet.ContextAnnotation;
import io.github.redouane59.twitter.dto.tweet.Geo;
import io.github.redouane59.twitter.dto.tweet.ReplySettings;
import io.github.redouane59.twitter.dto.tweet.Tweet;
import io.github.redouane59.twitter.dto.tweet.TweetType;
import io.github.redouane59.twitter.dto.user.UserV1;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TweetV1
implements Tweet {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TweetV1.class);
    private String id;
    private String lang;
    @JsonProperty(value="retweet_count")
    private int retweetCount;
    @JsonProperty(value="favorite_count")
    private int likeCount;
    @JsonProperty(value="reply_count")
    private int replyCount;
    @JsonProperty(value="quote_count")
    private int quoteCount;
    @JsonAlias(value={"text", "full_text"})
    private String text;
    @JsonProperty(value="created_at")
    private String createdAt;
    private UserV1 user;
    @JsonProperty(value="in_reply_to_status_id_str")
    private String inReplyToStatusId;
    @JsonProperty(value="in_reply_to_user_id_str")
    private String inReplyToUserId;
    @JsonProperty(value="is_quote_status")
    private boolean isQuoteStatus;

    @Override
    public LocalDateTime getCreatedAt() {
        return ConverterHelper.getDateFromTwitterString(this.createdAt);
    }

    @Override
    public List<ContextAnnotation> getContextAnnotations() {
        LOGGER.error("not implemented");
        return Arrays.asList(new ContextAnnotation[0]);
    }

    @Override
    public TweetType getTweetType() {
        if (this.isQuoteStatus) {
            return TweetType.QUOTED;
        }
        return TweetType.DEFAULT;
    }

    @Override
    public String getConversationId() {
        LOGGER.error("not implemented");
        return null;
    }

    @Override
    public ReplySettings getReplySettings() {
        LOGGER.error("not implemented");
        return null;
    }

    @Override
    public Geo getGeo() {
        LOGGER.error("not implemented");
        return new Geo();
    }

    @Override
    public Attachments getAttachments() {
        LOGGER.error("not implemented");
        return new Attachments();
    }

    @Override
    public String getInReplyToStatusId(TweetType type) {
        return this.getInReplyToStatusId();
    }

    @Override
    public String getAuthorId() {
        if (this.user == null) {
            return null;
        }
        return this.user.getId();
    }

    @Generated
    public static TweetV1Builder builder() {
        return new TweetV1Builder();
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getLang() {
        return this.lang;
    }

    @Override
    @Generated
    public int getRetweetCount() {
        return this.retweetCount;
    }

    @Override
    @Generated
    public int getLikeCount() {
        return this.likeCount;
    }

    @Override
    @Generated
    public int getReplyCount() {
        return this.replyCount;
    }

    @Override
    @Generated
    public int getQuoteCount() {
        return this.quoteCount;
    }

    @Override
    @Generated
    public String getText() {
        return this.text;
    }

    @Override
    @Generated
    public UserV1 getUser() {
        return this.user;
    }

    @Override
    @Generated
    public String getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    @Override
    @Generated
    public String getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    @Generated
    public boolean isQuoteStatus() {
        return this.isQuoteStatus;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLang(String lang) {
        this.lang = lang;
    }

    @JsonProperty(value="retweet_count")
    @Generated
    public void setRetweetCount(int retweetCount) {
        this.retweetCount = retweetCount;
    }

    @JsonProperty(value="favorite_count")
    @Generated
    public void setLikeCount(int likeCount) {
        this.likeCount = likeCount;
    }

    @JsonProperty(value="reply_count")
    @Generated
    public void setReplyCount(int replyCount) {
        this.replyCount = replyCount;
    }

    @JsonProperty(value="quote_count")
    @Generated
    public void setQuoteCount(int quoteCount) {
        this.quoteCount = quoteCount;
    }

    @JsonAlias(value={"text", "full_text"})
    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="created_at")
    @Generated
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUser(UserV1 user) {
        this.user = user;
    }

    @JsonProperty(value="in_reply_to_status_id_str")
    @Generated
    public void setInReplyToStatusId(String inReplyToStatusId) {
        this.inReplyToStatusId = inReplyToStatusId;
    }

    @JsonProperty(value="in_reply_to_user_id_str")
    @Generated
    public void setInReplyToUserId(String inReplyToUserId) {
        this.inReplyToUserId = inReplyToUserId;
    }

    @JsonProperty(value="is_quote_status")
    @Generated
    public void setQuoteStatus(boolean isQuoteStatus) {
        this.isQuoteStatus = isQuoteStatus;
    }

    @Generated
    public TweetV1(String id, String lang, int retweetCount, int likeCount, int replyCount, int quoteCount, String text, String createdAt, UserV1 user, String inReplyToStatusId, String inReplyToUserId, boolean isQuoteStatus) {
        this.id = id;
        this.lang = lang;
        this.retweetCount = retweetCount;
        this.likeCount = likeCount;
        this.replyCount = replyCount;
        this.quoteCount = quoteCount;
        this.text = text;
        this.createdAt = createdAt;
        this.user = user;
        this.inReplyToStatusId = inReplyToStatusId;
        this.inReplyToUserId = inReplyToUserId;
        this.isQuoteStatus = isQuoteStatus;
    }

    @Generated
    public TweetV1() {
    }

    @Generated
    public static class TweetV1Builder {
        @Generated
        private String id;
        @Generated
        private String lang;
        @Generated
        private int retweetCount;
        @Generated
        private int likeCount;
        @Generated
        private int replyCount;
        @Generated
        private int quoteCount;
        @Generated
        private String text;
        @Generated
        private String createdAt;
        @Generated
        private UserV1 user;
        @Generated
        private String inReplyToStatusId;
        @Generated
        private String inReplyToUserId;
        @Generated
        private boolean isQuoteStatus;

        @Generated
        TweetV1Builder() {
        }

        @Generated
        public TweetV1Builder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public TweetV1Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        @JsonProperty(value="retweet_count")
        @Generated
        public TweetV1Builder retweetCount(int retweetCount) {
            this.retweetCount = retweetCount;
            return this;
        }

        @JsonProperty(value="favorite_count")
        @Generated
        public TweetV1Builder likeCount(int likeCount) {
            this.likeCount = likeCount;
            return this;
        }

        @JsonProperty(value="reply_count")
        @Generated
        public TweetV1Builder replyCount(int replyCount) {
            this.replyCount = replyCount;
            return this;
        }

        @JsonProperty(value="quote_count")
        @Generated
        public TweetV1Builder quoteCount(int quoteCount) {
            this.quoteCount = quoteCount;
            return this;
        }

        @JsonAlias(value={"text", "full_text"})
        @Generated
        public TweetV1Builder text(String text) {
            this.text = text;
            return this;
        }

        @JsonProperty(value="created_at")
        @Generated
        public TweetV1Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public TweetV1Builder user(UserV1 user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="in_reply_to_status_id_str")
        @Generated
        public TweetV1Builder inReplyToStatusId(String inReplyToStatusId) {
            this.inReplyToStatusId = inReplyToStatusId;
            return this;
        }

        @JsonProperty(value="in_reply_to_user_id_str")
        @Generated
        public TweetV1Builder inReplyToUserId(String inReplyToUserId) {
            this.inReplyToUserId = inReplyToUserId;
            return this;
        }

        @JsonProperty(value="is_quote_status")
        @Generated
        public TweetV1Builder isQuoteStatus(boolean isQuoteStatus) {
            this.isQuoteStatus = isQuoteStatus;
            return this;
        }

        @Generated
        public TweetV1 build() {
            return new TweetV1(this.id, this.lang, this.retweetCount, this.likeCount, this.replyCount, this.quoteCount, this.text, this.createdAt, this.user, this.inReplyToStatusId, this.inReplyToUserId, this.isQuoteStatus);
        }

        @Generated
        public String toString() {
            return "TweetV1.TweetV1Builder(id=" + this.id + ", lang=" + this.lang + ", retweetCount=" + this.retweetCount + ", likeCount=" + this.likeCount + ", replyCount=" + this.replyCount + ", quoteCount=" + this.quoteCount + ", text=" + this.text + ", createdAt=" + this.createdAt + ", user=" + this.user + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isQuoteStatus=" + this.isQuoteStatus + ")";
        }
    }
}

