/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.tweet;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.redouane59.twitter.dto.stream.StreamRules;
import io.github.redouane59.twitter.dto.tweet.Attachments;
import io.github.redouane59.twitter.dto.tweet.ContextAnnotation;
import io.github.redouane59.twitter.dto.tweet.Geo;
import io.github.redouane59.twitter.dto.tweet.ReplySettings;
import io.github.redouane59.twitter.dto.tweet.Tweet;
import io.github.redouane59.twitter.dto.tweet.TweetType;
import io.github.redouane59.twitter.dto.user.User;
import io.github.redouane59.twitter.dto.user.UserV2;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class TweetV2
implements Tweet {
    private TweetData data;
    private Includes includes;
    @JsonProperty(value="matching_rules")
    private StreamRules.StreamRule[] matchingRules;

    @Override
    public String getInReplyToStatusId() {
        if (this.data == null || this.data.getReferencedTweets() == null || this.data.getReferencedTweets().isEmpty()) {
            return null;
        }
        return this.data.getReferencedTweets().get(0).getId();
    }

    @Override
    public String getInReplyToStatusId(TweetType type) {
        if (this.data == null || this.data.getReferencedTweets() == null || this.data.getReferencedTweets().isEmpty()) {
            return null;
        }
        for (ReferencedTweetDTO referencedTweetDTO : this.data.getReferencedTweets()) {
            if (referencedTweetDTO.getType() != type) continue;
            return referencedTweetDTO.getId();
        }
        return null;
    }

    @Override
    public String getLang() {
        if (this.data == null) {
            return null;
        }
        return this.data.getLang();
    }

    @Override
    public String getId() {
        if (this.data == null) {
            return null;
        }
        return this.data.getId();
    }

    @Override
    public String getText() {
        if (this.data == null) {
            return null;
        }
        return this.data.getText();
    }

    @Override
    public String getConversationId() {
        if (this.data == null) {
            return null;
        }
        return this.data.getConversationId();
    }

    @Override
    public ReplySettings getReplySettings() {
        if (this.data == null) {
            return null;
        }
        return this.data.getReplySettings();
    }

    @Override
    public Geo getGeo() {
        if (this.data == null) {
            return null;
        }
        return this.data.getGeo();
    }

    @Override
    public Attachments getAttachments() {
        if (this.data == null) {
            return null;
        }
        return this.data.getAttachments();
    }

    @Override
    public int getRetweetCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getPublicMetrics().getRetweetCount();
    }

    @Override
    public int getLikeCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getPublicMetrics().getLikeCount();
    }

    @Override
    public int getReplyCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getPublicMetrics().getReplyCount();
    }

    @Override
    public int getQuoteCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getPublicMetrics().getQuoteCount();
    }

    @Override
    public String getInReplyToUserId() {
        if (this.data == null) {
            return null;
        }
        return this.data.getInReplyToUserId();
    }

    @Override
    public User getUser() {
        if (this.includes == null) {
            return null;
        }
        return this.includes.getUsers()[0];
    }

    @Override
    public String getAuthorId() {
        if (this.data == null) {
            return null;
        }
        return this.data.getAuthorId();
    }

    @Override
    public LocalDateTime getCreatedAt() {
        if (this.data == null) {
            return null;
        }
        return this.data.getCreatedAt();
    }

    @Override
    public List<ContextAnnotation> getContextAnnotations() {
        if (this.data == null) {
            return Arrays.asList(new ContextAnnotation[0]);
        }
        return this.data.getContextAnnotations();
    }

    @Override
    public TweetType getTweetType() {
        if (this.data == null || this.data.referencedTweets == null || this.data.referencedTweets.isEmpty()) {
            return TweetType.DEFAULT;
        }
        if (this.data.getReferencedTweets().size() > 1 && (this.data.getReferencedTweets().get(0).getType().equals((Object)TweetType.RETWEETED) || this.data.getReferencedTweets().get(1).getType().equals((Object)TweetType.RETWEETED))) {
            return TweetType.RETWEETED;
        }
        return this.data.getReferencedTweets().get(0).getType();
    }

    @Generated
    public static TweetV2Builder builder() {
        return new TweetV2Builder();
    }

    @Generated
    public TweetData getData() {
        return this.data;
    }

    @Generated
    public Includes getIncludes() {
        return this.includes;
    }

    @Generated
    public StreamRules.StreamRule[] getMatchingRules() {
        return this.matchingRules;
    }

    @Generated
    public void setData(TweetData data) {
        this.data = data;
    }

    @Generated
    public void setIncludes(Includes includes) {
        this.includes = includes;
    }

    @JsonProperty(value="matching_rules")
    @Generated
    public void setMatchingRules(StreamRules.StreamRule[] matchingRules) {
        this.matchingRules = matchingRules;
    }

    @Generated
    public TweetV2(TweetData data, Includes includes, StreamRules.StreamRule[] matchingRules) {
        this.data = data;
        this.includes = includes;
        this.matchingRules = matchingRules;
    }

    @Generated
    public TweetV2() {
    }

    @Generated
    public static class TweetV2Builder {
        @Generated
        private TweetData data;
        @Generated
        private Includes includes;
        @Generated
        private StreamRules.StreamRule[] matchingRules;

        @Generated
        TweetV2Builder() {
        }

        @Generated
        public TweetV2Builder data(TweetData data) {
            this.data = data;
            return this;
        }

        @Generated
        public TweetV2Builder includes(Includes includes) {
            this.includes = includes;
            return this;
        }

        @JsonProperty(value="matching_rules")
        @Generated
        public TweetV2Builder matchingRules(StreamRules.StreamRule[] matchingRules) {
            this.matchingRules = matchingRules;
            return this;
        }

        @Generated
        public TweetV2 build() {
            return new TweetV2(this.data, this.includes, this.matchingRules);
        }

        @Generated
        public String toString() {
            return "TweetV2.TweetV2Builder(data=" + this.data + ", includes=" + this.includes + ", matchingRules=" + Arrays.deepToString(this.matchingRules) + ")";
        }
    }

    public static class TweetPublicMetricsDTO {
        @JsonProperty(value="retweet_count")
        private int retweetCount;
        @JsonProperty(value="reply_count")
        private int replyCount;
        @JsonProperty(value="like_count")
        private int likeCount;
        @JsonProperty(value="quote_count")
        private int quoteCount;

        @Generated
        public int getRetweetCount() {
            return this.retweetCount;
        }

        @Generated
        public int getReplyCount() {
            return this.replyCount;
        }

        @Generated
        public int getLikeCount() {
            return this.likeCount;
        }

        @Generated
        public int getQuoteCount() {
            return this.quoteCount;
        }

        @JsonProperty(value="retweet_count")
        @Generated
        public void setRetweetCount(int retweetCount) {
            this.retweetCount = retweetCount;
        }

        @JsonProperty(value="reply_count")
        @Generated
        public void setReplyCount(int replyCount) {
            this.replyCount = replyCount;
        }

        @JsonProperty(value="like_count")
        @Generated
        public void setLikeCount(int likeCount) {
            this.likeCount = likeCount;
        }

        @JsonProperty(value="quote_count")
        @Generated
        public void setQuoteCount(int quoteCount) {
            this.quoteCount = quoteCount;
        }
    }

    public static class Includes {
        private UserV2.UserData[] users;
        private TweetData[] tweets;

        @Generated
        public static IncludesBuilder builder() {
            return new IncludesBuilder();
        }

        @Generated
        public UserV2.UserData[] getUsers() {
            return this.users;
        }

        @Generated
        public TweetData[] getTweets() {
            return this.tweets;
        }

        @Generated
        public void setUsers(UserV2.UserData[] users) {
            this.users = users;
        }

        @Generated
        public void setTweets(TweetData[] tweets) {
            this.tweets = tweets;
        }

        @Generated
        public Includes() {
        }

        @Generated
        public Includes(UserV2.UserData[] users, TweetData[] tweets) {
            this.users = users;
            this.tweets = tweets;
        }

        @Generated
        public static class IncludesBuilder {
            @Generated
            private UserV2.UserData[] users;
            @Generated
            private TweetData[] tweets;

            @Generated
            IncludesBuilder() {
            }

            @Generated
            public IncludesBuilder users(UserV2.UserData[] users) {
                this.users = users;
                return this;
            }

            @Generated
            public IncludesBuilder tweets(TweetData[] tweets) {
                this.tweets = tweets;
                return this;
            }

            @Generated
            public Includes build() {
                return new Includes(this.users, this.tweets);
            }

            @Generated
            public String toString() {
                return "TweetV2.Includes.IncludesBuilder(users=" + Arrays.deepToString(this.users) + ", tweets=" + Arrays.deepToString(this.tweets) + ")";
            }
        }
    }

    public static class ReferencedTweetDTO {
        private TweetType type;
        private String id;

        @Generated
        public TweetType getType() {
            return this.type;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setType(TweetType type) {
            this.type = type;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }
    }

    public static class TweetData
    implements Tweet {
        private String id;
        @JsonProperty(value="created_at")
        private String createdAt;
        @JsonAlias(value={"text", "full_text"})
        private String text;
        @JsonProperty(value="author_id")
        private String authorId;
        @JsonProperty(value="in_reply_to_user_id")
        private String inReplyToUserId;
        @JsonProperty(value="referenced_tweets")
        private List<ReferencedTweetDTO> referencedTweets;
        private JsonNode entities;
        @JsonProperty(value="public_metrics")
        private TweetPublicMetricsDTO publicMetrics;
        @JsonProperty(value="possibly_sensitive")
        private boolean possiblySensitive;
        private String lang;
        @JsonProperty(value="context_annotations")
        private List<ContextAnnotation> contextAnnotations;
        @JsonProperty(value="conversation_id")
        private String conversationId;
        @JsonProperty(value="reply_settings")
        private ReplySettings replySettings;
        private Geo geo;
        private Attachments attachments;

        @Override
        public int getRetweetCount() {
            return this.publicMetrics.getRetweetCount();
        }

        @Override
        public int getLikeCount() {
            return this.publicMetrics.getLikeCount();
        }

        @Override
        public int getReplyCount() {
            return this.publicMetrics.getReplyCount();
        }

        @Override
        public int getQuoteCount() {
            return this.publicMetrics.getQuoteCount();
        }

        @Override
        public String getInReplyToStatusId() {
            if (this.referencedTweets == null || this.referencedTweets.isEmpty()) {
                return null;
            }
            return this.referencedTweets.get(0).getId();
        }

        @Override
        public String getInReplyToStatusId(TweetType type) {
            if (this.referencedTweets == null || this.referencedTweets.isEmpty()) {
                return null;
            }
            for (ReferencedTweetDTO referencedTweetDTO : this.referencedTweets) {
                if (referencedTweetDTO.getType() != type) continue;
                return referencedTweetDTO.getId();
            }
            return null;
        }

        @Override
        public TweetType getTweetType() {
            if (this.referencedTweets == null || this.referencedTweets.isEmpty()) {
                return TweetType.DEFAULT;
            }
            if (this.getReferencedTweets().size() > 1 && (this.getReferencedTweets().get(0).getType().equals((Object)TweetType.RETWEETED) || this.getReferencedTweets().get(1).getType().equals((Object)TweetType.RETWEETED))) {
                return TweetType.RETWEETED;
            }
            return this.getReferencedTweets().get(0).getType();
        }

        @Override
        public User getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthorId() {
            return this.authorId;
        }

        @Override
        public LocalDateTime getCreatedAt() {
            return ConverterHelper.getDateFromTwitterStringV2(this.createdAt);
        }

        @Generated
        public static TweetDataBuilder builder() {
            return new TweetDataBuilder();
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public String getText() {
            return this.text;
        }

        @Override
        @Generated
        public String getInReplyToUserId() {
            return this.inReplyToUserId;
        }

        @Generated
        public List<ReferencedTweetDTO> getReferencedTweets() {
            return this.referencedTweets;
        }

        @Generated
        public JsonNode getEntities() {
            return this.entities;
        }

        @Generated
        public TweetPublicMetricsDTO getPublicMetrics() {
            return this.publicMetrics;
        }

        @Generated
        public boolean isPossiblySensitive() {
            return this.possiblySensitive;
        }

        @Override
        @Generated
        public String getLang() {
            return this.lang;
        }

        @Override
        @Generated
        public List<ContextAnnotation> getContextAnnotations() {
            return this.contextAnnotations;
        }

        @Override
        @Generated
        public String getConversationId() {
            return this.conversationId;
        }

        @Override
        @Generated
        public ReplySettings getReplySettings() {
            return this.replySettings;
        }

        @Override
        @Generated
        public Geo getGeo() {
            return this.geo;
        }

        @Override
        @Generated
        public Attachments getAttachments() {
            return this.attachments;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="created_at")
        @Generated
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonAlias(value={"text", "full_text"})
        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="author_id")
        @Generated
        public void setAuthorId(String authorId) {
            this.authorId = authorId;
        }

        @JsonProperty(value="in_reply_to_user_id")
        @Generated
        public void setInReplyToUserId(String inReplyToUserId) {
            this.inReplyToUserId = inReplyToUserId;
        }

        @JsonProperty(value="referenced_tweets")
        @Generated
        public void setReferencedTweets(List<ReferencedTweetDTO> referencedTweets) {
            this.referencedTweets = referencedTweets;
        }

        @Generated
        public void setEntities(JsonNode entities) {
            this.entities = entities;
        }

        @JsonProperty(value="public_metrics")
        @Generated
        public void setPublicMetrics(TweetPublicMetricsDTO publicMetrics) {
            this.publicMetrics = publicMetrics;
        }

        @JsonProperty(value="possibly_sensitive")
        @Generated
        public void setPossiblySensitive(boolean possiblySensitive) {
            this.possiblySensitive = possiblySensitive;
        }

        @Generated
        public void setLang(String lang) {
            this.lang = lang;
        }

        @JsonProperty(value="context_annotations")
        @Generated
        public void setContextAnnotations(List<ContextAnnotation> contextAnnotations) {
            this.contextAnnotations = contextAnnotations;
        }

        @JsonProperty(value="conversation_id")
        @Generated
        public void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @JsonProperty(value="reply_settings")
        @Generated
        public void setReplySettings(ReplySettings replySettings) {
            this.replySettings = replySettings;
        }

        @Generated
        public void setGeo(Geo geo) {
            this.geo = geo;
        }

        @Generated
        public void setAttachments(Attachments attachments) {
            this.attachments = attachments;
        }

        @Generated
        public TweetData() {
        }

        @Generated
        public TweetData(String id, String createdAt, String text, String authorId, String inReplyToUserId, List<ReferencedTweetDTO> referencedTweets, JsonNode entities, TweetPublicMetricsDTO publicMetrics, boolean possiblySensitive, String lang, List<ContextAnnotation> contextAnnotations, String conversationId, ReplySettings replySettings, Geo geo, Attachments attachments) {
            this.id = id;
            this.createdAt = createdAt;
            this.text = text;
            this.authorId = authorId;
            this.inReplyToUserId = inReplyToUserId;
            this.referencedTweets = referencedTweets;
            this.entities = entities;
            this.publicMetrics = publicMetrics;
            this.possiblySensitive = possiblySensitive;
            this.lang = lang;
            this.contextAnnotations = contextAnnotations;
            this.conversationId = conversationId;
            this.replySettings = replySettings;
            this.geo = geo;
            this.attachments = attachments;
        }

        @Generated
        public static class TweetDataBuilder {
            @Generated
            private String id;
            @Generated
            private String createdAt;
            @Generated
            private String text;
            @Generated
            private String authorId;
            @Generated
            private String inReplyToUserId;
            @Generated
            private List<ReferencedTweetDTO> referencedTweets;
            @Generated
            private JsonNode entities;
            @Generated
            private TweetPublicMetricsDTO publicMetrics;
            @Generated
            private boolean possiblySensitive;
            @Generated
            private String lang;
            @Generated
            private List<ContextAnnotation> contextAnnotations;
            @Generated
            private String conversationId;
            @Generated
            private ReplySettings replySettings;
            @Generated
            private Geo geo;
            @Generated
            private Attachments attachments;

            @Generated
            TweetDataBuilder() {
            }

            @Generated
            public TweetDataBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="created_at")
            @Generated
            public TweetDataBuilder createdAt(String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @JsonAlias(value={"text", "full_text"})
            @Generated
            public TweetDataBuilder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="author_id")
            @Generated
            public TweetDataBuilder authorId(String authorId) {
                this.authorId = authorId;
                return this;
            }

            @JsonProperty(value="in_reply_to_user_id")
            @Generated
            public TweetDataBuilder inReplyToUserId(String inReplyToUserId) {
                this.inReplyToUserId = inReplyToUserId;
                return this;
            }

            @JsonProperty(value="referenced_tweets")
            @Generated
            public TweetDataBuilder referencedTweets(List<ReferencedTweetDTO> referencedTweets) {
                this.referencedTweets = referencedTweets;
                return this;
            }

            @Generated
            public TweetDataBuilder entities(JsonNode entities) {
                this.entities = entities;
                return this;
            }

            @JsonProperty(value="public_metrics")
            @Generated
            public TweetDataBuilder publicMetrics(TweetPublicMetricsDTO publicMetrics) {
                this.publicMetrics = publicMetrics;
                return this;
            }

            @JsonProperty(value="possibly_sensitive")
            @Generated
            public TweetDataBuilder possiblySensitive(boolean possiblySensitive) {
                this.possiblySensitive = possiblySensitive;
                return this;
            }

            @Generated
            public TweetDataBuilder lang(String lang) {
                this.lang = lang;
                return this;
            }

            @JsonProperty(value="context_annotations")
            @Generated
            public TweetDataBuilder contextAnnotations(List<ContextAnnotation> contextAnnotations) {
                this.contextAnnotations = contextAnnotations;
                return this;
            }

            @JsonProperty(value="conversation_id")
            @Generated
            public TweetDataBuilder conversationId(String conversationId) {
                this.conversationId = conversationId;
                return this;
            }

            @JsonProperty(value="reply_settings")
            @Generated
            public TweetDataBuilder replySettings(ReplySettings replySettings) {
                this.replySettings = replySettings;
                return this;
            }

            @Generated
            public TweetDataBuilder geo(Geo geo) {
                this.geo = geo;
                return this;
            }

            @Generated
            public TweetDataBuilder attachments(Attachments attachments) {
                this.attachments = attachments;
                return this;
            }

            @Generated
            public TweetData build() {
                return new TweetData(this.id, this.createdAt, this.text, this.authorId, this.inReplyToUserId, this.referencedTweets, this.entities, this.publicMetrics, this.possiblySensitive, this.lang, this.contextAnnotations, this.conversationId, this.replySettings, this.geo, this.attachments);
            }

            @Generated
            public String toString() {
                return "TweetV2.TweetData.TweetDataBuilder(id=" + this.id + ", createdAt=" + this.createdAt + ", text=" + this.text + ", authorId=" + this.authorId + ", inReplyToUserId=" + this.inReplyToUserId + ", referencedTweets=" + this.referencedTweets + ", entities=" + this.entities + ", publicMetrics=" + this.publicMetrics + ", possiblySensitive=" + this.possiblySensitive + ", lang=" + this.lang + ", contextAnnotations=" + this.contextAnnotations + ", conversationId=" + this.conversationId + ", replySettings=" + (Object)((Object)this.replySettings) + ", geo=" + this.geo + ", attachments=" + this.attachments + ")";
            }
        }
    }
}

