/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.redouane59.twitter.dto.tweet.Tweet;
import io.github.redouane59.twitter.dto.tweet.TweetV2;
import io.github.redouane59.twitter.dto.user.User;
import io.github.redouane59.twitter.dto.user.UserPublicMetrics;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import java.time.LocalDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserV2
implements User {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UserV2.class);
    private UserData data;
    private UserData.Includes includes;

    @Override
    public String getId() {
        return this.data == null ? null : this.data.getId();
    }

    @Override
    public String getName() {
        return this.data == null ? null : this.data.getName();
    }

    @Override
    public String getDisplayedName() {
        return this.data == null ? null : this.data.getDisplayedName();
    }

    @Override
    public String getLocation() {
        return this.data.getLocation();
    }

    @Override
    public String getDescription() {
        return this.data.getDescription();
    }

    @Override
    public LocalDateTime getDateOfCreation() {
        return ConverterHelper.getDateFromTwitterStringV2(this.data.getCreatedAt());
    }

    @Override
    public int getFollowersCount() {
        return this.data.getPublicMetrics().getFollowersCount();
    }

    @Override
    public int getFollowingCount() {
        return this.data.getPublicMetrics().getFollowingCount();
    }

    @Override
    public int getTweetCount() {
        return this.data.getPublicMetrics().getTweetCount();
    }

    @Override
    public String getLang() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProtectedAccount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFollowing() {
        return this.data.isFollowing();
    }

    @Override
    public boolean isVerified() {
        return this.data == null ? false : this.data.verified;
    }

    @Override
    public Tweet getPinnedTweet() {
        if (this.includes.getTweets().length < 1) {
            LOGGER.error("No tweet found");
            return null;
        }
        return this.includes.getTweets()[0];
    }

    @Override
    public String getUrl() {
        return this.data == null ? null : this.data.getUrl();
    }

    @Override
    public JsonNode getEntities() {
        return this.data == null ? null : this.data.getEntities();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass() && !User.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        User otherUser = (User)o;
        return otherUser.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Generated
    public static UserV2Builder builder() {
        return new UserV2Builder();
    }

    @Generated
    public UserData getData() {
        return this.data;
    }

    @Generated
    public UserData.Includes getIncludes() {
        return this.includes;
    }

    @Generated
    public void setData(UserData data) {
        this.data = data;
    }

    @Generated
    public void setIncludes(UserData.Includes includes) {
        this.includes = includes;
    }

    @Generated
    public UserV2(UserData data, UserData.Includes includes) {
        this.data = data;
        this.includes = includes;
    }

    @Generated
    public UserV2() {
    }

    @Generated
    public static class UserV2Builder {
        @Generated
        private UserData data;
        @Generated
        private UserData.Includes includes;

        @Generated
        UserV2Builder() {
        }

        @Generated
        public UserV2Builder data(UserData data) {
            this.data = data;
            return this;
        }

        @Generated
        public UserV2Builder includes(UserData.Includes includes) {
            this.includes = includes;
            return this;
        }

        @Generated
        public UserV2 build() {
            return new UserV2(this.data, this.includes);
        }

        @Generated
        public String toString() {
            return "UserV2.UserV2Builder(data=" + this.data + ", includes=" + this.includes + ")";
        }
    }

    public static class UserData
    implements User {
        private String id;
        @JsonProperty(value="created_at")
        private String createdAt;
        @JsonProperty(value="username")
        private String name;
        @JsonProperty(value="name")
        private String displayedName;
        private String location;
        private JsonNode entities;
        private String url;
        private boolean verified;
        @JsonProperty(value="profile_image_url")
        private String profileImageUrl;
        @JsonProperty(value="public_metrics")
        private UserPublicMetrics publicMetrics;
        @JsonProperty(value="pinned_tweet_id")
        private String pinnedTweetId;
        private String description;
        private String lang;
        private boolean isProtectedAccount;
        private boolean following;

        @Override
        public LocalDateTime getDateOfCreation() {
            return ConverterHelper.getDateFromTwitterStringV2(this.createdAt);
        }

        @Override
        public int getFollowersCount() {
            return this.publicMetrics.getFollowersCount();
        }

        @Override
        public int getFollowingCount() {
            return this.publicMetrics.getFollowingCount();
        }

        @Override
        public int getTweetCount() {
            return this.publicMetrics.getTweetCount();
        }

        @Override
        public Tweet getPinnedTweet() {
            LOGGER.error("Enable to access the data from here");
            return null;
        }

        @Generated
        public static UserDataBuilder builder() {
            return new UserDataBuilder();
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getDisplayedName() {
            return this.displayedName;
        }

        @Override
        @Generated
        public String getLocation() {
            return this.location;
        }

        @Override
        @Generated
        public JsonNode getEntities() {
            return this.entities;
        }

        @Override
        @Generated
        public String getUrl() {
            return this.url;
        }

        @Override
        @Generated
        public boolean isVerified() {
            return this.verified;
        }

        @Generated
        public String getProfileImageUrl() {
            return this.profileImageUrl;
        }

        @Generated
        public UserPublicMetrics getPublicMetrics() {
            return this.publicMetrics;
        }

        @Generated
        public String getPinnedTweetId() {
            return this.pinnedTweetId;
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Override
        @Generated
        public String getLang() {
            return this.lang;
        }

        @Override
        @Generated
        public boolean isProtectedAccount() {
            return this.isProtectedAccount;
        }

        @Override
        @Generated
        public boolean isFollowing() {
            return this.following;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="created_at")
        @Generated
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="username")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        @Generated
        public void setDisplayedName(String displayedName) {
            this.displayedName = displayedName;
        }

        @Generated
        public void setLocation(String location) {
            this.location = location;
        }

        @Generated
        public void setEntities(JsonNode entities) {
            this.entities = entities;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setVerified(boolean verified) {
            this.verified = verified;
        }

        @JsonProperty(value="profile_image_url")
        @Generated
        public void setProfileImageUrl(String profileImageUrl) {
            this.profileImageUrl = profileImageUrl;
        }

        @JsonProperty(value="public_metrics")
        @Generated
        public void setPublicMetrics(UserPublicMetrics publicMetrics) {
            this.publicMetrics = publicMetrics;
        }

        @JsonProperty(value="pinned_tweet_id")
        @Generated
        public void setPinnedTweetId(String pinnedTweetId) {
            this.pinnedTweetId = pinnedTweetId;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setLang(String lang) {
            this.lang = lang;
        }

        @Generated
        public void setProtectedAccount(boolean isProtectedAccount) {
            this.isProtectedAccount = isProtectedAccount;
        }

        @Generated
        public void setFollowing(boolean following) {
            this.following = following;
        }

        @Generated
        public UserData() {
        }

        @Generated
        public UserData(String id, String createdAt, String name, String displayedName, String location, JsonNode entities, String url, boolean verified, String profileImageUrl, UserPublicMetrics publicMetrics, String pinnedTweetId, String description, String lang, boolean isProtectedAccount, boolean following) {
            this.id = id;
            this.createdAt = createdAt;
            this.name = name;
            this.displayedName = displayedName;
            this.location = location;
            this.entities = entities;
            this.url = url;
            this.verified = verified;
            this.profileImageUrl = profileImageUrl;
            this.publicMetrics = publicMetrics;
            this.pinnedTweetId = pinnedTweetId;
            this.description = description;
            this.lang = lang;
            this.isProtectedAccount = isProtectedAccount;
            this.following = following;
        }

        @Generated
        public static class UserDataBuilder {
            @Generated
            private String id;
            @Generated
            private String createdAt;
            @Generated
            private String name;
            @Generated
            private String displayedName;
            @Generated
            private String location;
            @Generated
            private JsonNode entities;
            @Generated
            private String url;
            @Generated
            private boolean verified;
            @Generated
            private String profileImageUrl;
            @Generated
            private UserPublicMetrics publicMetrics;
            @Generated
            private String pinnedTweetId;
            @Generated
            private String description;
            @Generated
            private String lang;
            @Generated
            private boolean isProtectedAccount;
            @Generated
            private boolean following;

            @Generated
            UserDataBuilder() {
            }

            @Generated
            public UserDataBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="created_at")
            @Generated
            public UserDataBuilder createdAt(String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @JsonProperty(value="username")
            @Generated
            public UserDataBuilder name(String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="name")
            @Generated
            public UserDataBuilder displayedName(String displayedName) {
                this.displayedName = displayedName;
                return this;
            }

            @Generated
            public UserDataBuilder location(String location) {
                this.location = location;
                return this;
            }

            @Generated
            public UserDataBuilder entities(JsonNode entities) {
                this.entities = entities;
                return this;
            }

            @Generated
            public UserDataBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public UserDataBuilder verified(boolean verified) {
                this.verified = verified;
                return this;
            }

            @JsonProperty(value="profile_image_url")
            @Generated
            public UserDataBuilder profileImageUrl(String profileImageUrl) {
                this.profileImageUrl = profileImageUrl;
                return this;
            }

            @JsonProperty(value="public_metrics")
            @Generated
            public UserDataBuilder publicMetrics(UserPublicMetrics publicMetrics) {
                this.publicMetrics = publicMetrics;
                return this;
            }

            @JsonProperty(value="pinned_tweet_id")
            @Generated
            public UserDataBuilder pinnedTweetId(String pinnedTweetId) {
                this.pinnedTweetId = pinnedTweetId;
                return this;
            }

            @Generated
            public UserDataBuilder description(String description) {
                this.description = description;
                return this;
            }

            @Generated
            public UserDataBuilder lang(String lang) {
                this.lang = lang;
                return this;
            }

            @Generated
            public UserDataBuilder isProtectedAccount(boolean isProtectedAccount) {
                this.isProtectedAccount = isProtectedAccount;
                return this;
            }

            @Generated
            public UserDataBuilder following(boolean following) {
                this.following = following;
                return this;
            }

            @Generated
            public UserData build() {
                return new UserData(this.id, this.createdAt, this.name, this.displayedName, this.location, this.entities, this.url, this.verified, this.profileImageUrl, this.publicMetrics, this.pinnedTweetId, this.description, this.lang, this.isProtectedAccount, this.following);
            }

            @Generated
            public String toString() {
                return "UserV2.UserData.UserDataBuilder(id=" + this.id + ", createdAt=" + this.createdAt + ", name=" + this.name + ", displayedName=" + this.displayedName + ", location=" + this.location + ", entities=" + this.entities + ", url=" + this.url + ", verified=" + this.verified + ", profileImageUrl=" + this.profileImageUrl + ", publicMetrics=" + this.publicMetrics + ", pinnedTweetId=" + this.pinnedTweetId + ", description=" + this.description + ", lang=" + this.lang + ", isProtectedAccount=" + this.isProtectedAccount + ", following=" + this.following + ")";
            }
        }

        public static class Includes {
            private TweetV2.TweetData[] tweets;

            @Generated
            public TweetV2.TweetData[] getTweets() {
                return this.tweets;
            }

            @Generated
            public void setTweets(TweetV2.TweetData[] tweets) {
                this.tweets = tweets;
            }
        }
    }
}

