/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import io.github.redouane59.twitter.TwitterClient;
import io.github.redouane59.twitter.helpers.TweetStreamConsumer;
import io.github.redouane59.twitter.signature.TwitterCredentials;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestHelper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRequestHelper.class);
    public static final int DEFAULT_RETRY_AFTER_SEC = 300;
    private final TwitterCredentials twitterCredentials;
    private final OAuth10aService service;
    protected final TweetStreamConsumer tweetStreamConsumer = new TweetStreamConsumer();

    protected AbstractRequestHelper(TwitterCredentials twitterCredentials) {
        this(twitterCredentials, new ServiceBuilder(twitterCredentials.getApiKey()).apiSecret(twitterCredentials.getApiSecretKey()).build((DefaultApi10a)TwitterApi.instance()));
    }

    protected AbstractRequestHelper(TwitterCredentials twitterCredentials, OAuth10aService service) {
        this.twitterCredentials = twitterCredentials;
        this.service = service;
    }

    protected <T> T convert(String json, Class<? extends T> targetClass) throws JsonProcessingException {
        if (targetClass.isInstance(json)) {
            return (T)json;
        }
        return (T)TwitterClient.OBJECT_MAPPER.readValue(json, targetClass);
    }

    public static void logApiError(String method, String url, String stringResponse, int code) {
        LOGGER.error("(" + method + ") Error calling " + url + " " + stringResponse + " - " + code);
    }

    private int getCacheTimeoutFromUrl(String url, File configFile) {
        int defaultCache = 48;
        try {
            Map map = (Map)TwitterClient.OBJECT_MAPPER.readValue(configFile, Map.class);
            for (Map.Entry e : map.entrySet()) {
                if (!url.contains((CharSequence)e.getKey())) continue;
                return (Integer)e.getValue();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return defaultCache;
    }

    protected abstract void signRequest(OAuthRequest var1);

    public <T> Optional<T> makeRequest(Verb verb, String url, Map<String, String> parameters, String body, boolean signRequired, Class<T> classType) {
        return this.makeRequest(verb, url, null, parameters, body, signRequired, classType);
    }

    public <T> Optional<T> makeRequest(Verb verb, String url, Map<String, String> headers, Map<String, String> parameters, String body, boolean signRequired, Class<T> classType) {
        OAuthRequest request = new OAuthRequest(verb, url);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.addHeader(header.getKey(), header.getValue());
            }
        }
        if (parameters != null) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                request.addQuerystringParameter(param.getKey(), param.getValue());
            }
        }
        if (body != null && verb.isPermitBody()) {
            request.setPayload(body);
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/json");
            }
        }
        return this.makeRequest(request, signRequired, classType);
    }

    public <T> Optional<T> makeRequest(OAuthRequest request, boolean signRequired, Class<T> classType) {
        Object result = null;
        try {
            if (signRequired) {
                this.signRequest(request);
            }
            Response response = this.getService().execute(request);
            String stringResponse = response.getBody();
            if (response.getCode() == 429) {
                int retryAfter = 300;
                String retryAfterStr = response.getHeader("Retry-After");
                if (retryAfterStr != null) {
                    try {
                        retryAfter = Integer.parseInt(retryAfterStr);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Using default retry after because header format is invalid: " + retryAfterStr, (Throwable)e);
                    }
                }
                LOGGER.info("Rate limit exceeded, new retry in " + 1000L * (long)retryAfter + "s");
                Thread.sleep(1000L * (long)retryAfter);
                return this.makeRequest(request, false, classType);
            }
            if (response.getCode() < 200 || response.getCode() > 299) {
                AbstractRequestHelper.logApiError(request.getVerb().name(), request.getUrl(), stringResponse, response.getCode());
            }
            result = this.convert(stringResponse, classType);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return Optional.ofNullable(result);
    }

    public abstract <T> Optional<T> getRequest(String var1, Class<T> var2);

    public abstract <T> Optional<T> getRequestWithParameters(String var1, Map<String, String> var2, Class<T> var3);

    @Generated
    public TwitterCredentials getTwitterCredentials() {
        return this.twitterCredentials;
    }

    @Generated
    public OAuth10aService getService() {
        return this.service;
    }

    @Generated
    public TweetStreamConsumer getTweetStreamConsumer() {
        return this.tweetStreamConsumer;
    }
}

