/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.helpers;

import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import io.github.redouane59.twitter.IAPIEventListener;
import io.github.redouane59.twitter.dto.others.BearerToken;
import io.github.redouane59.twitter.dto.tweet.Tweet;
import io.github.redouane59.twitter.dto.tweet.TweetV2;
import io.github.redouane59.twitter.helpers.AbstractRequestHelper;
import io.github.redouane59.twitter.signature.TwitterCredentials;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHelperV2
extends AbstractRequestHelper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHelperV2.class);
    private String bearerToken;

    public RequestHelperV2(TwitterCredentials twitterCredentials) {
        super(twitterCredentials);
    }

    public RequestHelperV2(TwitterCredentials twitterCredentials, OAuth10aService service) {
        super(twitterCredentials, service);
    }

    @Override
    public <T> Optional<T> getRequest(String url, Class<T> classType) {
        return this.getRequestWithParameters(url, null, classType);
    }

    @Override
    public <T> Optional<T> getRequestWithParameters(String url, Map<String, String> parameters, Class<T> classType) {
        return this.makeRequest(Verb.GET, url, parameters, null, true, classType);
    }

    public Future<Response> getAsyncRequest(String url, final Consumer<Tweet> consumer) {
        IAPIEventListener listener = new IAPIEventListener(){

            @Override
            public void onStreamError(int httpCode, String error) {
            }

            @Override
            public void onTweetStreamed(Tweet tweet) {
                consumer.accept(tweet);
            }

            @Override
            public void onUnknownDataStreamed(String json) {
            }

            @Override
            public void onStreamEnded(Exception e) {
            }
        };
        return this.getAsyncRequest(url, listener, TweetV2.class);
    }

    public Future<Response> getAsyncRequest(String url, IAPIEventListener listener) {
        return this.getAsyncRequest(url, listener, TweetV2.class);
    }

    public <T> Future<Response> getAsyncRequest(String url, final IAPIEventListener listener, final Class<? extends T> targetClass) {
        OAuthRequest request = new OAuthRequest(Verb.GET, url);
        this.signRequest(request);
        return this.getService().execute(request, (OAuthAsyncRequestCallback)new OAuthAsyncRequestCallback<Response>(){

            public void onThrowable(Throwable t) {
                LOGGER.error(t.getMessage(), t);
            }

            public void onCompleted(Response response) {
                try {
                    RequestHelperV2.this.tweetStreamConsumer.consumeStream(listener, response, targetClass);
                }
                catch (Exception e) {
                    this.onThrowable(e);
                }
            }
        });
    }

    public <T> Optional<T> postRequest(String url, String body, Class<T> classType) {
        return this.makeRequest(Verb.POST, url, null, body, true, classType);
    }

    public <T> Optional<T> postRequestWithHeader(String url, Map<String, String> headersMap, String body, Class<T> classType) {
        return this.makeRequest(Verb.POST, url, headersMap, null, body, false, classType);
    }

    public <T> Optional<T> getRequestWithHeader(String url, Map<String, String> headersMap, Class<T> classType) {
        return this.makeRequest(Verb.GET, url, headersMap, null, null, false, classType);
    }

    @Override
    protected void signRequest(OAuthRequest request) {
        request.addHeader("Authorization", "Bearer " + this.getBearerToken());
    }

    public String getBearerToken() {
        if (this.bearerToken == null) {
            String url = "https://api.twitter.com/oauth2/token";
            String valueToCrypt = this.getTwitterCredentials().getApiKey() + ":" + this.getTwitterCredentials().getApiSecretKey();
            String cryptedValue = Base64.getEncoder().encodeToString(valueToCrypt.getBytes());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + cryptedValue);
            headers.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            String body = "grant_type=client_credentials";
            Optional<BearerToken> result = this.makeRequest(Verb.POST, url, headers, null, body, false, BearerToken.class);
            this.bearerToken = result.orElseThrow(NoSuchElementException::new).getAccessToken();
        }
        return this.bearerToken;
    }
}

