/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.scribejava.core.model.Response;
import io.github.redouane59.twitter.IAPIEventListener;
import io.github.redouane59.twitter.TwitterClient;
import io.github.redouane59.twitter.dto.tweet.TweetV2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TweetStreamConsumer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TweetStreamConsumer.class);
    private StringBuilder buffer = new StringBuilder();

    public boolean consumeBuffer(String data) {
        if (data.trim().isEmpty()) {
            return false;
        }
        if (this.buffer.toString().isEmpty() && !data.trim().startsWith("{")) {
            LOGGER.warn("Invalid JSON Start Character. Ignoring : " + data);
            return false;
        }
        this.buffer.append(data);
        return this.buffer.indexOf("\r\n") != -1;
    }

    public <T> void consumeStream(IAPIEventListener listener, Response response, Class<? extends T> clazz) {
        if (listener == null) {
            throw new IllegalAccessError("Missing listener");
        }
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getStream(), StandardCharsets.UTF_8));){
                boolean bValid = true;
                while (bValid) {
                    bValid = this.readSocket(listener, response, clazz, reader);
                }
            }
            catch (IOException e) {
                listener.onStreamEnded(e);
            }
        }).start();
    }

    private <T> boolean readSocket(IAPIEventListener listener, Response response, Class<? extends T> clazz, BufferedReader reader) throws IOException {
        try {
            String line = reader.readLine();
            if (line == null) {
                return false;
            }
            if (!line.trim().isEmpty() && !this.handleData(listener, response, clazz, line)) {
                return false;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return true;
    }

    private <T> boolean handleData(IAPIEventListener listener, Response response, Class<? extends T> clazz, String line) throws JsonProcessingException {
        if (response.getCode() == 200) {
            if (clazz == TweetV2.class) {
                listener.onTweetStreamed((TweetV2)TwitterClient.OBJECT_MAPPER.readValue(line, clazz));
            } else {
                listener.onUnknownDataStreamed(line);
            }
            return true;
        }
        listener.onStreamError(response.getCode(), line);
        return false;
    }

    private boolean isValidJSON(String json) {
        try {
            TwitterClient.OBJECT_MAPPER.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String[] getJsonTweets() {
        List result = Stream.of(this.buffer.toString().split("\n")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
        if (result.isEmpty()) {
            return new String[0];
        }
        String lastJSON = (String)result.get(result.size() - 1);
        boolean complete = this.isValidJSON(lastJSON);
        this.buffer = new StringBuilder();
        if (!complete) {
            this.consumeBuffer(lastJSON);
            result.remove(result.size() - 1);
        }
        return (String[])result.stream().toArray(String[]::new);
    }
}

