/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.helpers;

import io.github.redouane59.twitter.dto.tweet.MediaCategory;
import lombok.Generated;

public class URLHelper {
    private static final String ROOT_URL_V1 = "https://api.twitter.com/1.1";
    private static final String ROOT_URL_V2 = "https://api.twitter.com/2";
    private static final String IDS_JSON = "/ids.json?";
    private static final String ID = "id";
    private static final String COUNT = "count";
    private static final String LIST_JSON = "/list.json";
    private static final String SHOW_JSON = "/show.json?";
    private static final String RETWEETERS = "/retweeters";
    private static final String FOLLOWERS = "/followers";
    private static final String STATUSES = "/statuses";
    private static final String FRIENDSHIPS = "/friendships";
    private static final String USERS = "/users";
    private static final String TWEETS = "/tweets";
    private static final String SEARCH = "/search";
    private static final String THIRTY_DAYS = "/30day";
    private static final String FULL_ARCHIVE = "/fullarchive";
    private static final String USER_ID = "user_id";
    private static final String USER_TIMELINE = "/user_timeline.json?";
    private static final String JSON = ".json";
    private static final String MAX_ID = "max_id";
    private static final String COLLECTIONS = "/collections";
    private static final int RETWEET_MAX_COUNT = 100;
    public static final int MAX_LOOKUP = 100;
    public static final String LAST_TWEET_LIST_URL = "https://api.twitter.com/1.1/statuses/user_timeline.json?";
    public static final String RATE_LIMIT_URL = "https://api.twitter.com/1.1/application/rate_limit_status.json";
    public static final String SEARCH_TWEET_STANDARD_URL = "https://api.twitter.com/1.1/search/tweets.json";
    public static final String GET_BEARER_TOKEN_URL = "https://api.twitter.com/oauth2/token";
    public static final String GET_OAUTH1_TOKEN_URL = "https://api.twitter.com/oauth/request_token";
    public static final String GET_OAUTH1_ACCESS_TOKEN_URL = "https://api.twitter.com/oauth/access_token";
    private static final String DIRECT_MESSAGE_EVENTS = "/direct_messages/events";
    private final String idVariable = ":id";
    private final String searchRecentTweetsUrl = "https://api.twitter.com/2/tweets/search/recent";
    private final String searchAllTweetsUrl = "https://api.twitter.com/2/tweets/search/all";
    private final String filteredStreamRulesUrl = "https://api.twitter.com/2/tweets/search/stream/rules";
    private final String filteredStreamUrl = "https://api.twitter.com/2/tweets/search/stream";
    private final String tweetsCountUrl = "https://api.twitter.com/2/tweets/counts/recent";
    private final String tweetsCountAllUrl = "https://api.twitter.com/2/tweets/counts/all";
    private final String tweetsUrl = "https://api.twitter.com/2/tweets";
    private final String usersByUrl = "https://api.twitter.com/2/users/by";
    private final String usersUrl = "https://api.twitter.com/2/users";
    private final String followUrl = "https://api.twitter.com/2/users/:id/following";
    private final String unfollowUrl = "https://api.twitter.com/2/users/:sourceId/following/:targetId";
    private final String followersUrl = "https://api.twitter.com/2/users/:id/followers";
    private final String followingUrl = "https://api.twitter.com/2/users/:id/following";
    private final String userUrl = "https://api.twitter.com/2/users/:id";
    private final String userUrlFromName = "https://api.twitter.com/2/users/by/username/:username";
    private final String tweetUrl = "https://api.twitter.com/2/tweets/:id";
    private final String likeUrl = "https://api.twitter.com/2/users/:id/likes";
    private final String unlikeUrl = "https://api.twitter.com/2/users/:userId/likes/:tweetId";
    private final String hideUrl = "https://api.twitter.com/2/tweets/:id/hidden";
    private final String sampledStreamUrl = "https://api.twitter.com/2/tweets/sample/stream";
    private final String userTimelineUrl = "https://api.twitter.com/2/users/:id/tweets";
    private final String userMentionsUrl = "https://api.twitter.com/2/users/:id/mentions";
    private final String blockUserUrl = "https://api.twitter.com/2/users/:id/blocking";
    private final String unblockUserUrl = "https://api.twitter.com/2/users/:sourceId/blocking/:targetId";
    private final String blockingUsersUrl = "https://api.twitter.com/2/users/:id/blocking";
    private final String likingUsersUrl = "https://api.twitter.com/2/tweets/:id/liking_users";
    private final String likedTweetsUrl = "https://api.twitter.com/2/users/:id/liked_tweets";

    public String getSearchTweet30DaysUrl(String envName) {
        return "https://api.twitter.com/1.1/tweets/search/30day/" + envName + JSON;
    }

    public String getSearchTweetFullArchiveUrl(String envName) {
        return "https://api.twitter.com/1.1/tweets/search/fullarchive/" + envName + JSON;
    }

    public String getFollowUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/following".replace(":id", userId);
    }

    public String getUnfollowUrl(String sourceUserId, String targetUserId) {
        return "https://api.twitter.com/2/users/:sourceId/following/:targetId".replace(":sourceId", sourceUserId).replace(":targetId", targetUserId);
    }

    public String getFriendshipUrl(String sourceId, String targetId) {
        return "https://api.twitter.com/1.1/friendships/show.json?source_id=" + sourceId + "&target_" + ID + "=" + targetId;
    }

    public String getRetweetersUrl(String tweetId) {
        return "https://api.twitter.com/1.1/statuses/retweeters/ids.json?id=" + tweetId + "&" + COUNT + "=" + 100;
    }

    public String getFollowersUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/followers".replace(":id", userId);
    }

    public String getFollowersIdsUrl(String userId) {
        return "https://api.twitter.com/1.1/followers/ids.json?user_id=" + userId + "&count=5000";
    }

    public String getFollowingUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/following".replace(":id", userId);
    }

    public String getUserUrl(String userId) {
        return "https://api.twitter.com/2/users/:id".replace(":id", userId);
    }

    public String getUserUrlFromName(String username) {
        return "https://api.twitter.com/2/users/by/username/:username".replace(":username", username);
    }

    public String getTweetUrl(String tweetId) {
        return "https://api.twitter.com/2/tweets/:id".replace(":id", tweetId);
    }

    public String getLikeUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/likes".replace(":id", userId);
    }

    public String getUnlikeUrl(String userId, String tweetId) {
        return "https://api.twitter.com/2/users/:userId/likes/:tweetId".replace(":userId", userId).replace(":tweetId", tweetId);
    }

    public String getRetweetTweetUrl(String tweetId) {
        return "https://api.twitter.com/1.1/statuses/retweet/" + tweetId + JSON;
    }

    public String getPostTweetUrl() {
        return "https://api.twitter.com/1.1/statuses/update.json";
    }

    public String getDeleteTweetUrl(String tweetId) {
        return "https://api.twitter.com/1.1/statuses/destroy/" + tweetId + JSON;
    }

    public String getFavoriteTweetsUrl(String userId, String maxId) {
        String result = maxId == null || maxId.length() == 0 ? "https://api.twitter.com/1.1/favorites/list.json?count=200&user_id=" + userId : "https://api.twitter.com/1.1/favorites/list.json?count=200&user_id=" + userId + "&" + MAX_ID + "=" + maxId;
        return result.concat("&tweet_mode=extended");
    }

    public String getHideReplyUrl(String tweetId) {
        return "https://api.twitter.com/2/tweets/:id/hidden".replace(":id", tweetId);
    }

    public String getFilteredStreamUrl() {
        return "https://api.twitter.com/2/tweets/search/stream?expansionsauthor_id,entities.mentions.username,in_reply_to_user_id,referenced_tweets.id,referenced_tweets.id.author_id&tweet.fieldsattachments,author_id,created_at,entities,geo,id,in_reply_to_user_id,lang,possibly_sensitive,public_metrics,referenced_tweets,source,text,withheld,context_annotations,conversation_id,reply_settings&user.fieldsid,created_at,entities,username,name,location,url,verified,profile_image_url,public_metrics,pinned_tweet_id,description,protected";
    }

    public String getSampledStreamUrl() {
        return "https://api.twitter.com/2/tweets/sample/stream?expansionsauthor_id,entities.mentions.username,in_reply_to_user_id,referenced_tweets.id,referenced_tweets.id.author_id&tweet.fieldsattachments,author_id,created_at,entities,geo,id,in_reply_to_user_id,lang,possibly_sensitive,public_metrics,referenced_tweets,source,text,withheld,context_annotations,conversation_id,reply_settings&user.fieldsid,created_at,entities,username,name,location,url,verified,profile_image_url,public_metrics,pinned_tweet_id,description,protected";
    }

    public String getUserTimelineUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/tweets".replace(":id", userId);
    }

    public String getUserMentionsUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/mentions".replace(":id", userId);
    }

    public String getUploadMediaUrl(MediaCategory mediaCategory) {
        return "https://upload.twitter.com/1.1/media/upload.json?media_category=" + mediaCategory.label;
    }

    public String getCollectionsCreateUrl() {
        return "https://api.twitter.com/1.1/collections/create.json";
    }

    public String getCollectionsCurateUrl() {
        return "https://api.twitter.com/1.1/collections/entries/curate.json";
    }

    public String getCollectionsDestroyUrl(String collectionId) {
        return "https://api.twitter.com/1.1/collections/destroy.json?id=" + collectionId;
    }

    public String getCollectionsEntriesUrl(String collectionId) {
        return "https://api.twitter.com/1.1/collections/entries.json?id=" + collectionId;
    }

    public String getBlockUserUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/blocking".replace(":id", userId);
    }

    public String getUnblockUserUrl(String sourceUserId, String targetUserId) {
        return "https://api.twitter.com/2/users/:sourceId/blocking/:targetId".replace(":sourceId", sourceUserId).replace(":targetId", targetUserId);
    }

    public String getBlockingUsersUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/blocking".replace(":id", userId);
    }

    public String getLikingUsersUrl(String tweetId) {
        return "https://api.twitter.com/2/tweets/:id/liking_users".replace(":id", tweetId);
    }

    public String getLikedTweetsUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/liked_tweets".replace(":id", userId);
    }

    public String getDMListUrl(int count) {
        return "https://api.twitter.com/1.1/direct_messages/events/list.json?count=" + count;
    }

    public String getDmUrl(String id) {
        return "https://api.twitter.com/1.1/direct_messages/events/show.json?id=" + id;
    }

    public String getPostDmUrl() {
        return "https://api.twitter.com/1.1/direct_messages/events/new.json";
    }

    @Generated
    public String getSearchRecentTweetsUrl() {
        return this.searchRecentTweetsUrl;
    }

    @Generated
    public String getSearchAllTweetsUrl() {
        return this.searchAllTweetsUrl;
    }

    @Generated
    public String getFilteredStreamRulesUrl() {
        return this.filteredStreamRulesUrl;
    }

    @Generated
    public String getTweetsCountUrl() {
        return this.tweetsCountUrl;
    }

    @Generated
    public String getTweetsCountAllUrl() {
        return this.tweetsCountAllUrl;
    }

    @Generated
    public String getTweetsUrl() {
        return this.tweetsUrl;
    }

    @Generated
    public String getUsersByUrl() {
        return this.usersByUrl;
    }

    @Generated
    public String getUsersUrl() {
        return this.usersUrl;
    }
}

