/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import io.github.redouane59.RelationType;
import io.github.redouane59.twitter.IAPIEventListener;
import io.github.redouane59.twitter.ITwitterClientArchive;
import io.github.redouane59.twitter.ITwitterClientV1;
import io.github.redouane59.twitter.ITwitterClientV2;
import io.github.redouane59.twitter.dto.collections.CollectionsResponse;
import io.github.redouane59.twitter.dto.collections.TimeLineOrder;
import io.github.redouane59.twitter.dto.dm.DmParameters;
import io.github.redouane59.twitter.dto.dm.PostDmResponse;
import io.github.redouane59.twitter.dto.dm.deprecatedV1.DirectMessage;
import io.github.redouane59.twitter.dto.dm.deprecatedV1.DmEvent;
import io.github.redouane59.twitter.dto.dm.deprecatedV1.DmListAnswer;
import io.github.redouane59.twitter.dto.endpoints.AdditionalParameters;
import io.github.redouane59.twitter.dto.getrelationship.IdList;
import io.github.redouane59.twitter.dto.getrelationship.RelationshipObjectResponse;
import io.github.redouane59.twitter.dto.list.TwitterList;
import io.github.redouane59.twitter.dto.list.TwitterListList;
import io.github.redouane59.twitter.dto.list.TwitterListMember;
import io.github.redouane59.twitter.dto.others.BearerToken;
import io.github.redouane59.twitter.dto.others.BlockResponse;
import io.github.redouane59.twitter.dto.others.RateLimitStatus;
import io.github.redouane59.twitter.dto.others.RequestToken;
import io.github.redouane59.twitter.dto.rules.FilteredStreamRulePredicate;
import io.github.redouane59.twitter.dto.space.Space;
import io.github.redouane59.twitter.dto.space.SpaceList;
import io.github.redouane59.twitter.dto.space.SpaceState;
import io.github.redouane59.twitter.dto.stream.StreamRules;
import io.github.redouane59.twitter.dto.tweet.HiddenResponse;
import io.github.redouane59.twitter.dto.tweet.LikeResponse;
import io.github.redouane59.twitter.dto.tweet.MediaCategory;
import io.github.redouane59.twitter.dto.tweet.RetweetResponse;
import io.github.redouane59.twitter.dto.tweet.Tweet;
import io.github.redouane59.twitter.dto.tweet.TweetCountsList;
import io.github.redouane59.twitter.dto.tweet.TweetList;
import io.github.redouane59.twitter.dto.tweet.TweetParameters;
import io.github.redouane59.twitter.dto.tweet.TweetSearchResponseV1;
import io.github.redouane59.twitter.dto.tweet.TweetV1;
import io.github.redouane59.twitter.dto.tweet.TweetV1Deserializer;
import io.github.redouane59.twitter.dto.tweet.TweetV2;
import io.github.redouane59.twitter.dto.tweet.UploadMediaProcessingInfo;
import io.github.redouane59.twitter.dto.tweet.UploadMediaResponse;
import io.github.redouane59.twitter.dto.user.FollowBody;
import io.github.redouane59.twitter.dto.user.User;
import io.github.redouane59.twitter.dto.user.UserActionResponse;
import io.github.redouane59.twitter.dto.user.UserList;
import io.github.redouane59.twitter.dto.user.UserV2;
import io.github.redouane59.twitter.helpers.AbstractRequestHelper;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import io.github.redouane59.twitter.helpers.JsonHelper;
import io.github.redouane59.twitter.helpers.RequestHelper;
import io.github.redouane59.twitter.helpers.RequestHelperV2;
import io.github.redouane59.twitter.helpers.URLHelper;
import io.github.redouane59.twitter.signature.TwitterCredentials;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterClient
implements ITwitterClientV1,
ITwitterClientV2,
ITwitterClientArchive {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TwitterClient.class);
    public static final String TWEET_FIELDS = "tweet.fields";
    public static final String ALL_TWEET_FIELDS = "attachments,author_id,created_at,entities,geo,id,in_reply_to_user_id,lang,possibly_sensitive,public_metrics,referenced_tweets,source,text,withheld,context_annotations,conversation_id,reply_settings";
    public static final String EXPANSION = "expansions";
    public static final String ALL_EXPANSIONS = "author_id,entities.mentions.username,in_reply_to_user_id,referenced_tweets.id,referenced_tweets.id.author_id,attachments.media_keys,geo.place_id";
    public static final String USER_FIELDS = "user.fields";
    public static final String ALL_USER_FIELDS = "id,created_at,entities,username,name,location,url,verified,profile_image_url,public_metrics,pinned_tweet_id,description,protected";
    public static final String MEDIA_FIELD = "media.fields";
    public static final String ALL_MEDIA_FIELDS = "duration_ms,height,media_key,preview_image_url,public_metrics,type,url,width,alt_text,variants";
    public static final String SPACE_FIELDS = "space.fields";
    public static final String ALL_SPACE_FIELDS = "host_ids,created_at,creator_id,id,lang,invited_user_ids,participant_count,speaker_ids,started_at,state,title,updated_at,scheduled_start,is_ticketed";
    public static final String PLACE_FIELDS = "place.fields";
    public static final String ALL_PLACE_FIELDS = "contained_within,country,country_code,full_name,geo,id,name,place_type";
    public static final String POLL_FIELDS = "poll.fields";
    public static final String ALL_POLL_FIELDS = "duration_minutes,end_datetime,id,options,voting_status";
    public static final String LIST_FIELDS = "list.fields";
    public static final String ALL_LIST_FIELDS = "created_at,follower_count,member_count,private,description,owner_id";
    public static final String ALL_SPACE_EXPANSIONS = "invited_user_ids,speaker_ids,creator_id,host_ids";
    public static final String DM_FIELDS = "dm_event.fields";
    public static final String ALL_DM_FIELDS = "id,text,event_type,created_at,dm_conversation_id,sender_id,participant_ids,referenced_tweets,attachments";
    private static final String ALL_DM_EXPANSIONS = "attachments.media_keys,referenced_tweets.id,sender_id,participant_ids";
    private static final String QUERY = "query";
    private static final String CURSOR = "cursor";
    private static final String NEXT = "next";
    private static final String PAGINATION_TOKEN = "pagination_token";
    private static final String PINNED_TWEET_ID = "pinned_tweet_id";
    private static final String BACKFILL_MINUTES = "backfill_minutes";
    private static final String DATA = "data";
    private static final String DELETED = "deleted";
    private static final String IS_MEMBER = "is_member";
    private static final String FOLLOWING = "following";
    private static final String PINNED = "pinned";
    private static final String[] DEFAULT_VALID_CREDENTIALS_FILE_NAMES = new String[]{"test-twitter-credentials.json", "twitter-credentials.json"};
    private URLHelper urlHelper = new URLHelper();
    private RequestHelper requestHelperV1;
    private RequestHelperV2 requestHelperV2;
    private TwitterCredentials twitterCredentials;

    public TwitterClient() {
        this(TwitterClient.getAuthentication());
    }

    public TwitterClient(TwitterCredentials credentials) {
        this(credentials, new ServiceBuilder(credentials.getApiKey()).apiSecret(credentials.getApiSecretKey()));
    }

    public TwitterClient(TwitterCredentials credentials, HttpClient httpClient) {
        this(credentials, new ServiceBuilder(credentials.getApiKey()).apiSecret(credentials.getApiSecretKey()).httpClient(httpClient));
    }

    public TwitterClient(TwitterCredentials credentials, HttpClient httpClient, HttpClientConfig config) {
        this(credentials, new ServiceBuilder(credentials.getApiKey()).apiSecret(credentials.getApiSecretKey()).httpClient(httpClient).httpClientConfig(config));
    }

    public TwitterClient(TwitterCredentials credentials, ServiceBuilder serviceBuilder) {
        this(credentials, serviceBuilder.apiKey(credentials.getApiKey()).apiSecret(credentials.getApiSecretKey()).build((DefaultApi10a)TwitterApi.instance()));
    }

    public TwitterClient(TwitterCredentials credentials, OAuth10aService service) {
        this.twitterCredentials = credentials;
        this.requestHelperV1 = new RequestHelper(credentials, service);
        this.requestHelperV2 = new RequestHelperV2(credentials, service);
    }

    public static TwitterCredentials getAuthentication() {
        String credentialPath = System.getProperty("twitter.credentials.file.path");
        if (credentialPath != null) {
            return TwitterClient.getAuthentication(new File(credentialPath));
        }
        return TwitterClient.getAuthentication(Paths.get("", new String[0]), new String[0]);
    }

    public static TwitterCredentials getAuthentication(Path pathToScan, String ... validNames) {
        if (pathToScan.toFile().isFile()) {
            return TwitterClient.getAuthentication(pathToScan.toFile());
        }
        String[] namesToCheck = validNames != null && validNames.length > 0 ? validNames : DEFAULT_VALID_CREDENTIALS_FILE_NAMES;
        for (Path currentPath = pathToScan; currentPath != null; currentPath = currentPath.getParent()) {
            for (String name : namesToCheck) {
                Path file = currentPath.resolve(name);
                if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                return TwitterClient.getAuthentication(file.toFile());
            }
        }
        return null;
    }

    public static TwitterCredentials getAuthentication(File twitterCredentialsFile) {
        try {
            TwitterCredentials twitterCredentials = (TwitterCredentials)JsonHelper.OBJECT_MAPPER.readValue(twitterCredentialsFile, TwitterCredentials.class);
            if (twitterCredentials.getAccessToken() == null) {
                LOGGER.error("Access token is null in twitter-credentials.json");
            }
            if (twitterCredentials.getAccessTokenSecret() == null) {
                LOGGER.error("Secret token is null in twitter-credentials.json");
            }
            if (twitterCredentials.getApiKey() == null) {
                LOGGER.error("Consumer key is null in twitter-credentials.json");
            }
            if (twitterCredentials.getApiSecretKey() == null) {
                LOGGER.error("Consumer secret is null in twitter-credentials.json");
            }
            return twitterCredentials;
        }
        catch (Exception e) {
            LOGGER.error("Twitter credentials json file error in path {}. Use program argument -Dtwitter.credentials.file.path=/my/path/to/json.", (Object)twitterCredentialsFile.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    public void setAutomaticRetry(boolean automaticRetry) {
        this.requestHelperV1.setAutomaticRetry(automaticRetry);
        this.requestHelperV2.setAutomaticRetry(automaticRetry);
    }

    private List<String> getUserIdsByRelation(String url) {
        Optional<IdList> idListResponse;
        String cursor = "-1";
        ArrayList<String> result = new ArrayList<String>();
        do {
            String urlWithCursor = url + "&" + CURSOR + "=" + cursor;
            idListResponse = this.getRequestHelper().getRequest(urlWithCursor, IdList.class);
            if (!idListResponse.isPresent()) break;
            result.addAll(idListResponse.get().getIds());
        } while (!(cursor = idListResponse.get().getNextCursor()).equals("0"));
        return result;
    }

    @Override
    public UserList getFollowers(String userId) {
        return this.getFollowers(userId, AdditionalParameters.builder().maxResults(1000).build());
    }

    @Override
    public UserList getFollowers(String userId, AdditionalParameters additionalParameters) {
        String url = this.urlHelper.getFollowersUrl(userId);
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(1000));
        }
        return this.getUsersRecursively(url, parameters, this.getRequestHelper());
    }

    @Override
    public UserList getFollowing(String userId) {
        return this.getFollowing(userId, AdditionalParameters.builder().maxResults(1000).build());
    }

    @Override
    public UserList getFollowing(String userId, AdditionalParameters additionalParameters) {
        String url = this.urlHelper.getFollowingUrl(userId);
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(1000));
        }
        return this.getUsersRecursively(url, parameters, this.getRequestHelper());
    }

    @Override
    public RelationType getRelationType(String userId1, String userId2) {
        String url = this.urlHelper.getFriendshipUrl(userId1, userId2);
        RelationshipObjectResponse relationshipDTO = this.getRequestHelper().getRequest(url, RelationshipObjectResponse.class).orElseThrow(NoSuchElementException::new);
        boolean followedBy = relationshipDTO.getRelationship().getSource().isFollowedBy();
        boolean following = relationshipDTO.getRelationship().getSource().isFollowing();
        if (followedBy && following) {
            return RelationType.FRIENDS;
        }
        if (!followedBy && !following) {
            return RelationType.NONE;
        }
        if (followedBy) {
            return RelationType.FOLLOWER;
        }
        return RelationType.FOLLOWING;
    }

    @Override
    public List<String> getFollowersIds(String userId) {
        String url = this.urlHelper.getFollowersIdsUrl(userId);
        return this.getUserIdsByRelation(url);
    }

    @Override
    public List<String> getFollowingIds(String userId) {
        String url = this.urlHelper.getFollowingIdsUrl(userId);
        return this.getUserIdsByRelation(url);
    }

    @Override
    public UserActionResponse follow(String targetUserId) {
        String url = this.urlHelper.getFollowUrl(this.getUserIdFromAccessToken());
        String body = JsonHelper.toJson(new FollowBody(targetUserId));
        return this.requestHelperV1.postRequestWithBodyJson(url, new HashMap<String, String>(), body, UserActionResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserActionResponse unfollow(String targetUserId) {
        String url = this.urlHelper.getUnfollowUrl(this.getUserIdFromAccessToken(), targetUserId);
        return this.getRequestHelper().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, UserActionResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public BlockResponse blockUser(String targetUserId) {
        String url = this.urlHelper.getBlockUserUrl(this.getUserIdFromAccessToken());
        return this.getRequestHelper().makeRequest(Verb.POST, url, new HashMap<String, String>(), JsonHelper.toJson(new FollowBody(targetUserId)), true, BlockResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public BlockResponse unblockUser(String targetUserId) {
        String url = this.urlHelper.getUnblockUserUrl(this.getUserIdFromAccessToken(), targetUserId);
        return this.getRequestHelper().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, BlockResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserList getBlockedUsers() {
        String url = this.urlHelper.getBlockingUsersUrl(this.getUserIdFromAccessToken());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public User getUserFromUserId(String userId) {
        String url = this.getUrlHelper().getUserUrl(userId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, UserV2.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserV2 getUserFromUserName(String userName) {
        String url = this.getUrlHelper().getUserUrlFromName(userName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, UserV2.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public List<User> getUsersFromUserNames(List<String> userNames) {
        String url = this.getUrlHelper().getUsersByUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < userNames.size() && i < 100; ++i) {
            String name = userNames.get(i);
            names.append(name);
            names.append(",");
        }
        names.delete(names.length() - 1, names.length());
        parameters.put("usernames", names.toString());
        List<UserV2.UserData> result = this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new).getData();
        return result.stream().map(userData -> UserV2.builder().data((UserV2.UserData)userData).build()).collect(Collectors.toList());
    }

    @Override
    public List<User> getUsersFromUserIds(List<String> userIds) {
        String url = this.getUrlHelper().getUsersUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < userIds.size() && i < 100; ++i) {
            String name = userIds.get(i);
            names.append(name);
            names.append(",");
        }
        names.delete(names.length() - 1, names.length());
        parameters.put("ids", names.toString());
        List<UserV2.UserData> result = this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new).getData();
        return result.stream().map(userData -> UserV2.builder().data((UserV2.UserData)userData).build()).collect(Collectors.toList());
    }

    @Override
    public RateLimitStatus getRateLimitStatus() {
        String url = "https://api.twitter.com/1.1/application/rate_limit_status.json";
        return this.getRequestHelper().getRequest(url, RateLimitStatus.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public LikeResponse likeTweet(String tweetId) {
        String url = this.getUrlHelper().getLikeUrl(this.getUserIdFromAccessToken());
        return this.getRequestHelperV1().postRequestWithBodyJson(url, new HashMap<String, String>(), "{\"tweet_id\":\"" + tweetId + "\"}", LikeResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public LikeResponse unlikeTweet(String tweetId) {
        String url = this.getUrlHelper().getUnlikeUrl(this.getUserIdFromAccessToken(), tweetId);
        return this.getRequestHelper().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, LikeResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserList getRetweetingUsers(String tweetId, int maxResults) {
        String url = this.urlHelper.getRetweetersUrl(tweetId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        return this.getUsersRecursively(maxResults, url, parameters);
    }

    private UserList getUsersRecursively(int maxResults, String url, Map<String, String> parameters) {
        String next;
        UserList result = UserList.builder().meta(new UserList.UserMeta()).build();
        do {
            parameters.put("max_results", String.valueOf(Math.min(100, maxResults - result.getData().size())));
            Optional<UserList> userList = this.getRequestHelper().getRequestWithParameters(url, parameters, UserList.class);
            if (!userList.isPresent() || userList.get().getData() == null) {
                result.getMeta().setNextToken(null);
                break;
            }
            result.getData().addAll(userList.get().getData());
            UserList.UserMeta meta = UserList.UserMeta.builder().resultCount(result.getData().size()).nextToken(userList.get().getMeta().getNextToken()).build();
            result.setMeta(meta);
            next = userList.get().getMeta().getNextToken();
            parameters.put(PAGINATION_TOKEN, next);
        } while (next != null && result.getData().size() < maxResults);
        return result;
    }

    @Override
    public UserList getRetweetingUsers(String tweetId) {
        return this.getRetweetingUsers(tweetId, Integer.MAX_VALUE);
    }

    @Override
    public UserList getLikingUsers(String tweetId, int maxResults) {
        String url = this.getUrlHelper().getLikingUsersUrl(tweetId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        return this.getUsersRecursively(maxResults, url, parameters);
    }

    @Override
    public UserList getLikingUsers(String tweetId) {
        return this.getLikingUsers(tweetId, Integer.MAX_VALUE);
    }

    @Override
    public TweetList getLikedTweets(String userId) {
        return this.getLikedTweets(userId, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public TweetList getLikedTweets(String userId, AdditionalParameters additionalParameters) {
        String url = this.getUrlHelper().getLikedTweetsUrl(userId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelper().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters, this.getRequestHelper());
    }

    @Override
    public TweetCountsList getTweetCounts(String query) {
        return this.getTweetCounts(query, AdditionalParameters.builder().build());
    }

    @Override
    public TweetCountsList getTweetCounts(String query, AdditionalParameters additionalParameters) {
        String url = this.getUrlHelper().getTweetsCountUrl();
        return this.getTweetCounts(url, query, additionalParameters);
    }

    @Override
    public TweetCountsList getAllTweetCounts(String query) {
        return this.getAllTweetCounts(query, AdditionalParameters.builder().build());
    }

    @Override
    public TweetCountsList getAllTweetCounts(String query, AdditionalParameters additionalParameters) {
        String url = this.urlHelper.getTweetsCountAllUrl();
        return this.getTweetCounts(url, query, additionalParameters);
    }

    private TweetCountsList getTweetCounts(String url, String query, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(QUERY, query);
        return this.getRequestHelperV2().getRequestWithParameters(url, parameters, TweetCountsList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserActionResponse muteUser(String userId) {
        String url = this.urlHelper.getMuteUserUrl(this.getUserIdFromAccessToken());
        String body = JsonHelper.toJson(new FollowBody(userId));
        return this.requestHelperV1.postRequestWithBodyJson(url, new HashMap<String, String>(), body, UserActionResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserActionResponse unmuteUser(String userId) {
        String url = this.urlHelper.getUnmuteUserUrl(this.getUserIdFromAccessToken(), userId);
        return this.requestHelperV1.makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, UserActionResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserList getMutedUsers() {
        String url = this.urlHelper.getMutedUsersUrl(this.getUserIdFromAccessToken());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        parameters.put("max_results", "1000");
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        return this.requestHelperV1.getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public RetweetResponse retweetTweet(String tweetId) {
        String url = this.getUrlHelper().getRetweetTweetUrl(this.getUserIdFromAccessToken());
        String body = "{\"tweet_id\": \"" + tweetId + "\"}";
        return this.requestHelperV1.postRequestWithBodyJson(url, new HashMap<String, String>(), body, RetweetResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public RetweetResponse unretweetTweet(String tweetId) {
        String url = this.getUrlHelper().getUnretweetTweetUrl(this.getUserIdFromAccessToken(), tweetId);
        return this.requestHelperV1.makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, RetweetResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public Space getSpace(String spaceId) {
        String url = this.getUrlHelper().getSpaceUrl(spaceId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_SPACE_EXPANSIONS);
        parameters.put(SPACE_FIELDS, ALL_SPACE_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelperV2().getRequestWithParameters(url, parameters, Space.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public SpaceList getSpaces(List<String> spaceIds) {
        String url = this.getUrlHelper().getSpacesUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_SPACE_EXPANSIONS);
        parameters.put(SPACE_FIELDS, ALL_SPACE_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put("ids", String.join((CharSequence)", ", spaceIds));
        return this.getRequestHelperV2().getRequestWithParameters(url, parameters, SpaceList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public SpaceList getSpacesByCreators(List<String> creatorIds) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("user_ids", String.join((CharSequence)", ", creatorIds));
        parameters.put(EXPANSION, ALL_SPACE_EXPANSIONS);
        parameters.put(SPACE_FIELDS, ALL_SPACE_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelperV2().getRequestWithParameters(this.getUrlHelper().getSpaceByCreatorUrl(), parameters, SpaceList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public SpaceList searchSpaces(String query, SpaceState state) {
        String url = this.getUrlHelper().getSearchSpacesUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(QUERY, query);
        parameters.put("state", state.getLabel());
        parameters.put(EXPANSION, ALL_SPACE_EXPANSIONS);
        parameters.put(SPACE_FIELDS, ALL_SPACE_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put("max_results", "100");
        return this.getRequestHelperV2().getRequestWithParameters(url, parameters, SpaceList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserList getSpaceBuyers(String spaceId) {
        String url = this.getUrlHelper().getSpaceBuyersUrl(spaceId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        return this.getRequestHelperV2().getRequestWithParameters(url, parameters, UserList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public TwitterList createList(String listName, String description, boolean isPrivate) {
        String url = this.getUrlHelper().getListUrlV2();
        TwitterList.TwitterListData body = TwitterList.TwitterListData.builder().name(listName).description(description).isPrivate(isPrivate).build();
        return this.getRequestHelperV1().postRequestWithBodyJson(url, null, JsonHelper.toJson(body), TwitterList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public boolean deleteList(String listId) {
        String url = this.getUrlHelper().getListUrlV2() + "/" + listId;
        JsonNode jsonNode = this.getRequestHelperV1().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, JsonNode.class).orElseThrow(NoSuchElementException::new);
        return jsonNode.get(DATA).get(DELETED).asBoolean();
    }

    @Override
    public boolean addListMember(String listId, String userId) {
        String url = this.getUrlHelper().getAddListMemberUrl(listId);
        TwitterListMember.TwitterListMemberData body = TwitterListMember.TwitterListMemberData.builder().userId(userId).build();
        JsonNode jsonNode = this.getRequestHelperV1().postRequestWithBodyJson(url, null, JsonHelper.toJson(body), JsonNode.class).orElseThrow(NoSuchElementException::new);
        return jsonNode.get(DATA).get(IS_MEMBER).asBoolean();
    }

    @Override
    public boolean removeListMember(String listId, String userId) {
        String url = this.getUrlHelper().getRemoveListMemberUrl(listId, userId);
        JsonNode jsonNode = this.getRequestHelperV1().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, JsonNode.class).orElseThrow(NoSuchElementException::new);
        return jsonNode.get(DATA).get(IS_MEMBER).asBoolean();
    }

    @Override
    public boolean pinList(String listId) {
        String url = this.getUrlHelper().getPinListUrl(this.getUserIdFromAccessToken());
        String body = "{\"list_id\": \"" + listId + "\"}";
        JsonNode jsonNode = this.getRequestHelperV1().postRequestWithBodyJson(url, null, body, JsonNode.class).orElseThrow(NoSuchElementException::new);
        return jsonNode.get(DATA).get(PINNED).asBoolean();
    }

    @Override
    public boolean unpinList(String listId) {
        String url = this.getUrlHelper().getUnpinListUrl(this.getUserIdFromAccessToken(), listId);
        JsonNode jsonNode = this.getRequestHelperV1().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, JsonNode.class).orElseThrow(NoSuchElementException::new);
        return jsonNode.get(DATA).get(PINNED).asBoolean();
    }

    @Override
    public boolean updateList(String listId, String listName, String description, boolean isPrivate) {
        String url = this.getUrlHelper().getListUrlV2() + "/" + listId;
        TwitterList.TwitterListData body = TwitterList.TwitterListData.builder().name(listName).description(description).isPrivate(isPrivate).build();
        JsonNode jsonNode = this.getRequestHelperV1().makeRequest(Verb.PUT, url, new HashMap<String, String>(), JsonHelper.toJson(body), true, JsonNode.class).orElseThrow(NoSuchElementException::new);
        return jsonNode.get("updated").asBoolean();
    }

    @Override
    public boolean followList(String listId) {
        String url = this.getUrlHelper().getFollowListUrl(this.getUserIdFromAccessToken());
        String body = "{\"list_id\": \"" + listId + "\"}";
        JsonNode jsonNode = this.getRequestHelperV1().postRequestWithBodyJson(url, null, body, JsonNode.class).orElseThrow(NoSuchElementException::new);
        return jsonNode.get(DATA).get(FOLLOWING).asBoolean();
    }

    @Override
    public boolean unfollowList(String listId) {
        String url = this.getUrlHelper().getUnfollowListUrl(this.getUserIdFromAccessToken(), listId);
        JsonNode jsonNode = this.getRequestHelperV1().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, JsonNode.class).orElseThrow(NoSuchElementException::new);
        return jsonNode.get(DATA).get(FOLLOWING).asBoolean();
    }

    @Override
    public TwitterList getList(String listId) {
        String url = this.getUrlHelper().getListUrlV2() + "/" + listId;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, "owner_id");
        parameters.put(LIST_FIELDS, ALL_LIST_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelperV1().getRequestWithParameters(url, parameters, TwitterList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UserList getListMembers(String listId) {
        String url = this.getUrlHelper().getAddListMemberUrl(listId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, PINNED_TWEET_ID);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        return this.getUsersRecursively(Integer.MAX_VALUE, url, parameters);
    }

    @Override
    public TwitterListList getUserOwnedLists(String userId) {
        String url = this.getUrlHelper().getOwnedListUrl(userId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, "owner_id");
        parameters.put(LIST_FIELDS, ALL_LIST_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        return this.getRequestHelperV1().getRequestWithParameters(url, parameters, TwitterListList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public TweetList getListTweets(String listId, AdditionalParameters additionalParameters) {
        String url = this.getUrlHelper().getListTweetsUrl(listId);
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelperV2().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters, this.getRequestHelper());
    }

    @Override
    public Tweet postTweet(String text) {
        return this.postTweet(TweetParameters.builder().text(text).build());
    }

    @Override
    public Tweet postTweet(TweetParameters tweetParameters) {
        String url = this.getUrlHelper().getPostTweetUrl();
        String body = JsonHelper.toJson(tweetParameters);
        return this.getRequestHelperV1().postRequestWithBodyJson(url, new HashMap<String, String>(), body, TweetV2.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public boolean deleteTweet(String tweetId) {
        String url = this.getUrlHelper().getPostTweetUrl() + "/" + tweetId;
        JsonNode jsonNode = this.getRequestHelperV1().makeRequest(Verb.DELETE, url, new HashMap<String, String>(), null, true, JsonNode.class).orElseThrow(NoSuchElementException::new);
        return jsonNode.get(DATA).get(DELETED).asBoolean();
    }

    @Override
    public io.github.redouane59.twitter.dto.dm.DirectMessage getDirectMessageEvents() {
        return this.getDirectMessageEvents(AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public io.github.redouane59.twitter.dto.dm.DirectMessage getDirectMessageEvents(AdditionalParameters additionalParameters) {
        String url = this.getUrlHelper().getDmEventsUrl();
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(DM_FIELDS, ALL_DM_FIELDS);
        parameters.put(EXPANSION, ALL_DM_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        return this.getRequestHelperV1().getRequestWithParameters(url, parameters, io.github.redouane59.twitter.dto.dm.DirectMessage.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public io.github.redouane59.twitter.dto.dm.DirectMessage getDirectMessagesByConversation(String conversationId) {
        return this.getDirectMessagesByConversation(conversationId, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public io.github.redouane59.twitter.dto.dm.DirectMessage getDirectMessagesByConversation(String conversationId, AdditionalParameters additionalParameters) {
        String url = this.getUrlHelper().getDmLookupUrl(conversationId);
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(DM_FIELDS, ALL_DM_FIELDS);
        parameters.put(EXPANSION, ALL_DM_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        return this.getRequestHelperV1().getRequestWithParameters(url, parameters, io.github.redouane59.twitter.dto.dm.DirectMessage.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public io.github.redouane59.twitter.dto.dm.DirectMessage getDirectMessagesByUser(String participantId) {
        return this.getDirectMessagesByUser(participantId, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public io.github.redouane59.twitter.dto.dm.DirectMessage getDirectMessagesByUser(String participantId, AdditionalParameters additionalParameters) {
        String url = this.getUrlHelper().getDmUserLookupUrl(participantId);
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(DM_FIELDS, ALL_DM_FIELDS);
        parameters.put(EXPANSION, ALL_DM_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        return this.getRequestHelperV1().getRequestWithParameters(url, parameters, io.github.redouane59.twitter.dto.dm.DirectMessage.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public PostDmResponse createDirectMessage(String conversationId, String text) {
        return this.createDirectMessage(conversationId, DmParameters.DmMessage.builder().text(text).build());
    }

    @Override
    public PostDmResponse createDirectMessage(String conversationId, DmParameters.DmMessage message) {
        String body;
        String url = this.getUrlHelper().getPostConversationDmUrl(conversationId);
        try {
            body = JsonHelper.toJson(message);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException();
        }
        return this.getRequestHelperV1().postRequestWithBodyJson(url, null, body, PostDmResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public PostDmResponse createGroupDmConversation(List<String> participantIds, String text) {
        return this.createGroupDmConversation(DmParameters.builder().participantIds(participantIds).message(DmParameters.DmMessage.builder().text(text).build()).build());
    }

    @Override
    public PostDmResponse createGroupDmConversation(DmParameters parameters) {
        String body;
        String url = this.getUrlHelper().getCreateDmConversationUrl();
        try {
            body = JsonHelper.toJson(parameters);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException();
        }
        return this.getRequestHelperV1().postRequestWithBodyJson(url, null, body, PostDmResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public PostDmResponse createUserDmConversation(String participantId, String text) {
        return this.createUserDmConversation(participantId, DmParameters.DmMessage.builder().text(text).build());
    }

    @Override
    public PostDmResponse createUserDmConversation(String participantId, DmParameters.DmMessage message) {
        String body;
        String url = this.getUrlHelper().getPostUserDmUrl(participantId);
        try {
            body = JsonHelper.toJson(message);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException();
        }
        return this.getRequestHelperV1().postRequestWithBodyJson(url, null, body, PostDmResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public Tweet getTweet(String tweetId) {
        String url = this.getUrlHelper().getTweetUrl(tweetId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        return this.getRequestHelper().getRequestWithParameters(url, parameters, TweetV2.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public TweetList getTweets(List<String> tweetIds) {
        String url = this.getUrlHelper().getTweetsUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < tweetIds.size() && i < 100; ++i) {
            String id = tweetIds.get(i);
            result.append(id);
            result.append(",");
        }
        result.delete(result.length() - 1, result.length());
        parameters.put("ids", result.toString());
        return this.getRequestHelper().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public boolean hideReply(String tweetId, boolean hide) {
        String url = this.getUrlHelper().getHideReplyUrl(tweetId);
        try {
            String body = JsonHelper.toJson(new HiddenResponse.HiddenData(hide));
            HiddenResponse response = this.requestHelperV1.putRequest(url, body, HiddenResponse.class).orElseThrow(NoSuchElementException::new);
            return response.getData().isHidden();
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException();
        }
    }

    @Override
    public TweetList searchTweets(String query) {
        return this.searchTweets(query, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public TweetList searchTweets(String query, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(QUERY, query);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        String url = this.urlHelper.getSearchRecentTweetsUrl();
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelper().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters, this.getRequestHelper());
    }

    @Override
    public TweetList searchAllTweets(String query) {
        return this.searchAllTweets(query, AdditionalParameters.builder().maxResults(500).build());
    }

    @Override
    public TweetList searchAllTweets(String query, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(QUERY, query);
        if (additionalParameters.getMaxResults() <= 100) {
            parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        } else {
            LOGGER.warn("Removing context_annotations from tweet_fields because max_result is greater 100");
            parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS.replace(",context_annotations", ""));
        }
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        String url = this.urlHelper.getSearchAllTweetsUrl();
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelperV2().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters, this.getRequestHelperV2());
    }

    private TweetList getTweetsRecursively(String url, Map<String, String> parameters, AbstractRequestHelper requestHelper) {
        String next;
        TweetList result = TweetList.builder().data(new ArrayList<TweetV2.TweetData>()).meta(new TweetList.TweetMeta()).build();
        String newestId = null;
        do {
            Optional<TweetList> tweetList;
            if (!(tweetList = requestHelper.getRequestWithParameters(url, parameters, TweetList.class)).isPresent() || tweetList.get().getData() == null) {
                result.getMeta().setNextToken(null);
                break;
            }
            result.getData().addAll(tweetList.get().getData());
            if (newestId == null) {
                newestId = tweetList.get().getMeta().getNewestId();
            }
            TweetList.TweetMeta meta = TweetList.TweetMeta.builder().resultCount(result.getData().size()).oldestId(tweetList.get().getMeta().getOldestId()).newestId(newestId).nextToken(tweetList.get().getMeta().getNextToken()).build();
            result.setMeta(meta);
            result.setIncludes(tweetList.get().getIncludes());
            next = tweetList.get().getMeta().getNextToken();
            if (url.contains("/search")) {
                parameters.put("next_token", next);
                continue;
            }
            parameters.put(PAGINATION_TOKEN, next);
        } while (next != null);
        return result;
    }

    private UserList getUsersRecursively(String url, Map<String, String> parameters, AbstractRequestHelper requestHelper) {
        String next;
        UserList result = UserList.builder().data(new ArrayList<UserV2.UserData>()).meta(new UserList.UserMeta()).build();
        do {
            Optional<UserList> userList;
            if (!(userList = requestHelper.getRequestWithParameters(url, parameters, UserList.class)).isPresent() || userList.get().getData() == null) {
                result.getMeta().setNextToken(null);
                break;
            }
            result.getData().addAll(userList.get().getData());
            UserList.UserMeta meta = UserList.UserMeta.builder().resultCount(result.getData().size()).nextToken(userList.get().getMeta().getNextToken()).build();
            result.setMeta(meta);
            next = userList.get().getMeta().getNextToken();
            parameters.put(PAGINATION_TOKEN, next);
        } while (next != null);
        return result;
    }

    @Override
    @Deprecated
    public List<Tweet> searchForTweetsWithin30days(String query, LocalDateTime fromDate, LocalDateTime toDate, String envName) {
        Optional<TweetSearchResponseV1> tweetSearchV1DTO;
        int count = 100;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(QUERY, query);
        parameters.put("maxResults", String.valueOf(count));
        parameters.put("fromDate", ConverterHelper.getStringFromDate(fromDate));
        parameters.put("toDate", ConverterHelper.getStringFromDate(toDate));
        ArrayList<Tweet> result = new ArrayList<Tweet>();
        while ((tweetSearchV1DTO = this.getRequestHelper().getRequestWithParameters(this.urlHelper.getSearchTweet30DaysUrl(envName), parameters, TweetSearchResponseV1.class)).isPresent() && tweetSearchV1DTO.get().getResults() != null) {
            result.addAll(tweetSearchV1DTO.get().getResults());
            String next = tweetSearchV1DTO.get().getNext();
            parameters.put(NEXT, next);
            if (next != null) continue;
        }
        return result;
    }

    @Override
    @Deprecated
    public List<Tweet> searchForTweetsArchive(String query, LocalDateTime fromDate, LocalDateTime toDate, String envName) {
        String next;
        int count = 100;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(QUERY, query);
        parameters.put("max_results", String.valueOf(count));
        parameters.put("fromDate", ConverterHelper.getStringFromDate(fromDate));
        parameters.put("toDate", ConverterHelper.getStringFromDate(toDate));
        ArrayList<Tweet> result = new ArrayList<Tweet>();
        do {
            Optional<TweetSearchResponseV1> tweetSearchV1DTO;
            if (!(tweetSearchV1DTO = this.getRequestHelper().getRequestWithParameters(this.urlHelper.getSearchTweetFullArchiveUrl(envName), parameters, TweetSearchResponseV1.class)).isPresent()) {
                LOGGER.error("Empty response on searchForTweetsArchive");
                break;
            }
            result.addAll(tweetSearchV1DTO.get().getResults());
            next = tweetSearchV1DTO.get().getNext();
            parameters.put(NEXT, next);
        } while (next != null);
        return result;
    }

    @Override
    public Future<Response> startFilteredStream(Consumer<Tweet> consumer) {
        String url = this.urlHelper.getFilteredStreamUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        return this.requestHelperV2.getAsyncRequest(url, parameters, consumer);
    }

    @Override
    public Future<Response> startFilteredStream(IAPIEventListener listener) {
        return this.startFilteredStream(listener, 0);
    }

    @Override
    public Future<Response> startFilteredStream(IAPIEventListener listener, int backfillMinutes) {
        String url = this.urlHelper.getFilteredStreamUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        if (backfillMinutes > 0) {
            parameters.put(BACKFILL_MINUTES, String.valueOf(backfillMinutes));
        }
        return this.requestHelperV2.getAsyncRequest(url, parameters, listener);
    }

    @Override
    public boolean stopFilteredStream(Future<Response> responseFuture, long timeout, TimeUnit unit) {
        try {
            Response response = timeout > 0L && unit != null ? responseFuture.get(timeout, unit) : responseFuture.get();
            if (response == null) {
                return false;
            }
            response.getStream().close();
            return true;
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.error("Couldn't stopFilteredstream ", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean stopFilteredStream(Future<Response> responseFuture) {
        return this.stopFilteredStream(responseFuture, 0L, null);
    }

    @Override
    public List<StreamRules.StreamRule> retrieveFilteredStreamRules() {
        String url = this.urlHelper.getFilteredStreamRulesUrl();
        StreamRules result = this.requestHelperV2.getRequest(url, StreamRules.class).orElseThrow(NoSuchElementException::new);
        return result.getData();
    }

    @Override
    public StreamRules.StreamRule addFilteredStreamRule(String value, String tag) {
        String url = this.urlHelper.getFilteredStreamRulesUrl();
        StreamRules.StreamRule rule = StreamRules.StreamRule.builder().value(value).tag(tag).build();
        try {
            String body = "{\"add\": [" + JsonHelper.toJson(rule) + "]}";
            StreamRules result = this.requestHelperV2.postRequest(url, body, StreamRules.class).orElseThrow(NoSuchElementException::new);
            if (result.getData() == null || result.getData().isEmpty()) {
                LOGGER.error("Could not add filtered stream rule. Rule maybe already exists.");
                throw new IllegalArgumentException();
            }
            return result.getData().get(0);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException();
        }
    }

    @Override
    public StreamRules.StreamRule addFilteredStreamRule(FilteredStreamRulePredicate value, String tag) {
        return this.addFilteredStreamRule(value.toString(), tag);
    }

    @Override
    public StreamRules.StreamMeta deleteFilteredStreamRule(FilteredStreamRulePredicate ruleValue) {
        return this.deleteFilteredStreamRule(ruleValue.toString());
    }

    @Override
    public StreamRules.StreamMeta deleteFilteredStreamRule(String ruleValue) {
        String url = this.urlHelper.getFilteredStreamRulesUrl();
        String body = "{\"delete\": {\"values\": [\"" + ruleValue + "\"]}}";
        StreamRules result = this.requestHelperV2.postRequest(url, body, StreamRules.class).orElseThrow(NoSuchElementException::new);
        return result.getMeta();
    }

    @Override
    public StreamRules.StreamMeta deleteFilteredStreamRuleId(String ruleId) {
        String url = this.urlHelper.getFilteredStreamRulesUrl();
        String body = "{\"delete\": {\"ids\": [\"" + ruleId + "\"]}}";
        StreamRules result = this.requestHelperV2.postRequest(url, body, StreamRules.class).orElseThrow(NoSuchElementException::new);
        return result.getMeta();
    }

    @Override
    public Future<Response> startSampledStream(Consumer<Tweet> consumer) {
        String url = this.urlHelper.getSampledStreamUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        return this.requestHelperV2.getAsyncRequest(url, parameters, consumer);
    }

    @Override
    public Future<Response> startSampledStream(IAPIEventListener listener) {
        return this.startSampledStream(listener, 0);
    }

    @Override
    public Future<Response> startSampledStream(IAPIEventListener listener, int backfillMinutes) {
        String url = this.urlHelper.getSampledStreamUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        if (backfillMinutes > 0) {
            parameters.put(BACKFILL_MINUTES, String.valueOf(backfillMinutes));
        }
        return this.requestHelperV2.getAsyncRequest(url, parameters, listener);
    }

    @Override
    public TweetList getUserTimeline(String userId) {
        return this.getUserTimeline(userId, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public TweetList getUserTimeline(String userId, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        parameters.put(USER_FIELDS, ALL_USER_FIELDS);
        parameters.put(PLACE_FIELDS, ALL_PLACE_FIELDS);
        parameters.put(POLL_FIELDS, ALL_POLL_FIELDS);
        parameters.put(MEDIA_FIELD, ALL_MEDIA_FIELDS);
        parameters.put(EXPANSION, ALL_EXPANSIONS);
        String url = this.urlHelper.getUserTimelineUrl(userId);
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelperV2().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters, this.getRequestHelperV2());
    }

    @Override
    public TweetList getUserMentions(String userId) {
        return this.getUserMentions(userId, AdditionalParameters.builder().maxResults(100).build());
    }

    @Override
    public TweetList getUserMentions(String userId, AdditionalParameters additionalParameters) {
        Map<String, String> parameters = additionalParameters.getMapFromParameters();
        parameters.put(TWEET_FIELDS, ALL_TWEET_FIELDS);
        String url = this.urlHelper.getUserMentionsUrl(userId);
        if (!additionalParameters.isRecursiveCall()) {
            return this.getRequestHelperV2().getRequestWithParameters(url, parameters, TweetList.class).orElseThrow(NoSuchElementException::new);
        }
        if (additionalParameters.getMaxResults() <= 0) {
            parameters.put("max_results", String.valueOf(100));
        }
        return this.getTweetsRecursively(url, parameters, this.getRequestHelperV2());
    }

    @Override
    public List<TweetV1> readTwitterDataFile(File file) throws IOException {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(TweetV1.class, (JsonDeserializer)new TweetV1Deserializer());
        ObjectMapper customObjectMapper = new ObjectMapper();
        customObjectMapper.registerModule((Module)module);
        customObjectMapper.findAndRegisterModules();
        List<Object> result = new ArrayList<TweetV1>();
        if (!file.exists()) {
            LOGGER.error("File not found at : {}", (Object)file.toURI());
        } else {
            result = Arrays.asList((Object[])customObjectMapper.readValue(file, TweetV1[].class));
        }
        return result;
    }

    @Override
    public String getBearerToken() {
        return this.requestHelperV2.getBearerToken();
    }

    @Override
    public BearerToken getOAuth2RefreshToken(String refreshToken, String clientId) {
        String url = "https://api.twitter.com/2/oauth2/token";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refresh_token", refreshToken);
        params.put("client_id", clientId);
        params.put("grant_type", "refresh_token");
        return this.requestHelperV2.makeRequest(Verb.POST, url, headers, params, null, false, BearerToken.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public BearerToken getOAuth2AccessToken(String clientId, String code, String codeVerifier, String redirectUri) {
        String url = "https://api.twitter.com/2/oauth2/token";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("code", code);
        params.put("redirect_uri", redirectUri);
        params.put("code_verifier", codeVerifier);
        params.put("grant_type", "authorization_code");
        return this.requestHelperV2.makeRequest(Verb.POST, url, null, params, null, false, BearerToken.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public RequestToken getOauth1Token() {
        return this.getOauth1Token(null);
    }

    @Override
    public RequestToken getOauth1Token(String oauthCallback) {
        String url = "https://api.twitter.com/oauth/request_token";
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (oauthCallback != null) {
            parameters.put("oauth_callback", oauthCallback);
        }
        String stringResponse = this.requestHelperV1.postRequest(url, parameters, String.class).orElseThrow(NoSuchElementException::new);
        RequestToken requestToken = new RequestToken(stringResponse);
        LOGGER.info("Open the following URL to grant access to your account:");
        LOGGER.info("https://twitter.com/oauth/authenticate?oauth_token={}", (Object)requestToken.getOauthToken());
        return requestToken;
    }

    @Override
    public RequestToken getOAuth1AccessToken(RequestToken requestToken, String pinCode) {
        String url = "https://api.twitter.com/oauth/access_token";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oauth_verifier", pinCode);
        parameters.put("oauth_token", requestToken.getOauthToken());
        String stringResponse = this.requestHelperV1.postRequestWithoutSign(url, parameters, String.class).orElseThrow(NoSuchElementException::new);
        return new RequestToken(stringResponse);
    }

    @Override
    public UploadMediaResponse uploadMedia(String mediaName, byte[] data, MediaCategory mediaCategory) {
        String url = this.urlHelper.getUploadMediaUrl(mediaCategory);
        return this.requestHelperV1.uploadMedia(url, mediaName, data, UploadMediaResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public UploadMediaResponse uploadMedia(File imageFile, MediaCategory mediaCategory) {
        String url = this.urlHelper.getUploadMediaUrl(mediaCategory);
        return this.requestHelperV1.uploadMedia(url, imageFile, UploadMediaResponse.class).orElseThrow(NoSuchElementException::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<UploadMediaResponse> uploadChunkedMedia(String mediaName, long size, InputStream data, MediaCategory mediaCategory) {
        try {
            UploadMediaProcessingInfo processing;
            String type = URLConnection.guessContentTypeFromName(mediaName);
            String url = this.urlHelper.getChunkedUploadMediaUrl();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("command", "INIT");
            parameters.put("total_bytes", Long.toString(size));
            parameters.put("media_type", type);
            parameters.put("medai_category", mediaCategory.label);
            UploadMediaResponse initRsp = this.requestHelperV1.postRequest(url, parameters, UploadMediaResponse.class).orElseThrow(NoSuchElementException::new);
            parameters.clear();
            parameters.put("command", "APPEND");
            parameters.put("media_id", initRsp.getMediaId());
            byte[] buf = new byte[(int)Math.min(size, 0x500000L)];
            int segmentIndex = 0;
            try {
                int count;
                while ((count = data.read(buf)) > 0) {
                    parameters.put("segment_index", Integer.toString(segmentIndex++));
                    this.requestHelperV1.uploadChunkedMedia(url, parameters, buf, 0, count, Void.class);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Error occupied on reading media", (Throwable)ex);
                Optional<UploadMediaResponse> optional = Optional.empty();
                try {
                    data.close();
                }
                catch (IOException ex2) {
                    LOGGER.error("Error occupied on closing media stream", (Throwable)ex2);
                }
                return optional;
            }
            parameters.clear();
            parameters.put("command", "FINALIZE");
            parameters.put("media_id", initRsp.getMediaId());
            UploadMediaResponse rsp = this.requestHelperV1.postRequest(url, parameters, UploadMediaResponse.class).orElseThrow(NoSuchElementException::new);
            while ((processing = rsp.getProcessingInfo()) != null && processing.getState().equals("pending")) {
                try {
                    Thread.sleep((long)processing.getCheckAfterSecs() * 1000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.error("Error occupied on waiting media processing", (Throwable)ex);
                }
                parameters.clear();
                parameters.put("command", "STATUS");
                parameters.put("media_id", initRsp.getMediaId());
                rsp = this.requestHelperV1.getRequestWithParameters(url, parameters, UploadMediaResponse.class).orElseThrow(NoSuchElementException::new);
            }
            Optional<UploadMediaResponse> optional = Optional.of(rsp);
            return optional;
        }
        finally {
            try {
                data.close();
            }
            catch (IOException ex) {
                LOGGER.error("Error occupied on closing media stream", (Throwable)ex);
            }
        }
    }

    @Override
    public Optional<UploadMediaResponse> uploadChunkedMedia(File imageFile, MediaCategory mediaCategory) {
        try {
            return this.uploadChunkedMedia(imageFile.getName(), imageFile.length(), Files.newInputStream(imageFile.toPath(), new OpenOption[0]), mediaCategory);
        }
        catch (IOException ex) {
            LOGGER.error("Error occupied on reading media", (Throwable)ex);
            return Optional.empty();
        }
    }

    @Override
    public CollectionsResponse collectionsCreate(String name, String description, String collectionUrl, TimeLineOrder timeLineOrder) {
        String url = this.getUrlHelper().getCollectionsCreateUrl();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", name);
        parameters.put("description", description);
        parameters.put("url", collectionUrl);
        if (timeLineOrder != null) {
            parameters.put("timeline_order", timeLineOrder.value());
        }
        return this.requestHelperV1.postRequest(url, parameters, CollectionsResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public CollectionsResponse collectionsCurate(String collectionId, List<String> tweetIds) {
        String url = this.getUrlHelper().getCollectionsCurateUrl();
        AtomicInteger index = new AtomicInteger(0);
        Stream<List> chunked = tweetIds.stream().collect(Collectors.groupingBy(x -> index.getAndIncrement() / 100)).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue);
        return chunked.map(chunk -> {
            String json = String.format("{\"id\": \"%s\",\"changes\": [", collectionId);
            json = json + chunk.stream().map(tweetId -> String.format("{ \"op\": \"add\", \"tweet_id\": \"%s\"}", tweetId)).collect(Collectors.joining(", "));
            json = json + "]}";
            return this.requestHelperV1.postRequestWithBodyJson(url, Collections.emptyMap(), json, CollectionsResponse.class).orElseThrow(NoSuchElementException::new);
        }).filter(CollectionsResponse::hasErrors).findFirst().orElse(new CollectionsResponse());
    }

    @Override
    public CollectionsResponse collectionsDestroy(String collectionId) {
        String url = this.getUrlHelper().getCollectionsDestroyUrl(collectionId);
        return this.requestHelperV1.postRequest(url, Collections.emptyMap(), CollectionsResponse.class).orElseThrow(NoSuchElementException::new);
    }

    @Override
    @Deprecated
    public List<DirectMessage> getDmList() {
        return this.getDmList(Integer.MAX_VALUE);
    }

    @Override
    public List<DirectMessage> getDmList(int count) {
        DmListAnswer dmListAnswer;
        ArrayList<DirectMessage> result = new ArrayList<DirectMessage>();
        int maxCount = 50;
        String url = this.getUrlHelper().getDMListUrl(maxCount);
        do {
            dmListAnswer = this.requestHelperV1.getRequest(url, DmListAnswer.class).orElseThrow(NoSuchElementException::new);
            result.addAll(dmListAnswer.getDirectMessages());
            url = this.getUrlHelper().getDMListUrl(maxCount) + "&" + CURSOR + "=" + dmListAnswer.getNextCursor();
        } while (dmListAnswer.getNextCursor() != null && result.size() < count);
        return result.subList(0, Math.min(count, result.size()));
    }

    @Override
    public DirectMessage getDm(String dmId) {
        String url = this.urlHelper.getDmUrl(dmId);
        DmEvent result = this.getRequestHelper().getRequest(url, DmEvent.class).orElseThrow(NoSuchElementException::new);
        return result.getEvent();
    }

    @Override
    public DmEvent postDm(String text, String userId) {
        String url = this.urlHelper.getPostConversationDmUrl();
        try {
            String body = JsonHelper.toJson(DmEvent.builder().event(new DirectMessage(text, userId)).build());
            return this.getRequestHelperV1().postRequestWithBodyJson(url, null, body, DmEvent.class).orElseThrow(NoSuchElementException::new);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public CollectionsResponse collectionsEntries(String collectionId, int count, String maxPosition, String minPosition) {
        String url = this.getUrlHelper().getCollectionsEntriesUrl(collectionId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (count > 0) {
            parameters.put("count", Integer.toString(count));
        }
        if (maxPosition != null) {
            parameters.put("max_position", maxPosition);
        }
        if (minPosition != null) {
            parameters.put("min_position", minPosition);
        }
        return this.getRequestHelper().getRequestWithParameters(url, parameters, CollectionsResponse.class).orElseThrow(NoSuchElementException::new);
    }

    private AbstractRequestHelper getRequestHelper() {
        if (this.requestHelperV1.getTwitterCredentials().getAccessToken() != null && this.requestHelperV1.getTwitterCredentials().getAccessTokenSecret() != null) {
            return this.requestHelperV1;
        }
        return this.requestHelperV2;
    }

    public String getUserIdFromAccessToken() {
        String accessToken = this.twitterCredentials.getAccessToken();
        if (accessToken == null || accessToken.isEmpty() || !accessToken.contains("-")) {
            LOGGER.error("Access token null, empty or incorrect");
            throw new IllegalArgumentException();
        }
        return accessToken.substring(0, accessToken.indexOf("-"));
    }

    @Generated
    public URLHelper getUrlHelper() {
        return this.urlHelper;
    }

    @Generated
    public RequestHelper getRequestHelperV1() {
        return this.requestHelperV1;
    }

    @Generated
    public RequestHelperV2 getRequestHelperV2() {
        return this.requestHelperV2;
    }

    @Generated
    public TwitterCredentials getTwitterCredentials() {
        return this.twitterCredentials;
    }

    @Generated
    public void setUrlHelper(URLHelper urlHelper) {
        this.urlHelper = urlHelper;
    }

    @Generated
    public void setRequestHelperV1(RequestHelper requestHelperV1) {
        this.requestHelperV1 = requestHelperV1;
    }

    @Generated
    public void setRequestHelperV2(RequestHelperV2 requestHelperV2) {
        this.requestHelperV2 = requestHelperV2;
    }

    @Generated
    public void setTwitterCredentials(TwitterCredentials twitterCredentials) {
        this.twitterCredentials = twitterCredentials;
    }
}

