/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.endpoints;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(builder=AdditionalParametersBuilder.class)
public class AdditionalParameters {
    public static final String SINCE_ID = "since_id";
    public static final String UNTIL_ID = "until_id";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String MAX_RESULTS = "max_results";
    public static final String NEXT_TOKEN = "next_token";
    public static final String PAGINATION_TOKEN = "pagination_token";
    public static final String GRANULARITY_COUNT = "granularity";
    public static final String EVENT_TYPES = "event_types";
    private boolean recursiveCall;
    @JsonProperty(value="start_time")
    private LocalDateTime startTime;
    @JsonProperty(value="end_time")
    private LocalDateTime endTime;
    @JsonProperty(value="since_id")
    private String sinceId;
    @JsonProperty(value="until_id")
    private String untilId;
    private String granularity;
    @JsonProperty(value="next_token")
    private String nextToken;
    @JsonProperty(value="pagination_token")
    private String paginationToken;
    @JsonProperty(value="max_results")
    private int maxResults;
    @JsonProperty(value="event_types")
    private String eventTypes;

    public Map<String, String> getMapFromParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.getGranularity() != null) {
            parameters.put(GRANULARITY_COUNT, this.getGranularity());
        }
        if (this.getStartTime() != null) {
            parameters.put(START_TIME, ConverterHelper.getStringFromDateV2(this.getStartTime()));
        }
        if (this.getEndTime() != null) {
            parameters.put(END_TIME, ConverterHelper.getStringFromDateV2(this.getEndTime()));
        }
        if (this.getSinceId() != null) {
            parameters.put(SINCE_ID, this.getSinceId());
        }
        if (this.getUntilId() != null) {
            parameters.put(UNTIL_ID, this.getUntilId());
        }
        if (this.getNextToken() != null) {
            parameters.put(NEXT_TOKEN, this.getNextToken());
        }
        if (this.getPaginationToken() != null) {
            parameters.put(PAGINATION_TOKEN, this.getPaginationToken());
        }
        if (this.getMaxResults() > 0) {
            parameters.put(MAX_RESULTS, String.valueOf(this.getMaxResults()));
        }
        if (this.getEventTypes() != null) {
            parameters.put(EVENT_TYPES, this.getEventTypes());
        }
        return parameters;
    }

    @Generated
    private static boolean $default$recursiveCall() {
        return true;
    }

    @Generated
    AdditionalParameters(boolean recursiveCall, LocalDateTime startTime, LocalDateTime endTime, String sinceId, String untilId, String granularity, String nextToken, String paginationToken, int maxResults, String eventTypes) {
        this.recursiveCall = recursiveCall;
        this.startTime = startTime;
        this.endTime = endTime;
        this.sinceId = sinceId;
        this.untilId = untilId;
        this.granularity = granularity;
        this.nextToken = nextToken;
        this.paginationToken = paginationToken;
        this.maxResults = maxResults;
        this.eventTypes = eventTypes;
    }

    @Generated
    public static AdditionalParametersBuilder builder() {
        return new AdditionalParametersBuilder();
    }

    @Generated
    public boolean isRecursiveCall() {
        return this.recursiveCall;
    }

    @Generated
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getSinceId() {
        return this.sinceId;
    }

    @Generated
    public String getUntilId() {
        return this.untilId;
    }

    @Generated
    public String getGranularity() {
        return this.granularity;
    }

    @Generated
    public String getNextToken() {
        return this.nextToken;
    }

    @Generated
    public String getPaginationToken() {
        return this.paginationToken;
    }

    @Generated
    public int getMaxResults() {
        return this.maxResults;
    }

    @Generated
    public String getEventTypes() {
        return this.eventTypes;
    }

    @Generated
    public void setRecursiveCall(boolean recursiveCall) {
        this.recursiveCall = recursiveCall;
    }

    @JsonProperty(value="start_time")
    @Generated
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @JsonProperty(value="end_time")
    @Generated
    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    @JsonProperty(value="since_id")
    @Generated
    public void setSinceId(String sinceId) {
        this.sinceId = sinceId;
    }

    @JsonProperty(value="until_id")
    @Generated
    public void setUntilId(String untilId) {
        this.untilId = untilId;
    }

    @Generated
    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    @JsonProperty(value="next_token")
    @Generated
    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    @JsonProperty(value="pagination_token")
    @Generated
    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    @JsonProperty(value="max_results")
    @Generated
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    @JsonProperty(value="event_types")
    @Generated
    public void setEventTypes(String eventTypes) {
        this.eventTypes = eventTypes;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class AdditionalParametersBuilder {
        @Generated
        private boolean recursiveCall$set;
        @Generated
        private boolean recursiveCall$value;
        @Generated
        private LocalDateTime startTime;
        @Generated
        private LocalDateTime endTime;
        @Generated
        private String sinceId;
        @Generated
        private String untilId;
        @Generated
        private String granularity;
        @Generated
        private String nextToken;
        @Generated
        private String paginationToken;
        @Generated
        private int maxResults;
        @Generated
        private String eventTypes;

        @Generated
        AdditionalParametersBuilder() {
        }

        @Generated
        public AdditionalParametersBuilder recursiveCall(boolean recursiveCall) {
            this.recursiveCall$value = recursiveCall;
            this.recursiveCall$set = true;
            return this;
        }

        @JsonProperty(value="start_time")
        @Generated
        public AdditionalParametersBuilder startTime(LocalDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        @JsonProperty(value="end_time")
        @Generated
        public AdditionalParametersBuilder endTime(LocalDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        @JsonProperty(value="since_id")
        @Generated
        public AdditionalParametersBuilder sinceId(String sinceId) {
            this.sinceId = sinceId;
            return this;
        }

        @JsonProperty(value="until_id")
        @Generated
        public AdditionalParametersBuilder untilId(String untilId) {
            this.untilId = untilId;
            return this;
        }

        @Generated
        public AdditionalParametersBuilder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @JsonProperty(value="next_token")
        @Generated
        public AdditionalParametersBuilder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @JsonProperty(value="pagination_token")
        @Generated
        public AdditionalParametersBuilder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        @JsonProperty(value="max_results")
        @Generated
        public AdditionalParametersBuilder maxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @JsonProperty(value="event_types")
        @Generated
        public AdditionalParametersBuilder eventTypes(String eventTypes) {
            this.eventTypes = eventTypes;
            return this;
        }

        @Generated
        public AdditionalParameters build() {
            boolean recursiveCall$value = this.recursiveCall$value;
            if (!this.recursiveCall$set) {
                recursiveCall$value = AdditionalParameters.$default$recursiveCall();
            }
            return new AdditionalParameters(recursiveCall$value, this.startTime, this.endTime, this.sinceId, this.untilId, this.granularity, this.nextToken, this.paginationToken, this.maxResults, this.eventTypes);
        }

        @Generated
        public String toString() {
            return "AdditionalParameters.AdditionalParametersBuilder(recursiveCall$value=" + this.recursiveCall$value + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", sinceId=" + this.sinceId + ", untilId=" + this.untilId + ", granularity=" + this.granularity + ", nextToken=" + this.nextToken + ", paginationToken=" + this.paginationToken + ", maxResults=" + this.maxResults + ", eventTypes=" + this.eventTypes + ")";
        }
    }
}

