/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.tweet;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.github.redouane59.twitter.dto.tweet.TweetList;
import io.github.redouane59.twitter.dto.tweet.TweetV2;
import io.github.redouane59.twitter.dto.user.UserV2;
import io.github.redouane59.twitter.helpers.JsonHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TweetListDeserializer
extends StdDeserializer<TweetList> {
    protected TweetListDeserializer() {
        super(TweetListDeserializer.class);
    }

    public TweetList deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        TweetList result = TweetList.builder().build();
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.has("meta")) {
            result.setMeta(JsonHelper.fromJson((TreeNode)node.get("meta"), TweetList.TweetMeta.class));
        }
        if (node.has("data")) {
            List list = (List)JsonHelper.fromJson((TreeNode)node.get("data"), (JavaType)JsonHelper.OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, TweetV2.TweetData.class));
            if (node.has("includes")) {
                TweetV2.Includes includes = JsonHelper.fromJson((TreeNode)node.get("includes"), TweetV2.Includes.class);
                result.setIncludes(includes);
                Map users = includes.getUsers().stream().collect(Collectors.toMap(UserV2.UserData::getId, Function.identity()));
                for (TweetV2.TweetData tweetData : list) {
                    Optional.ofNullable(users.get(tweetData.getAuthorId())).ifPresent(tweetData::setUser);
                }
            }
            result.setData(list);
        }
        return result;
    }
}

