/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.tweet;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.redouane59.twitter.dto.stream.StreamRules;
import io.github.redouane59.twitter.dto.tweet.Attachments;
import io.github.redouane59.twitter.dto.tweet.ContextAnnotation;
import io.github.redouane59.twitter.dto.tweet.Geo;
import io.github.redouane59.twitter.dto.tweet.ReplySettings;
import io.github.redouane59.twitter.dto.tweet.Tweet;
import io.github.redouane59.twitter.dto.tweet.TweetType;
import io.github.redouane59.twitter.dto.tweet.TweetV2;
import io.github.redouane59.twitter.dto.tweet.entities.BaseEntity;
import io.github.redouane59.twitter.dto.tweet.entities.Entities;
import io.github.redouane59.twitter.dto.tweet.entities.HashtagEntity;
import io.github.redouane59.twitter.dto.tweet.entities.MediaEntity;
import io.github.redouane59.twitter.dto.tweet.entities.SymbolEntity;
import io.github.redouane59.twitter.dto.tweet.entities.TextBaseEntity;
import io.github.redouane59.twitter.dto.tweet.entities.UrlEntity;
import io.github.redouane59.twitter.dto.tweet.entities.UserMentionEntity;
import io.github.redouane59.twitter.dto.user.UserV1;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=TweetV1Builder.class)
public class TweetV1
implements Tweet {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TweetV1.class);
    private static final String NOT_IMPLEMENTED_EXCEPTION = "not implemented";
    private String id;
    private String lang;
    @JsonProperty(value="retweet_count")
    private int retweetCount;
    @JsonProperty(value="favorite_count")
    private int likeCount;
    @JsonProperty(value="reply_count")
    private int replyCount;
    @JsonProperty(value="quote_count")
    private int quoteCount;
    @JsonAlias(value={"text", "full_text"})
    private String text;
    @JsonProperty(value="created_at")
    private String createdAt;
    private UserV1 user;
    @JsonProperty(value="in_reply_to_status_id_str")
    private String inReplyToStatusId;
    @JsonProperty(value="in_reply_to_user_id_str")
    private String inReplyToUserId;
    @JsonProperty(value="is_quote_status")
    private boolean isQuoteStatus;
    private EntitiesV1 entities;

    @Override
    public LocalDateTime getCreatedAt() {
        return ConverterHelper.getDateFromTwitterString(this.createdAt);
    }

    @Override
    public List<ContextAnnotation> getContextAnnotations() {
        LOGGER.error(NOT_IMPLEMENTED_EXCEPTION);
        return Arrays.asList(new ContextAnnotation[0]);
    }

    @Override
    public TweetType getTweetType() {
        if (this.isQuoteStatus) {
            return TweetType.QUOTED;
        }
        return TweetType.DEFAULT;
    }

    @Override
    public String getConversationId() {
        LOGGER.error(NOT_IMPLEMENTED_EXCEPTION);
        return null;
    }

    @Override
    public ReplySettings getReplySettings() {
        LOGGER.error(NOT_IMPLEMENTED_EXCEPTION);
        return null;
    }

    @Override
    public Geo getGeo() {
        LOGGER.error(NOT_IMPLEMENTED_EXCEPTION);
        return new Geo();
    }

    @Override
    public Attachments getAttachments() {
        LOGGER.error(NOT_IMPLEMENTED_EXCEPTION);
        return new Attachments();
    }

    @Override
    public String getSource() {
        LOGGER.error(NOT_IMPLEMENTED_EXCEPTION);
        return null;
    }

    public List<MediaEntityV1> getMedia() {
        if (this.entities != null) {
            return this.entities.getMedia();
        }
        return Collections.emptyList();
    }

    @Override
    public List<TweetV2.Place> getPlaces() {
        LOGGER.error(NOT_IMPLEMENTED_EXCEPTION);
        return Collections.emptyList();
    }

    @Override
    public List<StreamRules.StreamRule> getMatchingRules() {
        LOGGER.error(NOT_IMPLEMENTED_EXCEPTION);
        return Collections.emptyList();
    }

    @Override
    public String getInReplyToStatusId(TweetType type) {
        return this.getInReplyToStatusId();
    }

    @Override
    public String getAuthorId() {
        if (this.user == null) {
            return null;
        }
        return this.user.getId();
    }

    @Generated
    public static TweetV1Builder builder() {
        return new TweetV1Builder();
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getLang() {
        return this.lang;
    }

    @Override
    @Generated
    public int getRetweetCount() {
        return this.retweetCount;
    }

    @Override
    @Generated
    public int getLikeCount() {
        return this.likeCount;
    }

    @Override
    @Generated
    public int getReplyCount() {
        return this.replyCount;
    }

    @Override
    @Generated
    public int getQuoteCount() {
        return this.quoteCount;
    }

    @Override
    @Generated
    public String getText() {
        return this.text;
    }

    @Override
    @Generated
    public UserV1 getUser() {
        return this.user;
    }

    @Override
    @Generated
    public String getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    @Override
    @Generated
    public String getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    @Generated
    public boolean isQuoteStatus() {
        return this.isQuoteStatus;
    }

    @Override
    @Generated
    public EntitiesV1 getEntities() {
        return this.entities;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLang(String lang) {
        this.lang = lang;
    }

    @JsonProperty(value="retweet_count")
    @Generated
    public void setRetweetCount(int retweetCount) {
        this.retweetCount = retweetCount;
    }

    @JsonProperty(value="favorite_count")
    @Generated
    public void setLikeCount(int likeCount) {
        this.likeCount = likeCount;
    }

    @JsonProperty(value="reply_count")
    @Generated
    public void setReplyCount(int replyCount) {
        this.replyCount = replyCount;
    }

    @JsonProperty(value="quote_count")
    @Generated
    public void setQuoteCount(int quoteCount) {
        this.quoteCount = quoteCount;
    }

    @JsonAlias(value={"text", "full_text"})
    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="created_at")
    @Generated
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUser(UserV1 user) {
        this.user = user;
    }

    @JsonProperty(value="in_reply_to_status_id_str")
    @Generated
    public void setInReplyToStatusId(String inReplyToStatusId) {
        this.inReplyToStatusId = inReplyToStatusId;
    }

    @JsonProperty(value="in_reply_to_user_id_str")
    @Generated
    public void setInReplyToUserId(String inReplyToUserId) {
        this.inReplyToUserId = inReplyToUserId;
    }

    @JsonProperty(value="is_quote_status")
    @Generated
    public void setQuoteStatus(boolean isQuoteStatus) {
        this.isQuoteStatus = isQuoteStatus;
    }

    @Generated
    public void setEntities(EntitiesV1 entities) {
        this.entities = entities;
    }

    @Generated
    public TweetV1(String id, String lang, int retweetCount, int likeCount, int replyCount, int quoteCount, String text, String createdAt, UserV1 user, String inReplyToStatusId, String inReplyToUserId, boolean isQuoteStatus, EntitiesV1 entities) {
        this.id = id;
        this.lang = lang;
        this.retweetCount = retweetCount;
        this.likeCount = likeCount;
        this.replyCount = replyCount;
        this.quoteCount = quoteCount;
        this.text = text;
        this.createdAt = createdAt;
        this.user = user;
        this.inReplyToStatusId = inReplyToStatusId;
        this.inReplyToUserId = inReplyToUserId;
        this.isQuoteStatus = isQuoteStatus;
        this.entities = entities;
    }

    @Generated
    public TweetV1() {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class TweetV1Builder {
        @Generated
        private String id;
        @Generated
        private String lang;
        @Generated
        private int retweetCount;
        @Generated
        private int likeCount;
        @Generated
        private int replyCount;
        @Generated
        private int quoteCount;
        @Generated
        private String text;
        @Generated
        private String createdAt;
        @Generated
        private UserV1 user;
        @Generated
        private String inReplyToStatusId;
        @Generated
        private String inReplyToUserId;
        @Generated
        private boolean isQuoteStatus;
        @Generated
        private EntitiesV1 entities;

        @Generated
        TweetV1Builder() {
        }

        @Generated
        public TweetV1Builder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public TweetV1Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        @JsonProperty(value="retweet_count")
        @Generated
        public TweetV1Builder retweetCount(int retweetCount) {
            this.retweetCount = retweetCount;
            return this;
        }

        @JsonProperty(value="favorite_count")
        @Generated
        public TweetV1Builder likeCount(int likeCount) {
            this.likeCount = likeCount;
            return this;
        }

        @JsonProperty(value="reply_count")
        @Generated
        public TweetV1Builder replyCount(int replyCount) {
            this.replyCount = replyCount;
            return this;
        }

        @JsonProperty(value="quote_count")
        @Generated
        public TweetV1Builder quoteCount(int quoteCount) {
            this.quoteCount = quoteCount;
            return this;
        }

        @JsonAlias(value={"text", "full_text"})
        @Generated
        public TweetV1Builder text(String text) {
            this.text = text;
            return this;
        }

        @JsonProperty(value="created_at")
        @Generated
        public TweetV1Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public TweetV1Builder user(UserV1 user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="in_reply_to_status_id_str")
        @Generated
        public TweetV1Builder inReplyToStatusId(String inReplyToStatusId) {
            this.inReplyToStatusId = inReplyToStatusId;
            return this;
        }

        @JsonProperty(value="in_reply_to_user_id_str")
        @Generated
        public TweetV1Builder inReplyToUserId(String inReplyToUserId) {
            this.inReplyToUserId = inReplyToUserId;
            return this;
        }

        @JsonProperty(value="is_quote_status")
        @Generated
        public TweetV1Builder isQuoteStatus(boolean isQuoteStatus) {
            this.isQuoteStatus = isQuoteStatus;
            return this;
        }

        @Generated
        public TweetV1Builder entities(EntitiesV1 entities) {
            this.entities = entities;
            return this;
        }

        @Generated
        public TweetV1 build() {
            return new TweetV1(this.id, this.lang, this.retweetCount, this.likeCount, this.replyCount, this.quoteCount, this.text, this.createdAt, this.user, this.inReplyToStatusId, this.inReplyToUserId, this.isQuoteStatus, this.entities);
        }

        @Generated
        public String toString() {
            return "TweetV1.TweetV1Builder(id=" + this.id + ", lang=" + this.lang + ", retweetCount=" + this.retweetCount + ", likeCount=" + this.likeCount + ", replyCount=" + this.replyCount + ", quoteCount=" + this.quoteCount + ", text=" + this.text + ", createdAt=" + this.createdAt + ", user=" + this.user + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isQuoteStatus=" + this.isQuoteStatus + ", entities=" + this.entities + ")";
        }
    }

    public static class MediaSize {
        @JsonProperty(value="w")
        private int width;
        @JsonProperty(value="h")
        private int height;
        private String resize;

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public String getResize() {
            return this.resize;
        }

        @JsonProperty(value="w")
        @Generated
        public void setWidth(int width) {
            this.width = width;
        }

        @JsonProperty(value="h")
        @Generated
        public void setHeight(int height) {
            this.height = height;
        }

        @Generated
        public void setResize(String resize) {
            this.resize = resize;
        }
    }

    public static class MediaEntityV1
    extends BaseEntityV1
    implements MediaEntity {
        private long id;
        private String url;
        @JsonProperty(value="display_url")
        private String displayUrl;
        @JsonProperty(value="expanded_url")
        private String expandedUrl;
        @JsonProperty(value="media_url_https")
        private String mediaUrl;
        private String type;
        private Map<String, MediaSize> sizes;

        @Override
        @Generated
        public long getId() {
            return this.id;
        }

        @Override
        @Generated
        public String getUrl() {
            return this.url;
        }

        @Override
        @Generated
        public String getDisplayUrl() {
            return this.displayUrl;
        }

        @Override
        @Generated
        public String getExpandedUrl() {
            return this.expandedUrl;
        }

        @Override
        @Generated
        public String getMediaUrl() {
            return this.mediaUrl;
        }

        @Override
        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Map<String, MediaSize> getSizes() {
            return this.sizes;
        }

        @Generated
        public void setId(long id) {
            this.id = id;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty(value="display_url")
        @Generated
        public void setDisplayUrl(String displayUrl) {
            this.displayUrl = displayUrl;
        }

        @JsonProperty(value="expanded_url")
        @Generated
        public void setExpandedUrl(String expandedUrl) {
            this.expandedUrl = expandedUrl;
        }

        @JsonProperty(value="media_url_https")
        @Generated
        public void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setSizes(Map<String, MediaSize> sizes) {
            this.sizes = sizes;
        }
    }

    public static class SymbolEntityV1
    extends TextBaseEntityV1
    implements SymbolEntity {
    }

    public static class UserMentionEntityV1
    extends TextBaseEntityV1
    implements UserMentionEntity {
        private String name;
        @JsonProperty(value="screen_name")
        private String screenName;
        private long id;

        @Override
        public String getText() {
            return this.getName();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getScreenName() {
            return this.screenName;
        }

        @Generated
        public long getId() {
            return this.id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="screen_name")
        @Generated
        public void setScreenName(String screenName) {
            this.screenName = screenName;
        }

        @Generated
        public void setId(long id) {
            this.id = id;
        }
    }

    public static class HashtagEntityV1
    extends TextBaseEntityV1
    implements HashtagEntity {
    }

    public static class UnwoundUrlEntity {
        private String url;
        private int status;
        private String title;
        private String description;

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public int getStatus() {
            return this.status;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setStatus(int status) {
            this.status = status;
        }

        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class UrlEntityV1
    extends BaseEntityV1
    implements UrlEntity {
        private String url;
        @JsonProperty(value="display_url")
        private String displayUrl;
        @JsonProperty(value="expanded_url")
        private String expandedUrl;
        private UnwoundUrlEntity unwound;

        @Override
        public int getStatus() {
            if (this.unwound != null) {
                return this.unwound.getStatus();
            }
            return -1;
        }

        @Override
        public String getDescription() {
            if (this.unwound != null) {
                return this.unwound.getDescription();
            }
            return null;
        }

        @Override
        public String getTitle() {
            if (this.unwound != null) {
                return this.unwound.getTitle();
            }
            return null;
        }

        @Override
        public String getUnwoundedUrl() {
            if (this.unwound != null) {
                return this.unwound.getUrl();
            }
            return null;
        }

        @Override
        @Generated
        public String getUrl() {
            return this.url;
        }

        @Override
        @Generated
        public String getDisplayUrl() {
            return this.displayUrl;
        }

        @Override
        @Generated
        public String getExpandedUrl() {
            return this.expandedUrl;
        }

        @Generated
        public UnwoundUrlEntity getUnwound() {
            return this.unwound;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty(value="display_url")
        @Generated
        public void setDisplayUrl(String displayUrl) {
            this.displayUrl = displayUrl;
        }

        @JsonProperty(value="expanded_url")
        @Generated
        public void setExpandedUrl(String expandedUrl) {
            this.expandedUrl = expandedUrl;
        }

        @Generated
        public void setUnwound(UnwoundUrlEntity unwound) {
            this.unwound = unwound;
        }
    }

    public static class TextBaseEntityV1
    extends BaseEntityV1
    implements TextBaseEntity {
        private String text;

        @Override
        public String getText() {
            return this.text;
        }

        @Generated
        public void setText(String text) {
            this.text = text;
        }
    }

    public static class BaseEntityV1
    implements BaseEntity {
        private int[] indices;

        @Override
        public int getStart() {
            return this.indices[0];
        }

        @Override
        public int getEnd() {
            return this.indices[1];
        }

        @Generated
        public int[] getIndices() {
            return this.indices;
        }

        @Generated
        public void setIndices(int[] indices) {
            this.indices = indices;
        }
    }

    public static class EntitiesV1
    implements Entities {
        private List<HashtagEntityV1> hashtags;
        private List<UrlEntityV1> urls;
        @JsonProperty(value="user_mentions")
        private List<UserMentionEntityV1> userMentions;
        private List<SymbolEntityV1> symbols;
        private List<MediaEntityV1> media;

        @Generated
        public List<HashtagEntityV1> getHashtags() {
            return this.hashtags;
        }

        @Generated
        public List<UrlEntityV1> getUrls() {
            return this.urls;
        }

        @Generated
        public List<UserMentionEntityV1> getUserMentions() {
            return this.userMentions;
        }

        @Generated
        public List<SymbolEntityV1> getSymbols() {
            return this.symbols;
        }

        @Generated
        public List<MediaEntityV1> getMedia() {
            return this.media;
        }

        @Generated
        public void setHashtags(List<HashtagEntityV1> hashtags) {
            this.hashtags = hashtags;
        }

        @Generated
        public void setUrls(List<UrlEntityV1> urls) {
            this.urls = urls;
        }

        @JsonProperty(value="user_mentions")
        @Generated
        public void setUserMentions(List<UserMentionEntityV1> userMentions) {
            this.userMentions = userMentions;
        }

        @Generated
        public void setSymbols(List<SymbolEntityV1> symbols) {
            this.symbols = symbols;
        }

        @Generated
        public void setMedia(List<MediaEntityV1> media) {
            this.media = media;
        }
    }
}

