/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.tweet;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.redouane59.twitter.dto.stream.StreamRules;
import io.github.redouane59.twitter.dto.tweet.Attachments;
import io.github.redouane59.twitter.dto.tweet.ContextAnnotation;
import io.github.redouane59.twitter.dto.tweet.Geo;
import io.github.redouane59.twitter.dto.tweet.ReplySettings;
import io.github.redouane59.twitter.dto.tweet.Tweet;
import io.github.redouane59.twitter.dto.tweet.TweetType;
import io.github.redouane59.twitter.dto.tweet.entities.BaseEntity;
import io.github.redouane59.twitter.dto.tweet.entities.Entities;
import io.github.redouane59.twitter.dto.tweet.entities.HashtagEntity;
import io.github.redouane59.twitter.dto.tweet.entities.MediaEntity;
import io.github.redouane59.twitter.dto.tweet.entities.SymbolEntity;
import io.github.redouane59.twitter.dto.tweet.entities.TextBaseEntity;
import io.github.redouane59.twitter.dto.tweet.entities.UrlEntity;
import io.github.redouane59.twitter.dto.tweet.entities.UserMentionEntity;
import io.github.redouane59.twitter.dto.user.User;
import io.github.redouane59.twitter.dto.user.UserV2;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=TweetV2Builder.class)
public class TweetV2
implements Tweet {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TweetV2.class);
    private static final String NOT_IMPLEMENTED_EXCEPTION = "not implemented";
    private TweetData data;
    private Includes includes;
    @JsonProperty(value="matching_rules")
    private List<StreamRules.StreamRule> matchingRules;

    @Override
    public String getInReplyToStatusId() {
        if (this.data == null || this.data.getReferencedTweets() == null || this.data.getReferencedTweets().isEmpty()) {
            return null;
        }
        return this.data.getReferencedTweets().get(0).getId();
    }

    @Override
    public String getInReplyToStatusId(TweetType type) {
        if (this.data == null || this.data.getReferencedTweets() == null || this.data.getReferencedTweets().isEmpty()) {
            return null;
        }
        for (ReferencedTweetDTO referencedTweetDTO : this.data.getReferencedTweets()) {
            if (referencedTweetDTO.getType() != type) continue;
            return referencedTweetDTO.getId();
        }
        return null;
    }

    @Override
    public String getLang() {
        if (this.data == null) {
            return null;
        }
        return this.data.getLang();
    }

    @Override
    public String getId() {
        if (this.data == null) {
            return null;
        }
        return this.data.getId();
    }

    @Override
    public String getText() {
        if (this.data == null) {
            return null;
        }
        return this.data.getText();
    }

    @Override
    public String getConversationId() {
        if (this.data == null) {
            return null;
        }
        return this.data.getConversationId();
    }

    @Override
    public ReplySettings getReplySettings() {
        if (this.data == null) {
            return null;
        }
        return this.data.getReplySettings();
    }

    @Override
    public Geo getGeo() {
        if (this.data == null) {
            return null;
        }
        return this.data.getGeo();
    }

    @Override
    public Attachments getAttachments() {
        if (this.data == null) {
            return null;
        }
        return this.data.getAttachments();
    }

    @Override
    public String getSource() {
        if (this.data == null) {
            return null;
        }
        return this.data.getSource();
    }

    @Override
    public Entities getEntities() {
        if (this.data == null) {
            return null;
        }
        return this.data.getEntities();
    }

    public List<MediaEntityV2> getMedia() {
        if (this.includes == null) {
            return Collections.emptyList();
        }
        return this.includes.getMedia();
    }

    @Override
    public List<Place> getPlaces() {
        if (this.includes == null) {
            return Collections.emptyList();
        }
        return this.includes.getPlaces();
    }

    @Override
    public int getRetweetCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getPublicMetrics().getRetweetCount();
    }

    @Override
    public int getLikeCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getPublicMetrics().getLikeCount();
    }

    @Override
    public int getReplyCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getPublicMetrics().getReplyCount();
    }

    @Override
    public int getQuoteCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getPublicMetrics().getQuoteCount();
    }

    @Override
    public String getInReplyToUserId() {
        if (this.data == null) {
            return null;
        }
        return this.data.getInReplyToUserId();
    }

    @Override
    public User getUser() {
        if (this.includes == null) {
            return null;
        }
        return this.includes.getUsers().get(0);
    }

    @Override
    public String getAuthorId() {
        if (this.data == null) {
            return null;
        }
        return this.data.getAuthorId();
    }

    @Override
    public LocalDateTime getCreatedAt() {
        if (this.data == null) {
            return null;
        }
        return this.data.getCreatedAt();
    }

    @Override
    public List<ContextAnnotation> getContextAnnotations() {
        if (this.data == null) {
            return Collections.emptyList();
        }
        return this.data.getContextAnnotations();
    }

    @Override
    public TweetType getTweetType() {
        if (this.data == null || this.data.referencedTweets == null || this.data.referencedTweets.isEmpty()) {
            return TweetType.DEFAULT;
        }
        if (this.data.getReferencedTweets().size() > 1 && (this.data.getReferencedTweets().get(0).getType().equals((Object)TweetType.RETWEETED) || this.data.getReferencedTweets().get(1).getType().equals((Object)TweetType.RETWEETED))) {
            return TweetType.RETWEETED;
        }
        return this.data.getReferencedTweets().get(0).getType();
    }

    @Generated
    public static TweetV2Builder builder() {
        return new TweetV2Builder();
    }

    @Generated
    public TweetData getData() {
        return this.data;
    }

    @Generated
    public Includes getIncludes() {
        return this.includes;
    }

    @Override
    @Generated
    public List<StreamRules.StreamRule> getMatchingRules() {
        return this.matchingRules;
    }

    @Generated
    public void setData(TweetData data) {
        this.data = data;
    }

    @Generated
    public void setIncludes(Includes includes) {
        this.includes = includes;
    }

    @JsonProperty(value="matching_rules")
    @Generated
    public void setMatchingRules(List<StreamRules.StreamRule> matchingRules) {
        this.matchingRules = matchingRules;
    }

    @Generated
    public TweetV2(TweetData data, Includes includes, List<StreamRules.StreamRule> matchingRules) {
        this.data = data;
        this.includes = includes;
        this.matchingRules = matchingRules;
    }

    @Generated
    public TweetV2() {
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class TweetV2Builder {
        @Generated
        private TweetData data;
        @Generated
        private Includes includes;
        @Generated
        private List<StreamRules.StreamRule> matchingRules;

        @Generated
        TweetV2Builder() {
        }

        @Generated
        public TweetV2Builder data(TweetData data) {
            this.data = data;
            return this;
        }

        @Generated
        public TweetV2Builder includes(Includes includes) {
            this.includes = includes;
            return this;
        }

        @JsonProperty(value="matching_rules")
        @Generated
        public TweetV2Builder matchingRules(List<StreamRules.StreamRule> matchingRules) {
            this.matchingRules = matchingRules;
            return this;
        }

        @Generated
        public TweetV2 build() {
            return new TweetV2(this.data, this.includes, this.matchingRules);
        }

        @Generated
        public String toString() {
            return "TweetV2.TweetV2Builder(data=" + this.data + ", includes=" + this.includes + ", matchingRules=" + this.matchingRules + ")";
        }
    }

    public static class Variant {
        @JsonProperty(value="bit_rate")
        private int bitRate;
        @JsonProperty(value="content_type")
        private String contentType;
        @JsonProperty(value="url")
        private String url;

        @Generated
        public int getBitRate() {
            return this.bitRate;
        }

        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @JsonProperty(value="bit_rate")
        @Generated
        public void setBitRate(int bitRate) {
            this.bitRate = bitRate;
        }

        @JsonProperty(value="content_type")
        @Generated
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @JsonProperty(value="url")
        @Generated
        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class MediaPublicMetricsDTO {
        @JsonProperty(value="view_count")
        private int viewCount;

        @Generated
        public int getViewCount() {
            return this.viewCount;
        }

        @JsonProperty(value="view_count")
        @Generated
        public void setViewCount(int viewCount) {
            this.viewCount = viewCount;
        }
    }

    public static class Place {
        private Geo geo;
        @JsonProperty(value="country_code")
        private String countryCode;
        private String name;
        private String id;
        @JsonProperty(value="place_type")
        private String placeType;
        private String country;
        @JsonProperty(value="full_name")
        private String fullName;

        @Generated
        public Geo getGeo() {
            return this.geo;
        }

        @Generated
        public String getCountryCode() {
            return this.countryCode;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getPlaceType() {
            return this.placeType;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getFullName() {
            return this.fullName;
        }

        @Generated
        public void setGeo(Geo geo) {
            this.geo = geo;
        }

        @JsonProperty(value="country_code")
        @Generated
        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="place_type")
        @Generated
        public void setPlaceType(String placeType) {
            this.placeType = placeType;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @JsonProperty(value="full_name")
        @Generated
        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public static class Geo {
            private String type;
            private List<Double> bbox;
            private JsonNode properties;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public List<Double> getBbox() {
                return this.bbox;
            }

            @Generated
            public JsonNode getProperties() {
                return this.properties;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setBbox(List<Double> bbox) {
                this.bbox = bbox;
            }

            @Generated
            public void setProperties(JsonNode properties) {
                this.properties = properties;
            }
        }
    }

    public static class MediaEntityV2
    implements MediaEntity {
        @JsonProperty(value="media_key")
        private String key;
        private String type;
        @JsonProperty(value="duration_ms")
        private int duration;
        private int height;
        private int width;
        private String url;
        @JsonProperty(value="preview_image_url")
        private String previewImageUrl;
        @JsonProperty(value="public_metrics")
        private MediaPublicMetricsDTO publicMetrics;
        @JsonProperty(value="variants")
        private List<Variant> variants;
        @JsonProperty(value="alt_text")
        private String altText;

        @Override
        public int getStart() {
            LOGGER.info(TweetV2.NOT_IMPLEMENTED_EXCEPTION);
            return -1;
        }

        @Override
        public int getEnd() {
            LOGGER.info(TweetV2.NOT_IMPLEMENTED_EXCEPTION);
            return -1;
        }

        @Override
        public String getDisplayUrl() {
            return this.getUrl();
        }

        @Override
        public String getExpandedUrl() {
            return this.getUrl();
        }

        @Override
        public String getMediaUrl() {
            return this.getUrl();
        }

        @Override
        public long getId() {
            LOGGER.info(TweetV2.NOT_IMPLEMENTED_EXCEPTION);
            return -1L;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Override
        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public int getDuration() {
            return this.duration;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Override
        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getPreviewImageUrl() {
            return this.previewImageUrl;
        }

        @Generated
        public MediaPublicMetricsDTO getPublicMetrics() {
            return this.publicMetrics;
        }

        @Generated
        public List<Variant> getVariants() {
            return this.variants;
        }

        @Generated
        public String getAltText() {
            return this.altText;
        }

        @JsonProperty(value="media_key")
        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="duration_ms")
        @Generated
        public void setDuration(int duration) {
            this.duration = duration;
        }

        @Generated
        public void setHeight(int height) {
            this.height = height;
        }

        @Generated
        public void setWidth(int width) {
            this.width = width;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty(value="preview_image_url")
        @Generated
        public void setPreviewImageUrl(String previewImageUrl) {
            this.previewImageUrl = previewImageUrl;
        }

        @JsonProperty(value="public_metrics")
        @Generated
        public void setPublicMetrics(MediaPublicMetricsDTO publicMetrics) {
            this.publicMetrics = publicMetrics;
        }

        @JsonProperty(value="variants")
        @Generated
        public void setVariants(List<Variant> variants) {
            this.variants = variants;
        }

        @JsonProperty(value="alt_text")
        @Generated
        public void setAltText(String altText) {
            this.altText = altText;
        }
    }

    public static class CashtagEntityV2
    extends TextBaseEntityV2
    implements SymbolEntity {
    }

    public static class UserMentionEntityV2
    extends TextBaseEntityV2
    implements UserMentionEntity {
        private String username;

        @Override
        public String getText() {
            return this.getUsername();
        }

        @Override
        public String getTag() {
            return this.getUsername();
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }
    }

    public static class HashtagEntityV2
    extends TextBaseEntityV2
    implements HashtagEntity {
    }

    public static class UrlEntityV2
    extends BaseEntityV2
    implements UrlEntity {
        private String url;
        @JsonProperty(value="display_url")
        private String displayUrl;
        @JsonProperty(value="expanded_url")
        private String expandedUrl;
        private int status;
        private String description;
        private String title;
        @JsonProperty(value="unwound_url")
        private String unwoundedUrl;
        @JsonProperty(value="media_key")
        private String mediaKey;

        @Override
        @Generated
        public String getUrl() {
            return this.url;
        }

        @Override
        @Generated
        public String getDisplayUrl() {
            return this.displayUrl;
        }

        @Override
        @Generated
        public String getExpandedUrl() {
            return this.expandedUrl;
        }

        @Override
        @Generated
        public int getStatus() {
            return this.status;
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Override
        @Generated
        public String getTitle() {
            return this.title;
        }

        @Override
        @Generated
        public String getUnwoundedUrl() {
            return this.unwoundedUrl;
        }

        @Generated
        public String getMediaKey() {
            return this.mediaKey;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty(value="display_url")
        @Generated
        public void setDisplayUrl(String displayUrl) {
            this.displayUrl = displayUrl;
        }

        @JsonProperty(value="expanded_url")
        @Generated
        public void setExpandedUrl(String expandedUrl) {
            this.expandedUrl = expandedUrl;
        }

        @Generated
        public void setStatus(int status) {
            this.status = status;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="unwound_url")
        @Generated
        public void setUnwoundedUrl(String unwoundedUrl) {
            this.unwoundedUrl = unwoundedUrl;
        }

        @JsonProperty(value="media_key")
        @Generated
        public void setMediaKey(String mediaKey) {
            this.mediaKey = mediaKey;
        }
    }

    public static class TextBaseEntityV2
    extends BaseEntityV2
    implements TextBaseEntity {
        private String tag;

        @Override
        public String getText() {
            return this.tag;
        }

        @Generated
        public String getTag() {
            return this.tag;
        }

        @Generated
        public void setTag(String tag) {
            this.tag = tag;
        }
    }

    public static class BaseEntityV2
    implements BaseEntity {
        private int start;
        private int end;

        @Override
        @Generated
        public int getStart() {
            return this.start;
        }

        @Override
        @Generated
        public int getEnd() {
            return this.end;
        }

        @Generated
        public void setStart(int start) {
            this.start = start;
        }

        @Generated
        public void setEnd(int end) {
            this.end = end;
        }
    }

    public static class EntitiesV2
    implements Entities {
        private List<HashtagEntityV2> hashtags;
        private List<UrlEntityV2> urls;
        @JsonProperty(value="mentions")
        private List<UserMentionEntityV2> userMentions;
        @JsonProperty(value="cashtags")
        private List<CashtagEntityV2> symbols;

        @Generated
        public List<HashtagEntityV2> getHashtags() {
            return this.hashtags;
        }

        @Generated
        public List<UrlEntityV2> getUrls() {
            return this.urls;
        }

        @Generated
        public List<UserMentionEntityV2> getUserMentions() {
            return this.userMentions;
        }

        @Generated
        public List<CashtagEntityV2> getSymbols() {
            return this.symbols;
        }

        @Generated
        public void setHashtags(List<HashtagEntityV2> hashtags) {
            this.hashtags = hashtags;
        }

        @Generated
        public void setUrls(List<UrlEntityV2> urls) {
            this.urls = urls;
        }

        @JsonProperty(value="mentions")
        @Generated
        public void setUserMentions(List<UserMentionEntityV2> userMentions) {
            this.userMentions = userMentions;
        }

        @JsonProperty(value="cashtags")
        @Generated
        public void setSymbols(List<CashtagEntityV2> symbols) {
            this.symbols = symbols;
        }
    }

    public static class TweetPublicMetricsDTO {
        @JsonProperty(value="retweet_count")
        private int retweetCount;
        @JsonProperty(value="reply_count")
        private int replyCount;
        @JsonProperty(value="like_count")
        private int likeCount;
        @JsonProperty(value="quote_count")
        private int quoteCount;

        @Generated
        public int getRetweetCount() {
            return this.retweetCount;
        }

        @Generated
        public int getReplyCount() {
            return this.replyCount;
        }

        @Generated
        public int getLikeCount() {
            return this.likeCount;
        }

        @Generated
        public int getQuoteCount() {
            return this.quoteCount;
        }

        @JsonProperty(value="retweet_count")
        @Generated
        public void setRetweetCount(int retweetCount) {
            this.retweetCount = retweetCount;
        }

        @JsonProperty(value="reply_count")
        @Generated
        public void setReplyCount(int replyCount) {
            this.replyCount = replyCount;
        }

        @JsonProperty(value="like_count")
        @Generated
        public void setLikeCount(int likeCount) {
            this.likeCount = likeCount;
        }

        @JsonProperty(value="quote_count")
        @Generated
        public void setQuoteCount(int quoteCount) {
            this.quoteCount = quoteCount;
        }
    }

    @JsonDeserialize(builder=IncludesBuilder.class)
    public static class Includes {
        private List<UserV2.UserData> users;
        private List<TweetData> tweets;
        private List<MediaEntityV2> media;
        private List<Place> places;

        @Generated
        public static IncludesBuilder builder() {
            return new IncludesBuilder();
        }

        @Generated
        public List<UserV2.UserData> getUsers() {
            return this.users;
        }

        @Generated
        public List<TweetData> getTweets() {
            return this.tweets;
        }

        @Generated
        public List<MediaEntityV2> getMedia() {
            return this.media;
        }

        @Generated
        public List<Place> getPlaces() {
            return this.places;
        }

        @Generated
        public void setUsers(List<UserV2.UserData> users) {
            this.users = users;
        }

        @Generated
        public void setTweets(List<TweetData> tweets) {
            this.tweets = tweets;
        }

        @Generated
        public void setMedia(List<MediaEntityV2> media) {
            this.media = media;
        }

        @Generated
        public void setPlaces(List<Place> places) {
            this.places = places;
        }

        @Generated
        public Includes() {
        }

        @Generated
        public Includes(List<UserV2.UserData> users, List<TweetData> tweets, List<MediaEntityV2> media, List<Place> places) {
            this.users = users;
            this.tweets = tweets;
            this.media = media;
            this.places = places;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class IncludesBuilder {
            @Generated
            private List<UserV2.UserData> users;
            @Generated
            private List<TweetData> tweets;
            @Generated
            private List<MediaEntityV2> media;
            @Generated
            private List<Place> places;

            @Generated
            IncludesBuilder() {
            }

            @Generated
            public IncludesBuilder users(List<UserV2.UserData> users) {
                this.users = users;
                return this;
            }

            @Generated
            public IncludesBuilder tweets(List<TweetData> tweets) {
                this.tweets = tweets;
                return this;
            }

            @Generated
            public IncludesBuilder media(List<MediaEntityV2> media) {
                this.media = media;
                return this;
            }

            @Generated
            public IncludesBuilder places(List<Place> places) {
                this.places = places;
                return this;
            }

            @Generated
            public Includes build() {
                return new Includes(this.users, this.tweets, this.media, this.places);
            }

            @Generated
            public String toString() {
                return "TweetV2.Includes.IncludesBuilder(users=" + this.users + ", tweets=" + this.tweets + ", media=" + this.media + ", places=" + this.places + ")";
            }
        }
    }

    public static class ReferencedTweetDTO {
        private TweetType type;
        private String id;

        @Generated
        public TweetType getType() {
            return this.type;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setType(TweetType type) {
            this.type = type;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }
    }

    @JsonDeserialize(builder=TweetDataBuilder.class)
    public static class TweetData
    implements Tweet {
        private String id;
        @JsonProperty(value="created_at")
        private String createdAt;
        @JsonAlias(value={"text", "full_text"})
        private String text;
        @JsonProperty(value="author_id")
        private String authorId;
        @JsonProperty(value="in_reply_to_user_id")
        private String inReplyToUserId;
        @JsonProperty(value="referenced_tweets")
        private List<ReferencedTweetDTO> referencedTweets;
        private EntitiesV2 entities;
        @JsonProperty(value="public_metrics")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private TweetPublicMetricsDTO publicMetrics;
        @JsonProperty(value="possibly_sensitive")
        private boolean possiblySensitive;
        private String lang;
        @JsonProperty(value="context_annotations")
        private List<ContextAnnotation> contextAnnotations;
        @JsonProperty(value="conversation_id")
        private String conversationId;
        @JsonProperty(value="reply_settings")
        private ReplySettings replySettings;
        private Geo geo;
        private Attachments attachments;
        private String source;
        @JsonIgnore
        private UserV2.UserData user;

        @Override
        @JsonIgnore
        public int getRetweetCount() {
            return this.publicMetrics.getRetweetCount();
        }

        @Override
        @JsonIgnore
        public int getLikeCount() {
            return this.publicMetrics.getLikeCount();
        }

        @Override
        @JsonIgnore
        public int getReplyCount() {
            return this.publicMetrics.getReplyCount();
        }

        @Override
        @JsonIgnore
        public int getQuoteCount() {
            return this.publicMetrics.getQuoteCount();
        }

        @Override
        public String getInReplyToStatusId() {
            if (this.referencedTweets == null || this.referencedTweets.isEmpty()) {
                return null;
            }
            return this.referencedTweets.get(0).getId();
        }

        @Override
        public String getInReplyToStatusId(TweetType type) {
            if (this.referencedTweets == null || this.referencedTweets.isEmpty()) {
                return null;
            }
            for (ReferencedTweetDTO referencedTweetDTO : this.referencedTweets) {
                if (referencedTweetDTO.getType() != type) continue;
                return referencedTweetDTO.getId();
            }
            return null;
        }

        @Override
        public TweetType getTweetType() {
            if (this.referencedTweets == null || this.referencedTweets.isEmpty()) {
                return TweetType.DEFAULT;
            }
            if (this.getReferencedTweets().size() > 1 && (this.getReferencedTweets().get(0).getType().equals((Object)TweetType.RETWEETED) || this.getReferencedTweets().get(1).getType().equals((Object)TweetType.RETWEETED))) {
                return TweetType.RETWEETED;
            }
            return this.getReferencedTweets().get(0).getType();
        }

        public List<MediaEntityV2> getMedia() {
            LOGGER.info(TweetV2.NOT_IMPLEMENTED_EXCEPTION);
            return Collections.emptyList();
        }

        @Override
        public List<Place> getPlaces() {
            LOGGER.info(TweetV2.NOT_IMPLEMENTED_EXCEPTION);
            return Collections.emptyList();
        }

        @Override
        public List<StreamRules.StreamRule> getMatchingRules() {
            LOGGER.info(TweetV2.NOT_IMPLEMENTED_EXCEPTION);
            return Collections.emptyList();
        }

        @Override
        public String getAuthorId() {
            return this.authorId;
        }

        @Override
        public LocalDateTime getCreatedAt() {
            return ConverterHelper.getDateFromTwitterStringV2(this.createdAt);
        }

        @Generated
        public static TweetDataBuilder builder() {
            return new TweetDataBuilder();
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public String getText() {
            return this.text;
        }

        @Override
        @Generated
        public String getInReplyToUserId() {
            return this.inReplyToUserId;
        }

        @Generated
        public List<ReferencedTweetDTO> getReferencedTweets() {
            return this.referencedTweets;
        }

        @Override
        @Generated
        public EntitiesV2 getEntities() {
            return this.entities;
        }

        @Generated
        public TweetPublicMetricsDTO getPublicMetrics() {
            return this.publicMetrics;
        }

        @Generated
        public boolean isPossiblySensitive() {
            return this.possiblySensitive;
        }

        @Override
        @Generated
        public String getLang() {
            return this.lang;
        }

        @Override
        @Generated
        public List<ContextAnnotation> getContextAnnotations() {
            return this.contextAnnotations;
        }

        @Override
        @Generated
        public String getConversationId() {
            return this.conversationId;
        }

        @Override
        @Generated
        public ReplySettings getReplySettings() {
            return this.replySettings;
        }

        @Override
        @Generated
        public Geo getGeo() {
            return this.geo;
        }

        @Override
        @Generated
        public Attachments getAttachments() {
            return this.attachments;
        }

        @Override
        @Generated
        public String getSource() {
            return this.source;
        }

        @Override
        @Generated
        public UserV2.UserData getUser() {
            return this.user;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="created_at")
        @Generated
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonAlias(value={"text", "full_text"})
        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="author_id")
        @Generated
        public void setAuthorId(String authorId) {
            this.authorId = authorId;
        }

        @JsonProperty(value="in_reply_to_user_id")
        @Generated
        public void setInReplyToUserId(String inReplyToUserId) {
            this.inReplyToUserId = inReplyToUserId;
        }

        @JsonProperty(value="referenced_tweets")
        @Generated
        public void setReferencedTweets(List<ReferencedTweetDTO> referencedTweets) {
            this.referencedTweets = referencedTweets;
        }

        @Generated
        public void setEntities(EntitiesV2 entities) {
            this.entities = entities;
        }

        @JsonProperty(value="public_metrics")
        @Generated
        public void setPublicMetrics(TweetPublicMetricsDTO publicMetrics) {
            this.publicMetrics = publicMetrics;
        }

        @JsonProperty(value="possibly_sensitive")
        @Generated
        public void setPossiblySensitive(boolean possiblySensitive) {
            this.possiblySensitive = possiblySensitive;
        }

        @Generated
        public void setLang(String lang) {
            this.lang = lang;
        }

        @JsonProperty(value="context_annotations")
        @Generated
        public void setContextAnnotations(List<ContextAnnotation> contextAnnotations) {
            this.contextAnnotations = contextAnnotations;
        }

        @JsonProperty(value="conversation_id")
        @Generated
        public void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @JsonProperty(value="reply_settings")
        @Generated
        public void setReplySettings(ReplySettings replySettings) {
            this.replySettings = replySettings;
        }

        @Generated
        public void setGeo(Geo geo) {
            this.geo = geo;
        }

        @Generated
        public void setAttachments(Attachments attachments) {
            this.attachments = attachments;
        }

        @Generated
        public void setSource(String source) {
            this.source = source;
        }

        @JsonIgnore
        @Generated
        public void setUser(UserV2.UserData user) {
            this.user = user;
        }

        @Generated
        public TweetData() {
        }

        @Generated
        public TweetData(String id, String createdAt, String text, String authorId, String inReplyToUserId, List<ReferencedTweetDTO> referencedTweets, EntitiesV2 entities, TweetPublicMetricsDTO publicMetrics, boolean possiblySensitive, String lang, List<ContextAnnotation> contextAnnotations, String conversationId, ReplySettings replySettings, Geo geo, Attachments attachments, String source, UserV2.UserData user) {
            this.id = id;
            this.createdAt = createdAt;
            this.text = text;
            this.authorId = authorId;
            this.inReplyToUserId = inReplyToUserId;
            this.referencedTweets = referencedTweets;
            this.entities = entities;
            this.publicMetrics = publicMetrics;
            this.possiblySensitive = possiblySensitive;
            this.lang = lang;
            this.contextAnnotations = contextAnnotations;
            this.conversationId = conversationId;
            this.replySettings = replySettings;
            this.geo = geo;
            this.attachments = attachments;
            this.source = source;
            this.user = user;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class TweetDataBuilder {
            @Generated
            private String id;
            @Generated
            private String createdAt;
            @Generated
            private String text;
            @Generated
            private String authorId;
            @Generated
            private String inReplyToUserId;
            @Generated
            private List<ReferencedTweetDTO> referencedTweets;
            @Generated
            private EntitiesV2 entities;
            @Generated
            private TweetPublicMetricsDTO publicMetrics;
            @Generated
            private boolean possiblySensitive;
            @Generated
            private String lang;
            @Generated
            private List<ContextAnnotation> contextAnnotations;
            @Generated
            private String conversationId;
            @Generated
            private ReplySettings replySettings;
            @Generated
            private Geo geo;
            @Generated
            private Attachments attachments;
            @Generated
            private String source;
            @Generated
            private UserV2.UserData user;

            @Generated
            TweetDataBuilder() {
            }

            @Generated
            public TweetDataBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="created_at")
            @Generated
            public TweetDataBuilder createdAt(String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @JsonAlias(value={"text", "full_text"})
            @Generated
            public TweetDataBuilder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="author_id")
            @Generated
            public TweetDataBuilder authorId(String authorId) {
                this.authorId = authorId;
                return this;
            }

            @JsonProperty(value="in_reply_to_user_id")
            @Generated
            public TweetDataBuilder inReplyToUserId(String inReplyToUserId) {
                this.inReplyToUserId = inReplyToUserId;
                return this;
            }

            @JsonProperty(value="referenced_tweets")
            @Generated
            public TweetDataBuilder referencedTweets(List<ReferencedTweetDTO> referencedTweets) {
                this.referencedTweets = referencedTweets;
                return this;
            }

            @Generated
            public TweetDataBuilder entities(EntitiesV2 entities) {
                this.entities = entities;
                return this;
            }

            @JsonProperty(value="public_metrics")
            @Generated
            public TweetDataBuilder publicMetrics(TweetPublicMetricsDTO publicMetrics) {
                this.publicMetrics = publicMetrics;
                return this;
            }

            @JsonProperty(value="possibly_sensitive")
            @Generated
            public TweetDataBuilder possiblySensitive(boolean possiblySensitive) {
                this.possiblySensitive = possiblySensitive;
                return this;
            }

            @Generated
            public TweetDataBuilder lang(String lang) {
                this.lang = lang;
                return this;
            }

            @JsonProperty(value="context_annotations")
            @Generated
            public TweetDataBuilder contextAnnotations(List<ContextAnnotation> contextAnnotations) {
                this.contextAnnotations = contextAnnotations;
                return this;
            }

            @JsonProperty(value="conversation_id")
            @Generated
            public TweetDataBuilder conversationId(String conversationId) {
                this.conversationId = conversationId;
                return this;
            }

            @JsonProperty(value="reply_settings")
            @Generated
            public TweetDataBuilder replySettings(ReplySettings replySettings) {
                this.replySettings = replySettings;
                return this;
            }

            @Generated
            public TweetDataBuilder geo(Geo geo) {
                this.geo = geo;
                return this;
            }

            @Generated
            public TweetDataBuilder attachments(Attachments attachments) {
                this.attachments = attachments;
                return this;
            }

            @Generated
            public TweetDataBuilder source(String source) {
                this.source = source;
                return this;
            }

            @JsonIgnore
            @Generated
            public TweetDataBuilder user(UserV2.UserData user) {
                this.user = user;
                return this;
            }

            @Generated
            public TweetData build() {
                return new TweetData(this.id, this.createdAt, this.text, this.authorId, this.inReplyToUserId, this.referencedTweets, this.entities, this.publicMetrics, this.possiblySensitive, this.lang, this.contextAnnotations, this.conversationId, this.replySettings, this.geo, this.attachments, this.source, this.user);
            }

            @Generated
            public String toString() {
                return "TweetV2.TweetData.TweetDataBuilder(id=" + this.id + ", createdAt=" + this.createdAt + ", text=" + this.text + ", authorId=" + this.authorId + ", inReplyToUserId=" + this.inReplyToUserId + ", referencedTweets=" + this.referencedTweets + ", entities=" + this.entities + ", publicMetrics=" + this.publicMetrics + ", possiblySensitive=" + this.possiblySensitive + ", lang=" + this.lang + ", contextAnnotations=" + this.contextAnnotations + ", conversationId=" + this.conversationId + ", replySettings=" + (Object)((Object)this.replySettings) + ", geo=" + this.geo + ", attachments=" + this.attachments + ", source=" + this.source + ", user=" + this.user + ")";
            }
        }
    }
}

