/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.dto.user;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.redouane59.twitter.dto.tweet.Tweet;
import io.github.redouane59.twitter.dto.user.User;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=UserV1Builder.class)
public class UserV1
implements User {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UserV1.class);
    private String id;
    @JsonProperty(value="screen_name")
    @JsonAlias(value={"screen_name"})
    private String name;
    @JsonAlias(value={"name"})
    private String displayedName;
    private List<Tweet> mostRecentTweet;
    private String description;
    @JsonAlias(value={"protected"})
    private boolean protectedAccount;
    @JsonProperty(value="followers_count")
    private int followersCount;
    @JsonProperty(value="friends_count")
    @JsonAlias(value={"friends_count", "followings_count"})
    private int followingCount;
    private String lang;
    private String url;
    private JsonNode entities;
    @JsonProperty(value="tweetCount")
    @JsonAlias(value={"statuses_count", "tweets_count"})
    private int tweetCount;
    @JsonAlias(value={"created_at"})
    private String dateOfCreation;
    private String lastUpdate;
    private String location;
    @JsonProperty(value="profile_image_url")
    private String profileImageUrl;
    private boolean following;

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass() && !User.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        User otherUser = (User)o;
        return otherUser.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public LocalDateTime getDateOfCreation() {
        return ConverterHelper.getDateFromTwitterString(this.dateOfCreation);
    }

    @Override
    public Tweet getPinnedTweet() {
        LOGGER.debug("UnsupportedOperation");
        return null;
    }

    @Override
    public boolean isVerified() {
        LOGGER.debug("UnsupportedOperation");
        return false;
    }

    public LocalDateTime getLastUpdate() {
        return ConverterHelper.getDateFromTwitterString(this.lastUpdate);
    }

    @Generated
    public static UserV1Builder builder() {
        return new UserV1Builder();
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getDisplayedName() {
        return this.displayedName;
    }

    @Generated
    public List<Tweet> getMostRecentTweet() {
        return this.mostRecentTweet;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public boolean isProtectedAccount() {
        return this.protectedAccount;
    }

    @Override
    @Generated
    public int getFollowersCount() {
        return this.followersCount;
    }

    @Override
    @Generated
    public int getFollowingCount() {
        return this.followingCount;
    }

    @Override
    @Generated
    public String getLang() {
        return this.lang;
    }

    @Override
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Override
    @Generated
    public JsonNode getEntities() {
        return this.entities;
    }

    @Override
    @Generated
    public int getTweetCount() {
        return this.tweetCount;
    }

    @Override
    @Generated
    public String getLocation() {
        return this.location;
    }

    @Override
    @Generated
    public String getProfileImageUrl() {
        return this.profileImageUrl;
    }

    @Override
    @Generated
    public boolean isFollowing() {
        return this.following;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="screen_name")
    @JsonAlias(value={"screen_name"})
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonAlias(value={"name"})
    @Generated
    public void setDisplayedName(String displayedName) {
        this.displayedName = displayedName;
    }

    @Generated
    public void setMostRecentTweet(List<Tweet> mostRecentTweet) {
        this.mostRecentTweet = mostRecentTweet;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonAlias(value={"protected"})
    @Generated
    public void setProtectedAccount(boolean protectedAccount) {
        this.protectedAccount = protectedAccount;
    }

    @JsonProperty(value="followers_count")
    @Generated
    public void setFollowersCount(int followersCount) {
        this.followersCount = followersCount;
    }

    @JsonProperty(value="friends_count")
    @JsonAlias(value={"friends_count", "followings_count"})
    @Generated
    public void setFollowingCount(int followingCount) {
        this.followingCount = followingCount;
    }

    @Generated
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setEntities(JsonNode entities) {
        this.entities = entities;
    }

    @JsonProperty(value="tweetCount")
    @JsonAlias(value={"statuses_count", "tweets_count"})
    @Generated
    public void setTweetCount(int tweetCount) {
        this.tweetCount = tweetCount;
    }

    @JsonAlias(value={"created_at"})
    @Generated
    public void setDateOfCreation(String dateOfCreation) {
        this.dateOfCreation = dateOfCreation;
    }

    @Generated
    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @JsonProperty(value="profile_image_url")
    @Generated
    public void setProfileImageUrl(String profileImageUrl) {
        this.profileImageUrl = profileImageUrl;
    }

    @Generated
    public void setFollowing(boolean following) {
        this.following = following;
    }

    @Generated
    public UserV1(String id, String name, String displayedName, List<Tweet> mostRecentTweet, String description, boolean protectedAccount, int followersCount, int followingCount, String lang, String url, JsonNode entities, int tweetCount, String dateOfCreation, String lastUpdate, String location, String profileImageUrl, boolean following) {
        this.id = id;
        this.name = name;
        this.displayedName = displayedName;
        this.mostRecentTweet = mostRecentTweet;
        this.description = description;
        this.protectedAccount = protectedAccount;
        this.followersCount = followersCount;
        this.followingCount = followingCount;
        this.lang = lang;
        this.url = url;
        this.entities = entities;
        this.tweetCount = tweetCount;
        this.dateOfCreation = dateOfCreation;
        this.lastUpdate = lastUpdate;
        this.location = location;
        this.profileImageUrl = profileImageUrl;
        this.following = following;
    }

    @Generated
    public UserV1() {
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class UserV1Builder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String displayedName;
        @Generated
        private List<Tweet> mostRecentTweet;
        @Generated
        private String description;
        @Generated
        private boolean protectedAccount;
        @Generated
        private int followersCount;
        @Generated
        private int followingCount;
        @Generated
        private String lang;
        @Generated
        private String url;
        @Generated
        private JsonNode entities;
        @Generated
        private int tweetCount;
        @Generated
        private String dateOfCreation;
        @Generated
        private String lastUpdate;
        @Generated
        private String location;
        @Generated
        private String profileImageUrl;
        @Generated
        private boolean following;

        @Generated
        UserV1Builder() {
        }

        @Generated
        public UserV1Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="screen_name")
        @JsonAlias(value={"screen_name"})
        @Generated
        public UserV1Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonAlias(value={"name"})
        @Generated
        public UserV1Builder displayedName(String displayedName) {
            this.displayedName = displayedName;
            return this;
        }

        @Generated
        public UserV1Builder mostRecentTweet(List<Tweet> mostRecentTweet) {
            this.mostRecentTweet = mostRecentTweet;
            return this;
        }

        @Generated
        public UserV1Builder description(String description) {
            this.description = description;
            return this;
        }

        @JsonAlias(value={"protected"})
        @Generated
        public UserV1Builder protectedAccount(boolean protectedAccount) {
            this.protectedAccount = protectedAccount;
            return this;
        }

        @JsonProperty(value="followers_count")
        @Generated
        public UserV1Builder followersCount(int followersCount) {
            this.followersCount = followersCount;
            return this;
        }

        @JsonProperty(value="friends_count")
        @JsonAlias(value={"friends_count", "followings_count"})
        @Generated
        public UserV1Builder followingCount(int followingCount) {
            this.followingCount = followingCount;
            return this;
        }

        @Generated
        public UserV1Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        @Generated
        public UserV1Builder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public UserV1Builder entities(JsonNode entities) {
            this.entities = entities;
            return this;
        }

        @JsonProperty(value="tweetCount")
        @JsonAlias(value={"statuses_count", "tweets_count"})
        @Generated
        public UserV1Builder tweetCount(int tweetCount) {
            this.tweetCount = tweetCount;
            return this;
        }

        @JsonAlias(value={"created_at"})
        @Generated
        public UserV1Builder dateOfCreation(String dateOfCreation) {
            this.dateOfCreation = dateOfCreation;
            return this;
        }

        @Generated
        public UserV1Builder lastUpdate(String lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        @Generated
        public UserV1Builder location(String location) {
            this.location = location;
            return this;
        }

        @JsonProperty(value="profile_image_url")
        @Generated
        public UserV1Builder profileImageUrl(String profileImageUrl) {
            this.profileImageUrl = profileImageUrl;
            return this;
        }

        @Generated
        public UserV1Builder following(boolean following) {
            this.following = following;
            return this;
        }

        @Generated
        public UserV1 build() {
            return new UserV1(this.id, this.name, this.displayedName, this.mostRecentTweet, this.description, this.protectedAccount, this.followersCount, this.followingCount, this.lang, this.url, this.entities, this.tweetCount, this.dateOfCreation, this.lastUpdate, this.location, this.profileImageUrl, this.following);
        }

        @Generated
        public String toString() {
            return "UserV1.UserV1Builder(id=" + this.id + ", name=" + this.name + ", displayedName=" + this.displayedName + ", mostRecentTweet=" + this.mostRecentTweet + ", description=" + this.description + ", protectedAccount=" + this.protectedAccount + ", followersCount=" + this.followersCount + ", followingCount=" + this.followingCount + ", lang=" + this.lang + ", url=" + this.url + ", entities=" + this.entities + ", tweetCount=" + this.tweetCount + ", dateOfCreation=" + this.dateOfCreation + ", lastUpdate=" + this.lastUpdate + ", location=" + this.location + ", profileImageUrl=" + this.profileImageUrl + ", following=" + this.following + ")";
        }
    }
}

