/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import io.github.redouane59.twitter.helpers.ConverterHelper;
import io.github.redouane59.twitter.helpers.JsonHelper;
import io.github.redouane59.twitter.helpers.TweetStreamConsumer;
import io.github.redouane59.twitter.signature.TwitterCredentials;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.naming.LimitExceededException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestHelper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRequestHelper.class);
    public static final int DEFAULT_RETRY_AFTER_SEC = 300;
    protected final TweetStreamConsumer tweetStreamConsumer = new TweetStreamConsumer();
    private final TwitterCredentials twitterCredentials;
    private final OAuth10aService service;
    private boolean automaticRetry = true;
    private long lastCallTs;

    protected AbstractRequestHelper(TwitterCredentials twitterCredentials) {
        this(twitterCredentials, new ServiceBuilder(twitterCredentials.getApiKey()).apiSecret(twitterCredentials.getApiSecretKey()).build((DefaultApi10a)TwitterApi.instance()));
    }

    protected AbstractRequestHelper(TwitterCredentials twitterCredentials, OAuth10aService service) {
        this.twitterCredentials = twitterCredentials;
        this.service = service;
    }

    public static void logApiError(String method, String url, String stringResponse, int code) {
        LOGGER.error("({}) Error calling {} {} - {}", new Object[]{method, url, stringResponse, code});
    }

    protected abstract void signRequest(OAuthRequest var1);

    public <T> Optional<T> makeRequest(Verb verb, String url, Map<String, String> parameters, String body, boolean signRequired, Class<T> classType) {
        return this.makeRequest(verb, url, null, parameters, body, signRequired, classType);
    }

    public <T> Optional<T> makeRequest(Verb verb, String url, Map<String, String> headers, Map<String, String> parameters, String body, boolean signRequired, Class<T> classType) {
        OAuthRequest request = new OAuthRequest(verb, url);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.addHeader(header.getKey(), header.getValue());
            }
        }
        if (parameters != null) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                request.addQuerystringParameter(param.getKey(), param.getValue());
            }
        }
        if (body != null && verb.isPermitBody()) {
            request.setPayload(body.getBytes(StandardCharsets.UTF_8));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/json");
            }
        }
        return this.makeRequest(request, signRequired, classType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Optional<T> makeRequest(OAuthRequest request, boolean signRequired, Class<T> classType) {
        Object result = null;
        if (signRequired) {
            this.signRequest(request);
        }
        if (request.getUrl().contains("/2/tweets/search/all")) {
            long now = System.currentTimeMillis();
            if (now < this.lastCallTs + 1000L) {
                int sleepTime = 1000 - Math.toIntExact(now - this.lastCallTs);
                LOGGER.trace("sleep {}ms between two calls on /search/all", (Object)sleepTime);
                Thread.sleep(sleepTime);
                this.lastCallTs = now + (long)sleepTime;
            } else {
                this.lastCallTs = now;
            }
        }
        try (Response response = this.getService().execute(request);){
            String stringResponse = response.getBody();
            LOGGER.debug("Response code: {} to url: '{}' headers: x-rate-limit-reset: {} x-rate-limit-remaining: {}", new Object[]{response.getCode(), request.getUrl(), response.getHeader("x-rate-limit-reset"), response.getHeader("x-rate-limit-remaining")});
            if (response.getCode() == 429) {
                int retryAfter;
                block31: {
                    if (!this.automaticRetry) {
                        throw new LimitExceededException(response.getHeader("x-rate-limit-reset"));
                    }
                    retryAfter = 300;
                    String retryAfterStr = response.getHeader("x-rate-limit-reset");
                    String rateRemainingStr = response.getHeader("x-rate-limit-remaining");
                    LOGGER.trace("Rate limit exceeded, x-rate-limit-reset: {} x-rate-limit-remaining: {}, x-rate-limit-limit:  {}", new Object[]{retryAfterStr, response.getHeader("x-rate-limit-remaining"), response.getHeader("x-rate-limit-limit")});
                    if (retryAfterStr != null && rateRemainingStr != null) {
                        try {
                            long currentTime;
                            int remaining = Integer.parseInt(rateRemainingStr);
                            if (remaining > 0) {
                                retryAfter = 1;
                                break block31;
                            }
                            long resetTime = Long.parseLong(retryAfterStr);
                            retryAfter = Math.toIntExact(resetTime - (currentTime = new Date().getTime() / 1000L));
                            if (retryAfter < 0) {
                                retryAfter = 1;
                            }
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Using default retry after because header format is invalid: {}", (Object)retryAfterStr, (Object)e);
                        }
                    }
                }
                LOGGER.info("Rate limit exceeded, new retry in {} at {}", (Object)ConverterHelper.getSecondsAsText(retryAfter), (Object)ConverterHelper.minutesBeforeNow(-retryAfter / 60).format(DateTimeFormatter.ofPattern("HH:mm")));
                Thread.sleep(1000L * (long)retryAfter);
                Optional<T> optional = this.makeRequest(request, false, classType);
                return optional;
            }
            if (response.getCode() < 200 || response.getCode() > 299) {
                AbstractRequestHelper.logApiError(request.getVerb().name(), request.getUrl(), stringResponse, response.getCode());
            }
            if (Void.class.equals(classType)) return Optional.ofNullable(result);
            result = this.convert(stringResponse, classType);
            return Optional.ofNullable(result);
        }
        catch (IOException ex) {
            LOGGER.error("Error occupied on executing request", (Throwable)ex);
        }
        return Optional.ofNullable(result);
    }

    protected <T> T convert(String json, Class<? extends T> targetClass) throws JsonProcessingException {
        if (targetClass.isInstance(json)) {
            return (T)json;
        }
        return JsonHelper.fromJson(json, targetClass);
    }

    public abstract <T> Optional<T> getRequest(String var1, Class<T> var2);

    public abstract <T> Optional<T> getRequestWithParameters(String var1, Map<String, String> var2, Class<T> var3);

    @Generated
    public TweetStreamConsumer getTweetStreamConsumer() {
        return this.tweetStreamConsumer;
    }

    @Generated
    public TwitterCredentials getTwitterCredentials() {
        return this.twitterCredentials;
    }

    @Generated
    public OAuth10aService getService() {
        return this.service;
    }

    @Generated
    public boolean isAutomaticRetry() {
        return this.automaticRetry;
    }

    @Generated
    public long getLastCallTs() {
        return this.lastCallTs;
    }

    @Generated
    public void setAutomaticRetry(boolean automaticRetry) {
        this.automaticRetry = automaticRetry;
    }
}

