/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.helpers;

import com.github.scribejava.core.httpclient.multipart.BodyPartPayload;
import com.github.scribejava.core.httpclient.multipart.FileByteArrayBodyPartPayload;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import io.github.redouane59.twitter.helpers.AbstractRequestHelper;
import io.github.redouane59.twitter.signature.TwitterCredentials;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHelper
extends AbstractRequestHelper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHelper.class);

    public RequestHelper(TwitterCredentials twitterCredentials) {
        super(twitterCredentials);
    }

    public RequestHelper(TwitterCredentials twitterCredentials, OAuth10aService service) {
        super(twitterCredentials, service);
    }

    public <T> Optional<T> postRequestWithBodyJson(String url, Map<String, String> parameters, String requestBodyJson, Class<T> classType) {
        return this.makeRequest(Verb.POST, url, parameters, requestBodyJson, true, classType);
    }

    public <T> Optional<T> postRequest(String url, Map<String, String> parameters, Class<T> classType) {
        return this.postRequestWithBodyJson(url, parameters, null, classType);
    }

    public <T> Optional<T> postRequestWithoutSign(String url, Map<String, String> parameters, Class<T> classType) {
        return this.makeRequest(Verb.POST, url, parameters, null, false, classType);
    }

    public <T> Optional<T> uploadMedia(String url, File file, Class<T> classType) {
        try {
            return this.uploadMedia(url, file.getName(), Files.readAllBytes(file.toPath()), classType);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public <T> Optional<T> uploadMedia(String url, String fileName, byte[] data, Class<T> classType) {
        OAuthRequest request = new OAuthRequest(Verb.POST, url);
        request.initMultipartPayload();
        request.addBodyPartPayloadInMultipartPayload((BodyPartPayload)new FileByteArrayBodyPartPayload("application/octet-stream", data, "media", fileName));
        return this.makeRequest(request, true, classType);
    }

    public <T> Optional<T> uploadChunkedMedia(String url, Map<String, String> parameters, byte[] media, int off, int len, Class<T> classType) {
        OAuthRequest request = new OAuthRequest(Verb.POST, url);
        if (parameters != null) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                request.addQuerystringParameter(param.getKey(), param.getValue());
            }
        }
        request.initMultipartPayload();
        request.addBodyPartPayloadInMultipartPayload((BodyPartPayload)new FileByteArrayBodyPartPayload("application/octet-stream", media, off, len, "media"));
        return this.makeRequest(request, true, classType);
    }

    public <T> Optional<T> putRequest(String url, String body, Class<T> classType) {
        return this.makeRequest(Verb.PUT, url, null, body, true, classType);
    }

    @Override
    public <T> Optional<T> getRequest(String url, Class<T> classType) {
        return this.getRequestWithParameters(url, null, classType);
    }

    @Override
    public <T> Optional<T> getRequestWithParameters(String url, Map<String, String> parameters, Class<T> classType) {
        return this.makeRequest(Verb.GET, url, parameters, null, true, classType);
    }

    @Override
    protected void signRequest(OAuthRequest request) {
        this.getService().signRequest(this.getTwitterCredentials().asAccessToken(), request);
    }
}

