/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.helpers;

import io.github.redouane59.twitter.dto.tweet.MediaCategory;
import lombok.Generated;

public class URLHelper {
    public static final int MAX_LOOKUP = 100;
    public static final String GET_BEARER_TOKEN_URL = "https://api.twitter.com/oauth2/token";
    public static final String ACCESS_TOKEN_URL = "https://api.twitter.com/2/oauth2/token";
    public static final String GET_OAUTH1_TOKEN_URL = "https://api.twitter.com/oauth/request_token";
    public static final String GET_OAUTH1_ACCESS_TOKEN_URL = "https://api.twitter.com/oauth/access_token";
    private static final String ROOT_URL_V1 = "https://api.twitter.com/1.1";
    private static final String UPLOAD_URL_V1 = "https://upload.twitter.com/1.1/media/upload.json";
    public static final String RATE_LIMIT_URL = "https://api.twitter.com/1.1/application/rate_limit_status.json";
    private static final String IDS_JSON = "/ids.json?";
    private static final String ID = "id";
    private static final String COUNT = "count";
    private static final String LIST_JSON = "/list.json";
    private static final String SHOW_JSON = "/show.json?";
    private static final String FOLLOWERS = "/followers";
    private static final String FOLLOWING = "/friends";
    private static final String FRIENDSHIPS = "/friendships";
    private static final String TWEETS = "/tweets";
    private static final String SEARCH = "/search";
    private static final String THIRTY_DAYS = "/30day";
    private static final String FULL_ARCHIVE = "/fullarchive";
    private static final String USER_ID = "user_id";
    private static final String JSON = ".json";
    public static final String SEARCH_TWEET_STANDARD_URL = "https://api.twitter.com/1.1/search/tweets.json";
    private static final String COLLECTIONS = "/collections";
    private static final String DIRECT_MESSAGE_EVENTS = "/direct_messages/events";
    private final String idVariable = ":id";
    private final String searchRecentTweetsUrl = "https://api.twitter.com/2/tweets/search/recent";
    private final String searchAllTweetsUrl = "https://api.twitter.com/2/tweets/search/all";
    private final String filteredStreamRulesUrl = "https://api.twitter.com/2/tweets/search/stream/rules";
    private final String filteredStreamUrl = "https://api.twitter.com/2/tweets/search/stream";
    private final String sampledStreamUrl = "https://api.twitter.com/2/tweets/sample/stream";
    private final String tweetsCountUrl = "https://api.twitter.com/2/tweets/counts/recent";
    private final String tweetsCountAllUrl = "https://api.twitter.com/2/tweets/counts/all";
    private final String tweetsUrl = "https://api.twitter.com/2/tweets";
    private final String usersByUrl = "https://api.twitter.com/2/users/by";
    private final String usersUrl = "https://api.twitter.com/2/users";
    private final String spacesUrl = "https://api.twitter.com/2/spaces";
    private final String spaceByCreatorUrl = "https://api.twitter.com/2/spaces/by/creator_ids";
    private final String searchSpacesUrl = "https://api.twitter.com/2/spaces/search";
    private final String listUrlV2 = "https://api.twitter.com/2/lists";
    private final String postTweetUrl = "https://api.twitter.com/2/tweets";
    private final String dmEventsUrl = "https://api.twitter.com/2/dm_events";
    private final String createDmConversationUrl = "https://api.twitter.com/2/dm_conversations";
    private final String followUrl = "https://api.twitter.com/2/users/:id/following";
    private final String unfollowUrl = "https://api.twitter.com/2/users/:sourceId/following/:targetId";
    private final String followersUrl = "https://api.twitter.com/2/users/:id/followers";
    private final String followingUrl = "https://api.twitter.com/2/users/:id/following";
    private final String userUrl = "https://api.twitter.com/2/users/:id";
    private final String userUrlFromName = "https://api.twitter.com/2/users/by/username/:username";
    private final String tweetUrl = "https://api.twitter.com/2/tweets/:id";
    private final String likeUrl = "https://api.twitter.com/2/users/:id/likes";
    private final String unlikeUrl = "https://api.twitter.com/2/users/:userId/likes/:tweetId";
    private final String hideUrl = "https://api.twitter.com/2/tweets/:id/hidden";
    private final String userTimelineUrl = "https://api.twitter.com/2/users/:id/tweets";
    private final String userMentionsUrl = "https://api.twitter.com/2/users/:id/mentions";
    private final String blockUserUrl = "https://api.twitter.com/2/users/:id/blocking";
    private final String unblockUserUrl = "https://api.twitter.com/2/users/:sourceId/blocking/:targetId";
    private final String blockingUsersUrl = "https://api.twitter.com/2/users/:id/blocking";
    private final String likingUsersUrl = "https://api.twitter.com/2/tweets/:id/liking_users";
    private final String likedTweetsUrl = "https://api.twitter.com/2/users/:id/liked_tweets";
    private final String muteUserUrl = "https://api.twitter.com/2/users/:id/muting";
    private final String unmuteUserUrl = "https://api.twitter.com/2/users/:source_user_id/muting/:target_user_id";
    private final String mutedUsersUrl = "https://api.twitter.com/2/users/:id/muting";
    private final String retweetingUsersUrl = "https://api.twitter.com/2/tweets/:id/retweeted_by";
    private final String retweetTweetUrl = "https://api.twitter.com/2/users/:id/retweets";
    private final String unretweetTweetUrl = "https://api.twitter.com/2/users/:id/retweets/:source_tweet_id";
    private final String spaceUrl = "https://api.twitter.com/2/spaces/:id";
    private final String spaceBuyersUrl = "https://api.twitter.com/2/spaces/:id/buyers";
    private final String addListMemberUrl = "https://api.twitter.com/2/lists/:id/members";
    private final String removeListMemberUrl = "https://api.twitter.com/2/lists/:id/members/:user_id";
    private final String listTweetsUrl = "https://api.twitter.com/2/lists/:id/tweets";
    private final String pinListUrl = "https://api.twitter.com/2/users/:id/pinned_lists";
    private final String unpinListUrl = "https://api.twitter.com/2/users/:id/pinned_lists/:list_id";
    private final String followListUrl = "https://api.twitter.com/2/users/:id/followed_lists";
    private final String unfollowListUrl = "https://api.twitter.com/2/users/:id/followed_lists/:list_id";
    private final String ownedListUrl = "https://api.twitter.com/2/users/:id/owned_lists";
    private final String dmLookupUrl = "https://api.twitter.com/2/dm_conversations/:dm_conversation_id/dm_events";
    private final String dmUserLookupUrl = "https://api.twitter.com/2/dm_conversations/with/:participant_id/dm_events";
    private final String postConversationDmUrl = "https://api.twitter.com/2/dm_conversations/:dm_conversation_id/messages";
    private final String postUserDmUrl = "https://api.twitter.com/2/dm_conversations/with/:participant_id/messages";

    public String getSearchTweet30DaysUrl(String envName) {
        return "https://api.twitter.com/1.1/tweets/search/30day/" + envName + JSON;
    }

    public String getSearchTweetFullArchiveUrl(String envName) {
        return "https://api.twitter.com/1.1/tweets/search/fullarchive/" + envName + JSON;
    }

    public String getFollowUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/following".replace(":id", userId);
    }

    public String getUnfollowUrl(String sourceUserId, String targetUserId) {
        return "https://api.twitter.com/2/users/:sourceId/following/:targetId".replace(":sourceId", sourceUserId).replace(":targetId", targetUserId);
    }

    public String getFriendshipUrl(String sourceId, String targetId) {
        return "https://api.twitter.com/1.1/friendships/show.json?source_id=" + sourceId + "&target_" + ID + "=" + targetId;
    }

    public String getRetweetersUrl(String tweetId) {
        return "https://api.twitter.com/2/tweets/:id/retweeted_by".replace(":id", tweetId);
    }

    public String getFollowersUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/followers".replace(":id", userId);
    }

    public String getFollowersIdsUrl(String userId) {
        return "https://api.twitter.com/1.1/followers/ids.json?user_id=" + userId + "&count=5000";
    }

    public String getFollowingIdsUrl(String userId) {
        return "https://api.twitter.com/1.1/friends/ids.json?user_id=" + userId + "&count=5000";
    }

    public String getFollowingUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/following".replace(":id", userId);
    }

    public String getUserUrl(String userId) {
        return "https://api.twitter.com/2/users/:id".replace(":id", userId);
    }

    public String getUserUrlFromName(String username) {
        return "https://api.twitter.com/2/users/by/username/:username".replace(":username", username);
    }

    public String getTweetUrl(String tweetId) {
        return "https://api.twitter.com/2/tweets/:id".replace(":id", tweetId);
    }

    public String getLikeUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/likes".replace(":id", userId);
    }

    public String getUnlikeUrl(String userId, String tweetId) {
        return "https://api.twitter.com/2/users/:userId/likes/:tweetId".replace(":userId", userId).replace(":tweetId", tweetId);
    }

    public String getRetweetTweetUrl(String tweetId) {
        return "https://api.twitter.com/2/users/:id/retweets".replace(":id", tweetId);
    }

    public String getUnretweetTweetUrl(String userId, String tweetId) {
        return "https://api.twitter.com/2/users/:id/retweets/:source_tweet_id".replace(":id", userId).replace(":source_tweet_id", tweetId);
    }

    public String getHideReplyUrl(String tweetId) {
        return "https://api.twitter.com/2/tweets/:id/hidden".replace(":id", tweetId);
    }

    public String getUserTimelineUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/tweets".replace(":id", userId);
    }

    public String getUserMentionsUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/mentions".replace(":id", userId);
    }

    public String getUploadMediaUrl(MediaCategory mediaCategory) {
        return "https://upload.twitter.com/1.1/media/upload.json?media_category=" + mediaCategory.label;
    }

    public String getChunkedUploadMediaUrl() {
        return UPLOAD_URL_V1;
    }

    public String getCollectionsCreateUrl() {
        return "https://api.twitter.com/1.1/collections/create.json";
    }

    public String getCollectionsCurateUrl() {
        return "https://api.twitter.com/1.1/collections/entries/curate.json";
    }

    public String getCollectionsDestroyUrl(String collectionId) {
        return "https://api.twitter.com/1.1/collections/destroy.json?id=" + collectionId;
    }

    public String getCollectionsEntriesUrl(String collectionId) {
        return "https://api.twitter.com/1.1/collections/entries.json?id=" + collectionId;
    }

    public String getBlockUserUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/blocking".replace(":id", userId);
    }

    public String getUnblockUserUrl(String sourceUserId, String targetUserId) {
        return "https://api.twitter.com/2/users/:sourceId/blocking/:targetId".replace(":sourceId", sourceUserId).replace(":targetId", targetUserId);
    }

    public String getBlockingUsersUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/blocking".replace(":id", userId);
    }

    public String getLikingUsersUrl(String tweetId) {
        return "https://api.twitter.com/2/tweets/:id/liking_users".replace(":id", tweetId);
    }

    public String getLikedTweetsUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/liked_tweets".replace(":id", userId);
    }

    @Deprecated
    public String getDMListUrl(int count) {
        return "https://api.twitter.com/1.1/direct_messages/events/list.json?count=" + count;
    }

    @Deprecated
    public String getDmUrl(String id) {
        return "https://api.twitter.com/1.1/direct_messages/events/show.json?id=" + id;
    }

    @Deprecated
    public String getPostConversationDmUrl() {
        return "https://api.twitter.com/1.1/direct_messages/events/new.json";
    }

    public String getMuteUserUrl(String sourceUserId) {
        return "https://api.twitter.com/2/users/:id/muting".replace(":id", sourceUserId);
    }

    public String getUnmuteUserUrl(String sourceUserId, String targetUserId) {
        return "https://api.twitter.com/2/users/:source_user_id/muting/:target_user_id".replace(":source_user_id", sourceUserId).replace(":target_user_id", targetUserId);
    }

    public String getSpaceUrl(String id) {
        return "https://api.twitter.com/2/spaces/:id".replace(":id", id);
    }

    public String getSpaceBuyersUrl(String spaceId) {
        return "https://api.twitter.com/2/spaces/:id/buyers".replace(":id", spaceId);
    }

    public String getMutedUsersUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/muting".replace(":id", userId);
    }

    public String getAddListMemberUrl(String listId) {
        return "https://api.twitter.com/2/lists/:id/members".replace(":id", listId);
    }

    public String getRemoveListMemberUrl(String listId, String userId) {
        return "https://api.twitter.com/2/lists/:id/members/:user_id".replace(":id", listId).replace(":user_id", userId);
    }

    public String getListTweetsUrl(String listId) {
        return "https://api.twitter.com/2/lists/:id/tweets".replace(":id", listId);
    }

    public String getPinListUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/pinned_lists".replace(":id", userId);
    }

    public String getUnpinListUrl(String userId, String listId) {
        return "https://api.twitter.com/2/users/:id/pinned_lists/:list_id".replace(":id", userId).replace(":list_id", listId);
    }

    public String getFollowListUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/followed_lists".replace(":id", userId);
    }

    public String getUnfollowListUrl(String userId, String listId) {
        return "https://api.twitter.com/2/users/:id/followed_lists/:list_id".replace(":id", userId).replace(":list_id", listId);
    }

    public String getOwnedListUrl(String userId) {
        return "https://api.twitter.com/2/users/:id/owned_lists".replace(":id", userId);
    }

    public String getDmLookupUrl(String conversationId) {
        return "https://api.twitter.com/2/dm_conversations/:dm_conversation_id/dm_events".replace(":dm_conversation_id", conversationId);
    }

    public String getDmUserLookupUrl(String conversationId) {
        return "https://api.twitter.com/2/dm_conversations/with/:participant_id/dm_events".replace(":participant_id", conversationId);
    }

    public String getPostConversationDmUrl(String conversationId) {
        return "https://api.twitter.com/2/dm_conversations/:dm_conversation_id/messages".replace(":dm_conversation_id", conversationId);
    }

    public String getPostUserDmUrl(String participantId) {
        return "https://api.twitter.com/2/dm_conversations/with/:participant_id/messages".replace(":participant_id", participantId);
    }

    @Generated
    public String getSearchRecentTweetsUrl() {
        return this.searchRecentTweetsUrl;
    }

    @Generated
    public String getSearchAllTweetsUrl() {
        return this.searchAllTweetsUrl;
    }

    @Generated
    public String getFilteredStreamRulesUrl() {
        return this.filteredStreamRulesUrl;
    }

    @Generated
    public String getFilteredStreamUrl() {
        return this.filteredStreamUrl;
    }

    @Generated
    public String getSampledStreamUrl() {
        return this.sampledStreamUrl;
    }

    @Generated
    public String getTweetsCountUrl() {
        return this.tweetsCountUrl;
    }

    @Generated
    public String getTweetsCountAllUrl() {
        return this.tweetsCountAllUrl;
    }

    @Generated
    public String getTweetsUrl() {
        this.getClass();
        return "https://api.twitter.com/2/tweets";
    }

    @Generated
    public String getUsersByUrl() {
        return this.usersByUrl;
    }

    @Generated
    public String getUsersUrl() {
        return this.usersUrl;
    }

    @Generated
    public String getSpacesUrl() {
        return this.spacesUrl;
    }

    @Generated
    public String getSpaceByCreatorUrl() {
        return this.spaceByCreatorUrl;
    }

    @Generated
    public String getSearchSpacesUrl() {
        return this.searchSpacesUrl;
    }

    @Generated
    public String getListUrlV2() {
        return this.listUrlV2;
    }

    @Generated
    public String getPostTweetUrl() {
        this.getClass();
        return "https://api.twitter.com/2/tweets";
    }

    @Generated
    public String getDmEventsUrl() {
        return this.dmEventsUrl;
    }

    @Generated
    public String getCreateDmConversationUrl() {
        return this.createDmConversationUrl;
    }
}

