/*
 * Decompiled with CFR 0.152.
 */
package io.github.redouane59.twitter.signature;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.utils.Preconditions;
import lombok.Generated;

@JsonDeserialize(builder=TwitterCredentialsBuilder.class)
public class TwitterCredentials {
    private String apiKey;
    private String apiSecretKey;
    private String accessToken;
    private String accessTokenSecret;
    private String bearerToken;

    public OAuth1AccessToken asAccessToken() {
        return new OAuth1AccessToken(this.getAccessToken(), this.getAccessTokenSecret());
    }

    public String getApiKey() {
        return Preconditions.hasText((String)this.apiKey) || !Preconditions.hasText((String)this.bearerToken) ? this.apiKey : this.bearerToken;
    }

    public String getApiSecretKey() {
        return Preconditions.hasText((String)this.apiSecretKey) || !Preconditions.hasText((String)this.bearerToken) ? this.apiSecretKey : this.bearerToken;
    }

    @Generated
    public static TwitterCredentialsBuilder builder() {
        return new TwitterCredentialsBuilder();
    }

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    @Generated
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public void setApiSecretKey(String apiSecretKey) {
        this.apiSecretKey = apiSecretKey;
    }

    @Generated
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    @Generated
    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @Generated
    public TwitterCredentials() {
    }

    @Generated
    public TwitterCredentials(String apiKey, String apiSecretKey, String accessToken, String accessTokenSecret, String bearerToken) {
        this.apiKey = apiKey;
        this.apiSecretKey = apiSecretKey;
        this.accessToken = accessToken;
        this.accessTokenSecret = accessTokenSecret;
        this.bearerToken = bearerToken;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class TwitterCredentialsBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String apiSecretKey;
        @Generated
        private String accessToken;
        @Generated
        private String accessTokenSecret;
        @Generated
        private String bearerToken;

        @Generated
        TwitterCredentialsBuilder() {
        }

        @Generated
        public TwitterCredentialsBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public TwitterCredentialsBuilder apiSecretKey(String apiSecretKey) {
            this.apiSecretKey = apiSecretKey;
            return this;
        }

        @Generated
        public TwitterCredentialsBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Generated
        public TwitterCredentialsBuilder accessTokenSecret(String accessTokenSecret) {
            this.accessTokenSecret = accessTokenSecret;
            return this;
        }

        @Generated
        public TwitterCredentialsBuilder bearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        @Generated
        public TwitterCredentials build() {
            return new TwitterCredentials(this.apiKey, this.apiSecretKey, this.accessToken, this.accessTokenSecret, this.bearerToken);
        }

        @Generated
        public String toString() {
            return "TwitterCredentials.TwitterCredentialsBuilder(apiKey=" + this.apiKey + ", apiSecretKey=" + this.apiSecretKey + ", accessToken=" + this.accessToken + ", accessTokenSecret=" + this.accessTokenSecret + ", bearerToken=" + this.bearerToken + ")";
        }
    }
}

