/*
 * Decompiled with CFR 0.152.
 */
package com.reidsync.kxjsonpatch;

import com.reidsync.kxjsonpatch.Constants;
import com.reidsync.kxjsonpatch.Diff;
import com.reidsync.kxjsonpatch.JsonElementExtensionsKt;
import com.reidsync.kxjsonpatch.NodeType;
import com.reidsync.kxjsonpatch.Operations;
import com.reidsync.kxjsonpatch.lcs.ListUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002JD\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001aH\u0007J\u0016\u0010\"\u001a\u00020#2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J4\u0010$\u001a\u00020#2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0002J4\u0010%\u001a\u00020#2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010 \u001a\u00020&2\u0006\u0010!\u001a\u00020&H\u0002J@\u0010'\u001a\u00020#2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00180)2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0002J@\u0010*\u001a\u00020#2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00180)2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010 \u001a\u00020&2\u0006\u0010!\u001a\u00020&H\u0002J4\u0010+\u001a\u00020#2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J@\u0010.\u001a\u00020#2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00180)2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001aH\u0002J4\u0010/\u001a\u00020#2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001aH\u0002J\u0016\u00100\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018H\u0002J\u0010\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u0016H\u0002J\u0016\u00103\u001a\u00020\u001f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u001e\u00104\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u001aH\u0002J2\u00107\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00182\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0018082\u0006\u00109\u001a\u00020\u001aH\u0002J$\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010;\u001a\u00020\u0001H\u0002J*\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0018082\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001aH\u0002J&\u0010=\u001a\u00020#2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001a2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002JD\u0010>\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010?\u001a\u00020\u00132\u0006\u0010@\u001a\u00020\u00132\u0006\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u00020\u001aH\u0002J\u001e\u0010C\u001a\u00020#2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010E\u001a\u00020\u0013H\u0002J&\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020\u00162\u0006\u0010H\u001a\u00020\u00132\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0002J,\u0010I\u001a\u00020#2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010G\u001a\u00020\u00162\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0002J$\u0010J\u001a\u00020#2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006K"}, d2={"Lcom/reidsync/kxjsonpatch/JsonDiff;", "", "()V", "consts", "Lcom/reidsync/kxjsonpatch/Constants;", "getConsts$kotlin_json_patch_debug", "()Lcom/reidsync/kxjsonpatch/Constants;", "setConsts$kotlin_json_patch_debug", "(Lcom/reidsync/kxjsonpatch/Constants;)V", "op", "Lcom/reidsync/kxjsonpatch/Operations;", "getOp$kotlin_json_patch_debug", "()Lcom/reidsync/kxjsonpatch/Operations;", "setOp$kotlin_json_patch_debug", "(Lcom/reidsync/kxjsonpatch/Operations;)V", "EncodePath", "", "object", "addRemaining", "", "diffs", "", "Lcom/reidsync/kxjsonpatch/Diff;", "path", "", "target_", "Lkotlinx/serialization/json/JsonElement;", "pos_", "targetIdx_", "targetSize", "asJson", "Lkotlinx/serialization/json/JsonArray;", "source", "target", "compactDiffs", "", "compareArray", "compareObjects", "Lkotlinx/serialization/json/JsonObject;", "computeArray", "unchangedValues", "", "computeObject", "computeRelativePath", "startIdx", "endIdx", "computeUnchangedValues", "generateDiffs", "getArrayNodeRepresentation", "getJsonNode", "diff", "getJsonNodes", "getLCS", "first_", "second_", "getMatchingValuePath", "", "value", "getPath", "key", "getUnchangedPart", "introduceCopyOperation", "removeRemaining", "pos", "srcIdx_", "srcSize", "source_", "resetCounters", "counters", "size", "updateCounters", "pseudo", "idx", "updatePath", "updatePathWithCounters", "kotlin-json-patch_debug"})
public final class JsonDiff {
    @NotNull
    public static final JsonDiff INSTANCE = new JsonDiff();
    @NotNull
    private static Operations op = new Operations();
    @NotNull
    private static Constants consts = new Constants();

    private JsonDiff() {
    }

    @NotNull
    public final Operations getOp$kotlin_json_patch_debug() {
        return op;
    }

    public final void setOp$kotlin_json_patch_debug(@NotNull Operations operations) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"<set-?>");
        op = operations;
    }

    @NotNull
    public final Constants getConsts$kotlin_json_patch_debug() {
        return consts;
    }

    public final void setConsts$kotlin_json_patch_debug(@NotNull Constants constants) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"<set-?>");
        consts = constants;
    }

    @JvmStatic
    @NotNull
    public static final JsonArray asJson(@NotNull JsonElement source, @NotNull JsonElement target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ArrayList diffs = new ArrayList();
        ArrayList path = new ArrayList();
        INSTANCE.generateDiffs(diffs, path, source, target);
        INSTANCE.compactDiffs(diffs);
        INSTANCE.introduceCopyOperation(source, target, diffs);
        return INSTANCE.getJsonNodes(diffs);
    }

    private final List<Object> getMatchingValuePath(Map<JsonElement, ? extends List<? extends Object>> unchangedValues, JsonElement value) {
        return unchangedValues.get(value);
    }

    private final void introduceCopyOperation(JsonElement source, JsonElement target, List<Diff> diffs) {
        Map<JsonElement, List<Object>> unchangedValues = this.getUnchangedPart(source, target);
        int n = diffs.size();
        for (int i = 0; i < n; ++i) {
            List<Object> matchingValuePath;
            Diff diff = diffs.get(i);
            if (op.getADD() != diff.getOperation() || (matchingValuePath = this.getMatchingValuePath(unchangedValues, diff.getValue())) == null) continue;
            diffs.set(i, new Diff(op.getCOPY(), matchingValuePath, diff.getPath()));
        }
    }

    private final Map<JsonElement, List<Object>> getUnchangedPart(JsonElement source, JsonElement target) {
        HashMap unchangedValues = new HashMap();
        this.computeUnchangedValues(unchangedValues, CollectionsKt.emptyList(), source, target);
        return unchangedValues;
    }

    private final void computeUnchangedValues(Map<JsonElement, List<Object>> unchangedValues, List<? extends Object> path, JsonElement source, JsonElement target) {
        int secondType;
        if (Intrinsics.areEqual((Object)source, (Object)target)) {
            unchangedValues.put(target, path);
            return;
        }
        int firstType = NodeType.INSTANCE.getNodeType(source);
        if (firstType == (secondType = NodeType.INSTANCE.getNodeType(target))) {
            int n = firstType;
            if (n == NodeType.INSTANCE.getOBJECT()) {
                this.computeObject(unchangedValues, path, JsonElementKt.getJsonObject((JsonElement)source), JsonElementKt.getJsonObject((JsonElement)target));
            } else if (n == NodeType.INSTANCE.getARRAY()) {
                this.computeArray(unchangedValues, path, JsonElementKt.getJsonArray((JsonElement)source), JsonElementKt.getJsonArray((JsonElement)target));
            }
        }
    }

    private final void computeArray(Map<JsonElement, List<Object>> unchangedValues, List<? extends Object> path, JsonArray source, JsonArray target) {
        int i = 0;
        int size = Math.min(source.size(), target.size());
        int n = size - 1;
        if (i <= n) {
            while (true) {
                List<Object> currPath = this.getPath(path, i);
                this.computeUnchangedValues(unchangedValues, currPath, source.get(i), target.get(i));
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void computeObject(Map<JsonElement, List<Object>> unchangedValues, List<? extends Object> path, JsonObject source, JsonObject target) {
        Iterator firstFields = ((Map)source).entrySet().iterator();
        while (firstFields.hasNext()) {
            String name = (String)firstFields.next().getKey();
            if (!target.containsKey((Object)name)) continue;
            List<Object> currPath = this.getPath(path, name);
            Object object = source.get((Object)name);
            Intrinsics.checkNotNull((Object)object);
            JsonElement jsonElement = (JsonElement)object;
            Object object2 = target.get((Object)name);
            Intrinsics.checkNotNull((Object)object2);
            this.computeUnchangedValues(unchangedValues, currPath, jsonElement, (JsonElement)object2);
        }
    }

    private final void compactDiffs(List<Diff> diffs) {
        int i = -1;
        block0: while (++i <= diffs.size() - 1) {
            Diff diff1 = diffs.get(i);
            if (op.getREMOVE() != diff1.getOperation() && op.getADD() != diff1.getOperation()) continue;
            int n = diffs.size();
            for (int j = i + 1; j < n; ++j) {
                Diff diff2 = diffs.get(j);
                if (!Intrinsics.areEqual((Object)diff1.getValue(), (Object)diff2.getValue())) continue;
                Diff moveDiff = null;
                if (op.getREMOVE() == diff1.getOperation() && op.getADD() == diff2.getOperation()) {
                    this.computeRelativePath(diff2.getPath(), i + 1, j - 1, diffs);
                    moveDiff = new Diff(op.getMOVE(), diff1.getPath(), diff2.getPath());
                } else if (op.getADD() == diff1.getOperation() && op.getREMOVE() == diff2.getOperation()) {
                    this.computeRelativePath(diff2.getPath(), i, j - 1, diffs);
                    moveDiff = new Diff(op.getMOVE(), diff2.getPath(), diff1.getPath());
                }
                if (moveDiff == null) continue;
                diffs.remove(j);
                diffs.set(i, moveDiff);
                continue block0;
            }
        }
    }

    private final void computeRelativePath(List<Object> path, int startIdx, int endIdx, List<Diff> diffs) {
        ArrayList counters = new ArrayList();
        this.resetCounters(counters, path.size());
        int i = startIdx;
        if (i <= endIdx) {
            while (true) {
                Diff diff = diffs.get(i);
                if (op.getADD() == diff.getOperation() || op.getREMOVE() == diff.getOperation()) {
                    this.updatePath(path, diff, counters);
                }
                if (i == endIdx) break;
                ++i;
            }
        }
        this.updatePathWithCounters(counters, path);
    }

    private final void resetCounters(List<Integer> counters, int size) {
        int i = 0;
        int n = size - 1;
        if (i <= n) {
            while (true) {
                counters.add(0);
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void updatePathWithCounters(List<Integer> counters, List<Object> path) {
        int n = counters.size();
        for (int i = 0; i < n; ++i) {
            int value = ((Number)counters.get(i)).intValue();
            if (value == 0) continue;
            int currValue = Integer.parseInt(path.get(i).toString());
            path.set(i, String.valueOf(currValue + value));
        }
    }

    private final void updatePath(List<? extends Object> path, Diff pseudo, List<Integer> counters) {
        if (pseudo.getPath().size() <= path.size()) {
            int idx = -1;
            int i = 0;
            int n = pseudo.getPath().size() - 1 - 1;
            if (i <= n) {
                while (Intrinsics.areEqual((Object)pseudo.getPath().get(i), (Object)path.get(i))) {
                    idx = i;
                    if (i == n) break;
                    ++i;
                }
            }
            if (idx == pseudo.getPath().size() - 2 && pseudo.getPath().get(pseudo.getPath().size() - 1) instanceof Integer) {
                this.updateCounters(pseudo, pseudo.getPath().size() - 1, counters);
            }
        }
    }

    private final void updateCounters(Diff pseudo, int idx, List<Integer> counters) {
        if (op.getADD() == pseudo.getOperation()) {
            counters.set(idx, ((Number)counters.get(idx)).intValue() - 1);
        } else if (op.getREMOVE() == pseudo.getOperation()) {
            counters.set(idx, ((Number)counters.get(idx)).intValue() + 1);
        }
    }

    private final JsonArray getJsonNodes(List<Diff> diffs) {
        JsonArray patch = new JsonArray(CollectionsKt.emptyList());
        for (Diff diff : diffs) {
            JsonObject jsonNode = this.getJsonNode(diff);
            patch = JsonElementExtensionsKt.add(patch, (JsonElement)jsonNode);
        }
        return patch;
    }

    private final JsonObject getJsonNode(Diff diff) {
        JsonObject jsonNode = new JsonObject(MapsKt.emptyMap());
        jsonNode = JsonElementExtensionsKt.addProperty(jsonNode, consts.getOP(), op.nameFromOp(diff.getOperation()));
        if (op.getMOVE() == diff.getOperation() || op.getCOPY() == diff.getOperation()) {
            jsonNode = JsonElementExtensionsKt.addProperty(jsonNode, consts.getFROM(), this.getArrayNodeRepresentation(diff.getPath()));
            jsonNode = JsonElementExtensionsKt.addProperty(jsonNode, consts.getPATH(), this.getArrayNodeRepresentation(diff.getToPath()));
        } else {
            jsonNode = JsonElementExtensionsKt.addProperty(jsonNode, consts.getPATH(), this.getArrayNodeRepresentation(diff.getPath()));
            jsonNode = JsonElementExtensionsKt.add(jsonNode, consts.getVALUE(), diff.getValue());
        }
        return jsonNode;
    }

    private final String EncodePath(Object object) {
        String path = object.toString();
        CharSequence charSequence = path;
        Regex regex = new Regex("~");
        String string = "~0";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("/");
        string = "~1";
        return regex.replace(charSequence, string);
    }

    private final String getArrayNodeRepresentation(List<? extends Object> path) {
        StringBuilder sb = new StringBuilder();
        int n = path.size();
        for (int i = 0; i < n; ++i) {
            sb.append('/');
            sb.append(this.EncodePath(path.get(i)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void generateDiffs(List<Diff> diffs, List<? extends Object> path, JsonElement source, JsonElement target) {
        if (!Intrinsics.areEqual((Object)source, (Object)target)) {
            int sourceType = NodeType.INSTANCE.getNodeType(source);
            int targetType = NodeType.INSTANCE.getNodeType(target);
            if (sourceType == NodeType.INSTANCE.getARRAY() && targetType == NodeType.INSTANCE.getARRAY()) {
                this.compareArray(diffs, path, JsonElementKt.getJsonArray((JsonElement)source), JsonElementKt.getJsonArray((JsonElement)target));
            } else if (sourceType == NodeType.INSTANCE.getOBJECT() && targetType == NodeType.INSTANCE.getOBJECT()) {
                this.compareObjects(diffs, path, JsonElementKt.getJsonObject((JsonElement)source), JsonElementKt.getJsonObject((JsonElement)target));
            } else {
                diffs.add(Diff.Companion.generateDiff(op.getREPLACE(), path, target));
            }
        }
    }

    private final void compareArray(List<Diff> diffs, List<? extends Object> path, JsonArray source, JsonArray target) {
        List<JsonElement> lcs = this.getLCS((JsonElement)source, (JsonElement)target);
        int srcIdx = 0;
        int targetIdx = 0;
        int lcsIdx = 0;
        int srcSize = source.size();
        int targetSize = target.size();
        int lcsSize = lcs.size();
        int pos = 0;
        while (lcsIdx < lcsSize) {
            List<Object> currPath;
            JsonElement lcsNode = lcs.get(lcsIdx);
            JsonElement srcNode = source.get(srcIdx);
            JsonElement targetNode = target.get(targetIdx);
            if (Intrinsics.areEqual((Object)lcsNode, (Object)srcNode) && Intrinsics.areEqual((Object)lcsNode, (Object)targetNode)) {
                ++srcIdx;
                ++targetIdx;
                ++lcsIdx;
                ++pos;
                continue;
            }
            if (Intrinsics.areEqual((Object)lcsNode, (Object)srcNode)) {
                currPath = this.getPath(path, pos);
                diffs.add(Diff.Companion.generateDiff(op.getADD(), currPath, targetNode));
                ++pos;
                ++targetIdx;
                continue;
            }
            if (Intrinsics.areEqual((Object)lcsNode, (Object)targetNode)) {
                currPath = this.getPath(path, pos);
                diffs.add(Diff.Companion.generateDiff(op.getREMOVE(), currPath, srcNode));
                ++srcIdx;
                continue;
            }
            currPath = this.getPath(path, pos);
            this.generateDiffs(diffs, currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        while (srcIdx < srcSize && targetIdx < targetSize) {
            JsonElement srcNode = source.get(srcIdx);
            JsonElement targetNode = target.get(targetIdx);
            List<Object> currPath = this.getPath(path, pos);
            this.generateDiffs(diffs, currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        pos = this.addRemaining(diffs, path, (JsonElement)target, pos, targetIdx, targetSize);
        this.removeRemaining(diffs, path, pos, srcIdx, srcSize, (JsonElement)source);
    }

    private final int removeRemaining(List<Diff> diffs, List<? extends Object> path, int pos, int srcIdx_, int srcSize, JsonElement source_) {
        JsonArray source = JsonElementKt.getJsonArray((JsonElement)source_);
        for (int srcIdx = srcIdx_; srcIdx < srcSize; ++srcIdx) {
            List<Object> currPath = this.getPath(path, pos);
            diffs.add(Diff.Companion.generateDiff(op.getREMOVE(), currPath, source.get(srcIdx)));
        }
        return pos;
    }

    private final int addRemaining(List<Diff> diffs, List<? extends Object> path, JsonElement target_, int pos_, int targetIdx_, int targetSize) {
        int pos = pos_;
        JsonArray target = JsonElementKt.getJsonArray((JsonElement)target_);
        for (int targetIdx = targetIdx_; targetIdx < targetSize; ++targetIdx) {
            JsonElement jsonNode = target.get(targetIdx);
            List<Object> currPath = this.getPath(path, pos);
            diffs.add(Diff.Companion.generateDiff(op.getADD(), currPath, JsonElementExtensionsKt.deepCopy(jsonNode)));
            ++pos;
        }
        return pos;
    }

    private final void compareObjects(List<Diff> diffs, List<? extends Object> path, JsonObject source, JsonObject target) {
        Iterator keysFromSrc = ((Map)source).entrySet().iterator();
        while (keysFromSrc.hasNext()) {
            List<Object> currPath;
            String key = (String)keysFromSrc.next().getKey();
            if (!target.containsKey((Object)key)) {
                currPath = this.getPath(path, key);
                int n = op.getREMOVE();
                Object object = source.get((Object)key);
                Intrinsics.checkNotNull((Object)object);
                diffs.add(Diff.Companion.generateDiff(n, currPath, (JsonElement)object));
                continue;
            }
            currPath = this.getPath(path, key);
            Object object = source.get((Object)key);
            Intrinsics.checkNotNull((Object)object);
            JsonElement jsonElement = (JsonElement)object;
            Object object2 = target.get((Object)key);
            Intrinsics.checkNotNull((Object)object2);
            this.generateDiffs(diffs, currPath, jsonElement, (JsonElement)object2);
        }
        Iterator keysFromTarget = ((Map)target).entrySet().iterator();
        while (keysFromTarget.hasNext()) {
            String key = (String)keysFromTarget.next().getKey();
            if (source.containsKey((Object)key)) continue;
            List<Object> currPath = this.getPath(path, key);
            int n = op.getADD();
            Object object = target.get((Object)key);
            Intrinsics.checkNotNull((Object)object);
            diffs.add(Diff.Companion.generateDiff(n, currPath, (JsonElement)object));
        }
    }

    private final List<Object> getPath(List<? extends Object> path, Object key) {
        ArrayList<Object> toReturn = new ArrayList<Object>();
        toReturn.addAll((Collection)path);
        toReturn.add(key);
        return toReturn;
    }

    private final List<JsonElement> getLCS(JsonElement first_, JsonElement second_) {
        if (!(first_ instanceof JsonArray)) {
            throw new IllegalArgumentException("LCS can only work on JSON arrays");
        }
        if (!(second_ instanceof JsonArray)) {
            throw new IllegalArgumentException("LCS can only work on JSON arrays");
        }
        JsonArray first = (JsonArray)first_;
        JsonArray second = (JsonArray)second_;
        return ListUtils.INSTANCE.longestCommonSubsequence(CollectionsKt.toList((Iterable)((Iterable)first)), CollectionsKt.toList((Iterable)((Iterable)second)));
    }
}

