/*
 * Decompiled with CFR 0.152.
 */
package com.reidsync.kxjsonpatch;

import com.reidsync.kxjsonpatch.JsonElementExtensionsKt;
import com.reidsync.kxjsonpatch.JsonPatchApplicationException;
import com.reidsync.kxjsonpatch.JsonPatchEditingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0016J&\u0010\u000e\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J&\u0010\u0010\u001a\u00020\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J$\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J6\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001cH\u0002J>\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001f\u001a\u00020\u00142\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001cH\u0002J(\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J \u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J$\u0010\"\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010#\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001e\u0010$\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u001e\u0010%\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006&"}, d2={"Lcom/reidsync/kxjsonpatch/JsonPatchEditingContextImpl;", "Lcom/reidsync/kxjsonpatch/JsonPatchEditingContext;", "source", "Lkotlinx/serialization/json/JsonElement;", "(Lkotlinx/serialization/json/JsonElement;)V", "getSource", "()Lkotlinx/serialization/json/JsonElement;", "setSource", "add", "", "path", "", "", "value", "addToArray", "parentNode", "addToObject", "Lkotlinx/serialization/json/JsonObject;", "node", "arrayIndex", "", "s", "max", "copy", "fromPath", "toPath", "editElement", "action", "Lkotlin/Function1;", "findAndAction", "ret", "pos_", "getNode", "getParentNode", "move", "remove", "replace", "test", "kotlin-json-patch_debug"})
public final class JsonPatchEditingContextImpl
implements JsonPatchEditingContext {
    @NotNull
    private JsonElement source;

    public JsonPatchEditingContextImpl(@NotNull JsonElement source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    @NotNull
    public final JsonElement getSource() {
        return this.source;
    }

    public final void setSource(@NotNull JsonElement jsonElement) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"<set-?>");
        this.source = jsonElement;
    }

    @Override
    public void remove(@NotNull List<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        JsonElement jsonElement = this.editElement(this.source, path, (Function1<? super JsonElement, ? extends JsonElement>)((Function1)new Function1<JsonElement, JsonElement>(path, this){
            final /* synthetic */ List<String> $path;
            final /* synthetic */ JsonPatchEditingContextImpl this$0;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final JsonElement invoke(@NotNull JsonElement root) {
                void var2_2;
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                if (this.$path.isEmpty()) {
                    throw new JsonPatchApplicationException("[Remove Operation] path is empty");
                }
                JsonElement parentNode = root;
                CharSequence charSequence = this.$path.get(this.$path.size() - 1);
                Regex regex = new Regex("\"");
                String string = "";
                String fieldToRemove = regex.replace(charSequence, string);
                if (parentNode instanceof JsonObject) {
                    JsonObject copyp = JsonElementExtensionsKt.remove((JsonObject)parentNode, fieldToRemove);
                    System.out.println(parentNode);
                    System.out.println(copyp);
                    System.out.println(root);
                    parentNode = (JsonElement)copyp;
                } else if (parentNode instanceof JsonArray) {
                    parentNode = (JsonElement)JsonElementExtensionsKt.remove((JsonArray)parentNode, JsonPatchEditingContextImpl.access$arrayIndex(this.this$0, fieldToRemove, ((JsonArray)parentNode).size() - 1));
                } else {
                    throw new JsonPatchApplicationException("[Remove Operation] noSuchPath in source, path provided : " + this.$path);
                }
                return var2_2;
            }
        }));
        if (jsonElement == null) {
            jsonElement = this.source;
        }
        this.source = jsonElement;
    }

    @Override
    public void replace(@NotNull List<String> path, @NotNull JsonElement value) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonElement jsonElement = this.editElement(this.source, path, (Function1<? super JsonElement, ? extends JsonElement>)((Function1)new Function1<JsonElement, JsonElement>(path, this, value){
            final /* synthetic */ List<String> $path;
            final /* synthetic */ JsonPatchEditingContextImpl this$0;
            final /* synthetic */ JsonElement $value;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final JsonElement invoke(@NotNull JsonElement root) {
                void var2_2;
                String string;
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                if (this.$path.isEmpty()) {
                    throw new JsonPatchApplicationException("[Replace Operation] path is empty");
                }
                JsonElement parentNode = JsonPatchEditingContextImpl.access$getParentNode(this.this$0, this.this$0.getSource(), this.$path);
                if (parentNode == null) {
                    throw new JsonPatchApplicationException("[Replace Operation] noSuchPath in source, path provided : " + this.$path);
                }
                Regex regex = new Regex("\"");
                CharSequence charSequence = this.$path.get(this.$path.size() - 1);
                String fieldToReplace = regex.replace(charSequence, string = "");
                if (((CharSequence)fieldToReplace).length() == 0 && this.$path.size() == 1) {
                    parentNode = this.$value;
                } else if (parentNode instanceof JsonObject) {
                    parentNode = (JsonElement)JsonElementExtensionsKt.add((JsonObject)parentNode, fieldToReplace, this.$value);
                } else if (parentNode instanceof JsonArray) {
                    parentNode = (JsonElement)JsonElementExtensionsKt.set((JsonArray)parentNode, JsonPatchEditingContextImpl.access$arrayIndex(this.this$0, fieldToReplace, ((JsonArray)parentNode).size() - 1), this.$value);
                } else {
                    throw new JsonPatchApplicationException("[Replace Operation] noSuchPath in source, path provided : " + this.$path);
                }
                return var2_2;
            }
        }));
        if (jsonElement == null) {
            jsonElement = this.source;
        }
        this.source = jsonElement;
    }

    @Override
    public void add(@NotNull List<String> path, @NotNull JsonElement value) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonElement jsonElement = this.editElement(this.source, path, (Function1<? super JsonElement, ? extends JsonElement>)((Function1)new Function1<JsonElement, JsonElement>(path, value, this){
            final /* synthetic */ List<String> $path;
            final /* synthetic */ JsonElement $value;
            final /* synthetic */ JsonPatchEditingContextImpl this$0;
            {
                this.$path = $path;
                this.$value = $value;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final JsonElement invoke(@NotNull JsonElement root) {
                void var2_2;
                String string;
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                if (this.$path.isEmpty()) {
                    throw new JsonPatchApplicationException("[ADD Operation] path is empty , path : ");
                }
                JsonElement parentNode = root;
                Regex regex = new Regex("\"");
                CharSequence charSequence = this.$path.get(this.$path.size() - 1);
                String fieldToReplace = regex.replace(charSequence, string = "");
                if (Intrinsics.areEqual((Object)fieldToReplace, (Object)"") && this.$path.size() == 1) {
                    parentNode = this.$value;
                } else {
                    if (!JsonElementExtensionsKt.isContainerNode(parentNode)) {
                        throw new JsonPatchApplicationException("[ADD Operation] parent is not a container in source, path provided : " + this.$path + " | node : " + parentNode);
                    }
                    parentNode = parentNode instanceof JsonArray ? JsonPatchEditingContextImpl.access$addToArray(this.this$0, this.$path, this.$value, parentNode) : (JsonElement)JsonPatchEditingContextImpl.access$addToObject(this.this$0, this.$path, parentNode, this.$value);
                }
                return var2_2;
            }
        }));
        if (jsonElement == null) {
            jsonElement = this.source;
        }
        this.source = jsonElement;
    }

    @Override
    public void move(@NotNull List<String> fromPath, @NotNull List<String> toPath) {
        Intrinsics.checkNotNullParameter(fromPath, (String)"fromPath");
        Intrinsics.checkNotNullParameter(toPath, (String)"toPath");
        JsonElement parentNode = this.getParentNode(this.source, fromPath);
        CharSequence charSequence = fromPath.get(fromPath.size() - 1);
        Regex regex = new Regex("\"");
        String string = "";
        String field = regex.replace(charSequence, string);
        JsonElement jsonElement = parentNode;
        Intrinsics.checkNotNull((Object)jsonElement);
        JsonElement valueNode = jsonElement instanceof JsonArray ? JsonElementKt.getJsonArray((JsonElement)parentNode).get(Integer.parseInt(field)) : (JsonElement)JsonElementKt.getJsonObject((JsonElement)parentNode).get((Object)field);
        this.remove(fromPath);
        JsonElement jsonElement2 = valueNode;
        Intrinsics.checkNotNull((Object)jsonElement2);
        this.add(toPath, jsonElement2);
    }

    @Override
    public void copy(@NotNull List<String> fromPath, @NotNull List<String> toPath) {
        JsonElement valueNode;
        Intrinsics.checkNotNullParameter(fromPath, (String)"fromPath");
        Intrinsics.checkNotNullParameter(toPath, (String)"toPath");
        JsonElement parentNode = this.getParentNode(this.source, fromPath);
        CharSequence charSequence = fromPath.get(fromPath.size() - 1);
        Regex regex = new Regex("\"");
        String string = "";
        String field = regex.replace(charSequence, string);
        JsonElement jsonElement = parentNode;
        Intrinsics.checkNotNull((Object)jsonElement);
        JsonElement jsonElement2 = valueNode = jsonElement instanceof JsonArray ? JsonElementKt.getJsonArray((JsonElement)parentNode).get(Integer.parseInt(field)) : (JsonElement)JsonElementKt.getJsonObject((JsonElement)parentNode).get((Object)field);
        Intrinsics.checkNotNull((Object)jsonElement2);
        this.add(toPath, jsonElement2);
    }

    @Override
    public void test(@NotNull List<String> path, @NotNull JsonElement value) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonElement jsonElement = this.editElement(this.source, path, (Function1<? super JsonElement, ? extends JsonElement>)((Function1)new Function1<JsonElement, JsonElement>(path, value, this){
            final /* synthetic */ List<String> $path;
            final /* synthetic */ JsonElement $value;
            final /* synthetic */ JsonPatchEditingContextImpl this$0;
            {
                this.$path = $path;
                this.$value = $value;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final JsonElement invoke(@NotNull JsonElement root) {
                void var2_2;
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                if (this.$path.isEmpty()) {
                    throw new JsonPatchApplicationException("[TEST Operation] path is empty , path : ");
                }
                JsonElement parentNode = root;
                Regex regex = new Regex("\"");
                CharSequence charSequence2 = this.$path.get(this.$path.size() - 1);
                String fieldToReplace = regex.replace(charSequence2, charSequence = "");
                if (Intrinsics.areEqual((Object)fieldToReplace, (Object)"") && this.$path.size() == 1) {
                    parentNode = this.$value;
                } else {
                    JsonElement target;
                    if (!JsonElementExtensionsKt.isContainerNode(parentNode)) {
                        throw new JsonPatchApplicationException("[TEST Operation] parent is not a container in source, path provided : " + this.$path + " | node : " + parentNode);
                    }
                    if (parentNode instanceof JsonArray) {
                        String string;
                        CharSequence charSequence3;
                        Regex regex2;
                        int idx;
                        target = parentNode;
                        String idxStr = this.$path.get(this.$path.size() - 1);
                        if (Intrinsics.areEqual((Object)"-", (Object)idxStr) ? !Intrinsics.areEqual((Object)((JsonArray)target).get(((JsonArray)target).size() - 1), (Object)this.$value) : !Intrinsics.areEqual((Object)((JsonArray)target).get(idx = JsonPatchEditingContextImpl.access$arrayIndex(this.this$0, (regex2 = new Regex("\"")).replace(charSequence3 = (CharSequence)idxStr, string = ""), ((JsonArray)target).size())), (Object)this.$value)) {
                            throw new JsonPatchApplicationException("[TEST Operation] value mismatch");
                        }
                    } else {
                        String string;
                        target = (JsonObject)parentNode;
                        Regex regex3 = new Regex("\"");
                        charSequence = this.$path.get(this.$path.size() - 1);
                        String key = regex3.replace(charSequence, string = "");
                        if (!Intrinsics.areEqual((Object)target.get((Object)key), (Object)this.$value)) {
                            throw new JsonPatchApplicationException("[TEST Operation] value mismatch");
                        }
                    }
                }
                return var2_2;
            }
        }));
        if (jsonElement == null) {
            jsonElement = this.source;
        }
        this.source = jsonElement;
    }

    private final JsonElement getParentNode(JsonElement source, List<String> fromPath) {
        List<String> pathToParent = fromPath.subList(0, fromPath.size() - 1);
        return this.getNode(source, pathToParent, 1);
    }

    private final JsonElement getNode(JsonElement ret, List<String> path, int pos_) {
        int pos = pos_;
        if (pos >= path.size()) {
            return ret;
        }
        String key = path.get(pos);
        if (ret instanceof JsonArray) {
            CharSequence charSequence = key;
            Regex regex = new Regex("\"");
            String string = "";
            int keyInt = Integer.parseInt(regex.replace(charSequence, string));
            return this.getNode(((JsonArray)ret).get(keyInt), path, ++pos);
        }
        if (ret instanceof JsonObject) {
            if (((JsonObject)ret).containsKey((Object)key)) {
                Object object = ((JsonObject)ret).get((Object)key);
                Intrinsics.checkNotNull((Object)object);
                return this.getNode((JsonElement)object, path, ++pos);
            }
            return null;
        }
        return ret;
    }

    private final JsonElement editElement(JsonElement source, List<String> fromPath, Function1<? super JsonElement, ? extends JsonElement> action) {
        List<String> pathToParent = fromPath.subList(0, fromPath.size() - 1);
        return this.findAndAction(source, pathToParent, 1, action);
    }

    private final JsonElement findAndAction(JsonElement ret, List<String> path, int pos_, Function1<? super JsonElement, ? extends JsonElement> action) {
        int pos = pos_;
        if (pos >= path.size()) {
            return (JsonElement)action.invoke((Object)ret);
        }
        String key = path.get(pos);
        if (ret instanceof JsonArray) {
            CharSequence charSequence = key;
            Regex regex = new Regex("\"");
            String string = "";
            int keyInt = Integer.parseInt(regex.replace(charSequence, string));
            return (JsonElement)JsonElementExtensionsKt.set((JsonArray)ret, keyInt, this.findAndAction(((JsonArray)ret).get(keyInt), path, ++pos, action));
        }
        if (ret instanceof JsonObject) {
            if (((JsonObject)ret).containsKey((Object)key)) {
                JsonObject jsonObject = (JsonObject)ret;
                Object object = ((JsonObject)ret).get((Object)key);
                Intrinsics.checkNotNull((Object)object);
                return (JsonElement)JsonElementExtensionsKt.set(jsonObject, key, this.findAndAction((JsonElement)object, path, ++pos, action));
            }
            return null;
        }
        return (JsonElement)action.invoke((Object)ret);
    }

    private final int arrayIndex(String s, int max) {
        int index = Integer.parseInt(s);
        if (index < 0) {
            throw new JsonPatchApplicationException("index Out of bound, index is negative");
        }
        if (index > max) {
            throw new JsonPatchApplicationException("index Out of bound, index is greater than " + max);
        }
        return index;
    }

    private final JsonObject addToObject(List<String> path, JsonElement node, JsonElement value) {
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
        JsonObject target = (JsonObject)node;
        CharSequence charSequence = path.get(path.size() - 1);
        Regex regex = new Regex("\"");
        String string = "";
        String key = regex.replace(charSequence, string);
        return JsonElementExtensionsKt.add(target, key, value);
    }

    private final JsonElement addToArray(List<String> path, JsonElement value, JsonElement parentNode) {
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonArray");
        JsonArray target = (JsonArray)parentNode;
        String idxStr = path.get(path.size() - 1);
        if (Intrinsics.areEqual((Object)"-", (Object)idxStr)) {
            target = JsonElementExtensionsKt.add(target, value);
        } else {
            CharSequence charSequence = idxStr;
            Regex regex = new Regex("\"");
            String string = "";
            int idx = this.arrayIndex(regex.replace(charSequence, string), target.size());
            target = JsonElementExtensionsKt.insert(target, idx, value);
        }
        return (JsonElement)target;
    }

    public static final /* synthetic */ int access$arrayIndex(JsonPatchEditingContextImpl $this, String s, int max) {
        return $this.arrayIndex(s, max);
    }

    public static final /* synthetic */ JsonElement access$getParentNode(JsonPatchEditingContextImpl $this, JsonElement source, List fromPath) {
        return $this.getParentNode(source, fromPath);
    }

    public static final /* synthetic */ JsonElement access$addToArray(JsonPatchEditingContextImpl $this, List path, JsonElement value, JsonElement parentNode) {
        return $this.addToArray(path, value, parentNode);
    }

    public static final /* synthetic */ JsonObject access$addToObject(JsonPatchEditingContextImpl $this, List path, JsonElement node, JsonElement value) {
        return $this.addToObject(path, node, value);
    }
}

