/*
 * Decompiled with CFR 0.152.
 */
package com.reidsync.kxjsonpatch.lcs;

import com.reidsync.kxjsonpatch.lcs.DefaultEquator;
import com.reidsync.kxjsonpatch.lcs.DeleteCommand;
import com.reidsync.kxjsonpatch.lcs.EditScript;
import com.reidsync.kxjsonpatch.lcs.Equator;
import com.reidsync.kxjsonpatch.lcs.InsertCommand;
import com.reidsync.kxjsonpatch.lcs.KeepCommand;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001bB5\b\u0007\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ6\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0002J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J*\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/reidsync/kxjsonpatch/lcs/SequencesComparator;", "T", "", "sequence1", "", "sequence2", "equator", "Lcom/reidsync/kxjsonpatch/lcs/Equator;", "(Ljava/util/List;Ljava/util/List;Lcom/reidsync/kxjsonpatch/lcs/Equator;)V", "vDown", "", "vUp", "buildScript", "", "start1", "", "end1", "start2", "end2", "script", "Lcom/reidsync/kxjsonpatch/lcs/EditScript;", "buildSnake", "Lcom/reidsync/kxjsonpatch/lcs/SequencesComparator$Snake;", "start", "diag", "getMiddleSnake", "getScript", "Snake", "kotlin-json-patch_debug"})
public final class SequencesComparator<T> {
    @NotNull
    private final List<T> sequence1;
    @NotNull
    private final List<T> sequence2;
    @NotNull
    private final Equator<? super T> equator;
    @NotNull
    private final int[] vDown;
    @NotNull
    private final int[] vUp;

    @JvmOverloads
    public SequencesComparator(@NotNull List<? extends T> sequence1, @NotNull List<? extends T> sequence2, @NotNull Equator<? super T> equator) {
        Intrinsics.checkNotNullParameter(sequence1, (String)"sequence1");
        Intrinsics.checkNotNullParameter(sequence2, (String)"sequence2");
        Intrinsics.checkNotNullParameter(equator, (String)"equator");
        this.sequence1 = sequence1;
        this.sequence2 = sequence2;
        this.equator = equator;
        int size = sequence1.size() + sequence2.size() + 2;
        this.vDown = new int[size];
        this.vUp = new int[size];
    }

    public /* synthetic */ SequencesComparator(List list, List list2, Equator equator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            equator = DefaultEquator.Companion.defaultEquator();
        }
        this(list, list2, equator);
    }

    @NotNull
    public final EditScript<T> getScript() {
        EditScript script = new EditScript();
        this.buildScript(0, this.sequence1.size(), 0, this.sequence2.size(), script);
        return script;
    }

    private final Snake buildSnake(int start, int diag, int end1, int end2) {
        int end;
        for (end = start; end - diag < end2 && end < end1 && this.equator.equate(this.sequence1.get(end), this.sequence2.get(end - diag)); ++end) {
        }
        return new Snake(start, end, diag);
    }

    private final Snake getMiddleSnake(int start1, int end1, int start2, int end2) {
        int m = end1 - start1;
        int n = end2 - start2;
        if (m == 0 || n == 0) {
            return null;
        }
        int delta = m - n;
        int sum = n + m;
        int offset = (sum % 2 == 0 ? sum : sum + 1) / 2;
        this.vDown[1 + offset] = start1;
        this.vUp[1 + offset] = end1 + 1;
        int d = 0;
        if (d <= offset) {
            while (true) {
                SequencesComparator $this$getMiddleSnake_u24lambda_u240 = this;
                boolean bl = false;
                for (int k = -d; k <= d; k += 2) {
                    int i = k + offset;
                    $this$getMiddleSnake_u24lambda_u240.vDown[i] = k == -d || k != d && $this$getMiddleSnake_u24lambda_u240.vDown[i - 1] < $this$getMiddleSnake_u24lambda_u240.vDown[i + 1] ? $this$getMiddleSnake_u24lambda_u240.vDown[i + 1] : $this$getMiddleSnake_u24lambda_u240.vDown[i - 1] + 1;
                    int x = $this$getMiddleSnake_u24lambda_u240.vDown[i];
                    for (int y = x - start1 + start2 - k; x < end1 && y < end2 && $this$getMiddleSnake_u24lambda_u240.equator.equate($this$getMiddleSnake_u24lambda_u240.sequence1.get(x), $this$getMiddleSnake_u24lambda_u240.sequence2.get(y)); ++y) {
                        $this$getMiddleSnake_u24lambda_u240.vDown[i] = ++x;
                    }
                    if (delta % 2 == 0 || delta - d > k || k > delta + d || $this$getMiddleSnake_u24lambda_u240.vUp[i - delta] > $this$getMiddleSnake_u24lambda_u240.vDown[i]) continue;
                    return $this$getMiddleSnake_u24lambda_u240.buildSnake($this$getMiddleSnake_u24lambda_u240.vUp[i - delta], k + start1 - start2, end1, end2);
                }
                for (int k = delta - d; k <= delta + d; k += 2) {
                    int i = k + offset - delta;
                    this.vUp[i] = k == delta - d || k != delta + d && this.vUp[i + 1] <= this.vUp[i - 1] ? this.vUp[i + 1] - 1 : this.vUp[i - 1];
                    int x = this.vUp[i] - 1;
                    for (int y = x - start1 + start2 - k; x >= start1 && y >= start2 && this.equator.equate(this.sequence1.get(x), this.sequence2.get(y)); --y) {
                        this.vUp[i] = x--;
                    }
                    if (delta % 2 != 0 || -d > k || k > d || this.vUp[i] > this.vDown[i + delta]) continue;
                    return this.buildSnake(this.vUp[i], k + start1 - start2, end1, end2);
                }
                if (d == offset) break;
                ++d;
            }
        }
        throw new RuntimeException("Internal Error");
    }

    private final void buildScript(int start1, int end1, int start2, int end2, EditScript<T> script) {
        Snake middle = this.getMiddleSnake(start1, end1, start2, end2);
        if (middle == null || middle.getStart() == end1 && middle.getDiag() == end1 - end2 || middle.getEnd() == start1 && middle.getDiag() == start1 - start2) {
            int i = start1;
            int j = start2;
            while (i < end1 || j < end2) {
                if (i < end1 && j < end2 && this.equator.equate(this.sequence1.get(i), this.sequence2.get(j))) {
                    script.append(new KeepCommand<T>(this.sequence1.get(i)));
                    ++i;
                    ++j;
                    continue;
                }
                if (end1 - start1 > end2 - start2) {
                    script.append(new DeleteCommand<T>(this.sequence1.get(i)));
                    ++i;
                    continue;
                }
                script.append(new InsertCommand<T>(this.sequence2.get(j)));
                ++j;
            }
        } else {
            this.buildScript(start1, middle.getStart(), start2, middle.getStart() - middle.getDiag(), script);
            int n = middle.getEnd();
            for (int i = middle.getStart(); i < n; ++i) {
                script.append(new KeepCommand<T>(this.sequence1.get(i)));
            }
            this.buildScript(middle.getEnd(), end1, middle.getEnd() - middle.getDiag(), end2, script);
        }
    }

    @JvmOverloads
    public SequencesComparator(@NotNull List<? extends T> sequence1, @NotNull List<? extends T> sequence2) {
        Intrinsics.checkNotNullParameter(sequence1, (String)"sequence1");
        Intrinsics.checkNotNullParameter(sequence2, (String)"sequence2");
        this(sequence1, sequence2, null, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/reidsync/kxjsonpatch/lcs/SequencesComparator$Snake;", "", "start", "", "end", "diag", "(III)V", "getDiag", "()I", "getEnd", "getStart", "kotlin-json-patch_debug"})
    private static final class Snake {
        private final int start;
        private final int end;
        private final int diag;

        public Snake(int start, int end, int diag) {
            this.start = start;
            this.end = end;
            this.diag = diag;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final int getDiag() {
            return this.diag;
        }
    }
}

