/*
 * Decompiled with CFR 0.152.
 */
package io.github.renefatuaki;

import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.codec.net.URLCodec;

public class OAuth1AuthorizationHeaderBuilder {
    private String consumerSecret;
    private String httpMethod;
    private String signingKey;
    private String tokenSecret;
    private String url;
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private final Map<String, String> queryParametersMap = new LinkedHashMap<String, String>();
    private static final URLCodec CODEC = new URLCodec();

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getQueryParametersMap() {
        return this.queryParametersMap;
    }

    public OAuth1AuthorizationHeaderBuilder addParameter(String name, String value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Parameter name cannot be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value cannot be null");
        }
        this.parameters.put(name, value);
        return this;
    }

    public OAuth1AuthorizationHeaderBuilder addQueryParameter(String queryParameter) {
        if (queryParameter == null || queryParameter.isEmpty()) {
            throw new IllegalArgumentException("Query parameter cannot be null or empty");
        }
        String[] parameterParts = queryParameter.split("=", 2);
        String key = parameterParts[0];
        String value = parameterParts.length > 1 ? parameterParts[1] : "";
        this.queryParametersMap.put(key, value);
        return this;
    }

    public OAuth1AuthorizationHeaderBuilder setConsumerSecret(String consumerSecret) {
        if (consumerSecret == null) {
            throw new IllegalArgumentException("Consumer secret cannot be null");
        }
        this.consumerSecret = consumerSecret;
        return this;
    }

    public OAuth1AuthorizationHeaderBuilder setHttpMethod(String method) {
        if (method == null || method.isEmpty()) {
            throw new IllegalArgumentException("Method cannot be null or empty");
        }
        this.httpMethod = method;
        return this;
    }

    public OAuth1AuthorizationHeaderBuilder setTokenSecret(String tokenSecret) {
        if (tokenSecret == null) {
            throw new IllegalArgumentException("Token secret cannot be null");
        }
        this.tokenSecret = tokenSecret;
        return this;
    }

    public OAuth1AuthorizationHeaderBuilder setUrl(String url) {
        if (url == null || url.isBlank()) {
            throw new IllegalArgumentException("URL cannot be null or empty");
        }
        int queryIndex = url.indexOf(63);
        if (queryIndex != -1) {
            this.url = url.substring(0, queryIndex);
            String query = url.substring(queryIndex + 1);
            this.handleQueryParam(query);
        } else {
            this.url = url;
        }
        return this;
    }

    public String build() {
        if (this.consumerSecret == null) {
            throw new IllegalArgumentException("Consumer secret cannot be null");
        }
        if (this.httpMethod == null || this.httpMethod.isEmpty()) {
            throw new IllegalArgumentException("Method cannot be null or empty");
        }
        if (this.url == null || this.url.isEmpty()) {
            throw new IllegalArgumentException("URL cannot be null or empty");
        }
        this.parameters.putIfAbsent("oauth_timestamp", String.valueOf(Instant.now().getEpochSecond()));
        this.parameters.put("oauth_nonce", this.generateNonce());
        this.parameters.put("oauth_signature_method", "HMAC-SHA1");
        this.parameters.put("oauth_version", "1.0");
        this.parameters.putAll(this.queryParametersMap);
        String parameterString = this.parameters.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(param -> this.encodeUriComponent((String)param.getKey()) + "=" + this.encodeUriComponent((String)param.getValue())).collect(Collectors.joining("&"));
        String signatureBaseString = this.httpMethod.toUpperCase() + "&" + this.encodeUriComponent(this.url) + "&" + this.encodeUriComponent(parameterString);
        if (this.signingKey == null) {
            this.signingKey = this.encodeUriComponent(this.consumerSecret) + "&" + (this.tokenSecret == null ? "" : this.encodeUriComponent(this.tokenSecret));
        }
        String signature = this.generateHmacSha1Signature(this.signingKey, signatureBaseString);
        this.parameters.put("oauth_signature", signature);
        return "OAuth " + this.parameters.entrySet().stream().map(param -> this.encodeUriComponent((String)param.getKey()) + "=\"" + this.encodeUriComponent((String)param.getValue()) + "\"").collect(Collectors.joining(", "));
    }

    private String encodeUriComponent(String uriComponent) {
        try {
            return CODEC.encode(uriComponent);
        }
        catch (EncoderException e) {
            throw new RuntimeException(e);
        }
    }

    private String generateHmacSha1Signature(String secret, String message) {
        byte[] hmacSha1Bytes = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, secret).hmac(message);
        return Base64.getEncoder().encodeToString(hmacSha1Bytes);
    }

    private String generateNonce() {
        StringBuilder randomDigits = new StringBuilder(15);
        SecureRandom secureRandom = new SecureRandom();
        for (int i = 0; i < 15; ++i) {
            randomDigits.append(secureRandom.nextInt(10));
        }
        return DigestUtils.md5Hex((String)randomDigits.toString());
    }

    private void handleQueryParam(String query) {
        if (query == null || query.isBlank()) {
            return;
        }
        Arrays.stream(query.split("&")).forEach(this::addQueryParameter);
    }
}

