/*
 * Decompiled with CFR 0.152.
 */
package io.github.rerorero.kafka.jsonpath;

import io.github.rerorero.kafka.jsonpath.ErrorListener;
import io.github.rerorero.kafka.jsonpath.JsonPathException;
import io.github.rerorero.kafka.jsonpath.ParserListener;
import io.github.rerorero.kafka.jsonpath.parser.JsonPathLexer;
import io.github.rerorero.kafka.jsonpath.parser.JsonPathParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.kafka.connect.errors.DataException;

abstract class AccessorBase {
    AccessorBase() {
    }

    protected static <S> List<ParserListener.Task<S>> parse(String jsonPath, ParserListener.TaskGen<S> taskGen) {
        ErrorListener errorListener = new ErrorListener();
        CodePointCharStream cs = CharStreams.fromString((String)jsonPath);
        JsonPathLexer lexer = new JsonPathLexer((CharStream)cs);
        lexer.addErrorListener(errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JsonPathParser parser = new JsonPathParser((TokenStream)tokens);
        parser.addErrorListener(errorListener);
        ParserListener<S> listner = new ParserListener<S>(taskGen);
        ParseTreeWalker walker = ParseTreeWalker.DEFAULT;
        walker.walk(listner, (ParseTree)parser.jsonpath());
        errorListener.throwIfError(jsonPath);
        return listner.getTasks();
    }

    protected static <S> void runTasks(S state, List<ParserListener.Task<S>> tasks) {
        for (ParserListener.Task<S> task : tasks) {
            task.apply(state);
        }
    }

    protected static String pathOfObjectSub(String base, String keyName) {
        return base + "." + keyName;
    }

    protected static String pathOfArraySub(String base, int index) {
        return base + "[" + index + "]";
    }

    protected static Map<String, Object> mapSubscriptArray(Map<String, Object> pathMap, int index, Function<ArraySubUpdateParam, Object> onSubscript) {
        HashMap<String, Object> updated = new HashMap<String, Object>();
        pathMap.forEach((path, cur) -> {
            if (!(cur instanceof List)) {
                throw new JsonPathException("field '" + path + "' is not an array but " + cur.getClass());
            }
            List curList = (List)cur;
            for (int i = 0; i < curList.size(); ++i) {
                if (index >= 0 && index != i) continue;
                String childPath = AccessorBase.pathOfArraySub(path, i);
                try {
                    Object child = onSubscript.apply(new ArraySubUpdateParam(childPath, i, curList));
                    updated.put(childPath, child);
                    continue;
                }
                catch (DataException e) {
                    throw new JsonPathException("An error occurred during processing of Array '" + childPath + "': " + e.getMessage(), e);
                }
            }
        });
        return updated;
    }

    protected static class ArraySubUpdateParam {
        final String path;
        final int index;
        final List<Object> parent;

        ArraySubUpdateParam(String path, int index, List<Object> parent) {
            this.path = path;
            this.index = index;
            this.parent = parent;
        }
    }
}

