/*
 * Decompiled with CFR 0.152.
 */
package io.github.rerorero.kafka.jsonpath;

import io.github.rerorero.kafka.jsonpath.Accessor;
import io.github.rerorero.kafka.jsonpath.AccessorBase;
import io.github.rerorero.kafka.jsonpath.JsonPathException;
import io.github.rerorero.kafka.jsonpath.ParserListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;

public class MapAccessor
extends AccessorBase {
    private static final ParserListener.TaskGen<GetTaskState> getTaskGen = new GetTaskGen();
    private static final ParserListener.TaskGen<UpdateTaskState> updateTaskGen = new UpdateTaskGen();

    private static Map<String, Object> copyMap(Map<String, Object> org) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        org.forEach((key, value) -> {
            Object obj = org.get(key);
            if (obj == null) {
                return;
            }
            Schema.Type inferredType = ConnectSchema.schemaType(obj.getClass());
            switch (inferredType) {
                case INT32: 
                case INT64: 
                case FLOAT32: 
                case FLOAT64: 
                case BOOLEAN: 
                case STRING: 
                case BYTES: {
                    newMap.put((String)key, obj);
                    return;
                }
                case MAP: {
                    newMap.put((String)key, MapAccessor.copyMap((Map)obj));
                    return;
                }
                case ARRAY: {
                    newMap.put((String)key, MapAccessor.copyArray(key, (List)obj));
                    return;
                }
            }
            throw new JsonPathException(value.getClass() + " is not supported for schemaless record field " + key);
        });
        return newMap;
    }

    private static List<Object> copyArray(String key, List<Object> org) {
        return org.stream().map(o -> {
            Schema.Type inferredType = ConnectSchema.schemaType(o.getClass());
            switch (inferredType) {
                case INT32: 
                case INT64: 
                case FLOAT32: 
                case FLOAT64: 
                case BOOLEAN: 
                case STRING: 
                case BYTES: {
                    return o;
                }
                case MAP: {
                    return MapAccessor.copyMap((Map)o);
                }
            }
            throw new JsonPathException(o.getClass() + " is not supported for the element of array field " + key);
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> mapObjectSubscript(Map<String, Object> pathMap, String keyName, Function<ObjectSubUpdateParam, Object> onSubscript) {
        HashMap<String, Object> updated = new HashMap<String, Object>();
        pathMap.forEach((path, cur) -> {
            String childPath = MapAccessor.pathOfObjectSub(path, keyName);
            if (!(cur instanceof Map)) {
                throw new JsonPathException("field '" + childPath + "' is not a Map but " + cur.getClass());
            }
            try {
                Object child = onSubscript.apply(new ObjectSubUpdateParam(childPath, keyName, (Map)cur));
                if (child != null) {
                    updated.put(childPath, child);
                }
            }
            catch (DataException e) {
                throw new JsonPathException("An error occurred during processing of Map value '" + childPath + "': " + e.getMessage(), e);
            }
        });
        return updated;
    }

    private static class UpdateTaskGen
    implements ParserListener.TaskGen<UpdateTaskState> {
        private UpdateTaskGen() {
        }

        @Override
        public ParserListener.Task<UpdateTaskState> subscriptObject(String keyName) {
            return state -> {
                state.pathMap = MapAccessor.mapObjectSubscript(state.pathMap, keyName, param -> {
                    Object newVal = state.getNewValue(param.path);
                    if (newVal != null) {
                        param.parent.put(param.key, newVal);
                        return newVal;
                    }
                    return param.parent.get(param.key);
                });
            };
        }

        @Override
        public ParserListener.Task<UpdateTaskState> subscriptArray(int index) {
            return state -> {
                state.pathMap = AccessorBase.mapSubscriptArray(state.pathMap, index, param -> {
                    Object newVal = state.getNewValue(param.path);
                    if (newVal != null) {
                        param.parent.set(param.index, newVal);
                        return newVal;
                    }
                    return param.parent.get(param.index);
                });
            };
        }
    }

    private static class UpdateTaskState {
        private final Map<String, Object> newValue;
        Map<String, Object> pathMap;

        UpdateTaskState(Map<String, Object> org, Map<String, Object> newValue) {
            this.newValue = newValue;
            this.pathMap = Collections.singletonMap("$", org);
        }

        Object getNewValue(String path) {
            return this.newValue.get(path);
        }
    }

    private static class GetTaskGen
    implements ParserListener.TaskGen<GetTaskState> {
        private GetTaskGen() {
        }

        @Override
        public ParserListener.Task<GetTaskState> subscriptObject(String keyName) {
            return state -> {
                state.pathMap = MapAccessor.mapObjectSubscript(state.pathMap, keyName, param -> param.parent.get(param.key));
            };
        }

        @Override
        public ParserListener.Task<GetTaskState> subscriptArray(int index) {
            return state -> {
                state.pathMap = AccessorBase.mapSubscriptArray(state.pathMap, index, param -> param.parent.get(param.index));
            };
        }
    }

    private static class ObjectSubUpdateParam {
        final String path;
        final String key;
        final Map<String, Object> parent;

        ObjectSubUpdateParam(String path, String key, Map<String, Object> parent) {
            this.path = path;
            this.key = key;
            this.parent = parent;
        }
    }

    private static class GetTaskState {
        Map<String, Object> pathMap;

        GetTaskState(Map<String, Object> org) {
            this.pathMap = Collections.singletonMap("$", org);
        }
    }

    public static class Updater
    implements Accessor.Updater<Map<String, Object>> {
        private final List<ParserListener.Task<UpdateTaskState>> tasks;

        public Updater(String jsonPath) {
            this.tasks = AccessorBase.parse(jsonPath, updateTaskGen);
        }

        @Override
        public Map<String, Object> run(Map<String, Object> org, Map<String, Object> valueToUpdate) {
            Map updated = MapAccessor.copyMap(org);
            if (valueToUpdate.isEmpty()) {
                return updated;
            }
            UpdateTaskState state = new UpdateTaskState(updated, valueToUpdate);
            AccessorBase.runTasks(state, this.tasks);
            return updated;
        }
    }

    public static class Getter
    implements Accessor.Getter<Map<String, Object>> {
        private final List<ParserListener.Task<GetTaskState>> tasks;

        public Getter(String jsonPath) {
            this.tasks = AccessorBase.parse(jsonPath, getTaskGen);
        }

        @Override
        public Map<String, Object> run(Map<String, Object> m) {
            GetTaskState state = new GetTaskState(m);
            AccessorBase.runTasks(state, this.tasks);
            return state.pathMap;
        }
    }
}

