/*
 * Decompiled with CFR 0.152.
 */
package io.github.rerorero.kafka.jsonpath;

import io.github.rerorero.kafka.jsonpath.parser.JsonPathBaseListener;
import io.github.rerorero.kafka.jsonpath.parser.JsonPathParser;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;

class ParserListener<S>
extends JsonPathBaseListener {
    private final TaskGen<S> taskGen;
    private final List<Task<S>> tasks = new ArrayList<Task<S>>();

    ParserListener(TaskGen<S> taskGen) {
        this.taskGen = taskGen;
    }

    List<Task<S>> getTasks() {
        return this.tasks;
    }

    private String unquoteSTRING(TerminalNode node) {
        String s = node.getText();
        return s.substring(1, s.length() - 1);
    }

    private void parseArraySubscript(JsonPathParser.ArraySubContext ctx) {
        if (ctx == null) {
            return;
        }
        if (ctx.NUMBER() != null) {
            this.tasks.add(this.taskGen.subscriptArray(Integer.parseInt(ctx.NUMBER().getText())));
        } else if (ctx.WILDCARD() != null) {
            this.tasks.add(this.taskGen.subscriptArray(-1));
        }
    }

    @Override
    public void exitSubscriptBracket(JsonPathParser.SubscriptBracketContext ctx) {
        String field = this.unquoteSTRING(ctx.STRING());
        this.tasks.add(this.taskGen.subscriptObject(field));
        this.parseArraySubscript(ctx.arraySub());
    }

    @Override
    public void exitSubscriptDot(JsonPathParser.SubscriptDotContext ctx) {
        this.tasks.add(this.taskGen.subscriptObject(ctx.ID().toString()));
        this.parseArraySubscript(ctx.arraySub());
    }

    static interface TaskGen<S> {
        public Task<S> subscriptObject(String var1);

        public Task<S> subscriptArray(int var1);
    }

    static interface Task<S> {
        public void apply(S var1);
    }
}

