/*
 * Decompiled with CFR 0.152.
 */
package io.github.rerorero.kafka.jsonpath;

import io.github.rerorero.kafka.jsonpath.Accessor;
import io.github.rerorero.kafka.jsonpath.AccessorBase;
import io.github.rerorero.kafka.jsonpath.JsonPathException;
import io.github.rerorero.kafka.jsonpath.ParserListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class StructAccessor
extends AccessorBase {
    private static final ParserListener.TaskGen<GetTaskState> getTaskGen = new GetTaskGen();
    private static final ParserListener.TaskGen<UpdateTaskState> updateTaskGen = new UpdateTaskGen();

    private static Struct copyStruct(Struct org) {
        Struct newStruct = new Struct(org.schema());
        block5: for (Field field : org.schema().fields()) {
            Object obj = org.get(field);
            if (obj == null) continue;
            Schema fieldSchema = field.schema();
            switch (fieldSchema.type()) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT32: 
                case FLOAT64: 
                case BOOLEAN: 
                case STRING: 
                case BYTES: {
                    newStruct.put(field, obj);
                    continue block5;
                }
                case STRUCT: {
                    newStruct.put(field, (Object)StructAccessor.copyStruct((Struct)obj));
                    continue block5;
                }
                case ARRAY: {
                    newStruct.put(field, StructAccessor.copyArray((List)obj, field));
                    continue block5;
                }
            }
            throw new JsonPathException(fieldSchema.type() + " is not supported for field " + field.name());
        }
        return newStruct;
    }

    private static List<Object> copyArray(List<Object> org, Field field) {
        Schema valueSchema = field.schema().valueSchema();
        return org.stream().map(o -> {
            switch (valueSchema.type()) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT32: 
                case FLOAT64: 
                case BOOLEAN: 
                case STRING: 
                case BYTES: {
                    return o;
                }
                case STRUCT: {
                    return StructAccessor.copyStruct((Struct)o);
                }
            }
            throw new JsonPathException(valueSchema.type() + " is not supported for field " + field.name());
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> mapObjectSubscript(Map<String, Object> pathMap, String keyName, Function<ObjectSubUpdateParam, Object> onSubscript) {
        HashMap<String, Object> updated = new HashMap<String, Object>();
        pathMap.forEach((path, cur) -> {
            String childPath = StructAccessor.pathOfObjectSub(path, keyName);
            if (!(cur instanceof Struct)) {
                throw new JsonPathException("field '" + childPath + "' is not a Struct but " + cur.getClass());
            }
            try {
                Struct parent = (Struct)cur;
                if (parent.schema().field(keyName) == null) {
                    return;
                }
                Object child = onSubscript.apply(new ObjectSubUpdateParam(childPath, keyName, parent));
                if (child != null) {
                    updated.put(childPath, child);
                }
            }
            catch (DataException e) {
                throw new JsonPathException("An error occurred during processing of Struct field '" + childPath + "': " + e.getMessage(), e);
            }
        });
        return updated;
    }

    private static class UpdateTaskGen
    implements ParserListener.TaskGen<UpdateTaskState> {
        private UpdateTaskGen() {
        }

        @Override
        public ParserListener.Task<UpdateTaskState> subscriptObject(String keyName) {
            return state -> {
                state.pathMap = StructAccessor.mapObjectSubscript(state.pathMap, keyName, param -> {
                    Object newVal = state.getNewValue(param.path);
                    if (newVal != null) {
                        param.parent.put(param.key, newVal);
                        return newVal;
                    }
                    return param.parent.get(param.key);
                });
            };
        }

        @Override
        public ParserListener.Task<UpdateTaskState> subscriptArray(int index) {
            return state -> {
                state.pathMap = AccessorBase.mapSubscriptArray(state.pathMap, index, param -> {
                    Object newVal = state.getNewValue(param.path);
                    if (newVal != null) {
                        param.parent.set(param.index, newVal);
                        return newVal;
                    }
                    return param.parent.get(param.index);
                });
            };
        }
    }

    private static class UpdateTaskState {
        private final Map<String, Object> newValue;
        Map<String, Object> pathMap;

        UpdateTaskState(Struct org, Map<String, Object> newValue) {
            this.newValue = newValue;
            this.pathMap = Collections.singletonMap("$", org);
        }

        Object getNewValue(String path) {
            return this.newValue.get(path);
        }
    }

    private static class GetTaskGen
    implements ParserListener.TaskGen<GetTaskState> {
        private GetTaskGen() {
        }

        @Override
        public ParserListener.Task<GetTaskState> subscriptObject(String keyName) {
            return state -> {
                state.pathMap = StructAccessor.mapObjectSubscript(state.pathMap, keyName, param -> param.parent.get(param.key));
            };
        }

        @Override
        public ParserListener.Task<GetTaskState> subscriptArray(int index) {
            return state -> {
                state.pathMap = AccessorBase.mapSubscriptArray(state.pathMap, index, param -> param.parent.get(param.index));
            };
        }
    }

    private static class ObjectSubUpdateParam {
        final String path;
        final String key;
        final Struct parent;

        ObjectSubUpdateParam(String path, String key, Struct parent) {
            this.path = path;
            this.key = key;
            this.parent = parent;
        }
    }

    private static class GetTaskState {
        Map<String, Object> pathMap;

        GetTaskState(Struct org) {
            this.pathMap = Collections.singletonMap("$", org);
        }
    }

    public static class Updater
    implements Accessor.Updater<Struct> {
        private final List<ParserListener.Task<UpdateTaskState>> tasks;

        public Updater(String jsonPath) {
            this.tasks = AccessorBase.parse(jsonPath, updateTaskGen);
        }

        @Override
        public Struct run(Struct org, Map<String, Object> valueToUpdate) {
            Struct updated = StructAccessor.copyStruct(org);
            if (valueToUpdate.isEmpty()) {
                return updated;
            }
            UpdateTaskState state = new UpdateTaskState(updated, valueToUpdate);
            AccessorBase.runTasks(state, this.tasks);
            return updated;
        }
    }

    public static class Getter
    implements Accessor.Getter<Struct> {
        private final List<ParserListener.Task<GetTaskState>> tasks;

        public Getter(String jsonPath) {
            this.tasks = AccessorBase.parse(jsonPath, getTaskGen);
        }

        @Override
        public Map<String, Object> run(Struct s) {
            GetTaskState state = new GetTaskState(s);
            AccessorBase.runTasks(state, this.tasks);
            return state.pathMap;
        }
    }
}

