/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;

public class BulkheadFullException
extends RuntimeException {
    public static BulkheadFullException createBulkheadFullException(Bulkhead bulkhead) {
        boolean writableStackTraceEnabled = bulkhead.getBulkheadConfig().isWritableStackTraceEnabled();
        String message = Thread.currentThread().isInterrupted() ? String.format("Bulkhead '%s' is full and thread was interrupted during permission wait", bulkhead.getName()) : String.format("Bulkhead '%s' is full and does not permit further calls", bulkhead.getName());
        return new BulkheadFullException(message, writableStackTraceEnabled);
    }

    public static BulkheadFullException createBulkheadFullException(ThreadPoolBulkhead bulkhead) {
        boolean writableStackTraceEnabled = bulkhead.getBulkheadConfig().isWritableStackTraceEnabled();
        String message = String.format("Bulkhead '%s' is full and does not permit further calls", bulkhead.getName());
        return new BulkheadFullException(message, writableStackTraceEnabled);
    }

    private BulkheadFullException(String message, boolean writableStackTrace) {
        super(message, null, false, writableStackTrace);
    }
}

