/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnCallNotPermittedEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnIgnoredErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnStateTransitionEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSuccessEvent;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerState;
import io.github.resilience4j.circuitbreaker.internal.ClosedState;
import io.github.resilience4j.circuitbreaker.internal.HalfOpenState;
import io.github.resilience4j.circuitbreaker.internal.OpenState;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CircuitBreakerStateMachine
implements CircuitBreaker {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakerStateMachine.class);
    private final String name;
    private final AtomicReference<CircuitBreakerState> stateReference;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final CircuitBreakerEventProcessor eventProcessor;

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig) {
        this.name = name;
        this.circuitBreakerConfig = circuitBreakerConfig;
        this.stateReference = new AtomicReference<ClosedState>(new ClosedState(this));
        this.eventProcessor = new CircuitBreakerEventProcessor();
    }

    public CircuitBreakerStateMachine(String name) {
        this(name, CircuitBreakerConfig.ofDefaults());
    }

    public CircuitBreakerStateMachine(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfig) {
        this(name, circuitBreakerConfig.get());
    }

    @Override
    public boolean isCallPermitted() {
        boolean callPermitted = this.stateReference.get().isCallPermitted();
        if (!callPermitted) {
            this.publishCallNotPermittedEvent();
        }
        return callPermitted;
    }

    @Override
    public void onError(long durationInNanos, Throwable throwable) {
        if (this.circuitBreakerConfig.getRecordFailurePredicate().test(throwable)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("CircuitBreaker '%s' recorded a failure:", this.name), throwable);
            }
            this.publishCircuitErrorEvent(this.name, durationInNanos, throwable);
            this.stateReference.get().onError(throwable);
        } else {
            this.publishCircuitIgnoredErrorEvent(this.name, durationInNanos, throwable);
        }
    }

    @Override
    public void onSuccess(long durationInNanos) {
        this.publishSuccessEvent(durationInNanos);
        this.stateReference.get().onSuccess();
    }

    @Override
    public CircuitBreaker.State getState() {
        return this.stateReference.get().getState();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    @Override
    public CircuitBreaker.Metrics getMetrics() {
        return this.stateReference.get().getMetrics();
    }

    public String toString() {
        return String.format("CircuitBreaker '%s'", this.name);
    }

    @Override
    public void transitionToClosedState() {
        CircuitBreakerState previousState = this.stateReference.getAndUpdate(currentState -> {
            if (currentState.getState() == CircuitBreaker.State.CLOSED) {
                return currentState;
            }
            return new ClosedState(this, currentState.getMetrics());
        });
        if (previousState.getState() != CircuitBreaker.State.CLOSED) {
            this.publishStateTransitionEvent(CircuitBreaker.StateTransition.transitionToClosedState(previousState.getState()));
        }
    }

    @Override
    public void transitionToOpenState() {
        CircuitBreakerState previousState = this.stateReference.getAndUpdate(currentState -> {
            if (currentState.getState() == CircuitBreaker.State.OPEN) {
                return currentState;
            }
            return new OpenState(this, currentState.getMetrics());
        });
        if (previousState.getState() != CircuitBreaker.State.OPEN) {
            this.publishStateTransitionEvent(CircuitBreaker.StateTransition.transitionToOpenState(previousState.getState()));
        }
    }

    @Override
    public void transitionToHalfOpenState() {
        CircuitBreakerState previousState = this.stateReference.getAndUpdate(currentState -> {
            if (currentState.getState() == CircuitBreaker.State.HALF_OPEN) {
                return currentState;
            }
            return new HalfOpenState(this);
        });
        if (previousState.getState() != CircuitBreaker.State.HALF_OPEN) {
            this.publishStateTransitionEvent(CircuitBreaker.StateTransition.transitionToHalfOpenState(previousState.getState()));
        }
    }

    private void publishStateTransitionEvent(CircuitBreaker.StateTransition stateTransition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("CircuitBreaker '%s' changed state from %s to %s", new Object[]{this.name, stateTransition.getFromState(), stateTransition.getToState()}));
        }
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(new CircuitBreakerOnStateTransitionEvent(this.name, stateTransition));
        }
    }

    private void publishCallNotPermittedEvent() {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(new CircuitBreakerOnCallNotPermittedEvent(this.name));
        }
    }

    private void publishSuccessEvent(long durationInNanos) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(new CircuitBreakerOnSuccessEvent(this.name, Duration.ofNanos(durationInNanos)));
        }
    }

    private void publishCircuitErrorEvent(String name, long durationInNanos, Throwable throwable) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(new CircuitBreakerOnErrorEvent(name, Duration.ofNanos(durationInNanos), throwable));
        }
    }

    private void publishCircuitIgnoredErrorEvent(String name, long durationInNanos, Throwable throwable) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(new CircuitBreakerOnIgnoredErrorEvent(name, Duration.ofNanos(durationInNanos), throwable));
        }
    }

    @Override
    public CircuitBreaker.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    private class CircuitBreakerEventProcessor
    extends EventProcessor<CircuitBreakerEvent>
    implements EventConsumer<CircuitBreakerEvent>,
    CircuitBreaker.EventPublisher {
        private CircuitBreakerEventProcessor() {
        }

        @Override
        public CircuitBreaker.EventPublisher onSuccess(EventConsumer<CircuitBreakerOnSuccessEvent> onSuccessEventConsumer) {
            this.registerConsumer(CircuitBreakerOnSuccessEvent.class, onSuccessEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onError(EventConsumer<CircuitBreakerOnErrorEvent> onErrorEventConsumer) {
            this.registerConsumer(CircuitBreakerOnErrorEvent.class, onErrorEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onStateTransition(EventConsumer<CircuitBreakerOnStateTransitionEvent> onStateTransitionEventConsumer) {
            this.registerConsumer(CircuitBreakerOnStateTransitionEvent.class, onStateTransitionEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onIgnoredError(EventConsumer<CircuitBreakerOnIgnoredErrorEvent> onIgnoredErrorEventConsumer) {
            this.registerConsumer(CircuitBreakerOnIgnoredErrorEvent.class, onIgnoredErrorEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onCallNotPermitted(EventConsumer<CircuitBreakerOnCallNotPermittedEvent> onCallNotPermittedEventConsumer) {
            this.registerConsumer(CircuitBreakerOnCallNotPermittedEvent.class, onCallNotPermittedEventConsumer);
            return this;
        }

        public void consumeEvent(CircuitBreakerEvent event) {
            super.processEvent((Object)event);
        }
    }
}

