/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public final class InMemoryCircuitBreakerRegistry
implements CircuitBreakerRegistry {
    private final CircuitBreakerConfig defaultCircuitBreakerConfig;
    private final ConcurrentMap<String, CircuitBreaker> circuitBreakers;

    public InMemoryCircuitBreakerRegistry() {
        this.defaultCircuitBreakerConfig = CircuitBreakerConfig.ofDefaults();
        this.circuitBreakers = new ConcurrentHashMap<String, CircuitBreaker>();
    }

    public InMemoryCircuitBreakerRegistry(CircuitBreakerConfig defaultCircuitBreakerConfig) {
        this.defaultCircuitBreakerConfig = Objects.requireNonNull(defaultCircuitBreakerConfig, "CircuitBreakerConfig must not be null");
        this.circuitBreakers = new ConcurrentHashMap<String, CircuitBreaker>();
    }

    @Override
    public Seq<CircuitBreaker> getAllCircuitBreakers() {
        return Array.ofAll(this.circuitBreakers.values());
    }

    @Override
    public CircuitBreaker circuitBreaker(String name) {
        return this.circuitBreakers.computeIfAbsent(Objects.requireNonNull(name, "Name must not be null"), k -> CircuitBreaker.of(name, this.defaultCircuitBreakerConfig));
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, CircuitBreakerConfig customCircuitBreakerConfig) {
        return this.circuitBreakers.computeIfAbsent(Objects.requireNonNull(name, "Name must not be null"), k -> CircuitBreaker.of(name, customCircuitBreakerConfig));
    }

    @Override
    public CircuitBreaker circuitBreaker(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier) {
        return this.circuitBreakers.computeIfAbsent(Objects.requireNonNull(name, "Name must not be null"), k -> CircuitBreaker.of(name, (CircuitBreakerConfig)circuitBreakerConfigSupplier.get()));
    }
}

