/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerOpenException;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnCallNotPermittedEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnIgnoredErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnStateTransitionEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSuccessEvent;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import io.github.resilience4j.circuitbreaker.utils.CircuitBreakerUtils;
import io.github.resilience4j.core.EventConsumer;
import io.vavr.CheckedConsumer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface CircuitBreaker {
    public boolean isCallPermitted();

    public void onError(long var1, Throwable var3);

    public void onSuccess(long var1);

    public void transitionToClosedState();

    public void transitionToOpenState();

    public void transitionToHalfOpenState();

    public String getName();

    public State getState();

    public CircuitBreakerConfig getCircuitBreakerConfig();

    public Metrics getMetrics();

    public EventPublisher getEventPublisher();

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return CircuitBreaker.decorateSupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return CircuitBreaker.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        CircuitBreaker.decorateRunnable(this, runnable).run();
    }

    default public <T> CompletionStage<T> executeCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return CircuitBreaker.decorateCompletionStage(this, supplier).get();
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(CircuitBreaker circuitBreaker, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            CircuitBreakerUtils.isCallPermitted(circuitBreaker);
            long start = System.nanoTime();
            try {
                Object returnValue = supplier.apply();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Throwable throwable) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, throwable);
                throw throwable;
            }
        };
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(CircuitBreaker circuitBreaker, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            if (!circuitBreaker.isCallPermitted()) {
                promise.completeExceptionally(new CircuitBreakerOpenException(String.format("CircuitBreaker '%s' is open", circuitBreaker.getName())));
            } else {
                long start = System.nanoTime();
                try {
                    ((CompletionStage)supplier.get()).whenComplete((result, throwable) -> {
                        long durationInNanos = System.nanoTime() - start;
                        if (throwable != null) {
                            circuitBreaker.onError(durationInNanos, (Throwable)throwable);
                            promise.completeExceptionally((Throwable)throwable);
                        } else {
                            circuitBreaker.onSuccess(durationInNanos);
                            promise.complete(result);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    long durationInNanos = System.nanoTime() - start;
                    circuitBreaker.onError(durationInNanos, throwable2);
                    throw throwable2;
                }
            }
            return promise;
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(CircuitBreaker circuitBreaker, CheckedRunnable runnable) {
        return () -> {
            CircuitBreakerUtils.isCallPermitted(circuitBreaker);
            long start = System.nanoTime();
            try {
                runnable.run();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
            }
            catch (Throwable throwable) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, throwable);
                throw throwable;
            }
        };
    }

    public static <T> Callable<T> decorateCallable(CircuitBreaker circuitBreaker, Callable<T> callable) {
        return () -> {
            CircuitBreakerUtils.isCallPermitted(circuitBreaker);
            long start = System.nanoTime();
            try {
                Object returnValue = callable.call();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Throwable throwable) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, throwable);
                throw throwable;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(CircuitBreaker circuitBreaker, Supplier<T> supplier) {
        return () -> {
            CircuitBreakerUtils.isCallPermitted(circuitBreaker);
            long start = System.nanoTime();
            try {
                Object returnValue = supplier.get();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Throwable throwable) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, throwable);
                throw throwable;
            }
        };
    }

    public static <T> Consumer<T> decorateConsumer(CircuitBreaker circuitBreaker, Consumer<T> consumer) {
        return t -> {
            CircuitBreakerUtils.isCallPermitted(circuitBreaker);
            long start = System.nanoTime();
            try {
                consumer.accept(t);
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
            }
            catch (Throwable throwable) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, throwable);
                throw throwable;
            }
        };
    }

    public static <T> CheckedConsumer<T> decorateCheckedConsumer(CircuitBreaker circuitBreaker, CheckedConsumer<T> consumer) {
        return t -> {
            CircuitBreakerUtils.isCallPermitted(circuitBreaker);
            long start = System.nanoTime();
            try {
                consumer.accept(t);
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
            }
            catch (Throwable throwable) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, throwable);
                throw throwable;
            }
        };
    }

    public static Runnable decorateRunnable(CircuitBreaker circuitBreaker, Runnable runnable) {
        return () -> {
            CircuitBreakerUtils.isCallPermitted(circuitBreaker);
            long start = System.nanoTime();
            try {
                runnable.run();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
            }
            catch (Throwable throwable) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, throwable);
                throw throwable;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(CircuitBreaker circuitBreaker, Function<T, R> function) {
        return t -> {
            CircuitBreakerUtils.isCallPermitted(circuitBreaker);
            long start = System.nanoTime();
            try {
                Object returnValue = function.apply(t);
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Throwable throwable) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, throwable);
                throw throwable;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(CircuitBreaker circuitBreaker, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            CircuitBreakerUtils.isCallPermitted(circuitBreaker);
            long start = System.nanoTime();
            try {
                Object returnValue = function.apply(t);
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Throwable throwable) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, throwable);
                throw throwable;
            }
        };
    }

    public static CircuitBreaker ofDefaults(String name) {
        return new CircuitBreakerStateMachine(name);
    }

    public static CircuitBreaker of(String name, CircuitBreakerConfig circuitBreakerConfig) {
        return new CircuitBreakerStateMachine(name, circuitBreakerConfig);
    }

    public static CircuitBreaker of(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier) {
        return new CircuitBreakerStateMachine(name, circuitBreakerConfigSupplier);
    }

    public static interface Metrics {
        public float getFailureRate();

        public int getNumberOfBufferedCalls();

        public int getNumberOfFailedCalls();

        public long getNumberOfNotPermittedCalls();

        public int getMaxNumberOfBufferedCalls();

        public int getNumberOfSuccessfulCalls();
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<CircuitBreakerEvent> {
        public EventPublisher onSuccess(EventConsumer<CircuitBreakerOnSuccessEvent> var1);

        public EventPublisher onError(EventConsumer<CircuitBreakerOnErrorEvent> var1);

        public EventPublisher onStateTransition(EventConsumer<CircuitBreakerOnStateTransitionEvent> var1);

        public EventPublisher onIgnoredError(EventConsumer<CircuitBreakerOnIgnoredErrorEvent> var1);

        public EventPublisher onCallNotPermitted(EventConsumer<CircuitBreakerOnCallNotPermittedEvent> var1);
    }

    public static enum StateTransition {
        CLOSED_TO_OPEN(State.CLOSED, State.OPEN),
        HALF_OPEN_TO_CLOSED(State.HALF_OPEN, State.CLOSED),
        HALF_OPEN_TO_OPEN(State.HALF_OPEN, State.OPEN),
        OPEN_TO_HALF_OPEN(State.OPEN, State.HALF_OPEN),
        FORCED_OPEN_TO_CLOSED(State.OPEN, State.CLOSED);

        State fromState;
        State toState;

        private StateTransition(State fromState, State toState) {
            this.fromState = fromState;
            this.toState = toState;
        }

        public State getFromState() {
            return this.fromState;
        }

        public State getToState() {
            return this.toState;
        }

        public static StateTransition transitionToClosedState(State fromState) {
            switch (fromState) {
                case HALF_OPEN: {
                    return HALF_OPEN_TO_CLOSED;
                }
                case OPEN: {
                    return FORCED_OPEN_TO_CLOSED;
                }
            }
            throw new IllegalStateException(String.format("Illegal state transition from %s to %s", fromState.toString(), State.CLOSED.toString()));
        }

        public static StateTransition transitionToOpenState(State fromState) {
            switch (fromState) {
                case HALF_OPEN: {
                    return HALF_OPEN_TO_OPEN;
                }
                case CLOSED: {
                    return CLOSED_TO_OPEN;
                }
            }
            throw new IllegalStateException(String.format("Illegal state transition from %s to %s", fromState.toString(), State.OPEN.toString()));
        }

        public static StateTransition transitionToHalfOpenState(State fromState) {
            switch (fromState) {
                case OPEN: {
                    return OPEN_TO_HALF_OPEN;
                }
            }
            throw new IllegalStateException(String.format("Illegal state transition from %s to %s", fromState.toString(), State.HALF_OPEN.toString()));
        }

        public String toString() {
            return String.format("State transition from %s to %s", new Object[]{this.fromState, this.toState});
        }
    }

    public static enum State {
        CLOSED(0),
        OPEN(1),
        HALF_OPEN(2);

        private final int order;

        private State(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

