/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.internal.AutoTransitioner;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerMetrics;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerState;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import java.time.Duration;
import java.time.Instant;

final class OpenState
extends CircuitBreakerState {
    private final Instant retryAfterWaitDuration;
    private final CircuitBreakerMetrics circuitBreakerMetrics;

    OpenState(CircuitBreakerStateMachine stateMachine, CircuitBreakerMetrics circuitBreakerMetrics) {
        super(stateMachine);
        Duration waitDurationInOpenState = stateMachine.getCircuitBreakerConfig().getWaitDurationInOpenState();
        this.retryAfterWaitDuration = Instant.now().plus(waitDurationInOpenState);
        this.circuitBreakerMetrics = circuitBreakerMetrics;
        if (stateMachine.getCircuitBreakerConfig().isAutomaticTransitionFromOpenToHalfOpenEnabled()) {
            AutoTransitioner.scheduleAutoTransition(stateMachine::transitionToHalfOpenState, waitDurationInOpenState);
        }
    }

    @Override
    boolean isCallPermitted() {
        if (Instant.now().isAfter(this.retryAfterWaitDuration)) {
            this.stateMachine.transitionToHalfOpenState();
            return true;
        }
        this.circuitBreakerMetrics.onCallNotPermitted();
        return false;
    }

    @Override
    void onError(Throwable throwable) {
        this.circuitBreakerMetrics.onError();
    }

    @Override
    void onSuccess() {
        this.circuitBreakerMetrics.onSuccess();
    }

    @Override
    CircuitBreaker.State getState() {
        return CircuitBreaker.State.OPEN;
    }

    @Override
    CircuitBreakerMetrics getMetrics() {
        return this.circuitBreakerMetrics;
    }
}

