/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

class BitSetMod {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private final int size;
    private final long[] words;

    BitSetMod(int capacity) {
        int countOfWordsRequired = BitSetMod.wordIndex(capacity - 1) + 1;
        this.size = countOfWordsRequired << 6;
        this.words = new long[countOfWordsRequired];
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    int set(int bitIndex, boolean value) {
        long bitMask;
        int previous;
        int wordIndex = BitSetMod.wordIndex(bitIndex);
        int n = previous = (this.words[wordIndex] & (bitMask = 1L << bitIndex)) != 0L ? 1 : 0;
        if (value) {
            int n2 = wordIndex;
            this.words[n2] = this.words[n2] | bitMask;
        } else {
            int n3 = wordIndex;
            this.words[n3] = this.words[n3] & (bitMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return previous;
    }

    int size() {
        return this.size;
    }

    boolean get(int bitIndex) {
        long bitMask;
        int wordIndex = BitSetMod.wordIndex(bitIndex);
        return (this.words[wordIndex] & (bitMask = 1L << bitIndex)) != 0L;
    }
}

