/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerMetrics;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerState;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import io.github.resilience4j.core.lang.Nullable;

final class ClosedState
extends CircuitBreakerState {
    private final CircuitBreakerMetrics circuitBreakerMetrics;
    private final float failureRateThreshold;

    ClosedState(CircuitBreakerStateMachine stateMachine) {
        this(stateMachine, null);
    }

    ClosedState(CircuitBreakerStateMachine stateMachine, @Nullable CircuitBreakerMetrics circuitBreakerMetrics) {
        super(stateMachine);
        CircuitBreakerConfig circuitBreakerConfig = stateMachine.getCircuitBreakerConfig();
        this.circuitBreakerMetrics = circuitBreakerMetrics == null ? new CircuitBreakerMetrics(circuitBreakerConfig.getRingBufferSizeInClosedState()) : circuitBreakerMetrics.copy(circuitBreakerConfig.getRingBufferSizeInClosedState());
        this.failureRateThreshold = stateMachine.getCircuitBreakerConfig().getFailureRateThreshold();
    }

    @Override
    boolean isCallPermitted() {
        return true;
    }

    @Override
    void onError(Throwable throwable) {
        this.checkFailureRate(this.circuitBreakerMetrics.onError());
    }

    @Override
    void onSuccess() {
        this.checkFailureRate(this.circuitBreakerMetrics.onSuccess());
    }

    private void checkFailureRate(float currentFailureRate) {
        if (currentFailureRate >= this.failureRateThreshold) {
            this.stateMachine.transitionToOpenState();
        }
    }

    @Override
    CircuitBreaker.State getState() {
        return CircuitBreaker.State.CLOSED;
    }

    @Override
    CircuitBreakerMetrics getMetrics() {
        return this.circuitBreakerMetrics;
    }
}

