/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.internal.BitSetMod;

class RingBitSet {
    private final int size;
    private final BitSetMod bitSet;
    private boolean notFull = true;
    private int index = -1;
    private volatile int length;
    private volatile int cardinality = 0;

    RingBitSet(int bitSetSize) {
        this.size = bitSetSize;
        this.bitSet = new BitSetMod(bitSetSize);
    }

    RingBitSet(int bitSetSize, RingBitSet sourceSet) {
        this(bitSetSize);
        int targetLength = Integer.min(bitSetSize, sourceSet.length);
        int sourceIndex = sourceSet.index;
        int forwardIndex = sourceSet.size - sourceIndex;
        for (int i = 0; i < targetLength; ++i) {
            this.setNextBit(sourceSet.bitSet.get(sourceIndex));
            forwardIndex = (forwardIndex + 1) % sourceSet.size;
            sourceIndex = (sourceSet.size - forwardIndex) % sourceSet.size;
        }
    }

    public synchronized int setNextBit(boolean value) {
        this.increaseLength();
        this.index = (this.index + 1) % this.size;
        int previous = this.bitSet.set(this.index, value);
        int current = value ? 1 : 0;
        this.cardinality = this.cardinality - previous + current;
        return this.cardinality;
    }

    public int cardinality() {
        return this.cardinality;
    }

    public int size() {
        return this.bitSet.size();
    }

    public int length() {
        return this.length;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            result.append(this.bitSet.get(i) ? (char)'1' : '0');
        }
        return result.toString();
    }

    synchronized int getIndex() {
        return this.index;
    }

    private void increaseLength() {
        if (this.notFull) {
            int nextLength = this.length + 1;
            if (nextLength < this.size) {
                this.length = nextLength;
            } else {
                this.length = this.size;
                this.notFull = false;
            }
        }
    }
}

