/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnCallNotPermittedEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnIgnoredErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnResetEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnStateTransitionEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSuccessEvent;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import io.github.resilience4j.core.EventConsumer;
import io.vavr.CheckedConsumer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface CircuitBreaker {
    @Deprecated
    public boolean isCallPermitted();

    public boolean tryAcquirePermission();

    public void releasePermission();

    public void acquirePermission();

    public void onError(long var1, Throwable var3);

    public void onSuccess(long var1);

    public void reset();

    public void transitionToClosedState();

    public void transitionToOpenState();

    public void transitionToHalfOpenState();

    public void transitionToDisabledState();

    public void transitionToForcedOpenState();

    public String getName();

    public State getState();

    public CircuitBreakerConfig getCircuitBreakerConfig();

    public Metrics getMetrics();

    public EventPublisher getEventPublisher();

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return CircuitBreaker.decorateSupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return CircuitBreaker.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        CircuitBreaker.decorateRunnable(this, runnable).run();
    }

    default public <T> CompletionStage<T> executeCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return CircuitBreaker.decorateCompletionStage(this, supplier).get();
    }

    default public <T> T executeCheckedSupplier(CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)CircuitBreaker.decorateCheckedSupplier(this, checkedSupplier).apply();
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(CircuitBreaker circuitBreaker, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            circuitBreaker.acquirePermission();
            long start = System.nanoTime();
            try {
                Object returnValue = supplier.apply();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Exception exception) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, exception);
                throw exception;
            }
        };
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(CircuitBreaker circuitBreaker, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            if (!circuitBreaker.tryAcquirePermission()) {
                promise.completeExceptionally(new CallNotPermittedException(circuitBreaker));
            } else {
                long start = System.nanoTime();
                try {
                    ((CompletionStage)supplier.get()).whenComplete((result, throwable) -> {
                        long durationInNanos = System.nanoTime() - start;
                        if (result != null) {
                            circuitBreaker.onSuccess(durationInNanos);
                            promise.complete(result);
                        } else if (throwable instanceof Exception) {
                            circuitBreaker.onError(durationInNanos, (Throwable)throwable);
                            promise.completeExceptionally((Throwable)throwable);
                        } else {
                            promise.completeExceptionally((Throwable)throwable);
                        }
                    });
                }
                catch (Exception exception) {
                    long durationInNanos = System.nanoTime() - start;
                    circuitBreaker.onError(durationInNanos, exception);
                    promise.completeExceptionally(exception);
                }
            }
            return promise;
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(CircuitBreaker circuitBreaker, CheckedRunnable runnable) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = System.nanoTime();
            try {
                runnable.run();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
            }
            catch (Exception exception) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, exception);
                throw exception;
            }
        };
    }

    public static <T> Callable<T> decorateCallable(CircuitBreaker circuitBreaker, Callable<T> callable) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = System.nanoTime();
            try {
                Object returnValue = callable.call();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Exception exception) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, exception);
                throw exception;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(CircuitBreaker circuitBreaker, Supplier<T> supplier) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = System.nanoTime();
            try {
                Object returnValue = supplier.get();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Exception exception) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, exception);
                throw exception;
            }
        };
    }

    public static <T> Consumer<T> decorateConsumer(CircuitBreaker circuitBreaker, Consumer<T> consumer) {
        return t -> {
            circuitBreaker.acquirePermission();
            long start = System.nanoTime();
            try {
                consumer.accept(t);
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
            }
            catch (Exception exception) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, exception);
                throw exception;
            }
        };
    }

    public static <T> CheckedConsumer<T> decorateCheckedConsumer(CircuitBreaker circuitBreaker, CheckedConsumer<T> consumer) {
        return t -> {
            circuitBreaker.acquirePermission();
            long start = System.nanoTime();
            try {
                consumer.accept(t);
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
            }
            catch (Exception exception) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, exception);
                throw exception;
            }
        };
    }

    public static Runnable decorateRunnable(CircuitBreaker circuitBreaker, Runnable runnable) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = System.nanoTime();
            try {
                runnable.run();
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
            }
            catch (Exception exception) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, exception);
                throw exception;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(CircuitBreaker circuitBreaker, Function<T, R> function) {
        return t -> {
            circuitBreaker.acquirePermission();
            long start = System.nanoTime();
            try {
                Object returnValue = function.apply(t);
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Exception exception) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, exception);
                throw exception;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(CircuitBreaker circuitBreaker, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            circuitBreaker.acquirePermission();
            long start = System.nanoTime();
            try {
                Object returnValue = function.apply(t);
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onSuccess(durationInNanos);
                return returnValue;
            }
            catch (Exception exception) {
                long durationInNanos = System.nanoTime() - start;
                circuitBreaker.onError(durationInNanos, exception);
                throw exception;
            }
        };
    }

    public static CircuitBreaker ofDefaults(String name) {
        return new CircuitBreakerStateMachine(name);
    }

    public static CircuitBreaker of(String name, CircuitBreakerConfig circuitBreakerConfig) {
        return new CircuitBreakerStateMachine(name, circuitBreakerConfig);
    }

    public static CircuitBreaker of(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier) {
        return new CircuitBreakerStateMachine(name, circuitBreakerConfigSupplier);
    }

    public static interface Metrics {
        public float getFailureRate();

        public int getNumberOfBufferedCalls();

        public int getNumberOfFailedCalls();

        public long getNumberOfNotPermittedCalls();

        public int getMaxNumberOfBufferedCalls();

        public int getNumberOfSuccessfulCalls();
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<CircuitBreakerEvent> {
        public EventPublisher onSuccess(EventConsumer<CircuitBreakerOnSuccessEvent> var1);

        public EventPublisher onError(EventConsumer<CircuitBreakerOnErrorEvent> var1);

        public EventPublisher onStateTransition(EventConsumer<CircuitBreakerOnStateTransitionEvent> var1);

        public EventPublisher onReset(EventConsumer<CircuitBreakerOnResetEvent> var1);

        public EventPublisher onIgnoredError(EventConsumer<CircuitBreakerOnIgnoredErrorEvent> var1);

        public EventPublisher onCallNotPermitted(EventConsumer<CircuitBreakerOnCallNotPermittedEvent> var1);
    }

    public static enum StateTransition {
        CLOSED_TO_OPEN(State.CLOSED, State.OPEN),
        CLOSED_TO_DISABLED(State.CLOSED, State.DISABLED),
        CLOSED_TO_FORCED_OPEN(State.CLOSED, State.FORCED_OPEN),
        HALF_OPEN_TO_CLOSED(State.HALF_OPEN, State.CLOSED),
        HALF_OPEN_TO_OPEN(State.HALF_OPEN, State.OPEN),
        HALF_OPEN_TO_DISABLED(State.HALF_OPEN, State.DISABLED),
        HALF_OPEN_TO_FORCED_OPEN(State.HALF_OPEN, State.FORCED_OPEN),
        OPEN_TO_CLOSED(State.OPEN, State.CLOSED),
        OPEN_TO_HALF_OPEN(State.OPEN, State.HALF_OPEN),
        OPEN_TO_DISABLED(State.OPEN, State.DISABLED),
        OPEN_TO_FORCED_OPEN(State.OPEN, State.FORCED_OPEN),
        FORCED_OPEN_TO_CLOSED(State.FORCED_OPEN, State.CLOSED),
        FORCED_OPEN_TO_OPEN(State.FORCED_OPEN, State.OPEN),
        FORCED_OPEN_TO_DISABLED(State.FORCED_OPEN, State.DISABLED),
        FORCED_OPEN_TO_HALF_OPEN(State.FORCED_OPEN, State.HALF_OPEN),
        DISABLED_TO_CLOSED(State.DISABLED, State.CLOSED),
        DISABLED_TO_OPEN(State.DISABLED, State.OPEN),
        DISABLED_TO_FORCED_OPEN(State.DISABLED, State.FORCED_OPEN),
        DISABLED_TO_HALF_OPEN(State.DISABLED, State.HALF_OPEN);

        private final State fromState;
        private final State toState;
        private static final Map<Tuple2<State, State>, StateTransition> STATE_TRANSITION_MAP;

        public static StateTransition transitionBetween(State fromState, State toState) {
            StateTransition stateTransition = STATE_TRANSITION_MAP.get(Tuple.of((Object)((Object)fromState), (Object)((Object)toState)));
            if (stateTransition == null) {
                throw new IllegalStateException(String.format("Illegal state transition from %s to %s", fromState.toString(), toState.toString()));
            }
            return stateTransition;
        }

        private StateTransition(State fromState, State toState) {
            this.fromState = fromState;
            this.toState = toState;
        }

        public State getFromState() {
            return this.fromState;
        }

        public State getToState() {
            return this.toState;
        }

        public String toString() {
            return String.format("State transition from %s to %s", new Object[]{this.fromState, this.toState});
        }

        static {
            STATE_TRANSITION_MAP = Arrays.stream(StateTransition.values()).collect(Collectors.toMap(v -> Tuple.of((Object)((Object)v.fromState), (Object)((Object)v.toState)), Function.identity()));
        }
    }

    public static enum State {
        DISABLED(3, false),
        CLOSED(0, true),
        OPEN(1, true),
        FORCED_OPEN(4, false),
        HALF_OPEN(2, true);

        private final int order;
        public final boolean allowPublish;

        private State(int order, boolean allowPublish) {
            this.order = order;
            this.allowPublish = allowPublish;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

